"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .ip_addresses import IPAddresses, IPAddressesTypedDict
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import FieldMetadata, QueryParamMetadata
import pydantic
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class FilterFamily(str, Enum):
    r"""The protocol family to filter by"""

    I_PV4 = "IPv4"
    I_PV6 = "IPv6"


class FilterType(str, Enum):
    r"""The protocol type to filter by"""

    PRIVATE = "private"
    PUBLIC = "public"


class GetIpsRequestTypedDict(TypedDict):
    filter_server: NotRequired[str]
    r"""The server ID to filter by"""
    filter_project: NotRequired[str]
    r"""The project ID or Slug to filter by"""
    filter_family: NotRequired[FilterFamily]
    r"""The protocol family to filter by"""
    filter_type: NotRequired[FilterType]
    r"""The protocol type to filter by"""
    filter_location: NotRequired[str]
    r"""The site slug to filter by (case-insensitive)"""
    filter_address: NotRequired[str]
    r"""The address of IP to filter by starts_with"""
    extra_fields_ip_addresses: NotRequired[str]
    r"""The `region` and `server` are provided as extra attributes that are lazy loaded. To request it, just set `extra_fields[ip_addresses]=region,server` in the query string."""
    page_size: NotRequired[int]
    r"""Number of items to return per page"""
    page_number: NotRequired[int]
    r"""Page number to return (starts at 1)"""


class GetIpsRequest(BaseModel):
    filter_server: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[server]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The server ID to filter by"""

    filter_project: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[project]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The project ID or Slug to filter by"""

    filter_family: Annotated[
        Optional[FilterFamily],
        pydantic.Field(alias="filter[family]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The protocol family to filter by"""

    filter_type: Annotated[
        Optional[FilterType],
        pydantic.Field(alias="filter[type]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The protocol type to filter by"""

    filter_location: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[location]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The site slug to filter by (case-insensitive)"""

    filter_address: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[address]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The address of IP to filter by starts_with"""

    extra_fields_ip_addresses: Annotated[
        Optional[str],
        pydantic.Field(alias="extra_fields[ip_addresses]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The `region` and `server` are provided as extra attributes that are lazy loaded. To request it, just set `extra_fields[ip_addresses]=region,server` in the query string."""

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 20
    r"""Number of items to return per page"""

    page_number: Annotated[
        Optional[int],
        pydantic.Field(alias="page[number]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Page number to return (starts at 1)"""


class GetIpsResponseTypedDict(TypedDict):
    result: IPAddressesTypedDict


class GetIpsResponse(BaseModel):
    next: Callable[[], Optional[GetIpsResponse]]

    result: IPAddresses
