"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .plan_data import PlanData, PlanDataTypedDict
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import FieldMetadata, QueryParamMetadata
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class FilterStockLevel(str, Enum):
    r"""The stock level at the site to filter by"""

    UNAVAILABLE = "unavailable"
    LOW = "low"
    MEDIUM = "medium"
    HIGH = "high"
    UNIQUE = "unique"


class GetPlansRequestTypedDict(TypedDict):
    filter_name: NotRequired[str]
    r"""The plan name to filter by"""
    filter_slug: NotRequired[str]
    r"""The plan slug to filter by"""
    filter_location: NotRequired[str]
    r"""The location of the site to filter by"""
    filter_stock_level: NotRequired[FilterStockLevel]
    r"""The stock level at the site to filter by"""
    filter_in_stock: NotRequired[bool]
    r"""The stock available at the site to filter by"""
    filter_gpu: NotRequired[bool]
    r"""Filter by the existence of an associated GPU"""
    filter_ram: NotRequired[int]
    r"""The ram size in Gigabytes to filter by, should be used with the following options:
    [eql] to filter for values equal to the provided value.
    [gte] to filter for values greater or equal to the provided value.
    [lte] to filter by values lower or equal to the provided value.
    """
    filter_disk: NotRequired[int]
    r"""The disk size in Gigabytes to filter by, should be used with the following options:
    [eql] to filter for values equal to the provided value.
    [gte] to filter for values greater or equal to the provided value.
    [lte] to filter by values lower or equal to the provided value.
    """


class GetPlansRequest(BaseModel):
    filter_name: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[name]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The plan name to filter by"""

    filter_slug: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[slug]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The plan slug to filter by"""

    filter_location: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[location]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The location of the site to filter by"""

    filter_stock_level: Annotated[
        Optional[FilterStockLevel],
        pydantic.Field(alias="filter[stock_level]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The stock level at the site to filter by"""

    filter_in_stock: Annotated[
        Optional[bool],
        pydantic.Field(alias="filter[in_stock]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The stock available at the site to filter by"""

    filter_gpu: Annotated[
        Optional[bool],
        pydantic.Field(alias="filter[gpu]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter by the existence of an associated GPU"""

    filter_ram: Annotated[
        Optional[int],
        pydantic.Field(alias="filter[ram]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The ram size in Gigabytes to filter by, should be used with the following options:
    [eql] to filter for values equal to the provided value.
    [gte] to filter for values greater or equal to the provided value.
    [lte] to filter by values lower or equal to the provided value.
    """

    filter_disk: Annotated[
        Optional[int],
        pydantic.Field(alias="filter[disk]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The disk size in Gigabytes to filter by, should be used with the following options:
    [eql] to filter for values equal to the provided value.
    [gte] to filter for values greater or equal to the provided value.
    [lte] to filter by values lower or equal to the provided value.
    """


class GetPlansResponseBodyTypedDict(TypedDict):
    r"""Success"""

    data: NotRequired[List[PlanDataTypedDict]]


class GetPlansResponseBody(BaseModel):
    r"""Success"""

    data: Optional[List[PlanData]] = None
