"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .projects import Projects, ProjectsTypedDict
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import FieldMetadata, QueryParamMetadata
import pydantic
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetProjectsRequestTypedDict(TypedDict):
    filter_name: NotRequired[str]
    r"""The project name to filter by"""
    filter_slug: NotRequired[str]
    r"""The project slug to filter by"""
    filter_description: NotRequired[str]
    r"""The project description to filter by"""
    filter_billing_type: NotRequired[str]
    r"""The billing type to filter by"""
    filter_environment: NotRequired[str]
    r"""The environment to filter by"""
    filter_tags: NotRequired[str]
    r"""The tags ids to filter by, separated by comma, e.g. `filter[tags]=tag_1,tag_2`will return projects with `tag_1` AND `tag_2`"""
    extra_fields_projects: NotRequired[str]
    r"""The `last_renewal_date` and `next_renewal_date` are provided as extra attributes that show previous and future billing cycle dates. To request it, just set `extra_fields[projects]=last_renewal_date,next_renewal_date` in the query string."""
    page_size: NotRequired[int]
    r"""Number of items to return per page"""
    page_number: NotRequired[int]
    r"""Page number to return (starts at 1)"""


class GetProjectsRequest(BaseModel):
    filter_name: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[name]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The project name to filter by"""

    filter_slug: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[slug]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The project slug to filter by"""

    filter_description: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[description]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The project description to filter by"""

    filter_billing_type: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[billing_type]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The billing type to filter by"""

    filter_environment: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[environment]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The environment to filter by"""

    filter_tags: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[tags]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The tags ids to filter by, separated by comma, e.g. `filter[tags]=tag_1,tag_2`will return projects with `tag_1` AND `tag_2`"""

    extra_fields_projects: Annotated[
        Optional[str],
        pydantic.Field(alias="extra_fields[projects]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The `last_renewal_date` and `next_renewal_date` are provided as extra attributes that show previous and future billing cycle dates. To request it, just set `extra_fields[projects]=last_renewal_date,next_renewal_date` in the query string."""

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 20
    r"""Number of items to return per page"""

    page_number: Annotated[
        Optional[int],
        pydantic.Field(alias="page[number]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Page number to return (starts at 1)"""


class GetProjectsResponseTypedDict(TypedDict):
    result: ProjectsTypedDict


class GetProjectsResponse(BaseModel):
    next: Callable[[], Optional[GetProjectsResponse]]

    result: Projects
