"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .servers import Servers, ServersTypedDict
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import FieldMetadata, QueryParamMetadata
import pydantic
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetServersRequestTypedDict(TypedDict):
    filter_project: NotRequired[str]
    r"""The project ID or Slug to filter by"""
    filter_region: NotRequired[str]
    r"""The region Slug to filter by (case-insensitive)"""
    filter_hostname: NotRequired[str]
    r"""The hostname of server to filter by"""
    filter_created_at_gte: NotRequired[str]
    r"""The created at greater than equal date to filter by"""
    filter_created_at_lte: NotRequired[str]
    r"""The created at less than equal date to filter by"""
    filter_label: NotRequired[str]
    r"""The label of server to filter by"""
    filter_status: NotRequired[str]
    r"""The status of server to filter by"""
    filter_plan: NotRequired[str]
    r"""The platform/plan name of the server to filter by"""
    filter_gpu: NotRequired[bool]
    r"""Filter by the existence of an associated GPU"""
    filter_ram_eql: NotRequired[int]
    r"""Filter servers with RAM size (in GB) equals the provided value."""
    filter_ram_gte: NotRequired[int]
    r"""Filter servers with RAM size (in GB) greater than or equal the provided value."""
    filter_ram_lte: NotRequired[int]
    r"""Filter servers with RAM size (in GB) less than or equal the provided value."""
    filter_disk: NotRequired[int]
    r"""The disk size in Gigabytes to filter by, should be used with the following options:
    [eql] to filter for values equal to the provided value.
    [gte] to filter for values greater than or equal to the provided value.
    [lte] to filter by values lower than or equal to the provided value.
    """
    filter_tags: NotRequired[str]
    r"""The tags IDs to filter by, separated by comma, e.g. `filter[tags]=tag_1,tag_2`will return servers with `tag_1` AND `tag_2`"""
    extra_fields_servers: NotRequired[str]
    r"""The `credentials` are provided as extra attributes that are lazy loaded. To request it, just set `extra_fields[servers]=credentials` in the query string."""
    page_size: NotRequired[int]
    r"""Number of items to return per page"""
    page_number: NotRequired[int]
    r"""Page number to return (starts at 1)"""


class GetServersRequest(BaseModel):
    filter_project: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[project]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The project ID or Slug to filter by"""

    filter_region: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[region]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The region Slug to filter by (case-insensitive)"""

    filter_hostname: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[hostname]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The hostname of server to filter by"""

    filter_created_at_gte: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[created_at_gte]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The created at greater than equal date to filter by"""

    filter_created_at_lte: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[created_at_lte]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The created at less than equal date to filter by"""

    filter_label: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[label]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The label of server to filter by"""

    filter_status: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[status]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The status of server to filter by"""

    filter_plan: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[plan]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The platform/plan name of the server to filter by"""

    filter_gpu: Annotated[
        Optional[bool],
        pydantic.Field(alias="filter[gpu]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter by the existence of an associated GPU"""

    filter_ram_eql: Annotated[
        Optional[int],
        pydantic.Field(alias="filter[ram][eql]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter servers with RAM size (in GB) equals the provided value."""

    filter_ram_gte: Annotated[
        Optional[int],
        pydantic.Field(alias="filter[ram][gte]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter servers with RAM size (in GB) greater than or equal the provided value."""

    filter_ram_lte: Annotated[
        Optional[int],
        pydantic.Field(alias="filter[ram][lte]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter servers with RAM size (in GB) less than or equal the provided value."""

    filter_disk: Annotated[
        Optional[int],
        pydantic.Field(alias="filter[disk]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The disk size in Gigabytes to filter by, should be used with the following options:
    [eql] to filter for values equal to the provided value.
    [gte] to filter for values greater than or equal to the provided value.
    [lte] to filter by values lower than or equal to the provided value.
    """

    filter_tags: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[tags]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The tags IDs to filter by, separated by comma, e.g. `filter[tags]=tag_1,tag_2`will return servers with `tag_1` AND `tag_2`"""

    extra_fields_servers: Annotated[
        Optional[str],
        pydantic.Field(alias="extra_fields[servers]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The `credentials` are provided as extra attributes that are lazy loaded. To request it, just set `extra_fields[servers]=credentials` in the query string."""

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 20
    r"""Number of items to return per page"""

    page_number: Annotated[
        Optional[int],
        pydantic.Field(alias="page[number]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Page number to return (starts at 1)"""


class GetServersResponseTypedDict(TypedDict):
    result: ServersTypedDict


class GetServersResponse(BaseModel):
    next: Callable[[], Optional[GetServersResponse]]

    result: Servers
