"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import FieldMetadata, QueryParamMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetTrafficConsumptionRequestTypedDict(TypedDict):
    filter_date_gte: str
    r"""The start timestamp to retrieve the traffic. You must provide in ISO8601 format. Example: filter[date][gte]=2024-04-01T00:00:00Z"""
    filter_date_lte: str
    r"""The end timestamp to retrieve the traffic. You must provide in ISO8601 format. Example: filter[date][gte]=2024-04-31T23:59:59Z"""
    filter_server: NotRequired[str]
    r"""The server id to filter by"""
    filter_project: NotRequired[str]
    r"""The project id to filter by"""


class GetTrafficConsumptionRequest(BaseModel):
    filter_date_gte: Annotated[
        str,
        pydantic.Field(alias="filter[date][gte]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""The start timestamp to retrieve the traffic. You must provide in ISO8601 format. Example: filter[date][gte]=2024-04-01T00:00:00Z"""

    filter_date_lte: Annotated[
        str,
        pydantic.Field(alias="filter[date][lte]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""The end timestamp to retrieve the traffic. You must provide in ISO8601 format. Example: filter[date][gte]=2024-04-31T23:59:59Z"""

    filter_server: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[server]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The server id to filter by"""

    filter_project: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[project]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The project id to filter by"""
