"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .virtual_network_assignments import (
    VirtualNetworkAssignments,
    VirtualNetworkAssignmentsTypedDict,
)
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import FieldMetadata, QueryParamMetadata
import pydantic
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetVirtualNetworksAssignmentsRequestTypedDict(TypedDict):
    filter_server: NotRequired[str]
    r"""The server ID to filter by"""
    filter_vid: NotRequired[str]
    r"""The vlan ID to filter by"""
    filter_virtual_network_id: NotRequired[str]
    r"""The virtual network ID to filter by"""
    page_size: NotRequired[int]
    r"""Number of items to return per page"""
    page_number: NotRequired[int]
    r"""Page number to return (starts at 1)"""


class GetVirtualNetworksAssignmentsRequest(BaseModel):
    filter_server: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[server]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The server ID to filter by"""

    filter_vid: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[vid]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The vlan ID to filter by"""

    filter_virtual_network_id: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[virtual_network_id]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The virtual network ID to filter by"""

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 20
    r"""Number of items to return per page"""

    page_number: Annotated[
        Optional[int],
        pydantic.Field(alias="page[number]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Page number to return (starts at 1)"""


class GetVirtualNetworksAssignmentsResponseTypedDict(TypedDict):
    result: VirtualNetworkAssignmentsTypedDict


class GetVirtualNetworksAssignmentsResponse(BaseModel):
    next: Callable[[], Optional[GetVirtualNetworksAssignmentsResponse]]

    result: VirtualNetworkAssignments
