"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .virtual_networks import VirtualNetworks, VirtualNetworksTypedDict
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import FieldMetadata, QueryParamMetadata
import pydantic
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetVirtualNetworksRequestTypedDict(TypedDict):
    filter_location: NotRequired[str]
    r"""The location slug to filter by"""
    filter_project: NotRequired[str]
    r"""The project id or slug to filter by"""
    filter_tags: NotRequired[str]
    r"""The tags ids to filter by, separated by comma, e.g. `filter[tags]=tag_1,tag_2`will return ssh keys with `tag_1` AND `tag_2`"""
    page_size: NotRequired[int]
    r"""Number of items to return per page"""
    page_number: NotRequired[int]
    r"""Page number to return (starts at 1)"""


class GetVirtualNetworksRequest(BaseModel):
    filter_location: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[location]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The location slug to filter by"""

    filter_project: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[project]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The project id or slug to filter by"""

    filter_tags: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[tags]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The tags ids to filter by, separated by comma, e.g. `filter[tags]=tag_1,tag_2`will return ssh keys with `tag_1` AND `tag_2`"""

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 20
    r"""Number of items to return per page"""

    page_number: Annotated[
        Optional[int],
        pydantic.Field(alias="page[number]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Page number to return (starts at 1)"""


class GetVirtualNetworksResponseTypedDict(TypedDict):
    result: VirtualNetworksTypedDict


class GetVirtualNetworksResponse(BaseModel):
    next: Callable[[], Optional[GetVirtualNetworksResponse]]

    result: VirtualNetworks
