"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .firewalls import Firewalls, FirewallsTypedDict
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import FieldMetadata, QueryParamMetadata
import pydantic
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListFirewallsRequestTypedDict(TypedDict):
    filter_project: NotRequired[str]
    page_size: NotRequired[int]
    r"""Number of items to return per page"""
    page_number: NotRequired[int]
    r"""Page number to return (starts at 1)"""


class ListFirewallsRequest(BaseModel):
    filter_project: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[project]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 20
    r"""Number of items to return per page"""

    page_number: Annotated[
        Optional[int],
        pydantic.Field(alias="page[number]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Page number to return (starts at 1)"""


class ListFirewallsResponseTypedDict(TypedDict):
    result: FirewallsTypedDict


class ListFirewallsResponse(BaseModel):
    next: Callable[[], Optional[ListFirewallsResponse]]

    result: Firewalls
