"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .team import Team, TeamTypedDict
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
)
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PatchCurrentTeamTeamsType(str, Enum):
    TEAMS = "teams"


class PatchCurrentTeamTeamsCurrency(str, Enum):
    USD = "USD"
    BRL = "BRL"


class PatchCurrentTeamTeamsAttributesTypedDict(TypedDict):
    address: NotRequired[str]
    name: NotRequired[str]
    currency: NotRequired[PatchCurrentTeamTeamsCurrency]
    referred_code: NotRequired[str]


class PatchCurrentTeamTeamsAttributes(BaseModel):
    address: Optional[str] = None

    name: Optional[str] = None

    currency: Optional[PatchCurrentTeamTeamsCurrency] = (
        PatchCurrentTeamTeamsCurrency.USD
    )

    referred_code: Optional[str] = None


class PatchCurrentTeamTeamsDataTypedDict(TypedDict):
    id: str
    type: PatchCurrentTeamTeamsType
    attributes: NotRequired[PatchCurrentTeamTeamsAttributesTypedDict]


class PatchCurrentTeamTeamsData(BaseModel):
    id: str

    type: PatchCurrentTeamTeamsType

    attributes: Optional[PatchCurrentTeamTeamsAttributes] = None


class PatchCurrentTeamTeamsRequestBodyTypedDict(TypedDict):
    data: PatchCurrentTeamTeamsDataTypedDict


class PatchCurrentTeamTeamsRequestBody(BaseModel):
    data: PatchCurrentTeamTeamsData


class PatchCurrentTeamRequestTypedDict(TypedDict):
    team_id: str
    request_body: PatchCurrentTeamTeamsRequestBodyTypedDict


class PatchCurrentTeamRequest(BaseModel):
    team_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    request_body: Annotated[
        PatchCurrentTeamTeamsRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


class PatchCurrentTeamResponseBodyTypedDict(TypedDict):
    r"""Success"""

    data: NotRequired[TeamTypedDict]


class PatchCurrentTeamResponseBody(BaseModel):
    r"""Success"""

    data: Optional[Team] = None
