"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .filesystem_data import FilesystemData, FilesystemDataTypedDict
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
)
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PatchStorageFilesystemsStorageType(str, Enum):
    FILESYSTEMS = "filesystems"


class PatchStorageFilesystemsStorageAttributesTypedDict(TypedDict):
    size_in_gb: NotRequired[int]
    r"""Size in GB (not required, default is 1500)"""


class PatchStorageFilesystemsStorageAttributes(BaseModel):
    size_in_gb: Optional[int] = 1500
    r"""Size in GB (not required, default is 1500)"""


class PatchStorageFilesystemsStorageDataTypedDict(TypedDict):
    id: str
    r"""Filesystem ID"""
    type: PatchStorageFilesystemsStorageType
    attributes: PatchStorageFilesystemsStorageAttributesTypedDict


class PatchStorageFilesystemsStorageData(BaseModel):
    id: str
    r"""Filesystem ID"""

    type: PatchStorageFilesystemsStorageType

    attributes: PatchStorageFilesystemsStorageAttributes


class PatchStorageFilesystemsStorageRequestBodyTypedDict(TypedDict):
    data: PatchStorageFilesystemsStorageDataTypedDict


class PatchStorageFilesystemsStorageRequestBody(BaseModel):
    data: PatchStorageFilesystemsStorageData


class PatchStorageFilesystemsRequestTypedDict(TypedDict):
    filesystem_id: str
    request_body: PatchStorageFilesystemsStorageRequestBodyTypedDict


class PatchStorageFilesystemsRequest(BaseModel):
    filesystem_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    request_body: Annotated[
        PatchStorageFilesystemsStorageRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


class PatchStorageFilesystemsResponseBodyTypedDict(TypedDict):
    r"""Success"""

    data: NotRequired[FilesystemDataTypedDict]


class PatchStorageFilesystemsResponseBody(BaseModel):
    r"""Success"""

    data: Optional[FilesystemData] = None
