"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PlanDataType(str, Enum):
    PLANS = "plans"


class CPUTypedDict(TypedDict):
    type: NotRequired[str]
    clock: NotRequired[float]
    cores: NotRequired[float]
    count: NotRequired[float]


class CPU(BaseModel):
    type: Optional[str] = None

    clock: Optional[float] = None

    cores: Optional[float] = None

    count: Optional[float] = None


class MemoryTypedDict(TypedDict):
    total: NotRequired[float]


class Memory(BaseModel):
    total: Optional[float] = None


class PlanDataAttributesType(str, Enum):
    SSD = "SSD"
    HDD = "HDD"
    NVME = "NVME"


class DrivesTypedDict(TypedDict):
    count: NotRequired[float]
    size: NotRequired[str]
    type: NotRequired[PlanDataAttributesType]


class Drives(BaseModel):
    count: Optional[float] = None

    size: Optional[str] = None

    type: Optional[PlanDataAttributesType] = None


class NicsTypedDict(TypedDict):
    count: NotRequired[float]
    type: NotRequired[str]


class Nics(BaseModel):
    count: Optional[float] = None

    type: Optional[str] = None


class GpuTypedDict(TypedDict):
    count: NotRequired[float]
    type: NotRequired[str]


class Gpu(BaseModel):
    count: Optional[float] = None

    type: Optional[str] = None


class SpecsTypedDict(TypedDict):
    cpu: NotRequired[CPUTypedDict]
    memory: NotRequired[MemoryTypedDict]
    drives: NotRequired[List[DrivesTypedDict]]
    nics: NotRequired[List[NicsTypedDict]]
    gpu: NotRequired[GpuTypedDict]


class Specs(BaseModel):
    cpu: Optional[CPU] = None

    memory: Optional[Memory] = None

    drives: Optional[List[Drives]] = None

    nics: Optional[List[Nics]] = None

    gpu: Optional[Gpu] = None


class LocationsTypedDict(TypedDict):
    available: NotRequired[List[str]]
    in_stock: NotRequired[List[str]]


class Locations(BaseModel):
    available: Optional[List[str]] = None

    in_stock: Optional[List[str]] = None


class StockLevel(str, Enum):
    UNAVAILABLE = "unavailable"
    LOW = "low"
    MEDIUM = "medium"
    HIGH = "high"


class PlanDataUSDTypedDict(TypedDict):
    hour: NotRequired[float]
    month: NotRequired[float]
    year: NotRequired[float]


class PlanDataUSD(BaseModel):
    hour: Optional[float] = None

    month: Optional[float] = None

    year: Optional[float] = None


class PlanDataBRLTypedDict(TypedDict):
    hour: NotRequired[float]
    month: NotRequired[float]
    year: NotRequired[float]


class PlanDataBRL(BaseModel):
    hour: Optional[float] = None

    month: Optional[float] = None

    year: Optional[float] = None


class PlanDataPricingTypedDict(TypedDict):
    usd: NotRequired[PlanDataUSDTypedDict]
    brl: NotRequired[PlanDataBRLTypedDict]


class PlanDataPricing(BaseModel):
    usd: Annotated[Optional[PlanDataUSD], pydantic.Field(alias="USD")] = None

    brl: Annotated[Optional[PlanDataBRL], pydantic.Field(alias="BRL")] = None


class PlanDataRegionsTypedDict(TypedDict):
    name: NotRequired[str]
    deploys_instantly: NotRequired[List[str]]
    locations: NotRequired[LocationsTypedDict]
    stock_level: NotRequired[StockLevel]
    pricing: NotRequired[PlanDataPricingTypedDict]


class PlanDataRegions(BaseModel):
    name: Optional[str] = None

    deploys_instantly: Optional[List[str]] = None

    locations: Optional[Locations] = None

    stock_level: Optional[StockLevel] = None

    pricing: Optional[PlanDataPricing] = None


class PlanDataAttributesTypedDict(TypedDict):
    slug: NotRequired[str]
    name: NotRequired[str]
    features: NotRequired[List[str]]
    specs: NotRequired[SpecsTypedDict]
    regions: NotRequired[List[PlanDataRegionsTypedDict]]


class PlanDataAttributes(BaseModel):
    slug: Optional[str] = None

    name: Optional[str] = None

    features: Optional[List[str]] = None

    specs: Optional[Specs] = None

    regions: Optional[List[PlanDataRegions]] = None


class PlanDataTypedDict(TypedDict):
    id: NotRequired[str]
    type: NotRequired[PlanDataType]
    attributes: NotRequired[PlanDataAttributesTypedDict]


class PlanData(BaseModel):
    id: Optional[str] = None

    type: Optional[PlanDataType] = None

    attributes: Optional[PlanDataAttributes] = None
