"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
)
from typing_extensions import Annotated, TypedDict


class PostStorageVolumesMountType(str, Enum):
    VOLUMES = "volumes"


class PostStorageVolumesMountAttributesTypedDict(TypedDict):
    nqn: str
    r"""NVMe Qualified Name (NQN) of the client/server that will access the volume storage. Format: nqn.YYYY-MM.domain:identifier (e.g., \"nqn.2024-01.com.example:server01\"). This uniquely identifies the NVMe client and must be configured on the client server."""


class PostStorageVolumesMountAttributes(BaseModel):
    nqn: str
    r"""NVMe Qualified Name (NQN) of the client/server that will access the volume storage. Format: nqn.YYYY-MM.domain:identifier (e.g., \"nqn.2024-01.com.example:server01\"). This uniquely identifies the NVMe client and must be configured on the client server."""


class PostStorageVolumesMountDataTypedDict(TypedDict):
    type: PostStorageVolumesMountType
    attributes: PostStorageVolumesMountAttributesTypedDict


class PostStorageVolumesMountData(BaseModel):
    type: PostStorageVolumesMountType

    attributes: PostStorageVolumesMountAttributes


class PostStorageVolumesMountRequestBodyTypedDict(TypedDict):
    data: PostStorageVolumesMountDataTypedDict


class PostStorageVolumesMountRequestBody(BaseModel):
    data: PostStorageVolumesMountData


class PostStorageVolumesMountRequestTypedDict(TypedDict):
    id: str
    r"""Volume storage ID"""
    request_body: PostStorageVolumesMountRequestBodyTypedDict


class PostStorageVolumesMountRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Volume storage ID"""

    request_body: Annotated[
        PostStorageVolumesMountRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
