"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .project_include import ProjectInclude, ProjectIncludeTypedDict
from .server_region_resource_data import (
    ServerRegionResourceData,
    ServerRegionResourceDataTypedDict,
)
from .team_include import TeamInclude, TeamIncludeTypedDict
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class Status(str, Enum):
    r"""`on` - The server is powered ON
    `off` - The server is powered OFF
    `unknown` - The server power status is unknown
    `ready` - The server is in reinstalling state `ready` and should start `disk_erasing` shortly
    `disk_erasing` - The server is in reinstalling state `disk_erasing`
    `failed_disk_erasing` - The server has failed disk erasing in reinstall
    `deploying` - The server is in the last reinstalling stage and is `deploying`
    `failed_deployment` - The server has failed deployment in reinstall

    """

    ON = "on"
    OFF = "off"
    UNKNOWN = "unknown"
    READY = "ready"
    DISK_ERASING = "disk_erasing"
    FAILED_DISK_ERASING = "failed_disk_erasing"
    DEPLOYING = "deploying"
    FAILED_DEPLOYMENT = "failed_deployment"


class IpmiStatus(str, Enum):
    UNAVAILABLE = "Unavailable"
    INTERMITTENT = "Intermittent"
    NORMAL = "Normal"


class ServerDataPlanTypedDict(TypedDict):
    id: NotRequired[str]
    r"""The plan ID"""
    name: NotRequired[str]
    r"""The plan name"""
    slug: NotRequired[str]
    r"""The plan slug"""
    billing: NotRequired[str]
    r"""hourly/monthly pricing. Defaults to `hourly`. Appliable for `on_demand` projects only."""


class ServerDataPlan(BaseModel):
    id: Optional[str] = None
    r"""The plan ID"""

    name: Optional[str] = None
    r"""The plan name"""

    slug: Optional[str] = None
    r"""The plan slug"""

    billing: Optional[str] = None
    r"""hourly/monthly pricing. Defaults to `hourly`. Appliable for `on_demand` projects only."""


class ServerDataFeaturesTypedDict(TypedDict):
    raid: NotRequired[bool]
    ssh_keys: NotRequired[bool]
    user_data: NotRequired[bool]


class ServerDataFeatures(BaseModel):
    raid: Optional[bool] = None

    ssh_keys: Optional[bool] = None

    user_data: Optional[bool] = None


class DistroTypedDict(TypedDict):
    name: NotRequired[str]
    r"""The OS Distro name"""
    slug: NotRequired[str]
    r"""The OS Distro slug"""
    series: NotRequired[str]
    r"""The OS Distro Series"""


class Distro(BaseModel):
    name: Optional[str] = None
    r"""The OS Distro name"""

    slug: Optional[str] = None
    r"""The OS Distro slug"""

    series: Optional[str] = None
    r"""The OS Distro Series"""


class OperatingSystemTypedDict(TypedDict):
    name: NotRequired[str]
    r"""The OS name"""
    slug: NotRequired[str]
    r"""The OS slug"""
    version: NotRequired[str]
    r"""The OS description"""
    features: NotRequired[ServerDataFeaturesTypedDict]
    distro: NotRequired[DistroTypedDict]


class OperatingSystem(BaseModel):
    name: Optional[str] = None
    r"""The OS name"""

    slug: Optional[str] = None
    r"""The OS slug"""

    version: Optional[str] = None
    r"""The OS description"""

    features: Optional[ServerDataFeatures] = None

    distro: Optional[Distro] = None


class ServerDataSpecsTypedDict(TypedDict):
    cpu: NotRequired[str]
    r"""CPU model"""
    disk: NotRequired[str]
    r"""Disk quantity and size in GB (e.g. 2 x 500GB)"""
    ram: NotRequired[str]
    r"""RAM size in GB"""
    nic: NotRequired[str]
    r"""NIC quantity and speed"""
    gpu: NotRequired[str]
    r"""GPU model and quantity, if present"""


class ServerDataSpecs(BaseModel):
    cpu: Optional[str] = None
    r"""CPU model"""

    disk: Optional[str] = None
    r"""Disk quantity and size in GB (e.g. 2 x 500GB)"""

    ram: Optional[str] = None
    r"""RAM size in GB"""

    nic: Optional[str] = None
    r"""NIC quantity and speed"""

    gpu: Optional[str] = None
    r"""GPU model and quantity, if present"""


class ServerDataRole(str, Enum):
    EXTERNAL = "external"
    INTERNAL = "internal"
    IPMI = "ipmi"
    UNKNOWN = "unknown"


class InterfacesTypedDict(TypedDict):
    role: NotRequired[ServerDataRole]
    name: NotRequired[str]
    mac_address: NotRequired[str]
    description: NotRequired[str]


class Interfaces(BaseModel):
    role: Optional[ServerDataRole] = None

    name: Optional[str] = None

    mac_address: Optional[str] = None

    description: Optional[str] = None


class ServerDataAttributesTypedDict(TypedDict):
    hostname: NotRequired[str]
    label: NotRequired[str]
    r"""The server label"""
    status: NotRequired[Status]
    r"""`on` - The server is powered ON
    `off` - The server is powered OFF
    `unknown` - The server power status is unknown
    `ready` - The server is in reinstalling state `ready` and should start `disk_erasing` shortly
    `disk_erasing` - The server is in reinstalling state `disk_erasing`
    `failed_disk_erasing` - The server has failed disk erasing in reinstall
    `deploying` - The server is in the last reinstalling stage and is `deploying`
    `failed_deployment` - The server has failed deployment in reinstall

    """
    ipmi_status: NotRequired[IpmiStatus]
    role: NotRequired[str]
    r"""The server role (e.g. Bare Metal)"""
    site: NotRequired[str]
    locked: NotRequired[bool]
    rescue: NotRequired[bool]
    primary_ipv4: NotRequired[str]
    primary_ipv6: NotRequired[str]
    created_at: NotRequired[str]
    scheduled_deletion_at: NotRequired[str]
    plan: NotRequired[ServerDataPlanTypedDict]
    operating_system: NotRequired[OperatingSystemTypedDict]
    region: NotRequired[ServerRegionResourceDataTypedDict]
    specs: NotRequired[ServerDataSpecsTypedDict]
    interfaces: NotRequired[List[InterfacesTypedDict]]
    project: NotRequired[ProjectIncludeTypedDict]
    team: NotRequired[TeamIncludeTypedDict]


class ServerDataAttributes(BaseModel):
    hostname: Optional[str] = None

    label: Optional[str] = None
    r"""The server label"""

    status: Optional[Status] = None
    r"""`on` - The server is powered ON
    `off` - The server is powered OFF
    `unknown` - The server power status is unknown
    `ready` - The server is in reinstalling state `ready` and should start `disk_erasing` shortly
    `disk_erasing` - The server is in reinstalling state `disk_erasing`
    `failed_disk_erasing` - The server has failed disk erasing in reinstall
    `deploying` - The server is in the last reinstalling stage and is `deploying`
    `failed_deployment` - The server has failed deployment in reinstall

    """

    ipmi_status: Optional[IpmiStatus] = None

    role: Optional[str] = None
    r"""The server role (e.g. Bare Metal)"""

    site: Optional[str] = None

    locked: Optional[bool] = None

    rescue: Optional[bool] = None

    primary_ipv4: Optional[str] = None

    primary_ipv6: Optional[str] = None

    created_at: Optional[str] = None

    scheduled_deletion_at: Optional[str] = None

    plan: Optional[ServerDataPlan] = None

    operating_system: Optional[OperatingSystem] = None

    region: Optional[ServerRegionResourceData] = None

    specs: Optional[ServerDataSpecs] = None

    interfaces: Optional[List[Interfaces]] = None

    project: Optional[ProjectInclude] = None

    team: Optional[TeamInclude] = None


class ServerDataTypedDict(TypedDict):
    id: NotRequired[str]
    type: NotRequired[str]
    attributes: NotRequired[ServerDataAttributesTypedDict]


class ServerData(BaseModel):
    id: Optional[str] = None

    type: Optional[str] = None

    attributes: Optional[ServerDataAttributes] = None
