"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TrafficType(str, Enum):
    TRAFFIC = "traffic"


class TrafficDataDataTypedDict(TypedDict):
    date_: NotRequired[str]
    r"""The datetime of the day"""
    inbound_gb: NotRequired[int]
    r"""Value in GB"""
    outbound_gb: NotRequired[int]
    r"""Value in GB"""
    avg_outbound_speed_mbps: NotRequired[float]
    r"""Value in MBps"""
    avg_inbound_speed_mbps: NotRequired[float]
    r"""Value in MBps"""


class TrafficDataData(BaseModel):
    date_: Annotated[Optional[str], pydantic.Field(alias="date")] = None
    r"""The datetime of the day"""

    inbound_gb: Optional[int] = None
    r"""Value in GB"""

    outbound_gb: Optional[int] = None
    r"""Value in GB"""

    avg_outbound_speed_mbps: Optional[float] = None
    r"""Value in MBps"""

    avg_inbound_speed_mbps: Optional[float] = None
    r"""Value in MBps"""


class TrafficRegionsTypedDict(TypedDict):
    region_slug: NotRequired[str]
    total_inbound_gb: NotRequired[int]
    r"""Value in GB"""
    total_outbound_gb: NotRequired[int]
    r"""Value in GB"""
    total_inbound_95th_percentile_mbps: NotRequired[float]
    r"""Value in MBps"""
    total_outbound_95th_percentile_mbps: NotRequired[float]
    r"""Value in MBps"""
    data: NotRequired[List[TrafficDataDataTypedDict]]


class TrafficRegions(BaseModel):
    region_slug: Optional[str] = None

    total_inbound_gb: Optional[int] = None
    r"""Value in GB"""

    total_outbound_gb: Optional[int] = None
    r"""Value in GB"""

    total_inbound_95th_percentile_mbps: Optional[float] = None
    r"""Value in MBps"""

    total_outbound_95th_percentile_mbps: Optional[float] = None
    r"""Value in MBps"""

    data: Optional[List[TrafficDataData]] = None


class TrafficAttributesTypedDict(TypedDict):
    from_date: NotRequired[int]
    r"""The start timestamp. Must be a unix timestamp"""
    to_date: NotRequired[int]
    r"""The end timestamp. Must be a unix timestamp"""
    regions: NotRequired[List[TrafficRegionsTypedDict]]
    total_inbound_gb: NotRequired[int]
    r"""Value in GB"""
    total_outbound_gb: NotRequired[int]
    r"""Value in GB"""
    total_inbound_95th_percentile_mbps: NotRequired[float]
    r"""Value in MBps"""
    total_outbound_95th_percentile_mbps: NotRequired[float]
    r"""Value in MBps"""


class TrafficAttributes(BaseModel):
    from_date: Optional[int] = None
    r"""The start timestamp. Must be a unix timestamp"""

    to_date: Optional[int] = None
    r"""The end timestamp. Must be a unix timestamp"""

    regions: Optional[List[TrafficRegions]] = None

    total_inbound_gb: Optional[int] = None
    r"""Value in GB"""

    total_outbound_gb: Optional[int] = None
    r"""Value in GB"""

    total_inbound_95th_percentile_mbps: Optional[float] = None
    r"""Value in MBps"""

    total_outbound_95th_percentile_mbps: Optional[float] = None
    r"""Value in MBps"""


class TrafficDataTypedDict(TypedDict):
    id: NotRequired[str]
    type: NotRequired[TrafficType]
    attributes: NotRequired[TrafficAttributesTypedDict]


class TrafficData(BaseModel):
    id: Optional[str] = None

    type: Optional[TrafficType] = None

    attributes: Optional[TrafficAttributes] = None


class TrafficTypedDict(TypedDict):
    data: NotRequired[TrafficDataTypedDict]


class Traffic(BaseModel):
    data: Optional[TrafficData] = None
