"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateFirewallFirewallsType(str, Enum):
    FIREWALLS = "firewalls"


class UpdateFirewallFirewallsProtocol(str, Enum):
    TCP = "TCP"
    UDP = "UDP"


class UpdateFirewallFirewallsRulesTypedDict(TypedDict):
    from_: NotRequired[str]
    to: NotRequired[str]
    protocol: NotRequired[UpdateFirewallFirewallsProtocol]
    port: NotRequired[str]
    r"""Port number or range (e.g., \"80\", \"80-443\")"""


class UpdateFirewallFirewallsRules(BaseModel):
    from_: Annotated[Optional[str], pydantic.Field(alias="from")] = None

    to: Optional[str] = None

    protocol: Optional[UpdateFirewallFirewallsProtocol] = None

    port: Optional[str] = None
    r"""Port number or range (e.g., \"80\", \"80-443\")"""


class UpdateFirewallFirewallsAttributesTypedDict(TypedDict):
    name: NotRequired[str]
    rules: NotRequired[List[UpdateFirewallFirewallsRulesTypedDict]]


class UpdateFirewallFirewallsAttributes(BaseModel):
    name: Optional[str] = None

    rules: Optional[List[UpdateFirewallFirewallsRules]] = None


class UpdateFirewallFirewallsDataTypedDict(TypedDict):
    type: UpdateFirewallFirewallsType
    attributes: NotRequired[UpdateFirewallFirewallsAttributesTypedDict]


class UpdateFirewallFirewallsData(BaseModel):
    type: UpdateFirewallFirewallsType

    attributes: Optional[UpdateFirewallFirewallsAttributes] = None


class UpdateFirewallFirewallsRequestBodyTypedDict(TypedDict):
    data: UpdateFirewallFirewallsDataTypedDict


class UpdateFirewallFirewallsRequestBody(BaseModel):
    data: UpdateFirewallFirewallsData


class UpdateFirewallRequestTypedDict(TypedDict):
    firewall_id: str
    r"""The Firewall ID"""
    request_body: UpdateFirewallFirewallsRequestBodyTypedDict


class UpdateFirewallRequest(BaseModel):
    firewall_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The Firewall ID"""

    request_body: Annotated[
        UpdateFirewallFirewallsRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
