"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .project import Project, ProjectTypedDict
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
)
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateProjectProjectsType(str, Enum):
    PROJECTS = "projects"


class UpdateProjectProjectsEnvironment(str, Enum):
    DEVELOPMENT = "Development"
    STAGING = "Staging"
    PRODUCTION = "Production"


class UpdateProjectProjectsAttributesTypedDict(TypedDict):
    name: NotRequired[str]
    description: NotRequired[str]
    environment: NotRequired[UpdateProjectProjectsEnvironment]
    bandwidth_alert: NotRequired[bool]
    tags: NotRequired[List[str]]


class UpdateProjectProjectsAttributes(BaseModel):
    name: Optional[str] = "A brand new name for the virtual network"

    description: Optional[str] = "A brand new description for the virtual network"

    environment: Optional[UpdateProjectProjectsEnvironment] = None

    bandwidth_alert: Optional[bool] = False

    tags: Optional[List[str]] = None


class UpdateProjectProjectsDataTypedDict(TypedDict):
    type: UpdateProjectProjectsType
    id: NotRequired[str]
    attributes: NotRequired[UpdateProjectProjectsAttributesTypedDict]


class UpdateProjectProjectsData(BaseModel):
    type: UpdateProjectProjectsType

    id: Optional[str] = "proj_81EVOtR1N4J2Z"

    attributes: Optional[UpdateProjectProjectsAttributes] = None


class UpdateProjectProjectsRequestBodyTypedDict(TypedDict):
    data: UpdateProjectProjectsDataTypedDict


class UpdateProjectProjectsRequestBody(BaseModel):
    data: UpdateProjectProjectsData


class UpdateProjectRequestTypedDict(TypedDict):
    project_id: str
    r"""The project ID or Slug"""
    request_body: NotRequired[UpdateProjectProjectsRequestBodyTypedDict]


class UpdateProjectRequest(BaseModel):
    project_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The project ID or Slug"""

    request_body: Annotated[
        Optional[UpdateProjectProjectsRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class UpdateProjectResponseBodyTypedDict(TypedDict):
    r"""Success"""

    data: NotRequired[ProjectTypedDict]


class UpdateProjectResponseBody(BaseModel):
    r"""Success"""

    data: Optional[Project] = None
