"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
)
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateServerDeployConfigServersType(str, Enum):
    DEPLOY_CONFIG = "deploy_config"


class UpdateServerDeployConfigServersOperatingSystem(str, Enum):
    IPXE = "ipxe"
    WINDOWS_SERVER_2019_STD_V1 = "windows_server_2019_std_v1"
    UBUNTU_22_04_X64_LTS = "ubuntu_22_04_x64_lts"
    DEBIAN_11 = "debian_11"
    DEBIAN_10 = "debian_10"
    RHEL8 = "rhel8"
    WINDOWS_SERVER_2012_R2_STD_V28 = "windows_server_2012_r2_std_v28"
    WINDOWS_SERVER_2012_R2_DC_V5 = "windows_server_2012_r2_dc_v5"
    ESXI_6_7 = "esxi_6_7"
    DEBIAN_9_4_X64 = "debian_9_4_x64"
    CENTOS_7_4_X64 = "centos_7_4_x64"
    CENTOS_8_X64 = "centos_8_x64"
    UBUNTU_16_04_X64_LTS = "ubuntu_16_04_x64_lts"
    UBUNTU_20_04_X64_LTS = "ubuntu_20_04_x64_lts"
    WINDOWS_SERVER_2016_STD_V1 = "windows_server_2016_std_v1"
    WINDOWS_SERVER_2016_DC_V1 = "windows_server_2016_dc_v1"
    WINDOWS_SERVER_2019_DC_V1 = "windows_server_2019_dc_v1"
    DEBIAN_12 = "debian_12"
    UBUNTU22_ML_IN_A_BOX = "ubuntu22_ml_in_a_box"
    UBUNTU_18_04_X64_LTS = "ubuntu_18_04_x64_lts"
    WINDOWS_SERVER_2019_STD_UEFI = "windows_server_2019_std_uefi"
    WINDOWS_2022_STD_UEFI = "windows_2022_std_uefi"
    WINDOWS_2022_STD = "windows_2022_std"
    UBUNTU_24_04_X64_LTS = "ubuntu_24_04_x64_lts"
    ROCKYLINUX_8 = "rockylinux_8"


class UpdateServerDeployConfigServersRaid(str, Enum):
    RAID_0 = "raid-0"
    RAID_1 = "raid-1"


class UpdateServerDeployConfigServersPartitionsTypedDict(TypedDict):
    size_in_gb: NotRequired[int]
    path: NotRequired[str]
    filesystem_type: NotRequired[str]


class UpdateServerDeployConfigServersPartitions(BaseModel):
    size_in_gb: Optional[int] = None

    path: Optional[str] = None

    filesystem_type: Optional[str] = None


class UpdateServerDeployConfigServersAttributesTypedDict(TypedDict):
    hostname: NotRequired[str]
    operating_system: NotRequired[UpdateServerDeployConfigServersOperatingSystem]
    raid: NotRequired[UpdateServerDeployConfigServersRaid]
    user_data: NotRequired[str]
    r"""User data to configure the server"""
    ssh_keys: NotRequired[List[str]]
    partitions: NotRequired[List[UpdateServerDeployConfigServersPartitionsTypedDict]]
    ipxe_url: NotRequired[str]
    r"""URL where iPXE script is stored on, necessary for custom image deployments. This attribute is required when operating system iPXE is selected."""


class UpdateServerDeployConfigServersAttributes(BaseModel):
    hostname: Optional[str] = None

    operating_system: Optional[UpdateServerDeployConfigServersOperatingSystem] = None

    raid: Optional[UpdateServerDeployConfigServersRaid] = None

    user_data: Optional[str] = None
    r"""User data to configure the server"""

    ssh_keys: Optional[List[str]] = None

    partitions: Optional[List[UpdateServerDeployConfigServersPartitions]] = None

    ipxe_url: Optional[str] = None
    r"""URL where iPXE script is stored on, necessary for custom image deployments. This attribute is required when operating system iPXE is selected."""


class UpdateServerDeployConfigServersRequestBodyTypedDict(TypedDict):
    type: UpdateServerDeployConfigServersType
    attributes: NotRequired[UpdateServerDeployConfigServersAttributesTypedDict]


class UpdateServerDeployConfigServersRequestBody(BaseModel):
    type: UpdateServerDeployConfigServersType

    attributes: Optional[UpdateServerDeployConfigServersAttributes] = None


class UpdateServerDeployConfigRequestTypedDict(TypedDict):
    server_id: str
    r"""The Server ID"""
    request_body: UpdateServerDeployConfigServersRequestBodyTypedDict


class UpdateServerDeployConfigRequest(BaseModel):
    server_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The Server ID"""

    request_body: Annotated[
        UpdateServerDeployConfigServersRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
