"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
)
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateServerServersType(str, Enum):
    SERVERS = "servers"


class UpdateServerServersBilling(str, Enum):
    r"""The server billing type. Accepts `hourly` and `monthly` for on demand projects and `yearly` for reserved projects."""

    HOURLY = "hourly"
    MONTHLY = "monthly"
    YEARLY = "yearly"


class UpdateServerServersAttributesTypedDict(TypedDict):
    hostname: NotRequired[str]
    billing: NotRequired[UpdateServerServersBilling]
    r"""The server billing type. Accepts `hourly` and `monthly` for on demand projects and `yearly` for reserved projects."""
    tags: NotRequired[List[str]]
    r"""List of Tag IDs"""
    project: NotRequired[str]
    r"""Project ID or slug to move the server to"""


class UpdateServerServersAttributes(BaseModel):
    hostname: Optional[str] = "new-hostname"

    billing: Optional[UpdateServerServersBilling] = None
    r"""The server billing type. Accepts `hourly` and `monthly` for on demand projects and `yearly` for reserved projects."""

    tags: Optional[List[str]] = None
    r"""List of Tag IDs"""

    project: Optional[str] = None
    r"""Project ID or slug to move the server to"""


class UpdateServerServersDataTypedDict(TypedDict):
    id: NotRequired[str]
    type: NotRequired[UpdateServerServersType]
    attributes: NotRequired[UpdateServerServersAttributesTypedDict]


class UpdateServerServersData(BaseModel):
    id: Optional[str] = "sv_81EVOtR1N4J2Z"

    type: Optional[UpdateServerServersType] = None

    attributes: Optional[UpdateServerServersAttributes] = None


class UpdateServerServersRequestBodyTypedDict(TypedDict):
    data: NotRequired[UpdateServerServersDataTypedDict]


class UpdateServerServersRequestBody(BaseModel):
    data: Optional[UpdateServerServersData] = None


class UpdateServerRequestTypedDict(TypedDict):
    server_id: str
    request_body: UpdateServerServersRequestBodyTypedDict


class UpdateServerRequest(BaseModel):
    server_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    request_body: Annotated[
        UpdateServerServersRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
