"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
)
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateTagTagsType(str, Enum):
    TAGS = "tags"


class UpdateTagTagsAttributesTypedDict(TypedDict):
    name: NotRequired[str]
    r"""Name of the Tag"""
    description: NotRequired[str]
    r"""Description of the Tag"""
    color: NotRequired[str]
    r"""Color of the Tag"""


class UpdateTagTagsAttributes(BaseModel):
    name: Optional[str] = None
    r"""Name of the Tag"""

    description: Optional[str] = None
    r"""Description of the Tag"""

    color: Optional[str] = "#ffffff"
    r"""Color of the Tag"""


class UpdateTagTagsDataTypedDict(TypedDict):
    id: NotRequired[str]
    type: NotRequired[UpdateTagTagsType]
    attributes: NotRequired[UpdateTagTagsAttributesTypedDict]


class UpdateTagTagsData(BaseModel):
    id: Optional[str] = None

    type: Optional[UpdateTagTagsType] = None

    attributes: Optional[UpdateTagTagsAttributes] = None


class UpdateTagTagsRequestBodyTypedDict(TypedDict):
    data: NotRequired[UpdateTagTagsDataTypedDict]


class UpdateTagTagsRequestBody(BaseModel):
    data: Optional[UpdateTagTagsData] = None


class UpdateTagRequestTypedDict(TypedDict):
    tag_id: str
    request_body: UpdateTagTagsRequestBodyTypedDict


class UpdateTagRequest(BaseModel):
    tag_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    request_body: Annotated[
        UpdateTagTagsRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
