"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .project_include import ProjectInclude, ProjectIncludeTypedDict
from .team_include import TeamInclude, TeamIncludeTypedDict
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class VirtualMachineAttributesType(str, Enum):
    VIRTUAL_MACHINES = "virtual_machines"


class VirtualMachineAttributesStatus(str, Enum):
    RUNNING = "Running"
    CONFIGURING_NETWORK = "Configuring network"
    STARTING = "Starting"
    SCHEDULING = "Scheduling"
    SCHEDULED = "Scheduled"


class CredentialsTypedDict(TypedDict):
    username: NotRequired[str]
    host: NotRequired[str]
    password: NotRequired[str]
    ssh_keys: NotRequired[List[str]]


class Credentials(BaseModel):
    username: Optional[str] = None

    host: Optional[str] = None

    password: Optional[str] = None

    ssh_keys: Optional[List[str]] = None


class VirtualMachineAttributesPlanTypedDict(TypedDict):
    id: NotRequired[str]
    name: NotRequired[str]


class VirtualMachineAttributesPlan(BaseModel):
    id: Optional[str] = None

    name: Optional[str] = None


class VirtualMachineAttributesSpecsTypedDict(TypedDict):
    vcpu: NotRequired[int]
    ram: NotRequired[str]
    storage: NotRequired[str]
    nic: NotRequired[str]
    gpu: NotRequired[str]


class VirtualMachineAttributesSpecs(BaseModel):
    vcpu: Optional[int] = None

    ram: Optional[str] = None

    storage: Optional[str] = None

    nic: Optional[str] = None

    gpu: Optional[str] = None


class VirtualMachineAttributesAttributesTypedDict(TypedDict):
    name: NotRequired[str]
    created_at: NotRequired[str]
    status: NotRequired[VirtualMachineAttributesStatus]
    operating_system: NotRequired[str]
    credentials: NotRequired[CredentialsTypedDict]
    plan: NotRequired[VirtualMachineAttributesPlanTypedDict]
    specs: NotRequired[VirtualMachineAttributesSpecsTypedDict]
    team: NotRequired[TeamIncludeTypedDict]
    project: NotRequired[ProjectIncludeTypedDict]


class VirtualMachineAttributesAttributes(BaseModel):
    name: Optional[str] = None

    created_at: Optional[str] = None

    status: Optional[VirtualMachineAttributesStatus] = None

    operating_system: Optional[str] = None

    credentials: Optional[Credentials] = None

    plan: Optional[VirtualMachineAttributesPlan] = None

    specs: Optional[VirtualMachineAttributesSpecs] = None

    team: Optional[TeamInclude] = None

    project: Optional[ProjectInclude] = None


class VirtualMachineAttributesTypedDict(TypedDict):
    id: NotRequired[str]
    type: NotRequired[VirtualMachineAttributesType]
    attributes: NotRequired[VirtualMachineAttributesAttributesTypedDict]


class VirtualMachineAttributes(BaseModel):
    id: Optional[str] = None

    type: Optional[VirtualMachineAttributesType] = None

    attributes: Optional[VirtualMachineAttributesAttributes] = None
