"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class VirtualMachinePlansType(str, Enum):
    r"""The type of the resource"""

    VIRTUAL_MACHINE_PLANS = "virtual_machine_plans"


class VirtualMachinePlansDataType(str, Enum):
    r"""The type of the disk"""

    LOCAL = "local"


class VirtualMachinePlansUnit(str, Enum):
    r"""The unit of the disk size"""

    GIB = "gib"


class SizeTypedDict(TypedDict):
    amount: NotRequired[int]
    r"""The total size of the disk"""
    unit: NotRequired[VirtualMachinePlansUnit]
    r"""The unit of the disk size"""


class Size(BaseModel):
    amount: Optional[int] = None
    r"""The total size of the disk"""

    unit: Optional[VirtualMachinePlansUnit] = None
    r"""The unit of the disk size"""


class DiskTypedDict(TypedDict):
    type: NotRequired[VirtualMachinePlansDataType]
    r"""The type of the disk"""
    size: NotRequired[SizeTypedDict]


class Disk(BaseModel):
    type: Optional[VirtualMachinePlansDataType] = None
    r"""The type of the disk"""

    size: Optional[Size] = None


class VirtualMachinePlansSpecsTypedDict(TypedDict):
    memory: NotRequired[int]
    r"""The total memory"""
    vcpus: NotRequired[int]
    r"""The number of virtual CPUs"""
    disk: NotRequired[DiskTypedDict]


class VirtualMachinePlansSpecs(BaseModel):
    memory: Optional[int] = None
    r"""The total memory"""

    vcpus: Optional[int] = None
    r"""The number of virtual CPUs"""

    disk: Optional[Disk] = None


class VirtualMachinePlansUSDTypedDict(TypedDict):
    hour: NotRequired[float]
    month: NotRequired[float]
    year: NotRequired[float]


class VirtualMachinePlansUSD(BaseModel):
    hour: Optional[float] = None

    month: Optional[float] = None

    year: Optional[float] = None


class VirtualMachinePlansBRLTypedDict(TypedDict):
    hour: NotRequired[float]
    month: NotRequired[float]
    year: NotRequired[float]


class VirtualMachinePlansBRL(BaseModel):
    hour: Optional[float] = None

    month: Optional[float] = None

    year: Optional[float] = None


class VirtualMachinePlansPricingTypedDict(TypedDict):
    usd: NotRequired[VirtualMachinePlansUSDTypedDict]
    brl: NotRequired[VirtualMachinePlansBRLTypedDict]


class VirtualMachinePlansPricing(BaseModel):
    usd: Annotated[Optional[VirtualMachinePlansUSD], pydantic.Field(alias="USD")] = None

    brl: Annotated[Optional[VirtualMachinePlansBRL], pydantic.Field(alias="BRL")] = None


class VirtualMachinePlansRegionsTypedDict(TypedDict):
    name: NotRequired[str]
    available: NotRequired[List[str]]
    pricing: NotRequired[VirtualMachinePlansPricingTypedDict]


class VirtualMachinePlansRegions(BaseModel):
    name: Optional[str] = None

    available: Optional[List[str]] = None

    pricing: Optional[VirtualMachinePlansPricing] = None


class VirtualMachinePlansStockLevel(str, Enum):
    r"""The stock level of the plan"""

    LOW = "low"
    UNAVAILABLE = "unavailable"
    MEDIUM = "medium"
    HIGH = "high"


class VirtualMachinePlansAttributesTypedDict(TypedDict):
    name: NotRequired[str]
    r"""The name of the plan"""
    specs: NotRequired[VirtualMachinePlansSpecsTypedDict]
    regions: NotRequired[List[VirtualMachinePlansRegionsTypedDict]]
    stock_level: NotRequired[VirtualMachinePlansStockLevel]
    r"""The stock level of the plan"""


class VirtualMachinePlansAttributes(BaseModel):
    name: Optional[str] = None
    r"""The name of the plan"""

    specs: Optional[VirtualMachinePlansSpecs] = None

    regions: Optional[List[VirtualMachinePlansRegions]] = None

    stock_level: Optional[VirtualMachinePlansStockLevel] = None
    r"""The stock level of the plan"""


class VirtualMachinePlansDataTypedDict(TypedDict):
    id: NotRequired[str]
    r"""The ID of the plan"""
    type: NotRequired[VirtualMachinePlansType]
    r"""The type of the resource"""
    attributes: NotRequired[VirtualMachinePlansAttributesTypedDict]


class VirtualMachinePlansData(BaseModel):
    id: Optional[str] = None
    r"""The ID of the plan"""

    type: Optional[VirtualMachinePlansType] = None
    r"""The type of the resource"""

    attributes: Optional[VirtualMachinePlansAttributes] = None


class VirtualMachinePlansTypedDict(TypedDict):
    data: NotRequired[List[VirtualMachinePlansDataTypedDict]]


class VirtualMachinePlans(BaseModel):
    data: Optional[List[VirtualMachinePlansData]] = None
