"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .project_include import ProjectInclude, ProjectIncludeTypedDict
from datetime import datetime
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class VirtualNetworkDataType(str, Enum):
    VIRTUAL_NETWORKS = "virtual_networks"


class VirtualNetworkDataSiteTypedDict(TypedDict):
    id: NotRequired[str]
    facility: NotRequired[str]
    name: NotRequired[str]
    slug: NotRequired[str]


class VirtualNetworkDataSite(BaseModel):
    id: Optional[str] = None

    facility: Optional[str] = None

    name: Optional[str] = None

    slug: Optional[str] = None


class VirtualNetworkDataRegionTypedDict(TypedDict):
    city: NotRequired[str]
    country: NotRequired[str]
    site: NotRequired[VirtualNetworkDataSiteTypedDict]


class VirtualNetworkDataRegion(BaseModel):
    city: Optional[str] = None

    country: Optional[str] = None

    site: Optional[VirtualNetworkDataSite] = None


class TagsModelTypedDict(TypedDict):
    id: NotRequired[str]
    name: NotRequired[str]
    description: NotRequired[str]
    color: NotRequired[str]


class TagsModel(BaseModel):
    id: Optional[str] = None

    name: Optional[str] = None

    description: Optional[str] = None

    color: Optional[str] = None


class VirtualNetworkDataAttributesTypedDict(TypedDict):
    vid: NotRequired[int]
    r"""vlan ID of the virtual network"""
    name: NotRequired[str]
    r"""Name of the virtual network"""
    description: NotRequired[str]
    r"""Description of the virtual network"""
    project: NotRequired[ProjectIncludeTypedDict]
    region: NotRequired[VirtualNetworkDataRegionTypedDict]
    created_at: NotRequired[datetime]
    assignments_count: NotRequired[int]
    r"""Amount of devices assigned to the virtual network"""
    tags: NotRequired[List[TagsModelTypedDict]]
    r"""Tags associated with the virtual network"""


class VirtualNetworkDataAttributes(BaseModel):
    vid: Optional[int] = None
    r"""vlan ID of the virtual network"""

    name: Optional[str] = None
    r"""Name of the virtual network"""

    description: Optional[str] = None
    r"""Description of the virtual network"""

    project: Optional[ProjectInclude] = None

    region: Optional[VirtualNetworkDataRegion] = None

    created_at: Optional[datetime] = None

    assignments_count: Optional[int] = None
    r"""Amount of devices assigned to the virtual network"""

    tags: Optional[List[TagsModel]] = None
    r"""Tags associated with the virtual network"""


class VirtualNetworkDataTypedDict(TypedDict):
    id: NotRequired[str]
    type: NotRequired[VirtualNetworkDataType]
    attributes: NotRequired[VirtualNetworkDataAttributesTypedDict]


class VirtualNetworkData(BaseModel):
    id: Optional[str] = None

    type: Optional[VirtualNetworkDataType] = None

    attributes: Optional[VirtualNetworkDataAttributes] = None
