"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from .httpclient import AsyncHttpClient, ClientOwner, HttpClient, close_clients
from .sdkconfiguration import SDKConfiguration
from .utils.logger import Logger, get_default_logger
from .utils.retries import RetryConfig
import httpx
import importlib
from latitudesh_python_sdk import models, utils
from latitudesh_python_sdk._hooks import SDKHooks
from latitudesh_python_sdk.types import OptionalNullable, UNSET
import sys
from typing import Any, Callable, Dict, List, Optional, TYPE_CHECKING, Union, cast
import weakref

if TYPE_CHECKING:
    from latitudesh_python_sdk.apikeys import APIKeys
    from latitudesh_python_sdk.billing import Billing
    from latitudesh_python_sdk.events_sdk import EventsSDK
    from latitudesh_python_sdk.firewalls_sdk import FirewallsSDK
    from latitudesh_python_sdk.ipaddresses_sdk import IPAddressesSDK
    from latitudesh_python_sdk.operatingsystems_sdk import OperatingSystemsSDK
    from latitudesh_python_sdk.plans import Plans
    from latitudesh_python_sdk.privatenetworks import PrivateNetworks
    from latitudesh_python_sdk.projects_sdk import ProjectsSDK
    from latitudesh_python_sdk.regions_sdk import RegionsSDK
    from latitudesh_python_sdk.roles import Roles
    from latitudesh_python_sdk.servers_sdk import ServersSDK
    from latitudesh_python_sdk.sshkeys_sdk import SSHKeysSDK
    from latitudesh_python_sdk.storage import Storage
    from latitudesh_python_sdk.tags import Tags
    from latitudesh_python_sdk.teams_sdk import TeamsSDK
    from latitudesh_python_sdk.teamsmembers import TeamsMembers
    from latitudesh_python_sdk.traffic_sdk import TrafficSDK
    from latitudesh_python_sdk.userdata_sdk import UserDataSDK
    from latitudesh_python_sdk.userprofile import UserProfile
    from latitudesh_python_sdk.virtualmachines import VirtualMachines
    from latitudesh_python_sdk.vpnsessions import VpnSessions


class Latitudesh(BaseSDK):
    r"""Latitude.sh API: The Latitude.sh API is a RESTful API to manage your Latitude.sh account. It allows you to perform the same actions as the Latitude.sh dashboard."""

    api_keys: "APIKeys"
    billing: "Billing"
    events: "EventsSDK"
    firewalls: "FirewallsSDK"
    ip_addresses: "IPAddressesSDK"
    teams_members: "TeamsMembers"
    operating_systems: "OperatingSystemsSDK"
    plans: "Plans"
    projects: "ProjectsSDK"
    ssh_keys: "SSHKeysSDK"
    user_data: "UserDataSDK"
    regions: "RegionsSDK"
    roles: "Roles"
    servers: "ServersSDK"
    storage: "Storage"
    tags: "Tags"
    teams: "TeamsSDK"
    traffic: "TrafficSDK"
    user_profile: "UserProfile"
    virtual_machines: "VirtualMachines"
    private_networks: "PrivateNetworks"
    vpn_sessions: "VpnSessions"
    _sub_sdk_map = {
        "api_keys": ("latitudesh_python_sdk.apikeys", "APIKeys"),
        "billing": ("latitudesh_python_sdk.billing", "Billing"),
        "events": ("latitudesh_python_sdk.events_sdk", "EventsSDK"),
        "firewalls": ("latitudesh_python_sdk.firewalls_sdk", "FirewallsSDK"),
        "ip_addresses": ("latitudesh_python_sdk.ipaddresses_sdk", "IPAddressesSDK"),
        "teams_members": ("latitudesh_python_sdk.teamsmembers", "TeamsMembers"),
        "operating_systems": (
            "latitudesh_python_sdk.operatingsystems_sdk",
            "OperatingSystemsSDK",
        ),
        "plans": ("latitudesh_python_sdk.plans", "Plans"),
        "projects": ("latitudesh_python_sdk.projects_sdk", "ProjectsSDK"),
        "ssh_keys": ("latitudesh_python_sdk.sshkeys_sdk", "SSHKeysSDK"),
        "user_data": ("latitudesh_python_sdk.userdata_sdk", "UserDataSDK"),
        "regions": ("latitudesh_python_sdk.regions_sdk", "RegionsSDK"),
        "roles": ("latitudesh_python_sdk.roles", "Roles"),
        "servers": ("latitudesh_python_sdk.servers_sdk", "ServersSDK"),
        "storage": ("latitudesh_python_sdk.storage", "Storage"),
        "tags": ("latitudesh_python_sdk.tags", "Tags"),
        "teams": ("latitudesh_python_sdk.teams_sdk", "TeamsSDK"),
        "traffic": ("latitudesh_python_sdk.traffic_sdk", "TrafficSDK"),
        "user_profile": ("latitudesh_python_sdk.userprofile", "UserProfile"),
        "virtual_machines": (
            "latitudesh_python_sdk.virtualmachines",
            "VirtualMachines",
        ),
        "private_networks": (
            "latitudesh_python_sdk.privatenetworks",
            "PrivateNetworks",
        ),
        "vpn_sessions": ("latitudesh_python_sdk.vpnsessions", "VpnSessions"),
    }

    def __init__(
        self,
        bearer: Optional[Union[Optional[str], Callable[[], Optional[str]]]] = None,
        latitude_api_key: Optional[str] = None,
        server_idx: Optional[int] = None,
        server_url: Optional[str] = None,
        url_params: Optional[Dict[str, str]] = None,
        client: Optional[HttpClient] = None,
        async_client: Optional[AsyncHttpClient] = None,
        retry_config: OptionalNullable[RetryConfig] = UNSET,
        timeout_ms: Optional[int] = None,
        debug_logger: Optional[Logger] = None,
    ) -> None:
        r"""Instantiates the SDK configuring it with the provided parameters.

        :param bearer: The bearer required for authentication
        :param latitude_api_key: Allows setting the latitude_api_key variable for url substitution
        :param server_idx: The index of the server to use for all methods
        :param server_url: The server URL to use for all methods
        :param url_params: Parameters to optionally template the server URL with
        :param client: The HTTP client to use for all synchronous methods
        :param async_client: The Async HTTP client to use for all asynchronous methods
        :param retry_config: The retry configuration to use for all supported methods
        :param timeout_ms: Optional request timeout applied to each operation in milliseconds
        """
        client_supplied = True
        if client is None:
            client = httpx.Client(follow_redirects=True)
            client_supplied = False

        assert issubclass(
            type(client), HttpClient
        ), "The provided client must implement the HttpClient protocol."

        async_client_supplied = True
        if async_client is None:
            async_client = httpx.AsyncClient(follow_redirects=True)
            async_client_supplied = False

        if debug_logger is None:
            debug_logger = get_default_logger()

        assert issubclass(
            type(async_client), AsyncHttpClient
        ), "The provided async_client must implement the AsyncHttpClient protocol."

        security: Any = None
        if callable(bearer):
            # pylint: disable=unnecessary-lambda-assignment
            security = lambda: models.Security(bearer=bearer())
        else:
            security = models.Security(bearer=bearer)

        if server_url is not None:
            if url_params is not None:
                server_url = utils.template_url(server_url, url_params)
        server_defaults: List[Dict[str, str]] = [
            {
                "latitude_api_key": latitude_api_key or "<insert your api key here>",
            },
            {
                "latitude_api_key": latitude_api_key or "<insert your api key here>",
            },
        ]

        BaseSDK.__init__(
            self,
            SDKConfiguration(
                client=client,
                client_supplied=client_supplied,
                async_client=async_client,
                async_client_supplied=async_client_supplied,
                security=security,
                server_url=server_url,
                server_idx=server_idx,
                server_defaults=server_defaults,
                retry_config=retry_config,
                timeout_ms=timeout_ms,
                debug_logger=debug_logger,
            ),
            parent_ref=self,
        )

        hooks = SDKHooks()

        # pylint: disable=protected-access
        self.sdk_configuration.__dict__["_hooks"] = hooks

        current_server_url, *_ = self.sdk_configuration.get_server_details()
        server_url, self.sdk_configuration.client = hooks.sdk_init(
            current_server_url, client
        )
        if current_server_url != server_url:
            self.sdk_configuration.server_url = server_url

        weakref.finalize(
            self,
            close_clients,
            cast(ClientOwner, self.sdk_configuration),
            self.sdk_configuration.client,
            self.sdk_configuration.client_supplied,
            self.sdk_configuration.async_client,
            self.sdk_configuration.async_client_supplied,
        )

    def dynamic_import(self, modname, retries=3):
        for attempt in range(retries):
            try:
                return importlib.import_module(modname)
            except KeyError:
                # Clear any half-initialized module and retry
                sys.modules.pop(modname, None)
                if attempt == retries - 1:
                    break
        raise KeyError(f"Failed to import module '{modname}' after {retries} attempts")

    def __getattr__(self, name: str):
        if name in self._sub_sdk_map:
            module_path, class_name = self._sub_sdk_map[name]
            try:
                module = self.dynamic_import(module_path)
                klass = getattr(module, class_name)
                instance = klass(self.sdk_configuration, parent_ref=self)
                setattr(self, name, instance)
                return instance
            except ImportError as e:
                raise AttributeError(
                    f"Failed to import module {module_path} for attribute {name}: {e}"
                ) from e
            except AttributeError as e:
                raise AttributeError(
                    f"Failed to find class {class_name} in module {module_path} for attribute {name}: {e}"
                ) from e

        raise AttributeError(
            f"'{type(self).__name__}' object has no attribute '{name}'"
        )

    def __dir__(self):
        default_attrs = list(super().__dir__())
        lazy_attrs = list(self._sub_sdk_map.keys())
        return sorted(list(set(default_attrs + lazy_attrs)))

    def __enter__(self):
        return self

    async def __aenter__(self):
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        if (
            self.sdk_configuration.client is not None
            and not self.sdk_configuration.client_supplied
        ):
            self.sdk_configuration.client.close()
        self.sdk_configuration.client = None

    async def __aexit__(self, exc_type, exc_val, exc_tb):
        if (
            self.sdk_configuration.async_client is not None
            and not self.sdk_configuration.async_client_supplied
        ):
            await self.sdk_configuration.async_client.aclose()
        self.sdk_configuration.async_client = None
