# LiveChat Platform API SDK for Python3

This Software Development Kit written in Python3 helps developers build external backend apps that extend LiveChat features. The SDK makes it easy to use Agent Chat API, Customer Chat API and Configuration API.

## API protocol docs

For protocol documentation of LiveChat APIs, please go to [Livechat Platform Docs](https://developers.livechatinc.com/docs/).

## Technical docs

Agent Chat API:
* [RTM API](https://livechat.github.io/lc-sdk-python/agent_rtm/index.html)
* [WEB API](https://livechat.github.io/lc-sdk-python/agent_web/index.html)

Customer Chat API:
* [RTM API](https://livechat.github.io/lc-sdk-python/customer_rtm/index.html)
* [WEB API](https://livechat.github.io/lc-sdk-python/customer_web/index.html)

Management:
* [Configuration API](https://livechat.github.io/lc-sdk-python/configuration/index.html)

Reports:
* [Reports API](https://livechat.github.io/lc-sdk-python/reports/index.html)

## Installation

### pip

```bash
pip install lc-sdk-python
```

## Usage

Usage examples can be found here:
[examples](https://github.com/livechat/lc-sdk-python/tree/master/examples)

## Feedback

​If you find any bugs or have trouble implementing the code on your own, please create an issue or contact us via e-mail: apiteam.qa@livechat.com.

## About LiveChat

LiveChat is an online customer service software with live support, help desk software, and web analytics capabilities. It's used by more than 32,000 companies all over the world. For more info, check out [LiveChat](https://livechat.com/).
