# coding: utf-8

"""
    Leap

    The Official Leap API

    The version of the OpenAPI document: 1.0
    Created by: https://tryleap.ai/
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from leap import schemas  # noqa: F401


class InferenceEntity(
    schemas.DictSchema
):
    """
    This class is auto generated by Konfig (https://konfigthis.com)
    """


    class MetaOapg:
        required = {
            "images",
            "seed",
            "modelId",
            "upscalingOption",
            "steps",
            "promptStrength",
            "negativePrompt",
            "createdAt",
            "numberOfImages",
            "width",
            "id",
            "state",
            "prompt",
            "height",
            "status",
        }
        
        class properties:
            id = schemas.StrSchema
            createdAt = schemas.DateTimeSchema
            prompt = schemas.StrSchema
            negativePrompt = schemas.StrSchema
            seed = schemas.NumberSchema
            width = schemas.NumberSchema
            height = schemas.NumberSchema
            promptStrength = schemas.NumberSchema
            numberOfImages = schemas.NumberSchema
            
            
            class state(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "failed": "FAILED",
                        "finished": "FINISHED",
                        "processing": "PROCESSING",
                        "queued": "QUEUED",
                    }
                
                @schemas.classproperty
                def FAILED(cls):
                    return cls("failed")
                
                @schemas.classproperty
                def FINISHED(cls):
                    return cls("finished")
                
                @schemas.classproperty
                def PROCESSING(cls):
                    return cls("processing")
                
                @schemas.classproperty
                def QUEUED(cls):
                    return cls("queued")
            
            
            class status(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "failed": "FAILED",
                        "finished": "FINISHED",
                        "processing": "PROCESSING",
                        "queued": "QUEUED",
                    }
                
                @schemas.classproperty
                def FAILED(cls):
                    return cls("failed")
                
                @schemas.classproperty
                def FINISHED(cls):
                    return cls("finished")
                
                @schemas.classproperty
                def PROCESSING(cls):
                    return cls("processing")
                
                @schemas.classproperty
                def QUEUED(cls):
                    return cls("queued")
            steps = schemas.NumberSchema
            
            
            class images(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['InferenceImageEntity']:
                        return InferenceImageEntity
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['InferenceImageEntity'], typing.List['InferenceImageEntity']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'images':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'InferenceImageEntity':
                    return super().__getitem__(i)
        
            @staticmethod
            def modelId() -> typing.Type['InferenceEntityModelId']:
                return InferenceEntityModelId
            
            
            class upscalingOption(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "x1": "X1",
                        "x2": "X2",
                        "x4": "X4",
                    }
                
                @schemas.classproperty
                def X1(cls):
                    return cls("x1")
                
                @schemas.classproperty
                def X2(cls):
                    return cls("x2")
                
                @schemas.classproperty
                def X4(cls):
                    return cls("x4")
            __annotations__ = {
                "id": id,
                "createdAt": createdAt,
                "prompt": prompt,
                "negativePrompt": negativePrompt,
                "seed": seed,
                "width": width,
                "height": height,
                "promptStrength": promptStrength,
                "numberOfImages": numberOfImages,
                "state": state,
                "status": status,
                "steps": steps,
                "images": images,
                "modelId": modelId,
                "upscalingOption": upscalingOption,
            }
    
    images: MetaOapg.properties.images
    seed: MetaOapg.properties.seed
    modelId: 'InferenceEntityModelId'
    upscalingOption: MetaOapg.properties.upscalingOption
    steps: MetaOapg.properties.steps
    promptStrength: MetaOapg.properties.promptStrength
    negativePrompt: MetaOapg.properties.negativePrompt
    createdAt: MetaOapg.properties.createdAt
    numberOfImages: MetaOapg.properties.numberOfImages
    width: MetaOapg.properties.width
    id: MetaOapg.properties.id
    state: MetaOapg.properties.state
    prompt: MetaOapg.properties.prompt
    height: MetaOapg.properties.height
    status: MetaOapg.properties.status
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["createdAt"]) -> MetaOapg.properties.createdAt: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["prompt"]) -> MetaOapg.properties.prompt: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["negativePrompt"]) -> MetaOapg.properties.negativePrompt: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["seed"]) -> MetaOapg.properties.seed: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["width"]) -> MetaOapg.properties.width: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["height"]) -> MetaOapg.properties.height: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["promptStrength"]) -> MetaOapg.properties.promptStrength: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["numberOfImages"]) -> MetaOapg.properties.numberOfImages: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["state"]) -> MetaOapg.properties.state: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["status"]) -> MetaOapg.properties.status: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["steps"]) -> MetaOapg.properties.steps: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["images"]) -> MetaOapg.properties.images: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["modelId"]) -> 'InferenceEntityModelId': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["upscalingOption"]) -> MetaOapg.properties.upscalingOption: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["id", "createdAt", "prompt", "negativePrompt", "seed", "width", "height", "promptStrength", "numberOfImages", "state", "status", "steps", "images", "modelId", "upscalingOption", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["createdAt"]) -> MetaOapg.properties.createdAt: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["prompt"]) -> MetaOapg.properties.prompt: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["negativePrompt"]) -> MetaOapg.properties.negativePrompt: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["seed"]) -> MetaOapg.properties.seed: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["width"]) -> MetaOapg.properties.width: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["height"]) -> MetaOapg.properties.height: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["promptStrength"]) -> MetaOapg.properties.promptStrength: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["numberOfImages"]) -> MetaOapg.properties.numberOfImages: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["state"]) -> MetaOapg.properties.state: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["status"]) -> MetaOapg.properties.status: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["steps"]) -> MetaOapg.properties.steps: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["images"]) -> MetaOapg.properties.images: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["modelId"]) -> 'InferenceEntityModelId': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["upscalingOption"]) -> MetaOapg.properties.upscalingOption: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["id", "createdAt", "prompt", "negativePrompt", "seed", "width", "height", "promptStrength", "numberOfImages", "state", "status", "steps", "images", "modelId", "upscalingOption", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        images: typing.Union[MetaOapg.properties.images, list, tuple, ],
        seed: typing.Union[MetaOapg.properties.seed, decimal.Decimal, int, float, ],
        modelId: 'InferenceEntityModelId',
        upscalingOption: typing.Union[MetaOapg.properties.upscalingOption, str, ],
        steps: typing.Union[MetaOapg.properties.steps, decimal.Decimal, int, float, ],
        promptStrength: typing.Union[MetaOapg.properties.promptStrength, decimal.Decimal, int, float, ],
        negativePrompt: typing.Union[MetaOapg.properties.negativePrompt, str, ],
        createdAt: typing.Union[MetaOapg.properties.createdAt, str, datetime, ],
        numberOfImages: typing.Union[MetaOapg.properties.numberOfImages, decimal.Decimal, int, float, ],
        width: typing.Union[MetaOapg.properties.width, decimal.Decimal, int, float, ],
        id: typing.Union[MetaOapg.properties.id, str, ],
        state: typing.Union[MetaOapg.properties.state, str, ],
        prompt: typing.Union[MetaOapg.properties.prompt, str, ],
        height: typing.Union[MetaOapg.properties.height, decimal.Decimal, int, float, ],
        status: typing.Union[MetaOapg.properties.status, str, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'InferenceEntity':
        return super().__new__(
            cls,
            *args,
            images=images,
            seed=seed,
            modelId=modelId,
            upscalingOption=upscalingOption,
            steps=steps,
            promptStrength=promptStrength,
            negativePrompt=negativePrompt,
            createdAt=createdAt,
            numberOfImages=numberOfImages,
            width=width,
            id=id,
            state=state,
            prompt=prompt,
            height=height,
            status=status,
            _configuration=_configuration,
            **kwargs,
        )

from leap.model.inference_entity_model_id import InferenceEntityModelId
from leap.model.inference_image_entity import InferenceImageEntity
