# coding: utf-8

"""
    Leap Workflows API

    The Leap Workflows API allows developers to run workflows, fetch workflow runs, and provide other utility functions related to workflow runs. Please use the X-Api-Key for authenticated requests.

    The version of the OpenAPI document: 1.0
    Contact: help@tryleap.ai
    Created by: https://tryleap.ai/
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from leap_workflows import schemas  # noqa: F401


class WorkflowRunEntity(
    schemas.DictSchema
):
    """
    This class is auto generated by Konfig (https://konfigthis.com)
    """


    class MetaOapg:
        required = {
            "output",
            "input",
            "workflow_id",
            "created_at",
            "started_at",
            "id",
            "version_id",
            "error",
            "ended_at",
            "status",
        }
        
        class properties:
            id = schemas.UUIDSchema
            version_id = schemas.UUIDSchema
            
            
            class status(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "completed": "COMPLETED",
                        "running": "RUNNING",
                        "failed": "FAILED",
                    }
                
                @schemas.classproperty
                def COMPLETED(cls):
                    return cls("completed")
                
                @schemas.classproperty
                def RUNNING(cls):
                    return cls("running")
                
                @schemas.classproperty
                def FAILED(cls):
                    return cls("failed")
            created_at = schemas.DateTimeSchema
            started_at = schemas.DateTimeSchema
            ended_at = schemas.DateTimeSchema
            workflow_id = schemas.UUIDSchema
            error = schemas.StrSchema
            input = schemas.DictSchema
            output = schemas.DictSchema
            __annotations__ = {
                "id": id,
                "version_id": version_id,
                "status": status,
                "created_at": created_at,
                "started_at": started_at,
                "ended_at": ended_at,
                "workflow_id": workflow_id,
                "error": error,
                "input": input,
                "output": output,
            }
    
    output: MetaOapg.properties.output
    input: MetaOapg.properties.input
    workflow_id: MetaOapg.properties.workflow_id
    created_at: MetaOapg.properties.created_at
    started_at: MetaOapg.properties.started_at
    id: MetaOapg.properties.id
    version_id: MetaOapg.properties.version_id
    error: MetaOapg.properties.error
    ended_at: MetaOapg.properties.ended_at
    status: MetaOapg.properties.status
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["version_id"]) -> MetaOapg.properties.version_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["status"]) -> MetaOapg.properties.status: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["created_at"]) -> MetaOapg.properties.created_at: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["started_at"]) -> MetaOapg.properties.started_at: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["ended_at"]) -> MetaOapg.properties.ended_at: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["workflow_id"]) -> MetaOapg.properties.workflow_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["error"]) -> MetaOapg.properties.error: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["input"]) -> MetaOapg.properties.input: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["output"]) -> MetaOapg.properties.output: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["id", "version_id", "status", "created_at", "started_at", "ended_at", "workflow_id", "error", "input", "output", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["version_id"]) -> MetaOapg.properties.version_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["status"]) -> MetaOapg.properties.status: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["created_at"]) -> MetaOapg.properties.created_at: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["started_at"]) -> MetaOapg.properties.started_at: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["ended_at"]) -> MetaOapg.properties.ended_at: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["workflow_id"]) -> MetaOapg.properties.workflow_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["error"]) -> MetaOapg.properties.error: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["input"]) -> MetaOapg.properties.input: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["output"]) -> MetaOapg.properties.output: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["id", "version_id", "status", "created_at", "started_at", "ended_at", "workflow_id", "error", "input", "output", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        output: typing.Union[MetaOapg.properties.output, dict, frozendict.frozendict, ],
        input: typing.Union[MetaOapg.properties.input, dict, frozendict.frozendict, ],
        workflow_id: typing.Union[MetaOapg.properties.workflow_id, str, uuid.UUID, ],
        created_at: typing.Union[MetaOapg.properties.created_at, str, datetime, ],
        started_at: typing.Union[MetaOapg.properties.started_at, str, datetime, ],
        id: typing.Union[MetaOapg.properties.id, str, uuid.UUID, ],
        version_id: typing.Union[MetaOapg.properties.version_id, str, uuid.UUID, ],
        error: typing.Union[MetaOapg.properties.error, str, ],
        ended_at: typing.Union[MetaOapg.properties.ended_at, str, datetime, ],
        status: typing.Union[MetaOapg.properties.status, str, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'WorkflowRunEntity':
        return super().__new__(
            cls,
            *args,
            output=output,
            input=input,
            workflow_id=workflow_id,
            created_at=created_at,
            started_at=started_at,
            id=id,
            version_id=version_id,
            error=error,
            ended_at=ended_at,
            status=status,
            _configuration=_configuration,
            **kwargs,
        )
