import logging
from learning_loop_node.tests import test_helper
from learning_loop_node.loop import loop
import pytest
import shutil
import icecream
from learning_loop_node.globals import GLOBALS
import os
icecream.install()
logging.basicConfig(level=logging.DEBUG)


@pytest.fixture()
def create_project():
    test_helper.LiveServerSession().delete(f"/zauberzeug/projects/pytest?keep_images=true")
    project_configuration = {'project_name': 'pytest', 'inbox': 0, 'annotate': 0, 'review': 0, 'complete': 3, 'image_style': 'beautiful',
                             'box_categories': 2, 'point_categories': 2, 'segmentation_categories': 2, 'thumbs': False, 'tags': 0, 'trainings': 1, 'box_detections': 3, 'box_annotations': 0}
    assert test_helper.LiveServerSession().post(f"/zauberzeug/projects/generator",
                                                json=project_configuration).status_code == 200
    yield
    test_helper.LiveServerSession().delete(f"/zauberzeug/projects/pytest?keep_images=true")


@pytest.fixture(autouse=True, scope='session')
def clea_loggers():
    yield
    # see https://github.com/pytest-dev/pytest/issues/5502
    """Remove handlers from all loggers"""
    import logging
    loggers = [logging.getLogger()] + list(logging.Logger.manager.loggerDict.values())
    for logger in loggers:
        handlers = getattr(logger, 'handlers', [])
        for handler in handlers:
            logger.removeHandler(handler)


@pytest.fixture(autouse=True, scope='function')
def loop_session():
    loop.session = None
    yield
    loop.session = None


@pytest.fixture(autouse=True, scope='function')
def data_folder():
    GLOBALS.data_folder = '/tmp/learning_loop_lib_data'
    shutil.rmtree(GLOBALS.data_folder, ignore_errors=True)
    os.makedirs(GLOBALS.data_folder, exist_ok=True)
    yield
    shutil.rmtree(GLOBALS.data_folder, ignore_errors=True)
