"""
HTTP状态码统一映射配置
"""

# HTTP状态码到业务状态码映射
# 1xx 信息： 这些代码是服务器表示“等等，仍在处理中！它们很少见，主要用于表示服务器收到了您的请求，您可以继续。
# 2xx 成功： 2xx 代码就像服务器竖起的大拇指，确认它接收、理解和处理请求都很好。著名的 200 OK 意味着一切都可以！
# 3xx 重定向： 将 3xx 代码视为用户的“路线”。服务器说，“此页面现在位于其他地方”，就像一种礼貌地将您带到正确的地方。
# 4xx 客户端错误： 这些代码意味着服务器由于用户端的某些内容（如拼写错误或错误的 URL）而无法完成请求。您会在此类别中认出经典的 404 Not Found。
# 5xx 服务器： 错误 5xx 范围内的代码告诉我们服务器遇到了问题。即使请求有效，服务器端也出现了故障。
STATUS_CODE_MAP = {
    200: "200",  # 成功:
    400: "400",  # 业务错误
    401: "401",  # 认证失败
    403: "403",  # 权限不足
    404: "404",  # 资源不存在
    422: "422",  # 数据验证失败
    500: "500",  # 服务器错误
}


def get_business_status(http_code: int, default: str = "400") -> str:
    """
    根据HTTP状态码获取业务状态码

    :param http_code: HTTP状态码
    :param default: 当HTTP状态码在映射表中不存在时返回的默认业务状态码，默认为"400"
    :return: 对应的业务状态码，如果HTTP状态码不存在则返回默认值
    """
    # 从状态码映射表中获取对应的业务状态码，如果不存在则返回默认值
    return STATUS_CODE_MAP.get(http_code, default)
