class KeysTransfer:
    def __init__(self, source, destination):
        self.source = source
        self.destination = destination
        self.available_option = [
            "gb_name",  # 幽灵键鼠的键名
            "gb_val"  # 幽灵键鼠的键值
            "js_code", # js中KeyboardEvent.code
            "js_key",  #
            "dm_keyname",  # 大漠插件的键名
            "pywinhook_scancode",  # pywinhook库中的ScanCode
            "pywinhook_name",  # pywinhook库的键名
            "default",  # 默认键名
        ]

        self.key_info = {
            "gb_name": {
                0: "0",
                1: "1",
                2: "2",
                3: "3",
                4: "4",
                5: "5",
                6: "6",
                7: "7",
                8: "8",
                9: "9",
                10: "F1",
                11: "F2",
                12: "F3",
                13: "F4",
                14: "F5",
                15: "F6",
                16: "F7",
                17: "F8",
                18: "F9",
                19: "F10",
                20: "F11",
                21: "F12",
                22: "A",
                23: "B",
                24: "C",
                25: "D",
                26: "E",
                27: "F",
                28: "G",
                29: "H",
                30: "I",
                31: "J",
                32: "K",
                33: "L",
                34: "M",
                35: "N",
                36: "O",
                37: "P",
                38: "Q",
                39: "R",
                40: "S",
                41: "T",
                42: "U",
                43: "V",
                44: "W",
                45: "X",
                46: "Y",
                47: "Z",
                48: "-",
                49: "=",
                50: "[",
                51: "]",
                52: ";",
                53: "'",
                54: ",",
                55: ".",
                56: "/",
                57: "Esc",
                58: ".",
                59: "Tab",
                60: "CapsLock",
                61: "Shift",
                62: "Ctrl",
                63: "Win",
                64: "Alt",
                65: "Space",
                66: "RAlt",
                67: "RGUI",
                68: "RCtrl",
                69: "Enter",
                70: "\\",
                71: "Backspace",
                72: "Up",
                73: "Down",
                74: "Left",
                75: "Right",
                76: "Insert",
                77: "Delete",
                78: "Home",
                79: "End",
                80: "PageUp",
                81: "PageDown",
                82: "Num0",
                83: "Num1",
                84: "Num2",
                85: "Num3",
                86: "Num4",
                87: "Num5",
                88: "Num6",
                89: "Num7",
                90: "Num8",
                91: "Num9",
                92: "NumDot",
                93: "NumpadEnter",
                94: "NumpadAdd",
                95: "NumpadDec",
                96: "NumpadMul",
                97: "NumpadDiv",
                98: "NumpadLock",
                99: "PrintScreen",
                100: "ScrollLock",
                101: "Pause",
            },
            "pywinhook_name": {
                0: "0",
                1: "1",
                2: "2",
                3: "3",
                4: "4",
                5: "5",
                6: "6",
                7: "7",
                8: "8",
                9: "9",
                10: "F1",
                11: "F2",
                12: "F3",
                13: "F4",
                14: "F5",
                15: "F6",
                16: "F7",
                17: "F8",
                18: "F9",
                19: "F10",
                20: "F11",
                21: "F12",
                22: "A",
                23: "B",
                24: "C",
                25: "D",
                26: "E",
                27: "F",
                28: "G",
                29: "H",
                30: "I",
                31: "J",
                32: "K",
                33: "L",
                34: "M",
                35: "N",
                36: "O",
                37: "P",
                38: "Q",
                39: "R",
                40: "S",
                41: "T",
                42: "U",
                43: "V",
                44: "W",
                45: "X",
                46: "Y",
                47: "Z",
                48: "Oem_Minus",
                49: "Oem_Plus",
                50: "Oem_4",  # "["
                51: "Oem_6",  # "]",
                52: "Oem_1",  # ;",
                53: "Oem_7",  # "'",
                54: "Oem_Comma",  # ",",
                55: "Oem_Period",  # ".",
                56: "Oem_2",  # "/",
                57: "Escape",
                58: "Oem_3",  # ".",
                59: "Tab",
                60: "Capital",
                61: "Lshift",
                62: "Lcontrol",
                63: "Lwin",
                64: "Lmenu",  # "Alt",
                65: "Space",
                66: "Rmenu",  # "RAlt",
                67: "Apps",  # "RGUI",
                68: "Rcontrol",
                69: "Return",
                70: "Oem_5",  # "\\",
                71: "Back",
                72: "Up",
                73: "Down",
                74: "Left",
                75: "Right",
                76: "Insert",
                77: "Delete",
                78: "Home",
                79: "End",
                80: "Prior",  # "PageUp",
                81: "Next",  # "PageDown",
                82: "Numpad0",
                83: "Numpad1",
                84: "Numpad2",
                85: "Numpad3",
                86: "Numpad4",
                87: "Numpad5",
                88: "Numpad6",
                89: "Numpad7",
                90: "Numpad8",
                91: "Numpad9",
                92: "Decimal",  # "NumDot",
                93: "Return",
                94: "Add",
                95: "Subtract",
                96: "Multiply",
                97: "Divide",
                98: "Numlock",
                99: "Snapshot",  # "PrintScreen",
                100: "Scroll",
                101: "Pause",
            },
            "pywinhook_scancode": {
                # 不同键的ScanCode可能相同，如PgDn和NumPad3，这是PyWinHooks库返回的键位的ScanCode
                # 因此，pyWinhook库建议用健名
                0: 11,
                1: 2,
                2: 3,
                3: 4,
                4: 5,
                5: 6,
                6: 7,
                7: 8,
                8: 9,
                9: 10,
                10: 59,  # "F1"
                11: 60,
                12: 61,
                13: 62,
                14: 63,
                15: 64,
                16: 65,
                17: 66,
                18: 67,
                19: 68,  # F10
                20: 87,  # F11
                21: 88,  # F12
                22: 30,  # "A"
                23: 48,  # "B"
                24: 46,  # "C"
                25: 32,  # "D"
                26: 18,  # "E"
                27: 33,  # "F"
                28: 34,  # "G",
                29: 35,  # "H",
                30: 23,  # "I",
                31: 36,  # "J",
                32: 37,  # "K",
                33: 38,  # "L",
                34: 50,  # "M",
                35: 49,  # "N",
                36: 24,  # "O",
                37: 25,  # "P",
                38: 16,  # "Q",
                39: 19,  # "R",
                40: 31,  # "S",
                41: 20,  # "T",
                42: 22,  # "U",
                43: 47,  # "V",
                44: 17,  # "W",
                45: 45,  # "X",
                46: 21,  # "Y",
                47: 44,  # "Z",
                48: 12,  # "-",
                49: 13,  # "=",
                50: 26,  # "[",
                51: 27,  # "]",
                52: 39,  # ";",
                53: 40,  # "'",
                54: 51,  # ",",
                55: 52,  # ".",
                56: 53,  # "/",
                57: 1,  # "Esc",
                58: 41,  # ".",
                59: 15,  # "Tab",
                60: 58,  # "CapsLock",
                61: 42,  # "Shift",
                62: 29,  # "Ctrl",
                63: 91,  # LeftWin
                64: 56,  # "Alt",
                65: 57,  # "Space",
                66: 56,  # "RAlt",
                67: 93,  # "RGUI",
                68: 29,  # "RCtrl",
                69: 28,  # "Enter",
                70: 43,  # "\\",
                71: 14,  # "Backspace",
                72: 72,  # "Up",
                73: 80,  # "Down",
                74: 75,  # "Left",
                75: 77,  # "Right",
                76: 82,  # "Insert",
                77: 83,  # "Delete",
                78: 71,  # "Home",
                79: 79,  # "End",
                80: 73,  # "PageUp",
                81: 81,  # "PageDown",
                82: 82,  # "Num0",
                83: 79,  # "Num1",
                84: 80,  # "Num2",
                85: 81,  # "Num3",
                86: 75,  # "Num4",
                87: 76,  # "Num5",
                88: 77,  # "Num6",
                89: 71,  # "Num7",
                90: 72,  # "Num8",
                91: 73,  # "Num9",
                92: 83,  # "NumDot",
                93: 28,  # "NumpadEnter",
                94: 78,  # "NumpadAdd",
                95: 74,  # "NumpadDec",
                96: 55,  # "NumpadMul",
                97: 53,  # "NumpadDiv",
                98: 69,  # "NumpadLock",
                99: 55,  # "PrintScreen",
                100: 70,  # "ScrollLock",
                101: 69,  # "Pause",
            },
            "js_code": {
                0: "Digit0",
                1: "Digit1",
                2: "Digit2",
                3: "Digit3",
                4: "Digit4",
                5: "Digit5",
                6: "Digit6",
                7: "Digit7",
                8: "Digit8",
                9: "Digit9",
                10: "F1",
                11: "F2",
                12: "F3",
                13: "F4",
                14: "F5",
                15: "F6",
                16: "F7",
                17: "F8",
                18: "F9",
                19: "F10",
                20: "F11",
                21: "F12",
                22: "KeyA",
                23: "KeyB",
                24: "KeyC",
                25: "KeyD",
                26: "KeyE",
                27: "KeyF",
                28: "KeyG",
                29: "KeyH",
                30: "KeyI",
                31: "KeyJ",
                32: "KeyK",
                33: "KeyL",
                34: "KeyM",
                35: "KeyN",
                36: "KeyO",
                37: "KeyP",
                38: "KeyQ",
                39: "KeyR",
                40: "KeyS",
                41: "KeyT",
                42: "KeyU",
                43: "KeyV",
                44: "KeyW",
                45: "KeyX",
                46: "KeyY",
                47: "KeyZ",
                48: "Minus",
                49: "Equal",
                50: "BracketLeft",
                51: "BracketRight",
                52: "Semicolon",
                53: "Quote",
                54: "Comma",
                55: "Period",
                56: "Slash",
                57: "Escape",
                58: "Backquote",
                59: "Tab",
                60: "CapsLock",
                61: "ShiftLeft",
                62: "ControlLeft",
                63: "MetaLeft",
                64: "AltLeft",
                65: "Space",
                66: "AltRight",
                67: "ContextMenu",
                68: "ControlRight",
                69: "Enter",
                70: "Backslash",
                71: "Backspace",
                72: "ArrowUp",
                73: "ArrowDown",
                74: "ArrowLeft",
                75: "ArrowRight",
                76: "Insert",
                77: "Delete",
                78: "Home",
                79: "End",
                80: "PageUp",
                81: "PageDown",
                82: "Numpad0",
                83: "Numpad1",
                84: "Numpad2",
                85: "Numpad3",
                86: "Numpad4",
                87: "Numpad5",
                88: "Numpad6",
                89: "Numpad7",
                90: "Numpad8",
                91: "Numpad9",
                92: "NumpadDecimal",
                93: "NumpadEnter",
                94: "NumpadAdd",
                95: "NumpadSubtract",
                96: "NumpadMultiply",
                97: "NumpadDivide",
                98: "NumpadLock",
                99: "PrintScreen",
                100: "ScrollLock",
                101: "Pause"

            },
            "default": {
                0: "0",
                1: "1",
                2: "2",
                3: "3",
                4: "4",
                5: "5",
                6: "6",
                7: "7",
                8: "8",
                9: "9",
                10: "F1",
                11: "F2",
                12: "F3",
                13: "F4",
                14: "F5",
                15: "F6",
                16: "F7",
                17: "F8",
                18: "F9",
                19: "F10",
                20: "F11",
                21: "F12",
                22: "A",
                23: "B",
                24: "C",
                25: "D",
                26: "E",
                27: "F",
                28: "G",
                29: "H",
                30: "I",
                31: "J",
                32: "K",
                33: "L",
                34: "M",
                35: "N",
                36: "O",
                37: "P",
                38: "Q",
                39: "R",
                40: "S",
                41: "T",
                42: "U",
                43: "V",
                44: "W",
                45: "X",
                46: "Y",
                47: "Z",
                48: "-",
                49: "=",
                50: "[",
                51: "]",
                52: ";",
                53: "'",
                54: ",",
                55: ".",
                56: "/",
                57: "Esc",
                58: ".",
                59: "Tab",
                60: "CapsLock",
                61: "Shift",
                62: "Ctrl",
                63: "Win",
                64: "Alt",
                65: "Space",
                66: "RAlt",
                67: "RGUI",
                68: "RCtrl",
                69: "Enter",
                70: "\\",
                71: "Backspace",
                72: "Up",
                73: "Down",
                74: "Left",
                75: "Right",
                76: "Insert",
                77: "Delete",
                78: "Home",
                79: "End",
                80: "PageUp",
                81: "PageDown",
                82: "Num0",
                83: "Num1",
                84: "Num2",
                85: "Num3",
                86: "Num4",
                87: "Num5",
                88: "Num6",
                89: "Num7",
                90: "Num8",
                91: "Num9",
                92: "NumDot",
                93: "NumpadEnter",
                94: "NumpadAdd",
                95: "NumpadDec",
                96: "NumpadMul",
                97: "NumpadDiv",
                98: "NumpadLock",
                99: "PrintScreen",
                100: "ScrollLock",
                101: "Pause",
            },
        }

    def get_key_index(self, key, source: str):
        """
        获取键名的索引
        """
        source = self.key_info.get(source)
        for k, v in source.items():
            if v.lower() == key.lower():
                return k
        return -1

    def transfer(self, key):
        """
        将source的key名转换为destination的键名
        """
        index = self.get_key_index(key, self.source)
        return self.key_info.get(self.destination).get(index)

    def transfer_reverse(self, key):
        """
        将destination的键名转换为source的键名
        """
        index = self.get_key_index(key, self.destination)
        return self.key_info.get(self.source).get(index)
