from yangke.pytorch.mytorch import DataFitterNet, DataSetFitting, OptunaModel, setup_seed, get_settings, \
    deal_settings_path, train_model, re_train, PriorLoss
import pandas as pd
import torch
from yangke.common.config import logger, add_file_logger
add_file_logger('log-神经网络训练.txt')

def train():
    # 加载数据
    df = pd.read_csv(r"D:\国华燃机\data.csv")

    # 定义输入和输出列
    input_columns = ["汽轮发电机功率", "凝汽器热负荷", "平均大气压力",
                     "环境温度", "大气湿度", "风速", "风机运行台数", "循泵运行方式数字编码"]
    output_column = ["背压"]

    # 创建数据集
    dataset = DataSetFitting(df, input_columns, output_column)
    dataset.set_standard(normal_method="z-score")  # 设置数据标准化方法
    # 定义模型配置
    settings = {
        "input": input_columns,
        "output": output_column,
        "networks": {
            "train": {
                "epochs": 50,
                "batch_size": 64,
                "learning_rate": 0.001,
            },
            "loss_fn": {
                "type": "PriorLoss",
            },
            "optimizer": {
                "type": "adam",
            },
            "layers": [
                {"type": "input", "cell_num": "auto"},
                {"type": "linear", "cell_num": 64, "bias": True},
                {"type": "relu"},
                {"type": "linear", "cell_num": 128, "bias": True},
                {"type": "relu"},
                {"type": "linear", "cell_num": 32, "bias": True},
                {"type": "relu"},
                {"type": "output", "cell_num": "auto"}
            ],
        },
        "save_path": "背压预测模型.torch",
        "normalization_method": "z-score"
    }
    # 创建模型
    device = "cuda" if torch.cuda.is_available() else "cpu"
    model = DataFitterNet(settings)
    loss_fn = PriorLoss(input_titles=input_columns, net=model.net)
    loss_fn.add_knowledge([
        {'isChecked': True, 'op': '任何条件', 'expression': '[背压]随[汽轮发电机功率]单调递增'},
        {'isChecked': True, 'op': '任何条件', 'expression': '[背压]随[凝汽器热负荷]单调递增'},
        {'isChecked': True, 'op': '任何条件', 'expression': '[背压]随[环境温度]单调递增'},
        {'isChecked': True, 'op': '任何条件', 'expression': '[背压]随[风机运行台数]单调递减'},
        {'isChecked': True, 'op': '任何条件', 'expression': '[背压]随[循泵运行方式数字编码]单调递减'},
    ])
    model.loss_fn = loss_fn
    model.to(device)

    # 训练模型
    average_err, max_err = model.start_train(dataset)

    # 保存模型
    model.save_yk("背压预测模型.torch")


def load_trained_model(model_path):
    """
    加载已训练的神经网络模型

    :param model_path: 模型文件路径
    :return: 加载的模型对象
    """
    # 使用DataFitterNet的静态方法加载模型
    torch.serialization.add_safe_globals([pd.Series])
    loaded_model = DataFitterNet.load_yk(model_path)
    return loaded_model


if __name__ == "__main__":
    # train()
    model = load_trained_model("背压预测模型.torch")
    logger.debug(f"{model.prediction([280, 1708286, 0.1019, 17.58, 75, 3.2, 7, 1])=}")
    logger.debug(f"{model.prediction([280, 1708286, 0.1019, 17.58, 75, 3.2, 7, 2])=}")
    logger.debug(f"{model.prediction([280, 1708286, 0.1019, 17.58, 75, 3.2, 7, 3])=}")
    logger.debug(f"{model.prediction([280, 1708286, 0.1019, 17.58, 75, 3.2, 7, 4])=}")
    logger.debug(f"{model.prediction([280, 1708286, 0.1019, 17.58, 75, 3.2, 7, 5])=}")
    logger.debug(f"{model.prediction([280, 1708286, 0.1019, 17.58, 75, 3.2, 7, 6])=}")
    logger.debug(f"{model.prediction([280, 1708286, 0.1019, 17.58, 75, 3.2, 7, 7])=}")
    logger.debug(f"{model.prediction([280, 1708286, 0.1019, 17.58, 75, 3.2, 7, 8])=}")
