/*
 * Definitions for libbde
 *
 * Copyright (C) 2011-2018, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This software is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined( _LIBBDE_DEFINITIONS_H )
#define _LIBBDE_DEFINITIONS_H

#include <libbde/types.h>

#define LIBBDE_VERSION					20181227

/* The version string
 */
#define LIBBDE_VERSION_STRING				"20181227"

/* The file access
 * bit 1        set to 1 for read access
 * bit 2        set to 1 for write access
 * bit 3-8      not used
 */
enum LIBBDE_ACCESS_FLAGS
{
	LIBBDE_ACCESS_FLAG_READ				= 0x01,
/* Reserved: not supported yet */
	LIBBDE_ACCESS_FLAG_WRITE			= 0x02
};

/* The file access macros
 */
#define LIBBDE_OPEN_READ				( LIBBDE_ACCESS_FLAG_READ )
/* Reserved: not supported yet */
#define LIBBDE_OPEN_WRITE				( LIBBDE_ACCESS_FLAG_WRITE )
/* Reserved: not supported yet */
#define LIBBDE_OPEN_READ_WRITE				( LIBBDE_ACCESS_FLAG_READ | LIBBDE_ACCESS_FLAG_WRITE )

/* The version
 */
enum LIBBDE_VERSIONS
{
	LIBBDE_VERSION_WINDOWS_VISTA			= 6,
	LIBBDE_VERSION_WINDOWS_7			= 7,
	LIBBDE_VERSION_TO_GO				= (int) 'T'
};

/* The encryption methods
 */
enum LIBBDE_ENCRYPTION_METHODS
{
	LIBBDE_ENCRYPTION_METHOD_AES_128_CBC_DIFFUSER	= 0x8000UL,
	LIBBDE_ENCRYPTION_METHOD_AES_256_CBC_DIFFUSER	= 0x8001UL,
	LIBBDE_ENCRYPTION_METHOD_AES_128_CBC		= 0x8002UL,
	LIBBDE_ENCRYPTION_METHOD_AES_256_CBC		= 0x8003UL,
	LIBBDE_ENCRYPTION_METHOD_AES_128_XTS		= 0x8004UL,
	LIBBDE_ENCRYPTION_METHOD_AES_256_XTS		= 0x8005UL
};

/* The key protection types
 */
enum LIBBDE_KEY_PROTECTION_TYPES
{
	LIBBDE_KEY_PROTECTION_TYPE_CLEAR_KEY		= 0x0000,

	LIBBDE_KEY_PROTECTION_TYPE_TPM			= 0x0100,
	LIBBDE_KEY_PROTECTION_TYPE_STARTUP_KEY		= 0x0200,

	LIBBDE_KEY_PROTECTION_TYPE_RECOVERY_PASSWORD	= 0x0800,

	LIBBDE_KEY_PROTECTION_TYPE_PASSWORD		= 0x2000,
};

#endif /* !defined( _LIBBDE_DEFINITIONS_H ) */

