/*
 * The internal definitions
 *
 * Copyright (C) 2011-2023, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBBDE_INTERNAL_DEFINITIONS_H )
#define _LIBBDE_INTERNAL_DEFINITIONS_H

#include <common.h>
#include <byte_stream.h>

/* Define HAVE_LOCAL_LIBBDE for local use of libbde
 */
#if !defined( HAVE_LOCAL_LIBBDE )
#include <libbde/definitions.h>

/* The definitions in <libbde/definitions.h> are copied here
 * for local use of libbde
 */
#else
#define LIBBDE_VERSION					20231220

/* The version string
 */
#define LIBBDE_VERSION_STRING				"20231220"

/* The file access
 * bit 1        set to 1 for read access
 * bit 2        set to 1 for write access
 * bit 3-8      not used
 */
enum LIBBDE_ACCESS_FLAGS
{
	LIBBDE_ACCESS_FLAG_READ				= 0x01,
/* Reserved: not supported yet */
	LIBBDE_ACCESS_FLAG_WRITE			= 0x02
};

/* The file access macros
 */
#define LIBBDE_OPEN_READ				( LIBBDE_ACCESS_FLAG_READ )
/* Reserved: not supported yet */
#define LIBBDE_OPEN_WRITE				( LIBBDE_ACCESS_FLAG_WRITE )
/* Reserved: not supported yet */
#define LIBBDE_OPEN_READ_WRITE				( LIBBDE_ACCESS_FLAG_READ | LIBBDE_ACCESS_FLAG_WRITE )

/* The version
 */
enum LIBBDE_VERSIONS
{
	LIBBDE_VERSION_WINDOWS_VISTA			= 6,
	LIBBDE_VERSION_WINDOWS_7			= 7,
	LIBBDE_VERSION_TO_GO				= (int) 'T'
};

/* The encryption methods
 */
enum LIBBDE_ENCRYPTION_METHODS
{
	LIBBDE_ENCRYPTION_METHOD_NONE			= 0x0000UL,

	LIBBDE_ENCRYPTION_METHOD_AES_128_CBC_DIFFUSER	= 0x8000UL,
	LIBBDE_ENCRYPTION_METHOD_AES_256_CBC_DIFFUSER	= 0x8001UL,
	LIBBDE_ENCRYPTION_METHOD_AES_128_CBC		= 0x8002UL,
	LIBBDE_ENCRYPTION_METHOD_AES_256_CBC		= 0x8003UL,
	LIBBDE_ENCRYPTION_METHOD_AES_128_XTS		= 0x8004UL,
	LIBBDE_ENCRYPTION_METHOD_AES_256_XTS		= 0x8005UL
};

/* The key protection types
 */
enum LIBBDE_KEY_PROTECTION_TYPES
{
	LIBBDE_KEY_PROTECTION_TYPE_CLEAR_KEY		= 0x0000,

	LIBBDE_KEY_PROTECTION_TYPE_TPM			= 0x0100,
	LIBBDE_KEY_PROTECTION_TYPE_STARTUP_KEY		= 0x0200,

	LIBBDE_KEY_PROTECTION_TYPE_TPM_AND_PIN		= 0x0500,

	LIBBDE_KEY_PROTECTION_TYPE_RECOVERY_PASSWORD	= 0x0800,

	LIBBDE_KEY_PROTECTION_TYPE_PASSWORD		= 0x2000,
};

#endif /* !defined( HAVE_LOCAL_LIBBDE ) */

/* The entry types
 */
enum LIBBDE_ENTRY_TYPES
{
	LIBBDE_ENTRY_TYPE_PROPERTY			= 0x0000,

	LIBBDE_ENTRY_TYPE_VOLUME_MASTER_KEY		= 0x0002,
	LIBBDE_ENTRY_TYPE_FULL_VOLUME_ENCRYPTION_KEY	= 0x0003,
	LIBBDE_ENTRY_TYPE_VALIDATION			= 0x0004,

	LIBBDE_ENTRY_TYPE_STARTUP_KEY			= 0x0006,
	LIBBDE_ENTRY_TYPE_DESCRIPTION			= 0x0007,

	LIBBDE_ENTRY_TYPE_VOLUME_HEADER_BLOCK		= 0x000f,
};

/* TODO 0x000b
 */

/* The value types
 */
enum LIBBDE_VALUE_TYPES
{
	LIBBDE_VALUE_TYPE_ERASED			= 0x0000,
	LIBBDE_VALUE_TYPE_KEY				= 0x0001,
	LIBBDE_VALUE_TYPE_UNICODE_STRING		= 0x0002,
	LIBBDE_VALUE_TYPE_STRETCH_KEY			= 0x0003,
	LIBBDE_VALUE_TYPE_USE_KEY			= 0x0004,
	LIBBDE_VALUE_TYPE_AES_CCM_ENCRYPTED_KEY		= 0x0005,
	LIBBDE_VALUE_TYPE_TPM_ENCODED_KEY		= 0x0006,
	LIBBDE_VALUE_TYPE_VALIDATION			= 0x0007,
	LIBBDE_VALUE_TYPE_VOLUME_MASTER_KEY		= 0x0008,
	LIBBDE_VALUE_TYPE_EXTERNAL_KEY			= 0x0009,
	LIBBDE_VALUE_TYPE_UPDATE			= 0x000a,
	LIBBDE_VALUE_TYPE_ERROR				= 0x000b,

	LIBBDE_VALUE_TYPE_OFFSET_AND_SIZE		= 0x000f
};

/* The crypt modes
 */
enum LIBBDE_ENCRYPTION_CRYPT_MODES
{
	LIBBDE_ENCRYPTION_CRYPT_MODE_DECRYPT		= 0,
	LIBBDE_ENCRYPTION_CRYPT_MODE_ENCRYPT		= 1
};

/* The sector modes
 */
enum LIBBDE_SECTOR_TYPES
{
	LIBBDE_SECTOR_TYPE_ENCRYPTED_DATA		= 0,
	LIBBDE_SECTOR_TYPE_METADATA			= 1,
	LIBBDE_SECTOR_TYPE_RAW_DATA			= 2
};

#define LIBBDE_MAXIMUM_CACHE_ENTRIES_SECTOR_DATA	16

#define LIBBDE_MAXIMUM_FVE_METADATA_SIZE		16 * 1024 * 1024

#endif /* !defined( _LIBBDE_INTERNAL_DEFINITIONS_H ) */

