/*
 * Library file_entry type test program
 *
 * Copyright (C) 2006-2024, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <common.h>
#include <file_stream.h>
#include <types.h>

#if defined( HAVE_STDLIB_H ) || defined( WINAPI )
#include <stdlib.h>
#endif

#if defined( HAVE_SYS_TIME_H )
#include <sys/time.h>
#endif

#include <time.h>

#include "ewf_test_libcdata.h"
#include "ewf_test_libcerror.h"
#include "ewf_test_libewf.h"
#include "ewf_test_libfdata.h"
#include "ewf_test_libfvalue.h"
#include "ewf_test_macros.h"
#include "ewf_test_memory.h"
#include "ewf_test_unused.h"

#include "../libewf/libewf_data_stream.h"
#include "../libewf/libewf_file_entry.h"
#include "../libewf/libewf_single_files.h"

#define EWF_TEST_FILE_ENTRY_READ_BUFFER_SIZE	4096

uint8_t ewf_test_file_entry_data1[ 5700 ] = {
	0x35, 0x00, 0x0a, 0x00, 0x72, 0x00, 0x65, 0x00, 0x63, 0x00, 0x0a, 0x00, 0x74, 0x00, 0x62, 0x00,
	0x09, 0x00, 0x63, 0x00, 0x6c, 0x00, 0x09, 0x00, 0x6e, 0x00, 0x09, 0x00, 0x66, 0x00, 0x70, 0x00,
	0x09, 0x00, 0x70, 0x00, 0x67, 0x00, 0x09, 0x00, 0x6c, 0x00, 0x67, 0x00, 0x09, 0x00, 0x69, 0x00,
	0x67, 0x00, 0x09, 0x00, 0x63, 0x00, 0x64, 0x00, 0x09, 0x00, 0x77, 0x00, 0x64, 0x00, 0x09, 0x00,
	0x6d, 0x00, 0x64, 0x00, 0x09, 0x00, 0x61, 0x00, 0x64, 0x00, 0x0a, 0x00, 0x32, 0x00, 0x36, 0x00,
	0x31, 0x00, 0x39, 0x00, 0x39, 0x00, 0x32, 0x00, 0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x65, 0x00, 0x72, 0x00, 0x6d, 0x00, 0x0a, 0x00,
	0x31, 0x00, 0x09, 0x00, 0x31, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x09, 0x00, 0x6e, 0x00, 0x09, 0x00,
	0x73, 0x00, 0x09, 0x00, 0x70, 0x00, 0x72, 0x00, 0x09, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x61, 0x00,
	0x09, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x69, 0x00, 0x0a, 0x00, 0x30, 0x00, 0x09, 0x00, 0x31, 0x00,
	0x0a, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x30, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x0a, 0x00, 0x30, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x31, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x0a, 0x00, 0x0a, 0x00,
	0x73, 0x00, 0x72, 0x00, 0x63, 0x00, 0x65, 0x00, 0x0a, 0x00, 0x31, 0x00, 0x09, 0x00, 0x31, 0x00,
	0x0a, 0x00, 0x70, 0x00, 0x09, 0x00, 0x6e, 0x00, 0x09, 0x00, 0x69, 0x00, 0x64, 0x00, 0x09, 0x00,
	0x65, 0x00, 0x76, 0x00, 0x09, 0x00, 0x64, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x6c, 0x00, 0x6f, 0x00,
	0x63, 0x00, 0x09, 0x00, 0x73, 0x00, 0x65, 0x00, 0x09, 0x00, 0x6d, 0x00, 0x66, 0x00, 0x72, 0x00,
	0x09, 0x00, 0x6d, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x74, 0x00, 0x62, 0x00, 0x09, 0x00, 0x6c, 0x00,
	0x6f, 0x00, 0x09, 0x00, 0x70, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x61, 0x00, 0x68, 0x00, 0x09, 0x00,
	0x73, 0x00, 0x68, 0x00, 0x09, 0x00, 0x67, 0x00, 0x75, 0x00, 0x09, 0x00, 0x70, 0x00, 0x67, 0x00,
	0x75, 0x00, 0x09, 0x00, 0x61, 0x00, 0x71, 0x00, 0x09, 0x00, 0x69, 0x00, 0x70, 0x00, 0x09, 0x00,
	0x73, 0x00, 0x69, 0x00, 0x09, 0x00, 0x6d, 0x00, 0x61, 0x00, 0x09, 0x00, 0x64, 0x00, 0x74, 0x00,
	0x0a, 0x00, 0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x0a, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x2d, 0x00, 0x31, 0x00, 0x09, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x66, 0x00, 0x0a, 0x00, 0x30, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00,
	0x09, 0x00, 0x46, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x04, 0x5f, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x46, 0x00, 0x6c, 0x00, 0x61, 0x00,
	0x73, 0x00, 0x68, 0x00, 0x20, 0x00, 0x44, 0x00, 0x69, 0x00, 0x73, 0x00, 0x6b, 0x00, 0x09, 0x00,
	0x32, 0x00, 0x36, 0x00, 0x32, 0x00, 0x31, 0x00, 0x34, 0x00, 0x34, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x09, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x09, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x37, 0x00, 0x37, 0x00, 0x39, 0x00, 0x30, 0x00, 0x30, 0x00, 0x42, 0x00,
	0x39, 0x00, 0x32, 0x00, 0x41, 0x00, 0x35, 0x00, 0x38, 0x00, 0x43, 0x00, 0x38, 0x00, 0x37, 0x00,
	0x43, 0x00, 0x34, 0x00, 0x38, 0x00, 0x30, 0x00, 0x41, 0x00, 0x33, 0x00, 0x30, 0x00, 0x46, 0x00,
	0x42, 0x00, 0x43, 0x00, 0x35, 0x00, 0x39, 0x00, 0x45, 0x00, 0x33, 0x00, 0x31, 0x00, 0x41, 0x00,
	0x36, 0x00, 0x35, 0x00, 0x09, 0x00, 0x37, 0x00, 0x37, 0x00, 0x39, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x42, 0x00, 0x39, 0x00, 0x32, 0x00, 0x41, 0x00, 0x35, 0x00, 0x38, 0x00, 0x43, 0x00, 0x38, 0x00,
	0x37, 0x00, 0x43, 0x00, 0x34, 0x00, 0x38, 0x00, 0x30, 0x00, 0x41, 0x00, 0x33, 0x00, 0x30, 0x00,
	0x46, 0x00, 0x42, 0x00, 0x43, 0x00, 0x35, 0x00, 0x39, 0x00, 0x45, 0x00, 0x33, 0x00, 0x31, 0x00,
	0x41, 0x00, 0x36, 0x00, 0x35, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x72, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x73, 0x00,
	0x75, 0x00, 0x62, 0x00, 0x0a, 0x00, 0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x0a, 0x00, 0x70, 0x00,
	0x09, 0x00, 0x6e, 0x00, 0x09, 0x00, 0x69, 0x00, 0x64, 0x00, 0x09, 0x00, 0x6e, 0x00, 0x75, 0x00,
	0x09, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x67, 0x00, 0x75, 0x00, 0x0a, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00,
	0x20, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x65, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x72, 0x00,
	0x79, 0x00, 0x0a, 0x00, 0x36, 0x00, 0x09, 0x00, 0x31, 0x00, 0x0a, 0x00, 0x6d, 0x00, 0x69, 0x00,
	0x64, 0x00, 0x09, 0x00, 0x6c, 0x00, 0x73, 0x00, 0x09, 0x00, 0x62, 0x00, 0x65, 0x00, 0x09, 0x00,
	0x69, 0x00, 0x64, 0x00, 0x09, 0x00, 0x63, 0x00, 0x72, 0x00, 0x09, 0x00, 0x61, 0x00, 0x63, 0x00,
	0x09, 0x00, 0x77, 0x00, 0x72, 0x00, 0x09, 0x00, 0x6d, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x64, 0x00,
	0x6c, 0x00, 0x09, 0x00, 0x73, 0x00, 0x69, 0x00, 0x67, 0x00, 0x09, 0x00, 0x68, 0x00, 0x61, 0x00,
	0x09, 0x00, 0x73, 0x00, 0x68, 0x00, 0x61, 0x00, 0x09, 0x00, 0x65, 0x00, 0x6e, 0x00, 0x74, 0x00,
	0x09, 0x00, 0x73, 0x00, 0x6e, 0x00, 0x68, 0x00, 0x09, 0x00, 0x70, 0x00, 0x09, 0x00, 0x6e, 0x00,
	0x09, 0x00, 0x64, 0x00, 0x75, 0x00, 0x09, 0x00, 0x6c, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x70, 0x00,
	0x6f, 0x00, 0x09, 0x00, 0x70, 0x00, 0x6d, 0x00, 0x09, 0x00, 0x6f, 0x00, 0x65, 0x00, 0x73, 0x00,
	0x09, 0x00, 0x73, 0x00, 0x70, 0x00, 0x74, 0x00, 0x68, 0x00, 0x09, 0x00, 0x6f, 0x00, 0x70, 0x00,
	0x72, 0x00, 0x09, 0x00, 0x73, 0x00, 0x72, 0x00, 0x63, 0x00, 0x09, 0x00, 0x73, 0x00, 0x75, 0x00,
	0x62, 0x00, 0x09, 0x00, 0x63, 0x00, 0x69, 0x00, 0x64, 0x00, 0x09, 0x00, 0x6a, 0x00, 0x71, 0x00,
	0x09, 0x00, 0x61, 0x00, 0x6c, 0x00, 0x74, 0x00, 0x09, 0x00, 0x65, 0x00, 0x70, 0x00, 0x09, 0x00,
	0x61, 0x00, 0x71, 0x00, 0x09, 0x00, 0x63, 0x00, 0x66, 0x00, 0x69, 0x00, 0x09, 0x00, 0x73, 0x00,
	0x67, 0x00, 0x09, 0x00, 0x65, 0x00, 0x61, 0x00, 0x09, 0x00, 0x6c, 0x00, 0x70, 0x00, 0x74, 0x00,
	0x0a, 0x00, 0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x36, 0x00, 0x0a, 0x00, 0x41, 0x00, 0x44, 0x00,
	0x31, 0x00, 0x43, 0x00, 0x34, 0x00, 0x31, 0x00, 0x42, 0x00, 0x42, 0x00, 0x33, 0x00, 0x46, 0x00,
	0x31, 0x00, 0x42, 0x00, 0x37, 0x00, 0x34, 0x00, 0x38, 0x00, 0x43, 0x00, 0x39, 0x00, 0x30, 0x00,
	0x45, 0x00, 0x34, 0x00, 0x38, 0x00, 0x34, 0x00, 0x44, 0x00, 0x32, 0x00, 0x46, 0x00, 0x31, 0x00,
	0x37, 0x00, 0x43, 0x00, 0x31, 0x00, 0x33, 0x00, 0x39, 0x00, 0x44, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x42, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x09, 0x00, 0x4c, 0x00, 0x6f, 0x00, 0x67, 0x00, 0x69, 0x00, 0x63, 0x00, 0x61, 0x00,
	0x6c, 0x00, 0x45, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x72, 0x00, 0x69, 0x00, 0x65, 0x00, 0x73, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x0a, 0x00, 0x32, 0x00,
	0x36, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x35, 0x00, 0x38, 0x00, 0x30, 0x00, 0x42, 0x00,
	0x41, 0x00, 0x33, 0x00, 0x30, 0x00, 0x44, 0x00, 0x42, 0x00, 0x38, 0x00, 0x34, 0x00, 0x32, 0x00,
	0x41, 0x00, 0x39, 0x00, 0x38, 0x00, 0x45, 0x00, 0x39, 0x00, 0x44, 0x00, 0x46, 0x00, 0x31, 0x00,
	0x31, 0x00, 0x32, 0x00, 0x34, 0x00, 0x30, 0x00, 0x34, 0x00, 0x37, 0x00, 0x46, 0x00, 0x42, 0x00,
	0x36, 0x00, 0x30, 0x00, 0x36, 0x00, 0x41, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x30, 0x00, 0x20, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x35, 0x00, 0x37, 0x00,
	0x37, 0x00, 0x36, 0x00, 0x38, 0x00, 0x39, 0x00, 0x37, 0x00, 0x36, 0x00, 0x38, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x35, 0x00, 0x37, 0x00, 0x37, 0x00, 0x36, 0x00, 0x36, 0x00, 0x30, 0x00, 0x34, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x35, 0x00, 0x37, 0x00, 0x37, 0x00, 0x36, 0x00,
	0x38, 0x00, 0x39, 0x00, 0x37, 0x00, 0x36, 0x00, 0x38, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x38, 0x00, 0x20, 0x00, 0x31, 0x00, 0x62, 0x00, 0x09, 0x00, 0x44, 0x00, 0x34, 0x00, 0x31, 0x00,
	0x44, 0x00, 0x38, 0x00, 0x43, 0x00, 0x44, 0x00, 0x39, 0x00, 0x38, 0x00, 0x46, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x42, 0x00, 0x32, 0x00, 0x30, 0x00, 0x34, 0x00, 0x45, 0x00, 0x39, 0x00, 0x38, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x39, 0x00, 0x39, 0x00, 0x38, 0x00, 0x45, 0x00, 0x43, 0x00, 0x46, 0x00,
	0x38, 0x00, 0x34, 0x00, 0x32, 0x00, 0x37, 0x00, 0x45, 0x00, 0x09, 0x00, 0x44, 0x00, 0x41, 0x00,
	0x33, 0x00, 0x39, 0x00, 0x41, 0x00, 0x33, 0x00, 0x45, 0x00, 0x45, 0x00, 0x35, 0x00, 0x45, 0x00,
	0x36, 0x00, 0x42, 0x00, 0x34, 0x00, 0x42, 0x00, 0x30, 0x00, 0x44, 0x00, 0x33, 0x00, 0x32, 0x00,
	0x35, 0x00, 0x35, 0x00, 0x42, 0x00, 0x46, 0x00, 0x45, 0x00, 0x46, 0x00, 0x39, 0x00, 0x35, 0x00,
	0x36, 0x00, 0x30, 0x00, 0x31, 0x00, 0x38, 0x00, 0x39, 0x00, 0x30, 0x00, 0x41, 0x00, 0x46, 0x00,
	0x44, 0x00, 0x38, 0x00, 0x30, 0x00, 0x37, 0x00, 0x30, 0x00, 0x39, 0x00, 0x09, 0x00, 0x45, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x54, 0x00, 0x65, 0x00, 0x73, 0x00,
	0x74, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x20, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x20, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x20, 0x00, 0x20, 0x00, 0x34, 0x00, 0x33, 0x00, 0x20, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x0a, 0x00, 0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x41, 0x00, 0x39, 0x00,
	0x46, 0x00, 0x42, 0x00, 0x44, 0x00, 0x32, 0x00, 0x44, 0x00, 0x41, 0x00, 0x42, 0x00, 0x31, 0x00,
	0x30, 0x00, 0x45, 0x00, 0x41, 0x00, 0x38, 0x00, 0x38, 0x00, 0x33, 0x00, 0x38, 0x00, 0x46, 0x00,
	0x36, 0x00, 0x35, 0x00, 0x32, 0x00, 0x39, 0x00, 0x46, 0x00, 0x41, 0x00, 0x34, 0x00, 0x45, 0x00,
	0x34, 0x00, 0x44, 0x00, 0x39, 0x00, 0x37, 0x00, 0x41, 0x00, 0x38, 0x00, 0x09, 0x00, 0x32, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00, 0x31, 0x00, 0x34, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x09, 0x00, 0x31, 0x00, 0x35, 0x00, 0x37, 0x00, 0x37, 0x00, 0x36, 0x00,
	0x38, 0x00, 0x39, 0x00, 0x38, 0x00, 0x32, 0x00, 0x33, 0x00, 0x09, 0x00, 0x31, 0x00, 0x35, 0x00,
	0x37, 0x00, 0x37, 0x00, 0x36, 0x00, 0x36, 0x00, 0x30, 0x00, 0x34, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x35, 0x00, 0x37, 0x00, 0x37, 0x00, 0x36, 0x00, 0x38, 0x00, 0x39, 0x00,
	0x38, 0x00, 0x31, 0x00, 0x36, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x38, 0x00, 0x20, 0x00,
	0x38, 0x00, 0x09, 0x00, 0x35, 0x00, 0x44, 0x00, 0x44, 0x00, 0x33, 0x00, 0x39, 0x00, 0x43, 0x00,
	0x41, 0x00, 0x42, 0x00, 0x31, 0x00, 0x43, 0x00, 0x35, 0x00, 0x33, 0x00, 0x43, 0x00, 0x32, 0x00,
	0x43, 0x00, 0x37, 0x00, 0x37, 0x00, 0x43, 0x00, 0x44, 0x00, 0x33, 0x00, 0x35, 0x00, 0x32, 0x00,
	0x39, 0x00, 0x38, 0x00, 0x33, 0x00, 0x46, 0x00, 0x39, 0x00, 0x36, 0x00, 0x34, 0x00, 0x31, 0x00,
	0x45, 0x00, 0x31, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x42, 0x00, 0x09, 0x00, 0x31, 0x00, 0x33, 0x00,
	0x20, 0x00, 0x54, 0x00, 0x45, 0x00, 0x53, 0x00, 0x54, 0x00, 0x46, 0x00, 0x49, 0x00, 0x4c, 0x00,
	0x45, 0x00, 0x2e, 0x00, 0x54, 0x00, 0x58, 0x00, 0x54, 0x00, 0x09, 0x00, 0x09, 0x00, 0x74, 0x00,
	0x65, 0x00, 0x73, 0x00, 0x74, 0x00, 0x66, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x2e, 0x00,
	0x74, 0x00, 0x78, 0x00, 0x74, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x32, 0x00, 0x38, 0x00,
	0x36, 0x00, 0x37, 0x00, 0x32, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x31, 0x00, 0x34, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00,
	0x34, 0x00, 0x36, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x33, 0x00,
	0x30, 0x00, 0x20, 0x00, 0x20, 0x00, 0x34, 0x00, 0x33, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x34, 0x00, 0x36, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x33, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00,
	0x33, 0x00, 0x30, 0x00, 0x20, 0x00, 0x38, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00,
	0x34, 0x00, 0x31, 0x00, 0x39, 0x00, 0x34, 0x00, 0x33, 0x00, 0x31, 0x00, 0x32, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x0a, 0x00, 0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x30, 0x00,
	0x0a, 0x00, 0x41, 0x00, 0x44, 0x00, 0x39, 0x00, 0x39, 0x00, 0x36, 0x00, 0x35, 0x00, 0x46, 0x00,
	0x34, 0x00, 0x34, 0x00, 0x36, 0x00, 0x30, 0x00, 0x34, 0x00, 0x33, 0x00, 0x37, 0x00, 0x38, 0x00,
	0x43, 0x00, 0x39, 0x00, 0x45, 0x00, 0x45, 0x00, 0x30, 0x00, 0x43, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x33, 0x00, 0x46, 0x00, 0x44, 0x00, 0x32, 0x00, 0x33, 0x00, 0x31, 0x00, 0x34, 0x00, 0x45, 0x00,
	0x34, 0x00, 0x09, 0x00, 0x34, 0x00, 0x30, 0x00, 0x39, 0x00, 0x36, 0x00, 0x09, 0x00, 0x31, 0x00,
	0x20, 0x00, 0x31, 0x00, 0x35, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x38, 0x00,
	0x20, 0x00, 0x31, 0x00, 0x62, 0x00, 0x09, 0x00, 0x43, 0x00, 0x39, 0x00, 0x30, 0x00, 0x41, 0x00,
	0x33, 0x00, 0x41, 0x00, 0x33, 0x00, 0x35, 0x00, 0x46, 0x00, 0x31, 0x00, 0x38, 0x00, 0x35, 0x00,
	0x41, 0x00, 0x45, 0x00, 0x43, 0x00, 0x37, 0x00, 0x38, 0x00, 0x41, 0x00, 0x43, 0x00, 0x31, 0x00,
	0x36, 0x00, 0x46, 0x00, 0x31, 0x00, 0x31, 0x00, 0x34, 0x00, 0x44, 0x00, 0x38, 0x00, 0x36, 0x00,
	0x34, 0x00, 0x38, 0x00, 0x41, 0x00, 0x32, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x42, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x56, 0x00, 0x6f, 0x00, 0x6c, 0x00, 0x75, 0x00,
	0x6d, 0x00, 0x65, 0x00, 0x20, 0x00, 0x42, 0x00, 0x6f, 0x00, 0x6f, 0x00, 0x74, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x35, 0x00, 0x33, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x38, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x20, 0x00, 0x38, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x38, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x34, 0x00, 0x31, 0x00,
	0x39, 0x00, 0x34, 0x00, 0x33, 0x00, 0x30, 0x00, 0x34, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x0a, 0x00, 0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x44, 0x00,
	0x31, 0x00, 0x46, 0x00, 0x45, 0x00, 0x36, 0x00, 0x45, 0x00, 0x42, 0x00, 0x39, 0x00, 0x30, 0x00,
	0x33, 0x00, 0x39, 0x00, 0x45, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x44, 0x00, 0x41, 0x00,
	0x38, 0x00, 0x35, 0x00, 0x44, 0x00, 0x32, 0x00, 0x30, 0x00, 0x41, 0x00, 0x31, 0x00, 0x37, 0x00,
	0x33, 0x00, 0x43, 0x00, 0x43, 0x00, 0x31, 0x00, 0x43, 0x00, 0x41, 0x00, 0x42, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x33, 0x00, 0x31, 0x00, 0x30, 0x00, 0x37, 0x00, 0x32, 0x00, 0x09, 0x00, 0x31, 0x00,
	0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x31, 0x00, 0x35, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x38, 0x00, 0x20, 0x00, 0x31, 0x00, 0x62, 0x00, 0x09, 0x00, 0x37, 0x00,
	0x46, 0x00, 0x32, 0x00, 0x46, 0x00, 0x31, 0x00, 0x38, 0x00, 0x36, 0x00, 0x38, 0x00, 0x43, 0x00,
	0x33, 0x00, 0x30, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x00, 0x35, 0x00, 0x44, 0x00, 0x32, 0x00,
	0x31, 0x00, 0x30, 0x00, 0x33, 0x00, 0x34, 0x00, 0x39, 0x00, 0x45, 0x00, 0x33, 0x00, 0x46, 0x00,
	0x43, 0x00, 0x43, 0x00, 0x46, 0x00, 0x46, 0x00, 0x33, 0x00, 0x35, 0x00, 0x35, 0x00, 0x09, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x42, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x50, 0x00,
	0x72, 0x00, 0x69, 0x00, 0x6d, 0x00, 0x61, 0x00, 0x72, 0x00, 0x79, 0x00, 0x20, 0x00, 0x46, 0x00,
	0x41, 0x00, 0x54, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x34, 0x00, 0x30, 0x00, 0x39, 0x00,
	0x36, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x38, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x35, 0x00, 0x33, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x20, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x20, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x20, 0x00, 0x38, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x34, 0x00, 0x31, 0x00, 0x39, 0x00, 0x34, 0x00,
	0x33, 0x00, 0x30, 0x00, 0x34, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x0a, 0x00,
	0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x35, 0x00, 0x39, 0x00, 0x42, 0x00,
	0x42, 0x00, 0x39, 0x00, 0x34, 0x00, 0x30, 0x00, 0x43, 0x00, 0x31, 0x00, 0x39, 0x00, 0x38, 0x00,
	0x39, 0x00, 0x35, 0x00, 0x44, 0x00, 0x38, 0x00, 0x39, 0x00, 0x42, 0x00, 0x32, 0x00, 0x31, 0x00,
	0x34, 0x00, 0x34, 0x00, 0x37, 0x00, 0x42, 0x00, 0x37, 0x00, 0x44, 0x00, 0x35, 0x00, 0x38, 0x00,
	0x37, 0x00, 0x45, 0x00, 0x37, 0x00, 0x33, 0x00, 0x32, 0x00, 0x09, 0x00, 0x31, 0x00, 0x33, 0x00,
	0x31, 0x00, 0x30, 0x00, 0x37, 0x00, 0x32, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00,
	0x31, 0x00, 0x30, 0x00, 0x31, 0x00, 0x35, 0x00, 0x20, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x38, 0x00, 0x20, 0x00, 0x31, 0x00,
	0x62, 0x00, 0x09, 0x00, 0x37, 0x00, 0x46, 0x00, 0x32, 0x00, 0x46, 0x00, 0x31, 0x00, 0x38, 0x00,
	0x36, 0x00, 0x38, 0x00, 0x43, 0x00, 0x33, 0x00, 0x30, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x00,
	0x35, 0x00, 0x44, 0x00, 0x32, 0x00, 0x31, 0x00, 0x30, 0x00, 0x33, 0x00, 0x34, 0x00, 0x39, 0x00,
	0x45, 0x00, 0x33, 0x00, 0x46, 0x00, 0x43, 0x00, 0x43, 0x00, 0x46, 0x00, 0x46, 0x00, 0x33, 0x00,
	0x35, 0x00, 0x35, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x42, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x53, 0x00, 0x65, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x64, 0x00,
	0x61, 0x00, 0x72, 0x00, 0x79, 0x00, 0x20, 0x00, 0x46, 0x00, 0x41, 0x00, 0x54, 0x00, 0x09, 0x00,
	0x34, 0x00, 0x31, 0x00, 0x31, 0x00, 0x37, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x33, 0x00,
	0x35, 0x00, 0x31, 0x00, 0x36, 0x00, 0x38, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x38, 0x00, 0x20, 0x00, 0x20, 0x00, 0x35, 0x00,
	0x33, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00,
	0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x20, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x38, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x37, 0x00, 0x31, 0x00, 0x33, 0x00,
	0x30, 0x00, 0x33, 0x00, 0x31, 0x00, 0x36, 0x00, 0x38, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x0a, 0x00, 0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x37, 0x00,
	0x30, 0x00, 0x43, 0x00, 0x37, 0x00, 0x37, 0x00, 0x36, 0x00, 0x33, 0x00, 0x35, 0x00, 0x44, 0x00,
	0x32, 0x00, 0x39, 0x00, 0x45, 0x00, 0x45, 0x00, 0x42, 0x00, 0x38, 0x00, 0x32, 0x00, 0x38, 0x00,
	0x36, 0x00, 0x37, 0x00, 0x39, 0x00, 0x33, 0x00, 0x45, 0x00, 0x38, 0x00, 0x42, 0x00, 0x37, 0x00,
	0x45, 0x00, 0x44, 0x00, 0x37, 0x00, 0x36, 0x00, 0x34, 0x00, 0x30, 0x00, 0x36, 0x00, 0x09, 0x00,
	0x32, 0x00, 0x36, 0x00, 0x31, 0x00, 0x38, 0x00, 0x35, 0x00, 0x37, 0x00, 0x32, 0x00, 0x38, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00, 0x31, 0x00, 0x30, 0x00, 0x31, 0x00,
	0x36, 0x00, 0x20, 0x00, 0x66, 0x00, 0x39, 0x00, 0x62, 0x00, 0x61, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x38, 0x00, 0x20, 0x00, 0x31, 0x00, 0x62, 0x00, 0x09, 0x00, 0x32, 0x00, 0x39, 0x00, 0x39, 0x00,
	0x37, 0x00, 0x44, 0x00, 0x44, 0x00, 0x36, 0x00, 0x31, 0x00, 0x39, 0x00, 0x30, 0x00, 0x38, 0x00,
	0x44, 0x00, 0x33, 0x00, 0x44, 0x00, 0x31, 0x00, 0x38, 0x00, 0x30, 0x00, 0x36, 0x00, 0x37, 0x00,
	0x38, 0x00, 0x44, 0x00, 0x33, 0x00, 0x31, 0x00, 0x41, 0x00, 0x44, 0x00, 0x35, 0x00, 0x45, 0x00,
	0x42, 0x00, 0x34, 0x00, 0x32, 0x00, 0x41, 0x00, 0x38, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x42, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x55, 0x00, 0x6e, 0x00, 0x61, 0x00,
	0x6c, 0x00, 0x6c, 0x00, 0x6f, 0x00, 0x63, 0x00, 0x61, 0x00, 0x74, 0x00, 0x65, 0x00, 0x64, 0x00,
	0x20, 0x00, 0x43, 0x00, 0x6c, 0x00, 0x75, 0x00, 0x73, 0x00, 0x74, 0x00, 0x65, 0x00, 0x72, 0x00,
	0x73, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x32, 0x00, 0x38, 0x00, 0x32, 0x00, 0x36, 0x00,
	0x32, 0x00, 0x34, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x66, 0x00, 0x39, 0x00,
	0x62, 0x00, 0x61, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x66, 0x00, 0x39, 0x00,
	0x62, 0x00, 0x61, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x34, 0x00, 0x35, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x32, 0x00, 0x38, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x34, 0x00, 0x33, 0x00, 0x20, 0x00, 0x32, 0x00, 0x20, 0x00, 0x34, 0x00, 0x35, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x20, 0x00, 0x32, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00, 0x32, 0x00, 0x38, 0x00,
	0x20, 0x00, 0x38, 0x00, 0x20, 0x00, 0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x20, 0x00, 0x66, 0x00, 0x39, 0x00, 0x62, 0x00, 0x39, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x20, 0x00, 0x34, 0x00, 0x20, 0x00, 0x66, 0x00, 0x39, 0x00, 0x62, 0x00, 0x39, 0x00, 0x20, 0x00,
	0x32, 0x00, 0x33, 0x00, 0x38, 0x00, 0x20, 0x00, 0x37, 0x00, 0x63, 0x00, 0x64, 0x00, 0x63, 0x00,
	0x38, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x36, 0x00, 0x32, 0x00, 0x39, 0x00,
	0x31, 0x00, 0x34, 0x00, 0x35, 0x00, 0x36, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x0a, 0x00, 0x0a, 0x00 };

#if defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT )

/* Tests the libewf_file_entry_initialize function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_initialize(
     void )
{
	libcdata_tree_node_t *file_entry_tree_node = NULL;
	libcerror_error_t *error                   = NULL;
	libewf_file_entry_t *file_entry            = NULL;
	libewf_single_files_t *single_files        = NULL;
	libfdata_stream_t *data_stream             = NULL;
	size64_t media_size                        = 0;
	uint8_t format                             = 0;
	int result                                 = 0;

#if defined( HAVE_EWF_TEST_MEMORY )
	int number_of_malloc_fail_tests            = 1;
	int number_of_memset_fail_tests            = 1;
	int test_number                            = 0;
#endif

	/* Initialize test
	 */
	result = libewf_single_files_initialize(
	          &single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "single_files",
	 single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_data_stream_initialize_from_buffer(
	          &data_stream,
	          ewf_test_file_entry_data1,
	          5700,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "data_stream",
	 data_stream );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_single_files_read_data_stream(
	          single_files,
	          data_stream,
	          NULL,
	          &media_size,
	          &format,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libfdata_stream_free(
	          &data_stream,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "data_stream",
	 data_stream );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_single_files_get_file_entry_tree_root_node(
	          single_files,
	          &file_entry_tree_node,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "file_entry_tree_node",
	 file_entry_tree_node );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	result = libewf_file_entry_initialize(
	          &file_entry,
	          NULL,
	          single_files,
	          file_entry_tree_node,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "file_entry",
	 file_entry );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_file_entry_free(
	          &file_entry,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "file_entry",
	 file_entry );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_file_entry_initialize(
	          NULL,
	          NULL,
	          single_files,
	          file_entry_tree_node,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	file_entry = (libewf_file_entry_t *) 0x12345678UL;

	result = libewf_file_entry_initialize(
	          &file_entry,
	          NULL,
	          single_files,
	          file_entry_tree_node,
	          &error );

	file_entry = NULL;

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_file_entry_initialize(
	          &file_entry,
	          NULL,
	          single_files,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

#if defined( HAVE_EWF_TEST_MEMORY )

	for( test_number = 0;
	     test_number < number_of_malloc_fail_tests;
	     test_number++ )
	{
		/* Test libewf_file_entry_initialize with malloc failing
		 */
		ewf_test_malloc_attempts_before_fail = test_number;

		result = libewf_file_entry_initialize(
		          &file_entry,
		          NULL,
		          single_files,
		          file_entry_tree_node,
		          &error );

		if( ewf_test_malloc_attempts_before_fail != -1 )
		{
			ewf_test_malloc_attempts_before_fail = -1;

			if( file_entry != NULL )
			{
				libewf_file_entry_free(
				 &file_entry,
				 NULL );
			}
		}
		else
		{
			EWF_TEST_ASSERT_EQUAL_INT(
			 "result",
			 result,
			 -1 );

			EWF_TEST_ASSERT_IS_NULL(
			 "file_entry",
			 file_entry );

			EWF_TEST_ASSERT_IS_NOT_NULL(
			 "error",
			 error );

			libcerror_error_free(
			 &error );
		}
	}
	for( test_number = 0;
	     test_number < number_of_memset_fail_tests;
	     test_number++ )
	{
		/* Test libewf_file_entry_initialize with memset failing
		 */
		ewf_test_memset_attempts_before_fail = test_number;

		result = libewf_file_entry_initialize(
		          &file_entry,
		          NULL,
		          single_files,
		          file_entry_tree_node,
		          &error );

		if( ewf_test_memset_attempts_before_fail != -1 )
		{
			ewf_test_memset_attempts_before_fail = -1;

			if( file_entry != NULL )
			{
				libewf_file_entry_free(
				 &file_entry,
				 NULL );
			}
		}
		else
		{
			EWF_TEST_ASSERT_EQUAL_INT(
			 "result",
			 result,
			 -1 );

			EWF_TEST_ASSERT_IS_NULL(
			 "file_entry",
			 file_entry );

			EWF_TEST_ASSERT_IS_NOT_NULL(
			 "error",
			 error );

			libcerror_error_free(
			 &error );
		}
	}
#endif /* defined( HAVE_EWF_TEST_MEMORY ) */

	/* Clean up
	 */
	result = libewf_single_files_free(
	          &single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "single_files",
	 single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	if( file_entry != NULL )
	{
		libewf_file_entry_free(
		 &file_entry,
		 NULL );
	}
	if( data_stream != NULL )
	{
		libfdata_stream_free(
		 &data_stream,
		 NULL );
	}
	if( single_files != NULL )
	{
		libewf_single_files_free(
		 &single_files,
		 NULL );
	}
	return( 0 );
}

#endif /* defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT ) */

/* Tests the libewf_file_entry_free function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_free(
     void )
{
	libcerror_error_t *error = NULL;
	int result               = 0;

	/* Test error cases
	 */
	result = libewf_file_entry_free(
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

#if defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT )

/* Tests the libewf_file_entry_get_identifier function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_identifier(
     libewf_file_entry_t *file_entry )
{
	libcerror_error_t *error = NULL;
	uint64_t identifier      = 0;
	int result               = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_identifier(
	          file_entry,
	          &identifier,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_file_entry_get_identifier(
	          NULL,
	          &identifier,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_file_entry_get_identifier(
	          file_entry,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_type function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_type(
     libewf_file_entry_t *file_entry )
{
	libcerror_error_t *error = NULL;
	uint8_t type             = 0;
	int result               = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_type(
	          file_entry,
	          &type,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_file_entry_get_type(
	          NULL,
	          &type,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_file_entry_get_type(
	          file_entry,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_flags function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_flags(
     libewf_file_entry_t *file_entry )
{
	libcerror_error_t *error = NULL;
	uint32_t flags           = 0;
	int result               = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_flags(
	          file_entry,
	          &flags,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_file_entry_get_flags(
	          NULL,
	          &flags,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_file_entry_get_flags(
	          file_entry,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_media_data_offset function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_media_data_offset(
     libewf_file_entry_t *file_entry )
{
	libcerror_error_t *error  = NULL;
	off64_t media_data_offset = 0;
	int result                = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_media_data_offset(
	          file_entry,
	          &media_data_offset,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_file_entry_get_media_data_offset(
	          NULL,
	          &media_data_offset,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_file_entry_get_media_data_offset(
	          file_entry,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_media_data_size function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_media_data_size(
     libewf_file_entry_t *file_entry )
{
	libcerror_error_t *error = NULL;
	size64_t media_data_size = 0;
	int result               = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_media_data_size(
	          file_entry,
	          &media_data_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_file_entry_get_media_data_size(
	          NULL,
	          &media_data_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_file_entry_get_media_data_size(
	          file_entry,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_duplicate_media_data_offset function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_duplicate_media_data_offset(
     libewf_file_entry_t *file_entry )
{
	libcerror_error_t *error            = NULL;
	off64_t duplicate_media_data_offset = 0;
	int result                          = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_duplicate_media_data_offset(
	          file_entry,
	          &duplicate_media_data_offset,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_file_entry_get_duplicate_media_data_offset(
	          NULL,
	          &duplicate_media_data_offset,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_file_entry_get_duplicate_media_data_offset(
	          file_entry,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_utf8_name_size function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_utf8_name_size(
     libewf_file_entry_t *file_entry )
{
	libcerror_error_t *error  = NULL;
	size_t utf8_string_size   = 0;
	int result                = 0;
	int utf8_name_size_is_set = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_utf8_name_size(
	          file_entry,
	          &utf8_string_size,
	          &error );

	EWF_TEST_ASSERT_NOT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	utf8_name_size_is_set = result;

	/* Test error cases
	 */
	result = libewf_file_entry_get_utf8_name_size(
	          NULL,
	          &utf8_string_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	if( utf8_name_size_is_set != 0 )
	{
		result = libewf_file_entry_get_utf8_name_size(
		          file_entry,
		          NULL,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );
	}
	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_utf8_name function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_utf8_name(
     libewf_file_entry_t *file_entry )
{
	uint8_t utf8_string[ 64 ];

	libcerror_error_t *error = NULL;
	int result               = 0;
	int utf8_name_is_set     = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_utf8_name(
	          file_entry,
	          utf8_string,
	          64,
	          &error );

	EWF_TEST_ASSERT_NOT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	utf8_name_is_set = result;

	/* Test error cases
	 */
	result = libewf_file_entry_get_utf8_name(
	          NULL,
	          utf8_string,
	          64,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	if( utf8_name_is_set != 0 )
	{
		result = libewf_file_entry_get_utf8_name(
		          file_entry,
		          NULL,
		          64,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );

		result = libewf_file_entry_get_utf8_name(
		          file_entry,
		          utf8_string,
		          0,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );

		result = libewf_file_entry_get_utf8_name(
		          file_entry,
		          utf8_string,
		          (size_t) SSIZE_MAX + 1,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );
	}
	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_utf16_name_size function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_utf16_name_size(
     libewf_file_entry_t *file_entry )
{
	libcerror_error_t *error   = NULL;
	size_t utf16_string_size   = 0;
	int result                 = 0;
	int utf16_name_size_is_set = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_utf16_name_size(
	          file_entry,
	          &utf16_string_size,
	          &error );

	EWF_TEST_ASSERT_NOT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	utf16_name_size_is_set = result;

	/* Test error cases
	 */
	result = libewf_file_entry_get_utf16_name_size(
	          NULL,
	          &utf16_string_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	if( utf16_name_size_is_set != 0 )
	{
		result = libewf_file_entry_get_utf16_name_size(
		          file_entry,
		          NULL,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );
	}
	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_utf16_name function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_utf16_name(
     libewf_file_entry_t *file_entry )
{
	uint16_t utf16_string[ 64 ];

	libcerror_error_t *error = NULL;
	int result               = 0;
	int utf16_name_is_set    = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_utf16_name(
	          file_entry,
	          utf16_string,
	          64,
	          &error );

	EWF_TEST_ASSERT_NOT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	utf16_name_is_set = result;

	/* Test error cases
	 */
	result = libewf_file_entry_get_utf16_name(
	          NULL,
	          utf16_string,
	          64,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	if( utf16_name_is_set != 0 )
	{
		result = libewf_file_entry_get_utf16_name(
		          file_entry,
		          NULL,
		          64,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );

		result = libewf_file_entry_get_utf16_name(
		          file_entry,
		          utf16_string,
		          0,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );

		result = libewf_file_entry_get_utf16_name(
		          file_entry,
		          utf16_string,
		          (size_t) SSIZE_MAX + 1,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );
	}
	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_utf8_short_name_size function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_utf8_short_name_size(
     libewf_file_entry_t *file_entry )
{
	libcerror_error_t *error        = NULL;
	size_t utf8_string_size         = 0;
	int result                      = 0;
	int utf8_short_name_size_is_set = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_utf8_short_name_size(
	          file_entry,
	          &utf8_string_size,
	          &error );

	EWF_TEST_ASSERT_NOT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	utf8_short_name_size_is_set = result;

	/* Test error cases
	 */
	result = libewf_file_entry_get_utf8_short_name_size(
	          NULL,
	          &utf8_string_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	if( utf8_short_name_size_is_set != 0 )
	{
		result = libewf_file_entry_get_utf8_short_name_size(
		          file_entry,
		          NULL,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );
	}
	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_utf8_short_name function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_utf8_short_name(
     libewf_file_entry_t *file_entry )
{
	uint8_t utf8_string[ 64 ];

	libcerror_error_t *error   = NULL;
	int result                 = 0;
	int utf8_short_name_is_set = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_utf8_short_name(
	          file_entry,
	          utf8_string,
	          64,
	          &error );

	EWF_TEST_ASSERT_NOT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	utf8_short_name_is_set = result;

	/* Test error cases
	 */
	result = libewf_file_entry_get_utf8_short_name(
	          NULL,
	          utf8_string,
	          64,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	if( utf8_short_name_is_set != 0 )
	{
		result = libewf_file_entry_get_utf8_short_name(
		          file_entry,
		          NULL,
		          64,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );

		result = libewf_file_entry_get_utf8_short_name(
		          file_entry,
		          utf8_string,
		          0,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );

		result = libewf_file_entry_get_utf8_short_name(
		          file_entry,
		          utf8_string,
		          (size_t) SSIZE_MAX + 1,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );
	}
	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_utf16_short_name_size function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_utf16_short_name_size(
     libewf_file_entry_t *file_entry )
{
	libcerror_error_t *error         = NULL;
	size_t utf16_string_size         = 0;
	int result                       = 0;
	int utf16_short_name_size_is_set = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_utf16_short_name_size(
	          file_entry,
	          &utf16_string_size,
	          &error );

	EWF_TEST_ASSERT_NOT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	utf16_short_name_size_is_set = result;

	/* Test error cases
	 */
	result = libewf_file_entry_get_utf16_short_name_size(
	          NULL,
	          &utf16_string_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	if( utf16_short_name_size_is_set != 0 )
	{
		result = libewf_file_entry_get_utf16_short_name_size(
		          file_entry,
		          NULL,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );
	}
	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_utf16_short_name function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_utf16_short_name(
     libewf_file_entry_t *file_entry )
{
	uint16_t utf16_string[ 64 ];

	libcerror_error_t *error    = NULL;
	int result                  = 0;
	int utf16_short_name_is_set = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_utf16_short_name(
	          file_entry,
	          utf16_string,
	          64,
	          &error );

	EWF_TEST_ASSERT_NOT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	utf16_short_name_is_set = result;

	/* Test error cases
	 */
	result = libewf_file_entry_get_utf16_short_name(
	          NULL,
	          utf16_string,
	          64,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	if( utf16_short_name_is_set != 0 )
	{
		result = libewf_file_entry_get_utf16_short_name(
		          file_entry,
		          NULL,
		          64,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );

		result = libewf_file_entry_get_utf16_short_name(
		          file_entry,
		          utf16_string,
		          0,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );

		result = libewf_file_entry_get_utf16_short_name(
		          file_entry,
		          utf16_string,
		          (size_t) SSIZE_MAX + 1,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );
	}
	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_size function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_size(
     libewf_file_entry_t *file_entry )
{
	libcerror_error_t *error = NULL;
	size64_t size            = 0;
	int result               = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_size(
	          file_entry,
	          &size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_file_entry_get_size(
	          NULL,
	          &size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_file_entry_get_size(
	          file_entry,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_creation_time function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_creation_time(
     libewf_file_entry_t *file_entry )
{
	libcerror_error_t *error = NULL;
	int64_t creation_time    = 0;
	int result               = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_creation_time(
	          file_entry,
	          &creation_time,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_file_entry_get_creation_time(
	          NULL,
	          &creation_time,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_file_entry_get_creation_time(
	          file_entry,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_modification_time function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_modification_time(
     libewf_file_entry_t *file_entry )
{
	libcerror_error_t *error  = NULL;
	int64_t modification_time = 0;
	int result                = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_modification_time(
	          file_entry,
	          &modification_time,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_file_entry_get_modification_time(
	          NULL,
	          &modification_time,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_file_entry_get_modification_time(
	          file_entry,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_access_time function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_access_time(
     libewf_file_entry_t *file_entry )
{
	libcerror_error_t *error = NULL;
	int64_t access_time      = 0;
	int result               = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_access_time(
	          file_entry,
	          &access_time,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_file_entry_get_access_time(
	          NULL,
	          &access_time,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_file_entry_get_access_time(
	          file_entry,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_entry_modification_time function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_entry_modification_time(
     libewf_file_entry_t *file_entry )
{
	libcerror_error_t *error        = NULL;
	int64_t entry_modification_time = 0;
	int result                      = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_entry_modification_time(
	          file_entry,
	          &entry_modification_time,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_file_entry_get_entry_modification_time(
	          NULL,
	          &entry_modification_time,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_file_entry_get_entry_modification_time(
	          file_entry,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_deletion_time function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_deletion_time(
     libewf_file_entry_t *file_entry )
{
	libcerror_error_t *error = NULL;
	int64_t deletion_time    = 0;
	int result               = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_deletion_time(
	          file_entry,
	          &deletion_time,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_file_entry_get_deletion_time(
	          NULL,
	          &deletion_time,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_file_entry_get_deletion_time(
	          file_entry,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_utf8_hash_value_md5 function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_utf8_hash_value_md5(
     libewf_file_entry_t *file_entry )
{
	uint8_t utf8_hash_value_md5[ 64 ];

	libcerror_error_t *error       = NULL;
	int result                     = 0;
	int utf8_hash_value_md5_is_set = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_utf8_hash_value_md5(
	          file_entry,
	          utf8_hash_value_md5,
	          64,
	          &error );

	EWF_TEST_ASSERT_NOT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	utf8_hash_value_md5_is_set = result;

	/* Test error cases
	 */
	result = libewf_file_entry_get_utf8_hash_value_md5(
	          NULL,
	          utf8_hash_value_md5,
	          64,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	if( utf8_hash_value_md5_is_set != 0 )
	{
		result = libewf_file_entry_get_utf8_hash_value_md5(
		          file_entry,
		          NULL,
		          64,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );

		result = libewf_file_entry_get_utf8_hash_value_md5(
		          file_entry,
		          utf8_hash_value_md5,
		          0,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );

		result = libewf_file_entry_get_utf8_hash_value_md5(
		          file_entry,
		          utf8_hash_value_md5,
		          (size_t) SSIZE_MAX + 1,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );
	}
	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_utf16_hash_value_md5 function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_utf16_hash_value_md5(
     libewf_file_entry_t *file_entry )
{
	uint16_t utf16_hash_value_md5[ 64 ];

	libcerror_error_t *error        = NULL;
	int result                      = 0;
	int utf16_hash_value_md5_is_set = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_utf16_hash_value_md5(
	          file_entry,
	          utf16_hash_value_md5,
	          64,
	          &error );

	EWF_TEST_ASSERT_NOT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	utf16_hash_value_md5_is_set = result;

	/* Test error cases
	 */
	result = libewf_file_entry_get_utf16_hash_value_md5(
	          NULL,
	          utf16_hash_value_md5,
	          64,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	if( utf16_hash_value_md5_is_set != 0 )
	{
		result = libewf_file_entry_get_utf16_hash_value_md5(
		          file_entry,
		          NULL,
		          64,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );

		result = libewf_file_entry_get_utf16_hash_value_md5(
		          file_entry,
		          utf16_hash_value_md5,
		          0,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );

		result = libewf_file_entry_get_utf16_hash_value_md5(
		          file_entry,
		          utf16_hash_value_md5,
		          (size_t) SSIZE_MAX + 1,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );
	}
	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_utf8_hash_value_sha1 function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_utf8_hash_value_sha1(
     libewf_file_entry_t *file_entry )
{
	uint8_t utf8_hash_value_sha1[ 64 ];

	libcerror_error_t *error        = NULL;
	int result                      = 0;
	int utf8_hash_value_sha1_is_set = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_utf8_hash_value_sha1(
	          file_entry,
	          utf8_hash_value_sha1,
	          64,
	          &error );

	EWF_TEST_ASSERT_NOT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	utf8_hash_value_sha1_is_set = result;

	/* Test error cases
	 */
	result = libewf_file_entry_get_utf8_hash_value_sha1(
	          NULL,
	          utf8_hash_value_sha1,
	          64,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	if( utf8_hash_value_sha1_is_set != 0 )
	{
		result = libewf_file_entry_get_utf8_hash_value_sha1(
		          file_entry,
		          NULL,
		          64,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );

		result = libewf_file_entry_get_utf8_hash_value_sha1(
		          file_entry,
		          utf8_hash_value_sha1,
		          0,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );

		result = libewf_file_entry_get_utf8_hash_value_sha1(
		          file_entry,
		          utf8_hash_value_sha1,
		          (size_t) SSIZE_MAX + 1,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );
	}
	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_file_entry_get_utf16_hash_value_sha1 function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_file_entry_get_utf16_hash_value_sha1(
     libewf_file_entry_t *file_entry )
{
	uint16_t utf16_hash_value_sha1[ 64 ];

	libcerror_error_t *error         = NULL;
	int result                       = 0;
	int utf16_hash_value_sha1_is_set = 0;

	/* Test regular cases
	 */
	result = libewf_file_entry_get_utf16_hash_value_sha1(
	          file_entry,
	          utf16_hash_value_sha1,
	          64,
	          &error );

	EWF_TEST_ASSERT_NOT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	utf16_hash_value_sha1_is_set = result;

	/* Test error cases
	 */
	result = libewf_file_entry_get_utf16_hash_value_sha1(
	          NULL,
	          utf16_hash_value_sha1,
	          64,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	if( utf16_hash_value_sha1_is_set != 0 )
	{
		result = libewf_file_entry_get_utf16_hash_value_sha1(
		          file_entry,
		          NULL,
		          64,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );

		result = libewf_file_entry_get_utf16_hash_value_sha1(
		          file_entry,
		          utf16_hash_value_sha1,
		          0,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );

		result = libewf_file_entry_get_utf16_hash_value_sha1(
		          file_entry,
		          utf16_hash_value_sha1,
		          (size_t) SSIZE_MAX + 1,
		          &error );

		EWF_TEST_ASSERT_EQUAL_INT(
		 "result",
		 result,
		 -1 );

		EWF_TEST_ASSERT_IS_NOT_NULL(
		 "error",
		 error );

		libcerror_error_free(
		 &error );
	}
	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

#endif /* defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT ) */

/* The main program
 */
#if defined( HAVE_WIDE_SYSTEM_CHARACTER )
int wmain(
     int argc EWF_TEST_ATTRIBUTE_UNUSED,
     wchar_t * const argv[] EWF_TEST_ATTRIBUTE_UNUSED )
#else
int main(
     int argc EWF_TEST_ATTRIBUTE_UNUSED,
     char * const argv[] EWF_TEST_ATTRIBUTE_UNUSED )
#endif
{
#if defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT )

	libcdata_tree_node_t *file_entry_tree_node = NULL;
	libcerror_error_t *error                   = NULL;
	libewf_file_entry_t *file_entry            = NULL;
	libewf_single_files_t *single_files        = NULL;
	libfdata_stream_t *data_stream             = NULL;
	size64_t media_size                        = 0;
	uint8_t format                             = 0;
	int result                                 = 0;

#endif /* defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT ) */

	EWF_TEST_UNREFERENCED_PARAMETER( argc )
	EWF_TEST_UNREFERENCED_PARAMETER( argv )

#if defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT )

	EWF_TEST_RUN(
	 "libewf_file_entry_initialize",
	 ewf_test_file_entry_initialize );

#endif /* defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT ) */

	EWF_TEST_RUN(
	 "libewf_file_entry_free",
	 ewf_test_file_entry_free );

#if defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT )
#if !defined( __BORLANDC__ ) || ( __BORLANDC__ >= 0x0560 )

	/* Initialize single_files for tests
	 */
	result = libewf_single_files_initialize(
	          &single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "single_files",
	 single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_data_stream_initialize_from_buffer(
	          &data_stream,
	          ewf_test_file_entry_data1,
	          5700,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "data_stream",
	 data_stream );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_single_files_read_data_stream(
	          single_files,
	          data_stream,
	          NULL,
	          &media_size,
	          &format,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libfdata_stream_free(
	          &data_stream,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "data_stream",
	 data_stream );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_single_files_get_file_entry_tree_root_node(
	          single_files,
	          &file_entry_tree_node,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "file_entry_tree_node",
	 file_entry_tree_node );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_file_entry_initialize(
	          &file_entry,
	          NULL,
	          single_files,
	          file_entry_tree_node,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "file_entry",
	 file_entry );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Run tests
	 */
	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_identifier",
	 ewf_test_file_entry_get_identifier,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_type",
	 ewf_test_file_entry_get_type,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_flags",
	 ewf_test_file_entry_get_flags,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_media_data_offset",
	 ewf_test_file_entry_get_media_data_offset,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_media_data_size",
	 ewf_test_file_entry_get_media_data_size,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_duplicate_media_data_offset",
	 ewf_test_file_entry_get_duplicate_media_data_offset,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_utf8_name_size",
	 ewf_test_file_entry_get_utf8_name_size,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_utf8_name",
	 ewf_test_file_entry_get_utf8_name,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_utf16_name_size",
	 ewf_test_file_entry_get_utf16_name_size,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_utf16_name",
	 ewf_test_file_entry_get_utf16_name,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_utf8_short_name_size",
	 ewf_test_file_entry_get_utf8_short_name_size,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_utf8_short_name",
	 ewf_test_file_entry_get_utf8_short_name,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_utf16_short_name_size",
	 ewf_test_file_entry_get_utf16_short_name_size,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_utf16_short_name",
	 ewf_test_file_entry_get_utf16_short_name,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_size",
	 ewf_test_file_entry_get_size,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_creation_time",
	 ewf_test_file_entry_get_creation_time,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_modification_time",
	 ewf_test_file_entry_get_modification_time,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_access_time",
	 ewf_test_file_entry_get_access_time,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_entry_modification_time",
	 ewf_test_file_entry_get_entry_modification_time,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_deletion_time",
	 ewf_test_file_entry_get_deletion_time,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_utf8_hash_value_md5",
	 ewf_test_file_entry_get_utf8_hash_value_md5,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_utf16_hash_value_md5",
	 ewf_test_file_entry_get_utf16_hash_value_md5,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_utf8_hash_value_sha1",
	 ewf_test_file_entry_get_utf8_hash_value_sha1,
	 file_entry );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_file_entry_get_utf16_hash_value_sha1",
	 ewf_test_file_entry_get_utf16_hash_value_sha1,
	 file_entry );

	/* TODO: add tests for libewf_internal_file_entry_read_buffer */

	/* TODO: add tests for libewf_file_entry_read_buffer */

	/* TODO: add tests for libewf_file_entry_read_buffer_at_offset */

	/* TODO: add tests for libewf_internal_file_entry_seek_offset */

	/* TODO: add tests for libewf_file_entry_seek_offset */

	/* TODO: add tests for libewf_file_entry_get_offset */

	/* TODO: add tests for libewf_file_entry_get_number_of_sub_file_entries */

	/* TODO: add tests for libewf_file_entry_get_sub_file_entry */

	/* TODO: add tests for libewf_file_entry_get_sub_file_entry_by_utf8_name */

	/* TODO: add tests for libewf_file_entry_get_sub_file_entry_by_utf8_path */

	/* TODO: add tests for libewf_file_entry_get_sub_file_entry_by_utf16_name */

	/* TODO: add tests for libewf_file_entry_get_sub_file_entry_by_utf16_path */

	/* TODO: add tests for libewf_file_entry_get_number_of_attributes */

	/* TODO: add tests for libewf_file_entry_get_attribute */

	/* TODO: add tests for libewf_file_entry_get_number_of_access_control_entries */

	/* TODO: add tests for libewf_file_entry_get_access_control_entry */

	/* TODO: add tests for libewf_file_entry_get_source */

	/* Clean up
	 */
	result = libewf_file_entry_free(
	          &file_entry,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "file_entry",
	 file_entry );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_single_files_free(
	          &single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "single_files",
	 single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

#endif /* !defined( __BORLANDC__ ) || ( __BORLANDC__ >= 0x0560 ) */
#endif /* defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT ) */

	return( EXIT_SUCCESS );

on_error:
#if defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT )
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	if( file_entry != NULL )
	{
		libewf_file_entry_free(
		 &file_entry,
		 NULL );
	}
	if( data_stream != NULL )
	{
		libfdata_stream_free(
		 &data_stream,
		 NULL );
	}
	if( single_files != NULL )
	{
		libewf_single_files_free(
		 &single_files,
		 NULL );
	}
#endif /* defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT ) */

	return( EXIT_FAILURE );
}

