/*
 * Library single_files type test program
 *
 * Copyright (C) 2006-2024, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <common.h>
#include <file_stream.h>
#include <types.h>

#if defined( HAVE_STDLIB_H ) || defined( WINAPI )
#include <stdlib.h>
#endif

#include "ewf_test_libcdata.h"
#include "ewf_test_libcerror.h"
#include "ewf_test_libewf.h"
#include "ewf_test_libfdata.h"
#include "ewf_test_libfvalue.h"
#include "ewf_test_macros.h"
#include "ewf_test_memory.h"
#include "ewf_test_unused.h"

#include "../libewf/libewf_data_stream.h"
#include "../libewf/libewf_line_reader.h"
#include "../libewf/libewf_single_files.h"

/* UTF-16 little-endian encoded single files data
 */
uint8_t ewf_test_single_files_data1[ 5700 ] = {
	0x35, 0x00, 0x0a, 0x00, 0x72, 0x00, 0x65, 0x00, 0x63, 0x00, 0x0a, 0x00, 0x74, 0x00, 0x62, 0x00,
	0x09, 0x00, 0x63, 0x00, 0x6c, 0x00, 0x09, 0x00, 0x6e, 0x00, 0x09, 0x00, 0x66, 0x00, 0x70, 0x00,
	0x09, 0x00, 0x70, 0x00, 0x67, 0x00, 0x09, 0x00, 0x6c, 0x00, 0x67, 0x00, 0x09, 0x00, 0x69, 0x00,
	0x67, 0x00, 0x09, 0x00, 0x63, 0x00, 0x64, 0x00, 0x09, 0x00, 0x77, 0x00, 0x64, 0x00, 0x09, 0x00,
	0x6d, 0x00, 0x64, 0x00, 0x09, 0x00, 0x61, 0x00, 0x64, 0x00, 0x0a, 0x00, 0x32, 0x00, 0x36, 0x00,
	0x31, 0x00, 0x39, 0x00, 0x39, 0x00, 0x32, 0x00, 0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x65, 0x00, 0x72, 0x00, 0x6d, 0x00, 0x0a, 0x00,
	0x31, 0x00, 0x09, 0x00, 0x31, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x09, 0x00, 0x6e, 0x00, 0x09, 0x00,
	0x73, 0x00, 0x09, 0x00, 0x70, 0x00, 0x72, 0x00, 0x09, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x61, 0x00,
	0x09, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x69, 0x00, 0x0a, 0x00, 0x30, 0x00, 0x09, 0x00, 0x31, 0x00,
	0x0a, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x30, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x0a, 0x00, 0x30, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x31, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x0a, 0x00, 0x0a, 0x00,
	0x73, 0x00, 0x72, 0x00, 0x63, 0x00, 0x65, 0x00, 0x0a, 0x00, 0x31, 0x00, 0x09, 0x00, 0x31, 0x00,
	0x0a, 0x00, 0x70, 0x00, 0x09, 0x00, 0x6e, 0x00, 0x09, 0x00, 0x69, 0x00, 0x64, 0x00, 0x09, 0x00,
	0x65, 0x00, 0x76, 0x00, 0x09, 0x00, 0x64, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x6c, 0x00, 0x6f, 0x00,
	0x63, 0x00, 0x09, 0x00, 0x73, 0x00, 0x65, 0x00, 0x09, 0x00, 0x6d, 0x00, 0x66, 0x00, 0x72, 0x00,
	0x09, 0x00, 0x6d, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x74, 0x00, 0x62, 0x00, 0x09, 0x00, 0x6c, 0x00,
	0x6f, 0x00, 0x09, 0x00, 0x70, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x61, 0x00, 0x68, 0x00, 0x09, 0x00,
	0x73, 0x00, 0x68, 0x00, 0x09, 0x00, 0x67, 0x00, 0x75, 0x00, 0x09, 0x00, 0x70, 0x00, 0x67, 0x00,
	0x75, 0x00, 0x09, 0x00, 0x61, 0x00, 0x71, 0x00, 0x09, 0x00, 0x69, 0x00, 0x70, 0x00, 0x09, 0x00,
	0x73, 0x00, 0x69, 0x00, 0x09, 0x00, 0x6d, 0x00, 0x61, 0x00, 0x09, 0x00, 0x64, 0x00, 0x74, 0x00,
	0x0a, 0x00, 0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x0a, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x2d, 0x00, 0x31, 0x00, 0x09, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x66, 0x00, 0x0a, 0x00, 0x30, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00,
	0x09, 0x00, 0x46, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x04, 0x5f, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x46, 0x00, 0x6c, 0x00, 0x61, 0x00,
	0x73, 0x00, 0x68, 0x00, 0x20, 0x00, 0x44, 0x00, 0x69, 0x00, 0x73, 0x00, 0x6b, 0x00, 0x09, 0x00,
	0x32, 0x00, 0x36, 0x00, 0x32, 0x00, 0x31, 0x00, 0x34, 0x00, 0x34, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x09, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x09, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x37, 0x00, 0x37, 0x00, 0x39, 0x00, 0x30, 0x00, 0x30, 0x00, 0x42, 0x00,
	0x39, 0x00, 0x32, 0x00, 0x41, 0x00, 0x35, 0x00, 0x38, 0x00, 0x43, 0x00, 0x38, 0x00, 0x37, 0x00,
	0x43, 0x00, 0x34, 0x00, 0x38, 0x00, 0x30, 0x00, 0x41, 0x00, 0x33, 0x00, 0x30, 0x00, 0x46, 0x00,
	0x42, 0x00, 0x43, 0x00, 0x35, 0x00, 0x39, 0x00, 0x45, 0x00, 0x33, 0x00, 0x31, 0x00, 0x41, 0x00,
	0x36, 0x00, 0x35, 0x00, 0x09, 0x00, 0x37, 0x00, 0x37, 0x00, 0x39, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x42, 0x00, 0x39, 0x00, 0x32, 0x00, 0x41, 0x00, 0x35, 0x00, 0x38, 0x00, 0x43, 0x00, 0x38, 0x00,
	0x37, 0x00, 0x43, 0x00, 0x34, 0x00, 0x38, 0x00, 0x30, 0x00, 0x41, 0x00, 0x33, 0x00, 0x30, 0x00,
	0x46, 0x00, 0x42, 0x00, 0x43, 0x00, 0x35, 0x00, 0x39, 0x00, 0x45, 0x00, 0x33, 0x00, 0x31, 0x00,
	0x41, 0x00, 0x36, 0x00, 0x35, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x72, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x73, 0x00,
	0x75, 0x00, 0x62, 0x00, 0x0a, 0x00, 0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x0a, 0x00, 0x70, 0x00,
	0x09, 0x00, 0x6e, 0x00, 0x09, 0x00, 0x69, 0x00, 0x64, 0x00, 0x09, 0x00, 0x6e, 0x00, 0x75, 0x00,
	0x09, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x67, 0x00, 0x75, 0x00, 0x0a, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00,
	0x20, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x65, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x72, 0x00,
	0x79, 0x00, 0x0a, 0x00, 0x36, 0x00, 0x09, 0x00, 0x31, 0x00, 0x0a, 0x00, 0x6d, 0x00, 0x69, 0x00,
	0x64, 0x00, 0x09, 0x00, 0x6c, 0x00, 0x73, 0x00, 0x09, 0x00, 0x62, 0x00, 0x65, 0x00, 0x09, 0x00,
	0x69, 0x00, 0x64, 0x00, 0x09, 0x00, 0x63, 0x00, 0x72, 0x00, 0x09, 0x00, 0x61, 0x00, 0x63, 0x00,
	0x09, 0x00, 0x77, 0x00, 0x72, 0x00, 0x09, 0x00, 0x6d, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x64, 0x00,
	0x6c, 0x00, 0x09, 0x00, 0x73, 0x00, 0x69, 0x00, 0x67, 0x00, 0x09, 0x00, 0x68, 0x00, 0x61, 0x00,
	0x09, 0x00, 0x73, 0x00, 0x68, 0x00, 0x61, 0x00, 0x09, 0x00, 0x65, 0x00, 0x6e, 0x00, 0x74, 0x00,
	0x09, 0x00, 0x73, 0x00, 0x6e, 0x00, 0x68, 0x00, 0x09, 0x00, 0x70, 0x00, 0x09, 0x00, 0x6e, 0x00,
	0x09, 0x00, 0x64, 0x00, 0x75, 0x00, 0x09, 0x00, 0x6c, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x70, 0x00,
	0x6f, 0x00, 0x09, 0x00, 0x70, 0x00, 0x6d, 0x00, 0x09, 0x00, 0x6f, 0x00, 0x65, 0x00, 0x73, 0x00,
	0x09, 0x00, 0x73, 0x00, 0x70, 0x00, 0x74, 0x00, 0x68, 0x00, 0x09, 0x00, 0x6f, 0x00, 0x70, 0x00,
	0x72, 0x00, 0x09, 0x00, 0x73, 0x00, 0x72, 0x00, 0x63, 0x00, 0x09, 0x00, 0x73, 0x00, 0x75, 0x00,
	0x62, 0x00, 0x09, 0x00, 0x63, 0x00, 0x69, 0x00, 0x64, 0x00, 0x09, 0x00, 0x6a, 0x00, 0x71, 0x00,
	0x09, 0x00, 0x61, 0x00, 0x6c, 0x00, 0x74, 0x00, 0x09, 0x00, 0x65, 0x00, 0x70, 0x00, 0x09, 0x00,
	0x61, 0x00, 0x71, 0x00, 0x09, 0x00, 0x63, 0x00, 0x66, 0x00, 0x69, 0x00, 0x09, 0x00, 0x73, 0x00,
	0x67, 0x00, 0x09, 0x00, 0x65, 0x00, 0x61, 0x00, 0x09, 0x00, 0x6c, 0x00, 0x70, 0x00, 0x74, 0x00,
	0x0a, 0x00, 0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x36, 0x00, 0x0a, 0x00, 0x41, 0x00, 0x44, 0x00,
	0x31, 0x00, 0x43, 0x00, 0x34, 0x00, 0x31, 0x00, 0x42, 0x00, 0x42, 0x00, 0x33, 0x00, 0x46, 0x00,
	0x31, 0x00, 0x42, 0x00, 0x37, 0x00, 0x34, 0x00, 0x38, 0x00, 0x43, 0x00, 0x39, 0x00, 0x30, 0x00,
	0x45, 0x00, 0x34, 0x00, 0x38, 0x00, 0x34, 0x00, 0x44, 0x00, 0x32, 0x00, 0x46, 0x00, 0x31, 0x00,
	0x37, 0x00, 0x43, 0x00, 0x31, 0x00, 0x33, 0x00, 0x39, 0x00, 0x44, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x42, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x09, 0x00, 0x4c, 0x00, 0x6f, 0x00, 0x67, 0x00, 0x69, 0x00, 0x63, 0x00, 0x61, 0x00,
	0x6c, 0x00, 0x45, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x72, 0x00, 0x69, 0x00, 0x65, 0x00, 0x73, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x0a, 0x00, 0x32, 0x00,
	0x36, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x35, 0x00, 0x38, 0x00, 0x30, 0x00, 0x42, 0x00,
	0x41, 0x00, 0x33, 0x00, 0x30, 0x00, 0x44, 0x00, 0x42, 0x00, 0x38, 0x00, 0x34, 0x00, 0x32, 0x00,
	0x41, 0x00, 0x39, 0x00, 0x38, 0x00, 0x45, 0x00, 0x39, 0x00, 0x44, 0x00, 0x46, 0x00, 0x31, 0x00,
	0x31, 0x00, 0x32, 0x00, 0x34, 0x00, 0x30, 0x00, 0x34, 0x00, 0x37, 0x00, 0x46, 0x00, 0x42, 0x00,
	0x36, 0x00, 0x30, 0x00, 0x36, 0x00, 0x41, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x30, 0x00, 0x20, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x35, 0x00, 0x37, 0x00,
	0x37, 0x00, 0x36, 0x00, 0x38, 0x00, 0x39, 0x00, 0x37, 0x00, 0x36, 0x00, 0x38, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x35, 0x00, 0x37, 0x00, 0x37, 0x00, 0x36, 0x00, 0x36, 0x00, 0x30, 0x00, 0x34, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x35, 0x00, 0x37, 0x00, 0x37, 0x00, 0x36, 0x00,
	0x38, 0x00, 0x39, 0x00, 0x37, 0x00, 0x36, 0x00, 0x38, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x38, 0x00, 0x20, 0x00, 0x31, 0x00, 0x62, 0x00, 0x09, 0x00, 0x44, 0x00, 0x34, 0x00, 0x31, 0x00,
	0x44, 0x00, 0x38, 0x00, 0x43, 0x00, 0x44, 0x00, 0x39, 0x00, 0x38, 0x00, 0x46, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x42, 0x00, 0x32, 0x00, 0x30, 0x00, 0x34, 0x00, 0x45, 0x00, 0x39, 0x00, 0x38, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x39, 0x00, 0x39, 0x00, 0x38, 0x00, 0x45, 0x00, 0x43, 0x00, 0x46, 0x00,
	0x38, 0x00, 0x34, 0x00, 0x32, 0x00, 0x37, 0x00, 0x45, 0x00, 0x09, 0x00, 0x44, 0x00, 0x41, 0x00,
	0x33, 0x00, 0x39, 0x00, 0x41, 0x00, 0x33, 0x00, 0x45, 0x00, 0x45, 0x00, 0x35, 0x00, 0x45, 0x00,
	0x36, 0x00, 0x42, 0x00, 0x34, 0x00, 0x42, 0x00, 0x30, 0x00, 0x44, 0x00, 0x33, 0x00, 0x32, 0x00,
	0x35, 0x00, 0x35, 0x00, 0x42, 0x00, 0x46, 0x00, 0x45, 0x00, 0x46, 0x00, 0x39, 0x00, 0x35, 0x00,
	0x36, 0x00, 0x30, 0x00, 0x31, 0x00, 0x38, 0x00, 0x39, 0x00, 0x30, 0x00, 0x41, 0x00, 0x46, 0x00,
	0x44, 0x00, 0x38, 0x00, 0x30, 0x00, 0x37, 0x00, 0x30, 0x00, 0x39, 0x00, 0x09, 0x00, 0x45, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x54, 0x00, 0x65, 0x00, 0x73, 0x00,
	0x74, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x20, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x20, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x20, 0x00, 0x20, 0x00, 0x34, 0x00, 0x33, 0x00, 0x20, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x0a, 0x00, 0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x41, 0x00, 0x39, 0x00,
	0x46, 0x00, 0x42, 0x00, 0x44, 0x00, 0x32, 0x00, 0x44, 0x00, 0x41, 0x00, 0x42, 0x00, 0x31, 0x00,
	0x30, 0x00, 0x45, 0x00, 0x41, 0x00, 0x38, 0x00, 0x38, 0x00, 0x33, 0x00, 0x38, 0x00, 0x46, 0x00,
	0x36, 0x00, 0x35, 0x00, 0x32, 0x00, 0x39, 0x00, 0x46, 0x00, 0x41, 0x00, 0x34, 0x00, 0x45, 0x00,
	0x34, 0x00, 0x44, 0x00, 0x39, 0x00, 0x37, 0x00, 0x41, 0x00, 0x38, 0x00, 0x09, 0x00, 0x32, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00, 0x31, 0x00, 0x34, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x09, 0x00, 0x31, 0x00, 0x35, 0x00, 0x37, 0x00, 0x37, 0x00, 0x36, 0x00,
	0x38, 0x00, 0x39, 0x00, 0x38, 0x00, 0x32, 0x00, 0x33, 0x00, 0x09, 0x00, 0x31, 0x00, 0x35, 0x00,
	0x37, 0x00, 0x37, 0x00, 0x36, 0x00, 0x36, 0x00, 0x30, 0x00, 0x34, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x35, 0x00, 0x37, 0x00, 0x37, 0x00, 0x36, 0x00, 0x38, 0x00, 0x39, 0x00,
	0x38, 0x00, 0x31, 0x00, 0x36, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x38, 0x00, 0x20, 0x00,
	0x38, 0x00, 0x09, 0x00, 0x35, 0x00, 0x44, 0x00, 0x44, 0x00, 0x33, 0x00, 0x39, 0x00, 0x43, 0x00,
	0x41, 0x00, 0x42, 0x00, 0x31, 0x00, 0x43, 0x00, 0x35, 0x00, 0x33, 0x00, 0x43, 0x00, 0x32, 0x00,
	0x43, 0x00, 0x37, 0x00, 0x37, 0x00, 0x43, 0x00, 0x44, 0x00, 0x33, 0x00, 0x35, 0x00, 0x32, 0x00,
	0x39, 0x00, 0x38, 0x00, 0x33, 0x00, 0x46, 0x00, 0x39, 0x00, 0x36, 0x00, 0x34, 0x00, 0x31, 0x00,
	0x45, 0x00, 0x31, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x42, 0x00, 0x09, 0x00, 0x31, 0x00, 0x33, 0x00,
	0x20, 0x00, 0x54, 0x00, 0x45, 0x00, 0x53, 0x00, 0x54, 0x00, 0x46, 0x00, 0x49, 0x00, 0x4c, 0x00,
	0x45, 0x00, 0x2e, 0x00, 0x54, 0x00, 0x58, 0x00, 0x54, 0x00, 0x09, 0x00, 0x09, 0x00, 0x74, 0x00,
	0x65, 0x00, 0x73, 0x00, 0x74, 0x00, 0x66, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x2e, 0x00,
	0x74, 0x00, 0x78, 0x00, 0x74, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x32, 0x00, 0x38, 0x00,
	0x36, 0x00, 0x37, 0x00, 0x32, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x31, 0x00, 0x34, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00,
	0x34, 0x00, 0x36, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x33, 0x00,
	0x30, 0x00, 0x20, 0x00, 0x20, 0x00, 0x34, 0x00, 0x33, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x34, 0x00, 0x36, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x33, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00,
	0x33, 0x00, 0x30, 0x00, 0x20, 0x00, 0x38, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00,
	0x34, 0x00, 0x31, 0x00, 0x39, 0x00, 0x34, 0x00, 0x33, 0x00, 0x31, 0x00, 0x32, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x0a, 0x00, 0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x30, 0x00,
	0x0a, 0x00, 0x41, 0x00, 0x44, 0x00, 0x39, 0x00, 0x39, 0x00, 0x36, 0x00, 0x35, 0x00, 0x46, 0x00,
	0x34, 0x00, 0x34, 0x00, 0x36, 0x00, 0x30, 0x00, 0x34, 0x00, 0x33, 0x00, 0x37, 0x00, 0x38, 0x00,
	0x43, 0x00, 0x39, 0x00, 0x45, 0x00, 0x45, 0x00, 0x30, 0x00, 0x43, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x33, 0x00, 0x46, 0x00, 0x44, 0x00, 0x32, 0x00, 0x33, 0x00, 0x31, 0x00, 0x34, 0x00, 0x45, 0x00,
	0x34, 0x00, 0x09, 0x00, 0x34, 0x00, 0x30, 0x00, 0x39, 0x00, 0x36, 0x00, 0x09, 0x00, 0x31, 0x00,
	0x20, 0x00, 0x31, 0x00, 0x35, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x38, 0x00,
	0x20, 0x00, 0x31, 0x00, 0x62, 0x00, 0x09, 0x00, 0x43, 0x00, 0x39, 0x00, 0x30, 0x00, 0x41, 0x00,
	0x33, 0x00, 0x41, 0x00, 0x33, 0x00, 0x35, 0x00, 0x46, 0x00, 0x31, 0x00, 0x38, 0x00, 0x35, 0x00,
	0x41, 0x00, 0x45, 0x00, 0x43, 0x00, 0x37, 0x00, 0x38, 0x00, 0x41, 0x00, 0x43, 0x00, 0x31, 0x00,
	0x36, 0x00, 0x46, 0x00, 0x31, 0x00, 0x31, 0x00, 0x34, 0x00, 0x44, 0x00, 0x38, 0x00, 0x36, 0x00,
	0x34, 0x00, 0x38, 0x00, 0x41, 0x00, 0x32, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x42, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x56, 0x00, 0x6f, 0x00, 0x6c, 0x00, 0x75, 0x00,
	0x6d, 0x00, 0x65, 0x00, 0x20, 0x00, 0x42, 0x00, 0x6f, 0x00, 0x6f, 0x00, 0x74, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x35, 0x00, 0x33, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x38, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x20, 0x00, 0x38, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x38, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x34, 0x00, 0x31, 0x00,
	0x39, 0x00, 0x34, 0x00, 0x33, 0x00, 0x30, 0x00, 0x34, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x0a, 0x00, 0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x44, 0x00,
	0x31, 0x00, 0x46, 0x00, 0x45, 0x00, 0x36, 0x00, 0x45, 0x00, 0x42, 0x00, 0x39, 0x00, 0x30, 0x00,
	0x33, 0x00, 0x39, 0x00, 0x45, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x44, 0x00, 0x41, 0x00,
	0x38, 0x00, 0x35, 0x00, 0x44, 0x00, 0x32, 0x00, 0x30, 0x00, 0x41, 0x00, 0x31, 0x00, 0x37, 0x00,
	0x33, 0x00, 0x43, 0x00, 0x43, 0x00, 0x31, 0x00, 0x43, 0x00, 0x41, 0x00, 0x42, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x33, 0x00, 0x31, 0x00, 0x30, 0x00, 0x37, 0x00, 0x32, 0x00, 0x09, 0x00, 0x31, 0x00,
	0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x31, 0x00, 0x35, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x38, 0x00, 0x20, 0x00, 0x31, 0x00, 0x62, 0x00, 0x09, 0x00, 0x37, 0x00,
	0x46, 0x00, 0x32, 0x00, 0x46, 0x00, 0x31, 0x00, 0x38, 0x00, 0x36, 0x00, 0x38, 0x00, 0x43, 0x00,
	0x33, 0x00, 0x30, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x00, 0x35, 0x00, 0x44, 0x00, 0x32, 0x00,
	0x31, 0x00, 0x30, 0x00, 0x33, 0x00, 0x34, 0x00, 0x39, 0x00, 0x45, 0x00, 0x33, 0x00, 0x46, 0x00,
	0x43, 0x00, 0x43, 0x00, 0x46, 0x00, 0x46, 0x00, 0x33, 0x00, 0x35, 0x00, 0x35, 0x00, 0x09, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x42, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x50, 0x00,
	0x72, 0x00, 0x69, 0x00, 0x6d, 0x00, 0x61, 0x00, 0x72, 0x00, 0x79, 0x00, 0x20, 0x00, 0x46, 0x00,
	0x41, 0x00, 0x54, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x34, 0x00, 0x30, 0x00, 0x39, 0x00,
	0x36, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x38, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x35, 0x00, 0x33, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x20, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x20, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x20, 0x00, 0x38, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x34, 0x00, 0x31, 0x00, 0x39, 0x00, 0x34, 0x00,
	0x33, 0x00, 0x30, 0x00, 0x34, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x0a, 0x00,
	0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x35, 0x00, 0x39, 0x00, 0x42, 0x00,
	0x42, 0x00, 0x39, 0x00, 0x34, 0x00, 0x30, 0x00, 0x43, 0x00, 0x31, 0x00, 0x39, 0x00, 0x38, 0x00,
	0x39, 0x00, 0x35, 0x00, 0x44, 0x00, 0x38, 0x00, 0x39, 0x00, 0x42, 0x00, 0x32, 0x00, 0x31, 0x00,
	0x34, 0x00, 0x34, 0x00, 0x37, 0x00, 0x42, 0x00, 0x37, 0x00, 0x44, 0x00, 0x35, 0x00, 0x38, 0x00,
	0x37, 0x00, 0x45, 0x00, 0x37, 0x00, 0x33, 0x00, 0x32, 0x00, 0x09, 0x00, 0x31, 0x00, 0x33, 0x00,
	0x31, 0x00, 0x30, 0x00, 0x37, 0x00, 0x32, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00,
	0x31, 0x00, 0x30, 0x00, 0x31, 0x00, 0x35, 0x00, 0x20, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x38, 0x00, 0x20, 0x00, 0x31, 0x00,
	0x62, 0x00, 0x09, 0x00, 0x37, 0x00, 0x46, 0x00, 0x32, 0x00, 0x46, 0x00, 0x31, 0x00, 0x38, 0x00,
	0x36, 0x00, 0x38, 0x00, 0x43, 0x00, 0x33, 0x00, 0x30, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x00,
	0x35, 0x00, 0x44, 0x00, 0x32, 0x00, 0x31, 0x00, 0x30, 0x00, 0x33, 0x00, 0x34, 0x00, 0x39, 0x00,
	0x45, 0x00, 0x33, 0x00, 0x46, 0x00, 0x43, 0x00, 0x43, 0x00, 0x46, 0x00, 0x46, 0x00, 0x33, 0x00,
	0x35, 0x00, 0x35, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x42, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x53, 0x00, 0x65, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x64, 0x00,
	0x61, 0x00, 0x72, 0x00, 0x79, 0x00, 0x20, 0x00, 0x46, 0x00, 0x41, 0x00, 0x54, 0x00, 0x09, 0x00,
	0x34, 0x00, 0x31, 0x00, 0x31, 0x00, 0x37, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x33, 0x00,
	0x35, 0x00, 0x31, 0x00, 0x36, 0x00, 0x38, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x38, 0x00, 0x20, 0x00, 0x20, 0x00, 0x35, 0x00,
	0x33, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00,
	0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x20, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x38, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x37, 0x00, 0x31, 0x00, 0x33, 0x00,
	0x30, 0x00, 0x33, 0x00, 0x31, 0x00, 0x36, 0x00, 0x38, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x0a, 0x00, 0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x37, 0x00,
	0x30, 0x00, 0x43, 0x00, 0x37, 0x00, 0x37, 0x00, 0x36, 0x00, 0x33, 0x00, 0x35, 0x00, 0x44, 0x00,
	0x32, 0x00, 0x39, 0x00, 0x45, 0x00, 0x45, 0x00, 0x42, 0x00, 0x38, 0x00, 0x32, 0x00, 0x38, 0x00,
	0x36, 0x00, 0x37, 0x00, 0x39, 0x00, 0x33, 0x00, 0x45, 0x00, 0x38, 0x00, 0x42, 0x00, 0x37, 0x00,
	0x45, 0x00, 0x44, 0x00, 0x37, 0x00, 0x36, 0x00, 0x34, 0x00, 0x30, 0x00, 0x36, 0x00, 0x09, 0x00,
	0x32, 0x00, 0x36, 0x00, 0x31, 0x00, 0x38, 0x00, 0x35, 0x00, 0x37, 0x00, 0x32, 0x00, 0x38, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00, 0x31, 0x00, 0x30, 0x00, 0x31, 0x00,
	0x36, 0x00, 0x20, 0x00, 0x66, 0x00, 0x39, 0x00, 0x62, 0x00, 0x61, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x38, 0x00, 0x20, 0x00, 0x31, 0x00, 0x62, 0x00, 0x09, 0x00, 0x32, 0x00, 0x39, 0x00, 0x39, 0x00,
	0x37, 0x00, 0x44, 0x00, 0x44, 0x00, 0x36, 0x00, 0x31, 0x00, 0x39, 0x00, 0x30, 0x00, 0x38, 0x00,
	0x44, 0x00, 0x33, 0x00, 0x44, 0x00, 0x31, 0x00, 0x38, 0x00, 0x30, 0x00, 0x36, 0x00, 0x37, 0x00,
	0x38, 0x00, 0x44, 0x00, 0x33, 0x00, 0x31, 0x00, 0x41, 0x00, 0x44, 0x00, 0x35, 0x00, 0x45, 0x00,
	0x42, 0x00, 0x34, 0x00, 0x32, 0x00, 0x41, 0x00, 0x38, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x42, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x55, 0x00, 0x6e, 0x00, 0x61, 0x00,
	0x6c, 0x00, 0x6c, 0x00, 0x6f, 0x00, 0x63, 0x00, 0x61, 0x00, 0x74, 0x00, 0x65, 0x00, 0x64, 0x00,
	0x20, 0x00, 0x43, 0x00, 0x6c, 0x00, 0x75, 0x00, 0x73, 0x00, 0x74, 0x00, 0x65, 0x00, 0x72, 0x00,
	0x73, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x32, 0x00, 0x38, 0x00, 0x32, 0x00, 0x36, 0x00,
	0x32, 0x00, 0x34, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x66, 0x00, 0x39, 0x00,
	0x62, 0x00, 0x61, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x66, 0x00, 0x39, 0x00,
	0x62, 0x00, 0x61, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x34, 0x00, 0x35, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x32, 0x00, 0x38, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x34, 0x00, 0x33, 0x00, 0x20, 0x00, 0x32, 0x00, 0x20, 0x00, 0x34, 0x00, 0x35, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x20, 0x00, 0x32, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00, 0x32, 0x00, 0x38, 0x00,
	0x20, 0x00, 0x38, 0x00, 0x20, 0x00, 0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x20, 0x00, 0x66, 0x00, 0x39, 0x00, 0x62, 0x00, 0x39, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x20, 0x00, 0x34, 0x00, 0x20, 0x00, 0x66, 0x00, 0x39, 0x00, 0x62, 0x00, 0x39, 0x00, 0x20, 0x00,
	0x32, 0x00, 0x33, 0x00, 0x38, 0x00, 0x20, 0x00, 0x37, 0x00, 0x63, 0x00, 0x64, 0x00, 0x63, 0x00,
	0x38, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x36, 0x00, 0x32, 0x00, 0x39, 0x00,
	0x31, 0x00, 0x34, 0x00, 0x35, 0x00, 0x36, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x0a, 0x00, 0x0a, 0x00 };

#if defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT )

/* Tests the libewf_single_files_initialize function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_single_files_initialize(
     void )
{
	libcerror_error_t *error            = NULL;
	libewf_single_files_t *single_files = NULL;
	int result                          = 0;

#if defined( HAVE_EWF_TEST_MEMORY )
	int number_of_malloc_fail_tests     = 4;
	int number_of_memset_fail_tests     = 1;
	int test_number                     = 0;
#endif

	/* Test regular cases
	 */
	result = libewf_single_files_initialize(
	          &single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "single_files",
	 single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_single_files_free(
	          &single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "single_files",
	 single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_single_files_initialize(
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	single_files = (libewf_single_files_t *) 0x12345678UL;

	result = libewf_single_files_initialize(
	          &single_files,
	          &error );

	single_files = NULL;

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

#if defined( HAVE_EWF_TEST_MEMORY )

	for( test_number = 0;
	     test_number < number_of_malloc_fail_tests;
	     test_number++ )
	{
		/* Test libewf_single_files_initialize with malloc failing
		 */
		ewf_test_malloc_attempts_before_fail = test_number;

		result = libewf_single_files_initialize(
		          &single_files,
		          &error );

		if( ewf_test_malloc_attempts_before_fail != -1 )
		{
			ewf_test_malloc_attempts_before_fail = -1;

			if( single_files != NULL )
			{
				libewf_single_files_free(
				 &single_files,
				 NULL );
			}
		}
		else
		{
			EWF_TEST_ASSERT_EQUAL_INT(
			 "result",
			 result,
			 -1 );

			EWF_TEST_ASSERT_IS_NULL(
			 "single_files",
			 single_files );

			EWF_TEST_ASSERT_IS_NOT_NULL(
			 "error",
			 error );

			libcerror_error_free(
			 &error );
		}
	}
	for( test_number = 0;
	     test_number < number_of_memset_fail_tests;
	     test_number++ )
	{
		/* Test libewf_single_files_initialize with memset failing
		 */
		ewf_test_memset_attempts_before_fail = test_number;

		result = libewf_single_files_initialize(
		          &single_files,
		          &error );

		if( ewf_test_memset_attempts_before_fail != -1 )
		{
			ewf_test_memset_attempts_before_fail = -1;

			if( single_files != NULL )
			{
				libewf_single_files_free(
				 &single_files,
				 NULL );
			}
		}
		else
		{
			EWF_TEST_ASSERT_EQUAL_INT(
			 "result",
			 result,
			 -1 );

			EWF_TEST_ASSERT_IS_NULL(
			 "single_files",
			 single_files );

			EWF_TEST_ASSERT_IS_NOT_NULL(
			 "error",
			 error );

			libcerror_error_free(
			 &error );
		}
	}
#endif /* defined( HAVE_EWF_TEST_MEMORY ) */

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	if( single_files != NULL )
	{
		libewf_single_files_free(
		 &single_files,
		 NULL );
	}
	return( 0 );
}

/* Tests the libewf_single_files_free function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_single_files_free(
     void )
{
	libcerror_error_t *error = NULL;
	int result               = 0;

	/* Test error cases
	 */
	result = libewf_single_files_free(
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_single_files_clone function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_single_files_clone(
     void )
{
	libcerror_error_t *error                        = NULL;
	libewf_single_files_t *destination_single_files = NULL;
	libewf_single_files_t *source_single_files      = NULL;
	libfdata_stream_t *data_stream                  = NULL;
	size64_t media_size                             = 0;
	uint8_t format                                  = 0;
	int result                                      = 0;

#if defined( HAVE_EWF_TEST_MEMORY )
	int number_of_malloc_fail_tests                 = 6;
	int test_number                                 = 0;

#if defined( OPTIMIZATION_DISABLED )
	int number_of_memcpy_fail_tests                 = 1;
#endif
#endif /* defined( HAVE_EWF_TEST_MEMORY ) */

	/* Initialize test
	 */
	result = libewf_single_files_initialize(
	          &source_single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "source_single_files",
	 source_single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_data_stream_initialize_from_buffer(
	          &data_stream,
	          ewf_test_single_files_data1,
	          5700,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "data_stream",
	 data_stream );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_single_files_read_data_stream(
	          source_single_files,
	          data_stream,
	          NULL,
	          &media_size,
	          &format,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libfdata_stream_free(
	          &data_stream,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "data_stream",
	 data_stream );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	result = libewf_single_files_clone(
	          &destination_single_files,
	          source_single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "destination_single_files",
	 destination_single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_single_files_free(
	          &destination_single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "destination_single_files",
	 destination_single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_single_files_clone(
	          &destination_single_files,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "destination_single_files",
	 destination_single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_single_files_clone(
	          NULL,
	          source_single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	destination_single_files = (libewf_single_files_t *) 0x12345678UL;

	result = libewf_single_files_clone(
	          &destination_single_files,
	          source_single_files,
	          &error );

	destination_single_files = NULL;

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

#if defined( HAVE_EWF_TEST_MEMORY )

	for( test_number = 0;
	     test_number < number_of_malloc_fail_tests;
	     test_number++ )
	{
		/* Test libewf_single_files_clone with malloc failing
		 */
		ewf_test_malloc_attempts_before_fail = test_number;

		result = libewf_single_files_clone(
		          &destination_single_files,
		          source_single_files,
		          &error );

		if( ewf_test_malloc_attempts_before_fail != -1 )
		{
			ewf_test_malloc_attempts_before_fail = -1;

			if( destination_single_files != NULL )
			{
				libewf_single_files_free(
				 &destination_single_files,
				 NULL );
			}
		}
		else
		{
			EWF_TEST_ASSERT_EQUAL_INT(
			 "result",
			 result,
			 -1 );

			EWF_TEST_ASSERT_IS_NULL(
			 "destination_single_files",
			 destination_single_files );

			EWF_TEST_ASSERT_IS_NOT_NULL(
			 "error",
			 error );

			libcerror_error_free(
			 &error );
		}
	}
#if defined( OPTIMIZATION_DISABLED )

	for( test_number = 0;
	     test_number < number_of_memcpy_fail_tests;
	     test_number++ )
	{
		/* Test libewf_single_files_clone with memcpy failing
		 */
		ewf_test_memcpy_attempts_before_fail = test_number;

		result = libewf_single_files_clone(
		          &destination_single_files,
		          source_single_files,
		          &error );

		if( ewf_test_memcpy_attempts_before_fail != -1 )
		{
			ewf_test_memcpy_attempts_before_fail = -1;

			if( destination_single_files != NULL )
			{
				libewf_single_files_free(
				 &destination_single_files,
				 NULL );
			}
		}
		else
		{
			EWF_TEST_ASSERT_EQUAL_INT(
			 "result",
			 result,
			 -1 );

			EWF_TEST_ASSERT_IS_NULL(
			 "destination_single_files",
			 destination_single_files );

			EWF_TEST_ASSERT_IS_NOT_NULL(
			 "error",
			 error );

			libcerror_error_free(
			 &error );
		}
	}
#endif /* defined( OPTIMIZATION_DISABLED ) */
#endif /* defined( HAVE_EWF_TEST_MEMORY ) */

	/* Clean up
	 */
	result = libewf_single_files_free(
	          &source_single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "source_single_files",
	 source_single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	if( destination_single_files != NULL )
	{
		libewf_single_files_free(
		 &destination_single_files,
		 NULL );
	}
	if( data_stream != NULL )
	{
		libfdata_stream_free(
		 &data_stream,
		 NULL );
	}
	if( source_single_files != NULL )
	{
		libewf_single_files_free(
		 &source_single_files,
		 NULL );
	}
	return( 0 );
}

/* Tests the libewf_single_files_parse_category_number_of_entries function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_single_files_parse_category_number_of_entries(
     libewf_single_files_t *single_files,
     libewf_line_reader_t *line_reader )
{
	libcerror_error_t *error = NULL;
	uint8_t *line_string     = NULL;
	size_t line_string_size  = 0;
	int number_of_entries    = 0;
	int result               = 0;

	/* Initialize test
	 */
	line_reader->stream_offset = 0;
	line_reader->buffer_offset = 0;
	line_reader->line_index    = 0;

	result = libewf_line_reader_read_utf8_string(
	          line_reader,
	          &line_string,
	          &line_string_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "line_string",
	 line_string );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	line_reader->buffer_offset = 0x140;
	line_reader->line_index    = 6;

	result = libewf_single_files_parse_category_number_of_entries(
	          single_files,
	          line_reader,
	          &number_of_entries,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	line_reader->buffer_offset = 0x140;
	line_reader->line_index    = 6;

	result = libewf_single_files_parse_category_number_of_entries(
	          NULL,
	          line_reader,
	          &number_of_entries,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_category_number_of_entries(
	          single_files,
	          NULL,
	          &number_of_entries,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_category_number_of_entries(
	          single_files,
	          line_reader,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_single_files_parse_category_types function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_single_files_parse_category_types(
     libewf_single_files_t *single_files,
     libewf_line_reader_t *line_reader )
{
	libcerror_error_t *error             = NULL;
	libfvalue_split_utf8_string_t *types = NULL;
	uint8_t *line_string                 = NULL;
	size_t line_string_size              = 0;
	int result                           = 0;

	/* Initialize test
	 */
	line_reader->stream_offset = 0;
	line_reader->buffer_offset = 0;
	line_reader->line_index    = 0;

	result = libewf_line_reader_read_utf8_string(
	          line_reader,
	          &line_string,
	          &line_string_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "line_string",
	 line_string );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	line_reader->buffer_offset = 0x148;
	line_reader->line_index    = 7;

	result = libewf_single_files_parse_category_types(
	          single_files,
	          line_reader,
	          &types,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Clean up
	 */
	result = libfvalue_split_utf8_string_free(
	          &types,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "types",
	 types );

	/* Test error cases
	 */
	line_reader->buffer_offset = 0x148;
	line_reader->line_index    = 7;

	result = libewf_single_files_parse_category_types(
	          NULL,
	          line_reader,
	          &types,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_category_types(
	          single_files,
	          NULL,
	          &types,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_category_types(
	          single_files,
	          line_reader,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	if( types != NULL )
	{
		libfvalue_split_utf8_string_free(
		 &types,
		 NULL );
	}
	return( 0 );
}

/* Tests the libewf_single_files_parse_number_of_entries function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_single_files_parse_number_of_entries(
     libewf_single_files_t *single_files,
     libewf_line_reader_t *line_reader )
{
	libcerror_error_t *error = NULL;
	uint8_t *line_string     = NULL;
	size_t line_string_size  = 0;
	int number_of_entries    = 0;
	int result               = 0;

	/* Initialize test
	 */
	line_reader->stream_offset = 0;
	line_reader->buffer_offset = 0;
	line_reader->line_index    = 0;

	result = libewf_line_reader_read_utf8_string(
	          line_reader,
	          &line_string,
	          &line_string_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "line_string",
	 line_string );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	line_reader->buffer_offset = 0x16a;
	line_reader->line_index    = 8;

	result = libewf_single_files_parse_number_of_entries(
	          single_files,
	          line_reader,
	          &number_of_entries,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	line_reader->buffer_offset = 0x16a;
	line_reader->line_index    = 8;

	result = libewf_single_files_parse_number_of_entries(
	          NULL,
	          line_reader,
	          &number_of_entries,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_number_of_entries(
	          single_files,
	          NULL,
	          &number_of_entries,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_number_of_entries(
	          single_files,
	          line_reader,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_single_files_parse_format function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_single_files_parse_format(
     libewf_single_files_t *single_files,
     libewf_line_reader_t *line_reader )
{
	libcerror_error_t *error             = NULL;
	libfvalue_split_utf8_string_t *types = NULL;
	uint8_t *line_string                 = NULL;
	size_t line_string_size              = 0;
	uint8_t format                       = 0;
	int result                           = 0;

	/* Initialize test
	 */
	line_reader->stream_offset = 0;
	line_reader->buffer_offset = 0;
	line_reader->line_index    = 0;

	result = libewf_line_reader_read_utf8_string(
	          line_reader,
	          &line_string,
	          &line_string_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "line_string",
	 line_string );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	line_reader->buffer_offset = 0x148;
	line_reader->line_index    = 7;

	result = libewf_single_files_parse_category_types(
	          single_files,
	          line_reader,
	          &types,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	result = libewf_single_files_parse_format(
	          types,
	          &format,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_single_files_parse_format(
	          NULL,
	          &format,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_format(
	          types,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	/* Clean up
	 */
	result = libfvalue_split_utf8_string_free(
	          &types,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "types",
	 types );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	if( types != NULL )
	{
		libfvalue_split_utf8_string_free(
		 &types,
		 NULL );
	}
	return( 0 );
}

/* Tests the libewf_single_files_parse_rec_category function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_single_files_parse_rec_category(
     libewf_single_files_t *single_files,
     libewf_line_reader_t *line_reader )
{
	libcerror_error_t *error = NULL;
	uint8_t *line_string     = NULL;
	size64_t media_size      = 0;
	size_t line_string_size  = 0;
	int result               = 0;

	/* Initialize test
	 */
	line_reader->stream_offset = 0;
	line_reader->buffer_offset = 0;
	line_reader->line_index    = 0;

	result = libewf_line_reader_read_utf8_string(
	          line_reader,
	          &line_string,
	          &line_string_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "line_string",
	 line_string );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	line_reader->buffer_offset = 0x4;
	line_reader->line_index    = 1;

	result = libewf_single_files_parse_rec_category(
	          single_files,
	          line_reader,
	          &media_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	line_reader->buffer_offset = 0x4;
	line_reader->line_index    = 1;

	result = libewf_single_files_parse_rec_category(
	          NULL,
	          line_reader,
	          &media_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_rec_category(
	          single_files,
	          NULL,
	          &media_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_rec_category(
	          single_files,
	          line_reader,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	/* Test unsupported category header
	 */
	line_reader->buffer_offset = 0x136;
	line_reader->line_index    = 5;

	result = libewf_single_files_parse_rec_category(
	          single_files,
	          line_reader,
	          &media_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_single_files_parse_record_values function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_single_files_parse_record_values(
     libewf_single_files_t *single_files,
     libewf_line_reader_t *line_reader )
{
	libcerror_error_t *error = NULL;
	uint8_t *line_string     = NULL;
	size64_t media_size      = 0;
	size_t line_string_size  = 0;
	int result               = 0;

	/* Initialize test
	 */
	line_reader->stream_offset = 0;
	line_reader->buffer_offset = 0;
	line_reader->line_index    = 0;

	result = libewf_line_reader_read_utf8_string(
	          line_reader,
	          &line_string,
	          &line_string_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "line_string",
	 line_string );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	line_reader->buffer_offset = 0xc;
	line_reader->line_index    = 2;

	result = libewf_single_files_parse_record_values(
	          single_files,
	          line_reader,
	          &media_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	line_reader->buffer_offset = 0xc;
	line_reader->line_index    = 2;

	result = libewf_single_files_parse_record_values(
	          NULL,
	          line_reader,
	          &media_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_record_values(
	          single_files,
	          NULL,
	          &media_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_record_values(
	          single_files,
	          line_reader,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_single_files_parse_perm_category function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_single_files_parse_perm_category(
     libewf_single_files_t *single_files,
     libewf_line_reader_t *line_reader )
{
	libcerror_error_t *error = NULL;
	uint8_t *line_string     = NULL;
	size_t line_string_size  = 0;
	int result               = 0;

	/* Initialize test
	 */
	line_reader->stream_offset = 0;
	line_reader->buffer_offset = 0;
	line_reader->line_index    = 0;

	result = libewf_line_reader_read_utf8_string(
	          line_reader,
	          &line_string,
	          &line_string_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "line_string",
	 line_string );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	line_reader->buffer_offset = 0x136;
	line_reader->line_index    = 5;

	result = libewf_single_files_parse_perm_category(
	          single_files,
	          line_reader,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	line_reader->buffer_offset = 0x136;
	line_reader->line_index    = 5;

	result = libewf_single_files_parse_perm_category(
	          NULL,
	          line_reader,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_perm_category(
	          single_files,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_single_files_parse_permission_group function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_single_files_parse_permission_group(
     libewf_single_files_t *single_files,
     libewf_line_reader_t *line_reader )
{
	libcerror_error_t *error                    = NULL;
	libewf_permission_group_t *permission_group = NULL;
	libfvalue_split_utf8_string_t *types        = NULL;
	uint8_t *line_string                        = NULL;
	size_t line_string_size                     = 0;
	int result                                  = 0;

	/* Initialize test
	 */
	line_reader->stream_offset = 0;
	line_reader->buffer_offset = 0;
	line_reader->line_index    = 0;

	result = libewf_line_reader_read_utf8_string(
	          line_reader,
	          &line_string,
	          &line_string_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "line_string",
	 line_string );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
/* TODO implement */

	/* Test error cases
	 */
	line_reader->buffer_offset = 0x148;
	line_reader->line_index    = 7;

	result = libewf_single_files_parse_permission_group(
	          single_files,
	          line_reader,
	          types,
	          permission_group,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_permission_group(
	          NULL,
	          line_reader,
	          types,
	          permission_group,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_permission_group(
	          single_files,
	          NULL,
	          types,
	          permission_group,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_permission_group(
	          single_files,
	          line_reader,
	          NULL,
	          permission_group,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_permission_group(
	          single_files,
	          line_reader,
	          types,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_single_files_parse_srce_category function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_single_files_parse_srce_category(
     libewf_single_files_t *single_files,
     libewf_line_reader_t *line_reader )
{
	libcerror_error_t *error = NULL;
	uint8_t *line_string     = NULL;
	size_t line_string_size  = 0;
	int result               = 0;

	/* Initialize test
	 */
	line_reader->stream_offset = 0;
	line_reader->buffer_offset = 0;
	line_reader->line_index    = 0;

	result = libewf_line_reader_read_utf8_string(
	          line_reader,
	          &line_string,
	          &line_string_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "line_string",
	 line_string );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	line_reader->buffer_offset = 0x1a0;
	line_reader->line_index    = 13;

	result = libewf_single_files_parse_srce_category(
	          single_files,
	          line_reader,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	line_reader->buffer_offset = 0x1a0;
	line_reader->line_index    = 13;

	result = libewf_single_files_parse_srce_category(
	          NULL,
	          line_reader,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_srce_category(
	          single_files,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_single_files_parse_sub_category function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_single_files_parse_sub_category(
     libewf_single_files_t *single_files,
     libewf_line_reader_t *line_reader )
{
	libcerror_error_t *error = NULL;
	uint8_t *line_string     = NULL;
	size_t line_string_size  = 0;
	int result               = 0;

	/* Initialize test
	 */
	line_reader->stream_offset = 0;
	line_reader->buffer_offset = 0;
	line_reader->line_index    = 0;

	result = libewf_line_reader_read_utf8_string(
	          line_reader,
	          &line_string,
	          &line_string_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "line_string",
	 line_string );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	line_reader->buffer_offset = 0x52e;
	line_reader->line_index    = 21;

	result = libewf_single_files_parse_sub_category(
	          single_files,
	          line_reader,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	line_reader->buffer_offset = 0x52e;
	line_reader->line_index    = 21;

	result = libewf_single_files_parse_sub_category(
	          NULL,
	          line_reader,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_sub_category(
	          single_files,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_single_files_parse_entry_category function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_single_files_parse_entry_category(
     libewf_single_files_t *single_files,
     libewf_line_reader_t *line_reader )
{
	libcerror_error_t *error = NULL;
	uint8_t *line_string     = NULL;
	size_t line_string_size  = 0;
	uint8_t format           = 0;
	int result               = 0;

	/* Initialize test
	 */
	line_reader->stream_offset = 0;
	line_reader->buffer_offset = 0;
	line_reader->line_index    = 0;

	result = libewf_line_reader_read_utf8_string(
	          line_reader,
	          &line_string,
	          &line_string_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "line_string",
	 line_string );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	line_reader->buffer_offset = 0x5b8;
	line_reader->line_index    = 27;

	result = libewf_single_files_parse_entry_category(
	          single_files,
	          line_reader,
	          &format,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	line_reader->buffer_offset = 0x5b8;
	line_reader->line_index    = 27;

	result = libewf_single_files_parse_entry_category(
	          NULL,
	          line_reader,
	          &format,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_entry_category(
	          single_files,
	          NULL,
	          &format,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_entry_category(
	          single_files,
	          line_reader,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_single_files_parse_file_entry_number_of_sub_entries function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_single_files_parse_file_entry_number_of_sub_entries(
     libewf_single_files_t *single_files,
     libewf_line_reader_t *line_reader )
{
	libcerror_error_t *error  = NULL;
	uint8_t *line_string      = NULL;
	size_t line_string_size   = 0;
	int number_of_sub_entries = 0;
	int result                = 0;

	/* Initialize test
	 */
	line_reader->stream_offset = 0;
	line_reader->buffer_offset = 0;
	line_reader->line_index    = 0;

	result = libewf_line_reader_read_utf8_string(
	          line_reader,
	          &line_string,
	          &line_string_size,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "line_string",
	 line_string );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	line_reader->buffer_offset = 0xcb8;
	line_reader->line_index    = 36;

	result = libewf_single_files_parse_file_entry_number_of_sub_entries(
	          single_files,
	          line_reader,
	          &number_of_sub_entries,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	line_reader->buffer_offset = 0xcb8;
	line_reader->line_index    = 36;

	result = libewf_single_files_parse_file_entry_number_of_sub_entries(
	          NULL,
	          line_reader,
	          &number_of_sub_entries,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_file_entry_number_of_sub_entries(
	          single_files,
	          NULL,
	          &number_of_sub_entries,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_parse_file_entry_number_of_sub_entries(
	          single_files,
	          line_reader,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libewf_single_files_read_data_stream function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_single_files_read_data_stream(
     void )
{
	libcerror_error_t *error            = NULL;
	libewf_single_files_t *single_files = NULL;
	libfdata_stream_t *data_stream      = NULL;
	size64_t media_size                 = 0;
	uint8_t format                      = 0;
	int result                          = 0;

	/* Initialize test
	 */
	result = libewf_single_files_initialize(
	          &single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "single_files",
	 single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_data_stream_initialize_from_buffer(
	          &data_stream,
	          ewf_test_single_files_data1,
	          5700,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "data_stream",
	 data_stream );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	result = libewf_single_files_read_data_stream(
	          single_files,
	          data_stream,
	          NULL,
	          &media_size,
	          &format,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_single_files_read_data_stream(
	          NULL,
	          data_stream,
	          NULL,
	          &media_size,
	          &format,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_read_data_stream(
	          single_files,
	          NULL,
	          NULL,
	          &media_size,
	          &format,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_read_data_stream(
	          single_files,
	          data_stream,
	          NULL,
	          NULL,
	          &format,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_read_data_stream(
	          single_files,
	          data_stream,
	          NULL,
	          &media_size,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	/* Clean up
	 */
	result = libfdata_stream_free(
	          &data_stream,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "data_stream",
	 data_stream );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_single_files_free(
	          &single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "single_files",
	 single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	if( data_stream != NULL )
	{
		libfdata_stream_free(
		 &data_stream,
		 NULL );
	}
	if( single_files != NULL )
	{
		libewf_single_files_free(
		 &single_files,
		 NULL );
	}
	return( 0 );
}

/* Tests the libewf_single_files_get_file_entry_tree_root_node function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_single_files_get_file_entry_tree_root_node(
     libewf_single_files_t *single_files )
{
	libcdata_tree_node_t *root_node = NULL;
	libcerror_error_t *error        = NULL;
	int result                      = 0;

	/* Test regular cases
	 */
	result = libewf_single_files_get_file_entry_tree_root_node(
	          single_files,
	          &root_node,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "root_node",
	 root_node );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_single_files_get_file_entry_tree_root_node(
	          NULL,
	          &root_node,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_files_get_file_entry_tree_root_node(
	          single_files,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

#endif /* defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT ) */

/* The main program
 */
#if defined( HAVE_WIDE_SYSTEM_CHARACTER )
int wmain(
     int argc EWF_TEST_ATTRIBUTE_UNUSED,
     wchar_t * const argv[] EWF_TEST_ATTRIBUTE_UNUSED )
#else
int main(
     int argc EWF_TEST_ATTRIBUTE_UNUSED,
     char * const argv[] EWF_TEST_ATTRIBUTE_UNUSED )
#endif
{
#if defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT )

	libcerror_error_t *error            = NULL;
	libewf_line_reader_t *line_reader   = NULL;
	libewf_single_files_t *single_files = NULL;
	libfdata_stream_t *data_stream      = NULL;
	size64_t media_size                 = 0;
	uint8_t format                      = 0;
	int result                          = 0;

#endif /* defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT ) */

	EWF_TEST_UNREFERENCED_PARAMETER( argc )
	EWF_TEST_UNREFERENCED_PARAMETER( argv )

#if defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT )

	EWF_TEST_RUN(
	 "libewf_single_files_initialize",
	 ewf_test_single_files_initialize );

	EWF_TEST_RUN(
	 "libewf_single_files_free",
	 ewf_test_single_files_free );

	EWF_TEST_RUN(
	 "libewf_single_files_clone",
	 ewf_test_single_files_clone );

#if !defined( __BORLANDC__ ) || ( __BORLANDC__ >= 0x0560 )

	/* Initialize single_files for tests
	 */
	result = libewf_single_files_initialize(
	          &single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "single_files",
	 single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_data_stream_initialize_from_buffer(
	          &data_stream,
	          ewf_test_single_files_data1,
	          5700,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "data_stream",
	 data_stream );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_line_reader_initialize(
	          &line_reader,
	          data_stream,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "line_reader",
	 line_reader );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Run tests
	 */
	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_single_files_parse_category_number_of_entries",
	 ewf_test_single_files_parse_category_number_of_entries,
	 single_files,
	 line_reader );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_single_files_parse_category_types",
	 ewf_test_single_files_parse_category_types,
	 single_files,
	 line_reader );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_single_files_parse_number_of_entries",
	 ewf_test_single_files_parse_number_of_entries,
	 single_files,
	 line_reader );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_single_files_parse_format",
	 ewf_test_single_files_parse_format,
	 single_files,
	 line_reader );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_single_files_parse_rec_category",
	 ewf_test_single_files_parse_rec_category,
	 single_files,
	 line_reader );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_single_files_parse_record_values",
	 ewf_test_single_files_parse_record_values,
	 single_files,
	 line_reader );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_single_files_parse_perm_category",
	 ewf_test_single_files_parse_perm_category,
	 single_files,
	 line_reader );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_single_files_parse_permission_group",
	 ewf_test_single_files_parse_permission_group,
	 single_files,
	 line_reader );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_single_files_parse_srce_category",
	 ewf_test_single_files_parse_srce_category,
	 single_files,
	 line_reader );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_single_files_parse_sub_category",
	 ewf_test_single_files_parse_sub_category,
	 single_files,
	 line_reader );

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_single_files_parse_entry_category",
	 ewf_test_single_files_parse_entry_category,
	 single_files,
	 line_reader );

	/* TODO: add tests for libewf_single_files_parse_file_entry */

	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_single_files_parse_file_entry_number_of_sub_entries",
	 ewf_test_single_files_parse_file_entry_number_of_sub_entries,
	 single_files,
	 line_reader );

	/* Clean up
	 */
	result = libewf_line_reader_free(
	          &line_reader,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "line_reader",
	 line_reader );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libfdata_stream_free(
	          &data_stream,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "data_stream",
	 data_stream );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_single_files_free(
	          &single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "single_files",
	 single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

#endif /* !defined( __BORLANDC__ ) || ( __BORLANDC__ >= 0x0560 ) */

	EWF_TEST_RUN(
	 "libewf_single_files_read_data_stream",
	 ewf_test_single_files_read_data_stream );

#if !defined( __BORLANDC__ ) || ( __BORLANDC__ >= 0x0560 )

	/* Initialize single_files for tests
	 */
	result = libewf_single_files_initialize(
	          &single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "single_files",
	 single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_data_stream_initialize_from_buffer(
	          &data_stream,
	          ewf_test_single_files_data1,
	          5700,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "data_stream",
	 data_stream );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_single_files_read_data_stream(
	          single_files,
	          data_stream,
	          NULL,
	          &media_size,
	          &format,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Run tests
	 */
	EWF_TEST_RUN_WITH_ARGS(
	 "libewf_single_files_get_file_entry_tree_root_node",
	 ewf_test_single_files_get_file_entry_tree_root_node,
	 single_files );

	/* TODO: add tests for libewf_single_files_get_source_by_index */

	/* Clean up
	 */
	result = libfdata_stream_free(
	          &data_stream,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "data_stream",
	 data_stream );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_single_files_free(
	          &single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "single_files",
	 single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

#endif /* !defined( __BORLANDC__ ) || ( __BORLANDC__ >= 0x0560 ) */
#endif /* defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT ) */

	return( EXIT_SUCCESS );

#if defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT )
on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	if( data_stream != NULL )
	{
		libfdata_stream_free(
		 &data_stream,
		 NULL );
	}
	if( single_files != NULL )
	{
		libewf_single_files_free(
		 &single_files,
		 NULL );
	}
	return( EXIT_FAILURE );

#endif /* defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT ) */
}

