Name: libexe
Version: 20181128
Release: 1
Summary: Library to access the executable (EXE) format
Group: System Environment/Libraries
License: LGPL
Source: %{name}-%{version}.tar.gz
URL: https://github.com/libyal/libexe
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
             
BuildRequires: gcc             

%description -n libexe
Library to access the executable (EXE) format

%package -n libexe-devel
Summary: Header files and libraries for developing applications for libexe
Group: Development/Libraries
Requires: libexe = %{version}-%{release}

%description -n libexe-devel
Header files and libraries for developing applications for libexe.

%package -n libexe-python2
Obsoletes: libexe-python < %{version}
Provides: libexe-python = %{version}
Summary: Python 2 bindings for libexe
Group: System Environment/Libraries
Requires: libexe = %{version}-%{release} python2
BuildRequires: python2-devel

%description -n libexe-python2
Python 2 bindings for libexe

%package -n libexe-python3
Summary: Python 3 bindings for libexe
Group: System Environment/Libraries
Requires: libexe = %{version}-%{release} python3
BuildRequires: python3-devel

%description -n libexe-python3
Python 3 bindings for libexe

%package -n libexe-tools
Summary: Several tools for reading executable (EXE) files
Group: Applications/System
Requires: libexe = %{version}-%{release}

%description -n libexe-tools
Several tools for reading executable (EXE) files

%prep
%setup -q

%build
%configure --prefix=/usr --libdir=%{_libdir} --mandir=%{_mandir} --enable-python2 --enable-python3
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
%make_install

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files -n libexe
%defattr(644,root,root,755)
%license COPYING
%doc AUTHORS README
%attr(755,root,root) %{_libdir}/*.so.*

%files -n libexe-devel
%defattr(644,root,root,755)
%license COPYING
%doc AUTHORS README ChangeLog
%{_libdir}/*.a
%{_libdir}/*.la
%{_libdir}/*.so
%{_libdir}/pkgconfig/libexe.pc
%{_includedir}/*
%{_mandir}/man3/*

%files -n libexe-python2
%defattr(644,root,root,755)
%license COPYING
%doc AUTHORS README
%{_libdir}/python2*/site-packages/*.a
%{_libdir}/python2*/site-packages/*.la
%{_libdir}/python2*/site-packages/*.so

%files -n libexe-python3
%defattr(644,root,root,755)
%license COPYING
%doc AUTHORS README
%{_libdir}/python3*/site-packages/*.a
%{_libdir}/python3*/site-packages/*.la
%{_libdir}/python3*/site-packages/*.so

%files -n libexe-tools
%defattr(644,root,root,755)
%license COPYING
%doc AUTHORS README
%attr(755,root,root) %{_bindir}/*
%{_mandir}/man1/*

%changelog
* Wed Nov 28 2018 Joachim Metz <joachim.metz@gmail.com> 20181128-1
- Auto-generated

