/*
 * Definitions for libfcrypto
 *
 * Copyright (C) 2017-2022, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBFCRYPTO_DEFINITIONS_H )
#define _LIBFCRYPTO_DEFINITIONS_H

#include <libfcrypto/types.h>

#define LIBFCRYPTO_VERSION			20221230

/* The version string
 */
#define LIBFCRYPTO_VERSION_STRING		"20221230"

/* The crypt modes
 */
enum LIBFCRYPTO_CRYPT_MODES
{
	LIBFCRYPTO_CRYPT_MODE_DECRYPT		= 0,
	LIBFCRYPTO_CRYPT_MODE_ENCRYPT		= 1
};

/* The DES3 crypt modes
 */
enum LIBFCRYPTO_DES3_CRYPT_MODES
{
	LIBFCRYPTO_DES3_CRYPT_MODE_DECRYPT	= 0,
	LIBFCRYPTO_DES3_CRYPT_MODE_ENCRYPT	= 1
};

/* The RC4 crypt modes
 */
enum LIBFCRYPTO_RC4_CRYPT_MODES
{
	LIBFCRYPTO_RC4_CRYPT_MODE_DECRYPT	= 0,
	LIBFCRYPTO_RC4_CRYPT_MODE_ENCRYPT	= 1
};

/* The Serpent crypt modes
 */
enum LIBFCRYPTO_SERPENT_CRYPT_MODES
{
	LIBFCRYPTO_SERPENT_CRYPT_MODE_DECRYPT	= 0,
	LIBFCRYPTO_SERPENT_CRYPT_MODE_ENCRYPT	= 1
};

#endif /* !defined( _LIBFCRYPTO_DEFINITIONS_H ) */

