/*
 * The APFS object definition
 *
 * Copyright (C) 2018-2019, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _FSAPFS_OBJECT_H )
#define _FSAPFS_OBJECT_H

#include <common.h>
#include <types.h>

#if defined( __cplusplus )
extern "C" {
#endif

typedef struct fsapfs_object fsapfs_object_t;

struct fsapfs_object
{
	/* The checksum
	 * Consists of 8 bytes
	 */
	uint8_t checksum[ 8 ];

	/* The identifier
	 * Consists of 8 bytes
	 */
	uint8_t identifier[ 8 ];

	/* The transaction identifier
	 * Consists of 8 bytes
	 */
	uint8_t transaction_identifier[ 8 ];

	/* The type
	 * Consists of 4 bytes
	 */
	uint8_t type[ 4 ];

	/* The subtype
	 * Consists of 4 bytes
	 */
	uint8_t subtype[ 4 ];
};

#if defined( __cplusplus )
}
#endif

#endif /* !defined( _FSAPFS_OBJECT_H ) */

