Name: libfsapfs
Version: 20240218
Release: 1
Summary: Library to access the Apple File System (APFS) format
Group: System Environment/Libraries
License: LGPL-3.0-or-later
Source: %{name}-%{version}.tar.gz
URL: https://github.com/libyal/libfsapfs
Requires:         openssl          zlib
BuildRequires: gcc         openssl-devel          zlib-devel

%description -n libfsapfs
Library to access the Apple File System (APFS) format

%package -n libfsapfs-static
Summary: Library to access the Apple File System (APFS) format
Group: Development/Libraries
Requires: libfsapfs = %{version}-%{release}

%description -n libfsapfs-static
Static library version of libfsapfs.

%package -n libfsapfs-devel
Summary: Header files and libraries for developing applications for libfsapfs
Group: Development/Libraries
Requires: libfsapfs = %{version}-%{release}

%description -n libfsapfs-devel
Header files and libraries for developing applications for libfsapfs.

%package -n libfsapfs-python3
Summary: Python 3 bindings for libfsapfs
Group: System Environment/Libraries
Requires: libfsapfs = %{version}-%{release} python3
BuildRequires: python3-devel python3-setuptools

%description -n libfsapfs-python3
Python 3 bindings for libfsapfs

%package -n libfsapfs-tools
Summary: Several tools for reading Apple File System (APFS) volumes
Group: Applications/System
Requires: libfsapfs = %{version}-%{release} openssl fuse-libs
BuildRequires: openssl-devel fuse-devel

%description -n libfsapfs-tools
Several tools for reading Apple File System (APFS) volumes

%prep
%setup -q

%build
%configure --prefix=/usr --libdir=%{_libdir} --mandir=%{_mandir} --enable-python
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
%make_install

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files -n libfsapfs
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/*.so.*

%files -n libfsapfs-static
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/*.a

%files -n libfsapfs-devel
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/*.so
%{_libdir}/pkgconfig/libfsapfs.pc
%{_includedir}/*
%{_mandir}/man3/*

%files -n libfsapfs-python3
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/python3*/site-packages/*.a
%{_libdir}/python3*/site-packages/*.so

%files -n libfsapfs-tools
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_bindir}/*
%{_mandir}/man1/*

%changelog
* Sun Feb 18 2024 Joachim Metz <joachim.metz@gmail.com> 20240218-1
- Auto-generated

