/*
 * Name functions
 *
 * Copyright (C) 2009-2021, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <common.h>
#include <types.h>

#if defined( HAVE_WCTYPE_H )
#include <wctype.h>
#endif

#include "libfshfs_libcerror.h"
#include "libfshfs_libuna.h"
#include "libfshfs_name.h"

uint32_t libfshfs_name_case_folding_mappings_0x00000040[ 528 ] = {
	/* 0x00000040 */ 0x00000040,
	/* 0x00000041 */ 0x00000061,
	/* 0x00000042 */ 0x00000062,
	/* 0x00000043 */ 0x00000063,
	/* 0x00000044 */ 0x00000064,
	/* 0x00000045 */ 0x00000065,
	/* 0x00000046 */ 0x00000066,
	/* 0x00000047 */ 0x00000067,
	/* 0x00000048 */ 0x00000068,
	/* 0x00000049 */ 0x00000069,
	/* 0x0000004a */ 0x0000006a,
	/* 0x0000004b */ 0x0000006b,
	/* 0x0000004c */ 0x0000006c,
	/* 0x0000004d */ 0x0000006d,
	/* 0x0000004e */ 0x0000006e,
	/* 0x0000004f */ 0x0000006f,
	/* 0x00000050 */ 0x00000070,
	/* 0x00000051 */ 0x00000071,
	/* 0x00000052 */ 0x00000072,
	/* 0x00000053 */ 0x00000073,
	/* 0x00000054 */ 0x00000074,
	/* 0x00000055 */ 0x00000075,
	/* 0x00000056 */ 0x00000076,
	/* 0x00000057 */ 0x00000077,
	/* 0x00000058 */ 0x00000078,
	/* 0x00000059 */ 0x00000079,
	/* 0x0000005a */ 0x0000007a,
	/* 0x0000005b */ 0x0000005b,
	/* 0x0000005c */ 0x0000005c,
	/* 0x0000005d */ 0x0000005d,
	/* 0x0000005e */ 0x0000005e,
	/* 0x0000005f */ 0x0000005f,
	/* 0x00000060 */ 0x00000060,
	/* 0x00000061 */ 0x00000061,
	/* 0x00000062 */ 0x00000062,
	/* 0x00000063 */ 0x00000063,
	/* 0x00000064 */ 0x00000064,
	/* 0x00000065 */ 0x00000065,
	/* 0x00000066 */ 0x00000066,
	/* 0x00000067 */ 0x00000067,
	/* 0x00000068 */ 0x00000068,
	/* 0x00000069 */ 0x00000069,
	/* 0x0000006a */ 0x0000006a,
	/* 0x0000006b */ 0x0000006b,
	/* 0x0000006c */ 0x0000006c,
	/* 0x0000006d */ 0x0000006d,
	/* 0x0000006e */ 0x0000006e,
	/* 0x0000006f */ 0x0000006f,
	/* 0x00000070 */ 0x00000070,
	/* 0x00000071 */ 0x00000071,
	/* 0x00000072 */ 0x00000072,
	/* 0x00000073 */ 0x00000073,
	/* 0x00000074 */ 0x00000074,
	/* 0x00000075 */ 0x00000075,
	/* 0x00000076 */ 0x00000076,
	/* 0x00000077 */ 0x00000077,
	/* 0x00000078 */ 0x00000078,
	/* 0x00000079 */ 0x00000079,
	/* 0x0000007a */ 0x0000007a,
	/* 0x0000007b */ 0x0000007b,
	/* 0x0000007c */ 0x0000007c,
	/* 0x0000007d */ 0x0000007d,
	/* 0x0000007e */ 0x0000007e,
	/* 0x0000007f */ 0x0000007f,
	/* 0x00000080 */ 0x00000080,
	/* 0x00000081 */ 0x00000081,
	/* 0x00000082 */ 0x00000082,
	/* 0x00000083 */ 0x00000083,
	/* 0x00000084 */ 0x00000084,
	/* 0x00000085 */ 0x00000085,
	/* 0x00000086 */ 0x00000086,
	/* 0x00000087 */ 0x00000087,
	/* 0x00000088 */ 0x00000088,
	/* 0x00000089 */ 0x00000089,
	/* 0x0000008a */ 0x0000008a,
	/* 0x0000008b */ 0x0000008b,
	/* 0x0000008c */ 0x0000008c,
	/* 0x0000008d */ 0x0000008d,
	/* 0x0000008e */ 0x0000008e,
	/* 0x0000008f */ 0x0000008f,
	/* 0x00000090 */ 0x00000090,
	/* 0x00000091 */ 0x00000091,
	/* 0x00000092 */ 0x00000092,
	/* 0x00000093 */ 0x00000093,
	/* 0x00000094 */ 0x00000094,
	/* 0x00000095 */ 0x00000095,
	/* 0x00000096 */ 0x00000096,
	/* 0x00000097 */ 0x00000097,
	/* 0x00000098 */ 0x00000098,
	/* 0x00000099 */ 0x00000099,
	/* 0x0000009a */ 0x0000009a,
	/* 0x0000009b */ 0x0000009b,
	/* 0x0000009c */ 0x0000009c,
	/* 0x0000009d */ 0x0000009d,
	/* 0x0000009e */ 0x0000009e,
	/* 0x0000009f */ 0x0000009f,
	/* 0x000000a0 */ 0x000000a0,
	/* 0x000000a1 */ 0x000000a1,
	/* 0x000000a2 */ 0x000000a2,
	/* 0x000000a3 */ 0x000000a3,
	/* 0x000000a4 */ 0x000000a4,
	/* 0x000000a5 */ 0x000000a5,
	/* 0x000000a6 */ 0x000000a6,
	/* 0x000000a7 */ 0x000000a7,
	/* 0x000000a8 */ 0x000000a8,
	/* 0x000000a9 */ 0x000000a9,
	/* 0x000000aa */ 0x000000aa,
	/* 0x000000ab */ 0x000000ab,
	/* 0x000000ac */ 0x000000ac,
	/* 0x000000ad */ 0x000000ad,
	/* 0x000000ae */ 0x000000ae,
	/* 0x000000af */ 0x000000af,
	/* 0x000000b0 */ 0x000000b0,
	/* 0x000000b1 */ 0x000000b1,
	/* 0x000000b2 */ 0x000000b2,
	/* 0x000000b3 */ 0x000000b3,
	/* 0x000000b4 */ 0x000000b4,
	/* 0x000000b5 */ 0x000003bc,
	/* 0x000000b6 */ 0x000000b6,
	/* 0x000000b7 */ 0x000000b7,
	/* 0x000000b8 */ 0x000000b8,
	/* 0x000000b9 */ 0x000000b9,
	/* 0x000000ba */ 0x000000ba,
	/* 0x000000bb */ 0x000000bb,
	/* 0x000000bc */ 0x000000bc,
	/* 0x000000bd */ 0x000000bd,
	/* 0x000000be */ 0x000000be,
	/* 0x000000bf */ 0x000000bf,
	/* 0x000000c0 */ 0x000000e0,
	/* 0x000000c1 */ 0x000000e1,
	/* 0x000000c2 */ 0x000000e2,
	/* 0x000000c3 */ 0x000000e3,
	/* 0x000000c4 */ 0x000000e4,
	/* 0x000000c5 */ 0x000000e5,
	/* 0x000000c6 */ 0x000000e6,
	/* 0x000000c7 */ 0x000000e7,
	/* 0x000000c8 */ 0x000000e8,
	/* 0x000000c9 */ 0x000000e9,
	/* 0x000000ca */ 0x000000ea,
	/* 0x000000cb */ 0x000000eb,
	/* 0x000000cc */ 0x000000ec,
	/* 0x000000cd */ 0x000000ed,
	/* 0x000000ce */ 0x000000ee,
	/* 0x000000cf */ 0x000000ef,
	/* 0x000000d0 */ 0x000000f0,
	/* 0x000000d1 */ 0x000000f1,
	/* 0x000000d2 */ 0x000000f2,
	/* 0x000000d3 */ 0x000000f3,
	/* 0x000000d4 */ 0x000000f4,
	/* 0x000000d5 */ 0x000000f5,
	/* 0x000000d6 */ 0x000000f6,
	/* 0x000000d7 */ 0x000000d7,
	/* 0x000000d8 */ 0x000000f8,
	/* 0x000000d9 */ 0x000000f9,
	/* 0x000000da */ 0x000000fa,
	/* 0x000000db */ 0x000000fb,
	/* 0x000000dc */ 0x000000fc,
	/* 0x000000dd */ 0x000000fd,
	/* 0x000000de */ 0x000000fe,
	/* 0x000000df */ 0x000000df,
	/* 0x000000e0 */ 0x000000e0,
	/* 0x000000e1 */ 0x000000e1,
	/* 0x000000e2 */ 0x000000e2,
	/* 0x000000e3 */ 0x000000e3,
	/* 0x000000e4 */ 0x000000e4,
	/* 0x000000e5 */ 0x000000e5,
	/* 0x000000e6 */ 0x000000e6,
	/* 0x000000e7 */ 0x000000e7,
	/* 0x000000e8 */ 0x000000e8,
	/* 0x000000e9 */ 0x000000e9,
	/* 0x000000ea */ 0x000000ea,
	/* 0x000000eb */ 0x000000eb,
	/* 0x000000ec */ 0x000000ec,
	/* 0x000000ed */ 0x000000ed,
	/* 0x000000ee */ 0x000000ee,
	/* 0x000000ef */ 0x000000ef,
	/* 0x000000f0 */ 0x000000f0,
	/* 0x000000f1 */ 0x000000f1,
	/* 0x000000f2 */ 0x000000f2,
	/* 0x000000f3 */ 0x000000f3,
	/* 0x000000f4 */ 0x000000f4,
	/* 0x000000f5 */ 0x000000f5,
	/* 0x000000f6 */ 0x000000f6,
	/* 0x000000f7 */ 0x000000f7,
	/* 0x000000f8 */ 0x000000f8,
	/* 0x000000f9 */ 0x000000f9,
	/* 0x000000fa */ 0x000000fa,
	/* 0x000000fb */ 0x000000fb,
	/* 0x000000fc */ 0x000000fc,
	/* 0x000000fd */ 0x000000fd,
	/* 0x000000fe */ 0x000000fe,
	/* 0x000000ff */ 0x000000ff,
	/* 0x00000100 */ 0x00000101,
	/* 0x00000101 */ 0x00000101,
	/* 0x00000102 */ 0x00000103,
	/* 0x00000103 */ 0x00000103,
	/* 0x00000104 */ 0x00000105,
	/* 0x00000105 */ 0x00000105,
	/* 0x00000106 */ 0x00000107,
	/* 0x00000107 */ 0x00000107,
	/* 0x00000108 */ 0x00000109,
	/* 0x00000109 */ 0x00000109,
	/* 0x0000010a */ 0x0000010b,
	/* 0x0000010b */ 0x0000010b,
	/* 0x0000010c */ 0x0000010d,
	/* 0x0000010d */ 0x0000010d,
	/* 0x0000010e */ 0x0000010f,
	/* 0x0000010f */ 0x0000010f,
	/* 0x00000110 */ 0x00000111,
	/* 0x00000111 */ 0x00000111,
	/* 0x00000112 */ 0x00000113,
	/* 0x00000113 */ 0x00000113,
	/* 0x00000114 */ 0x00000115,
	/* 0x00000115 */ 0x00000115,
	/* 0x00000116 */ 0x00000117,
	/* 0x00000117 */ 0x00000117,
	/* 0x00000118 */ 0x00000119,
	/* 0x00000119 */ 0x00000119,
	/* 0x0000011a */ 0x0000011b,
	/* 0x0000011b */ 0x0000011b,
	/* 0x0000011c */ 0x0000011d,
	/* 0x0000011d */ 0x0000011d,
	/* 0x0000011e */ 0x0000011f,
	/* 0x0000011f */ 0x0000011f,
	/* 0x00000120 */ 0x00000121,
	/* 0x00000121 */ 0x00000121,
	/* 0x00000122 */ 0x00000123,
	/* 0x00000123 */ 0x00000123,
	/* 0x00000124 */ 0x00000125,
	/* 0x00000125 */ 0x00000125,
	/* 0x00000126 */ 0x00000127,
	/* 0x00000127 */ 0x00000127,
	/* 0x00000128 */ 0x00000129,
	/* 0x00000129 */ 0x00000129,
	/* 0x0000012a */ 0x0000012b,
	/* 0x0000012b */ 0x0000012b,
	/* 0x0000012c */ 0x0000012d,
	/* 0x0000012d */ 0x0000012d,
	/* 0x0000012e */ 0x0000012f,
	/* 0x0000012f */ 0x0000012f,
	/* 0x00000130 */ 0x00000130,
	/* 0x00000131 */ 0x00000131,
	/* 0x00000132 */ 0x00000133,
	/* 0x00000133 */ 0x00000133,
	/* 0x00000134 */ 0x00000135,
	/* 0x00000135 */ 0x00000135,
	/* 0x00000136 */ 0x00000137,
	/* 0x00000137 */ 0x00000137,
	/* 0x00000138 */ 0x00000138,
	/* 0x00000139 */ 0x0000013a,
	/* 0x0000013a */ 0x0000013a,
	/* 0x0000013b */ 0x0000013c,
	/* 0x0000013c */ 0x0000013c,
	/* 0x0000013d */ 0x0000013e,
	/* 0x0000013e */ 0x0000013e,
	/* 0x0000013f */ 0x00000140,
	/* 0x00000140 */ 0x00000140,
	/* 0x00000141 */ 0x00000142,
	/* 0x00000142 */ 0x00000142,
	/* 0x00000143 */ 0x00000144,
	/* 0x00000144 */ 0x00000144,
	/* 0x00000145 */ 0x00000146,
	/* 0x00000146 */ 0x00000146,
	/* 0x00000147 */ 0x00000148,
	/* 0x00000148 */ 0x00000148,
	/* 0x00000149 */ 0x00000149,
	/* 0x0000014a */ 0x0000014b,
	/* 0x0000014b */ 0x0000014b,
	/* 0x0000014c */ 0x0000014d,
	/* 0x0000014d */ 0x0000014d,
	/* 0x0000014e */ 0x0000014f,
	/* 0x0000014f */ 0x0000014f,
	/* 0x00000150 */ 0x00000151,
	/* 0x00000151 */ 0x00000151,
	/* 0x00000152 */ 0x00000153,
	/* 0x00000153 */ 0x00000153,
	/* 0x00000154 */ 0x00000155,
	/* 0x00000155 */ 0x00000155,
	/* 0x00000156 */ 0x00000157,
	/* 0x00000157 */ 0x00000157,
	/* 0x00000158 */ 0x00000159,
	/* 0x00000159 */ 0x00000159,
	/* 0x0000015a */ 0x0000015b,
	/* 0x0000015b */ 0x0000015b,
	/* 0x0000015c */ 0x0000015d,
	/* 0x0000015d */ 0x0000015d,
	/* 0x0000015e */ 0x0000015f,
	/* 0x0000015f */ 0x0000015f,
	/* 0x00000160 */ 0x00000161,
	/* 0x00000161 */ 0x00000161,
	/* 0x00000162 */ 0x00000163,
	/* 0x00000163 */ 0x00000163,
	/* 0x00000164 */ 0x00000165,
	/* 0x00000165 */ 0x00000165,
	/* 0x00000166 */ 0x00000167,
	/* 0x00000167 */ 0x00000167,
	/* 0x00000168 */ 0x00000169,
	/* 0x00000169 */ 0x00000169,
	/* 0x0000016a */ 0x0000016b,
	/* 0x0000016b */ 0x0000016b,
	/* 0x0000016c */ 0x0000016d,
	/* 0x0000016d */ 0x0000016d,
	/* 0x0000016e */ 0x0000016f,
	/* 0x0000016f */ 0x0000016f,
	/* 0x00000170 */ 0x00000171,
	/* 0x00000171 */ 0x00000171,
	/* 0x00000172 */ 0x00000173,
	/* 0x00000173 */ 0x00000173,
	/* 0x00000174 */ 0x00000175,
	/* 0x00000175 */ 0x00000175,
	/* 0x00000176 */ 0x00000177,
	/* 0x00000177 */ 0x00000177,
	/* 0x00000178 */ 0x000000ff,
	/* 0x00000179 */ 0x0000017a,
	/* 0x0000017a */ 0x0000017a,
	/* 0x0000017b */ 0x0000017c,
	/* 0x0000017c */ 0x0000017c,
	/* 0x0000017d */ 0x0000017e,
	/* 0x0000017e */ 0x0000017e,
	/* 0x0000017f */ 0x00000073,
	/* 0x00000180 */ 0x00000180,
	/* 0x00000181 */ 0x00000253,
	/* 0x00000182 */ 0x00000183,
	/* 0x00000183 */ 0x00000183,
	/* 0x00000184 */ 0x00000185,
	/* 0x00000185 */ 0x00000185,
	/* 0x00000186 */ 0x00000254,
	/* 0x00000187 */ 0x00000188,
	/* 0x00000188 */ 0x00000188,
	/* 0x00000189 */ 0x00000256,
	/* 0x0000018a */ 0x00000257,
	/* 0x0000018b */ 0x0000018c,
	/* 0x0000018c */ 0x0000018c,
	/* 0x0000018d */ 0x0000018d,
	/* 0x0000018e */ 0x000001dd,
	/* 0x0000018f */ 0x00000259,
	/* 0x00000190 */ 0x0000025b,
	/* 0x00000191 */ 0x00000192,
	/* 0x00000192 */ 0x00000192,
	/* 0x00000193 */ 0x00000260,
	/* 0x00000194 */ 0x00000263,
	/* 0x00000195 */ 0x00000195,
	/* 0x00000196 */ 0x00000269,
	/* 0x00000197 */ 0x00000268,
	/* 0x00000198 */ 0x00000199,
	/* 0x00000199 */ 0x00000199,
	/* 0x0000019a */ 0x0000019a,
	/* 0x0000019b */ 0x0000019b,
	/* 0x0000019c */ 0x0000026f,
	/* 0x0000019d */ 0x00000272,
	/* 0x0000019e */ 0x0000019e,
	/* 0x0000019f */ 0x00000275,
	/* 0x000001a0 */ 0x000001a1,
	/* 0x000001a1 */ 0x000001a1,
	/* 0x000001a2 */ 0x000001a3,
	/* 0x000001a3 */ 0x000001a3,
	/* 0x000001a4 */ 0x000001a5,
	/* 0x000001a5 */ 0x000001a5,
	/* 0x000001a6 */ 0x00000280,
	/* 0x000001a7 */ 0x000001a8,
	/* 0x000001a8 */ 0x000001a8,
	/* 0x000001a9 */ 0x00000283,
	/* 0x000001aa */ 0x000001aa,
	/* 0x000001ab */ 0x000001ab,
	/* 0x000001ac */ 0x000001ad,
	/* 0x000001ad */ 0x000001ad,
	/* 0x000001ae */ 0x00000288,
	/* 0x000001af */ 0x000001b0,
	/* 0x000001b0 */ 0x000001b0,
	/* 0x000001b1 */ 0x0000028a,
	/* 0x000001b2 */ 0x0000028b,
	/* 0x000001b3 */ 0x000001b4,
	/* 0x000001b4 */ 0x000001b4,
	/* 0x000001b5 */ 0x000001b6,
	/* 0x000001b6 */ 0x000001b6,
	/* 0x000001b7 */ 0x00000292,
	/* 0x000001b8 */ 0x000001b9,
	/* 0x000001b9 */ 0x000001b9,
	/* 0x000001ba */ 0x000001ba,
	/* 0x000001bb */ 0x000001bb,
	/* 0x000001bc */ 0x000001bd,
	/* 0x000001bd */ 0x000001bd,
	/* 0x000001be */ 0x000001be,
	/* 0x000001bf */ 0x000001bf,
	/* 0x000001c0 */ 0x000001c0,
	/* 0x000001c1 */ 0x000001c1,
	/* 0x000001c2 */ 0x000001c2,
	/* 0x000001c3 */ 0x000001c3,
	/* 0x000001c4 */ 0x000001c6,
	/* 0x000001c5 */ 0x000001c6,
	/* 0x000001c6 */ 0x000001c6,
	/* 0x000001c7 */ 0x000001c9,
	/* 0x000001c8 */ 0x000001c9,
	/* 0x000001c9 */ 0x000001c9,
	/* 0x000001ca */ 0x000001cc,
	/* 0x000001cb */ 0x000001cc,
	/* 0x000001cc */ 0x000001cc,
	/* 0x000001cd */ 0x000001ce,
	/* 0x000001ce */ 0x000001ce,
	/* 0x000001cf */ 0x000001d0,
	/* 0x000001d0 */ 0x000001d0,
	/* 0x000001d1 */ 0x000001d2,
	/* 0x000001d2 */ 0x000001d2,
	/* 0x000001d3 */ 0x000001d4,
	/* 0x000001d4 */ 0x000001d4,
	/* 0x000001d5 */ 0x000001d6,
	/* 0x000001d6 */ 0x000001d6,
	/* 0x000001d7 */ 0x000001d8,
	/* 0x000001d8 */ 0x000001d8,
	/* 0x000001d9 */ 0x000001da,
	/* 0x000001da */ 0x000001da,
	/* 0x000001db */ 0x000001dc,
	/* 0x000001dc */ 0x000001dc,
	/* 0x000001dd */ 0x000001dd,
	/* 0x000001de */ 0x000001df,
	/* 0x000001df */ 0x000001df,
	/* 0x000001e0 */ 0x000001e1,
	/* 0x000001e1 */ 0x000001e1,
	/* 0x000001e2 */ 0x000001e3,
	/* 0x000001e3 */ 0x000001e3,
	/* 0x000001e4 */ 0x000001e5,
	/* 0x000001e5 */ 0x000001e5,
	/* 0x000001e6 */ 0x000001e7,
	/* 0x000001e7 */ 0x000001e7,
	/* 0x000001e8 */ 0x000001e9,
	/* 0x000001e9 */ 0x000001e9,
	/* 0x000001ea */ 0x000001eb,
	/* 0x000001eb */ 0x000001eb,
	/* 0x000001ec */ 0x000001ed,
	/* 0x000001ed */ 0x000001ed,
	/* 0x000001ee */ 0x000001ef,
	/* 0x000001ef */ 0x000001ef,
	/* 0x000001f0 */ 0x000001f0,
	/* 0x000001f1 */ 0x000001f3,
	/* 0x000001f2 */ 0x000001f3,
	/* 0x000001f3 */ 0x000001f3,
	/* 0x000001f4 */ 0x000001f5,
	/* 0x000001f5 */ 0x000001f5,
	/* 0x000001f6 */ 0x00000195,
	/* 0x000001f7 */ 0x000001bf,
	/* 0x000001f8 */ 0x000001f9,
	/* 0x000001f9 */ 0x000001f9,
	/* 0x000001fa */ 0x000001fb,
	/* 0x000001fb */ 0x000001fb,
	/* 0x000001fc */ 0x000001fd,
	/* 0x000001fd */ 0x000001fd,
	/* 0x000001fe */ 0x000001ff,
	/* 0x000001ff */ 0x000001ff,
	/* 0x00000200 */ 0x00000201,
	/* 0x00000201 */ 0x00000201,
	/* 0x00000202 */ 0x00000203,
	/* 0x00000203 */ 0x00000203,
	/* 0x00000204 */ 0x00000205,
	/* 0x00000205 */ 0x00000205,
	/* 0x00000206 */ 0x00000207,
	/* 0x00000207 */ 0x00000207,
	/* 0x00000208 */ 0x00000209,
	/* 0x00000209 */ 0x00000209,
	/* 0x0000020a */ 0x0000020b,
	/* 0x0000020b */ 0x0000020b,
	/* 0x0000020c */ 0x0000020d,
	/* 0x0000020d */ 0x0000020d,
	/* 0x0000020e */ 0x0000020f,
	/* 0x0000020f */ 0x0000020f,
	/* 0x00000210 */ 0x00000211,
	/* 0x00000211 */ 0x00000211,
	/* 0x00000212 */ 0x00000213,
	/* 0x00000213 */ 0x00000213,
	/* 0x00000214 */ 0x00000215,
	/* 0x00000215 */ 0x00000215,
	/* 0x00000216 */ 0x00000217,
	/* 0x00000217 */ 0x00000217,
	/* 0x00000218 */ 0x00000219,
	/* 0x00000219 */ 0x00000219,
	/* 0x0000021a */ 0x0000021b,
	/* 0x0000021b */ 0x0000021b,
	/* 0x0000021c */ 0x0000021d,
	/* 0x0000021d */ 0x0000021d,
	/* 0x0000021e */ 0x0000021f,
	/* 0x0000021f */ 0x0000021f,
	/* 0x00000220 */ 0x0000019e,
	/* 0x00000221 */ 0x00000221,
	/* 0x00000222 */ 0x00000223,
	/* 0x00000223 */ 0x00000223,
	/* 0x00000224 */ 0x00000225,
	/* 0x00000225 */ 0x00000225,
	/* 0x00000226 */ 0x00000227,
	/* 0x00000227 */ 0x00000227,
	/* 0x00000228 */ 0x00000229,
	/* 0x00000229 */ 0x00000229,
	/* 0x0000022a */ 0x0000022b,
	/* 0x0000022b */ 0x0000022b,
	/* 0x0000022c */ 0x0000022d,
	/* 0x0000022d */ 0x0000022d,
	/* 0x0000022e */ 0x0000022f,
	/* 0x0000022f */ 0x0000022f,
	/* 0x00000230 */ 0x00000231,
	/* 0x00000231 */ 0x00000231,
	/* 0x00000232 */ 0x00000233,
	/* 0x00000233 */ 0x00000233,
	/* 0x00000234 */ 0x00000234,
	/* 0x00000235 */ 0x00000235,
	/* 0x00000236 */ 0x00000236,
	/* 0x00000237 */ 0x00000237,
	/* 0x00000238 */ 0x00000238,
	/* 0x00000239 */ 0x00000239,
	/* 0x0000023a */ 0x00002c65,
	/* 0x0000023b */ 0x0000023c,
	/* 0x0000023c */ 0x0000023c,
	/* 0x0000023d */ 0x0000019a,
	/* 0x0000023e */ 0x00002c66,
	/* 0x0000023f */ 0x0000023f,
	/* 0x00000240 */ 0x00000240,
	/* 0x00000241 */ 0x00000242,
	/* 0x00000242 */ 0x00000242,
	/* 0x00000243 */ 0x00000180,
	/* 0x00000244 */ 0x00000289,
	/* 0x00000245 */ 0x0000028c,
	/* 0x00000246 */ 0x00000247,
	/* 0x00000247 */ 0x00000247,
	/* 0x00000248 */ 0x00000249,
	/* 0x00000249 */ 0x00000249,
	/* 0x0000024a */ 0x0000024b,
	/* 0x0000024b */ 0x0000024b,
	/* 0x0000024c */ 0x0000024d,
	/* 0x0000024d */ 0x0000024d,
	/* 0x0000024e */ 0x0000024f,
	/* 0x0000024f */ 0x0000024f
};

uint32_t libfshfs_name_case_folding_mappings_0x00000340[ 536 ] = {
	/* 0x00000340 */ 0x00000340,
	/* 0x00000341 */ 0x00000341,
	/* 0x00000342 */ 0x00000342,
	/* 0x00000343 */ 0x00000343,
	/* 0x00000344 */ 0x00000344,
	/* 0x00000345 */ 0x000003b9,
	/* 0x00000346 */ 0x00000346,
	/* 0x00000347 */ 0x00000347,
	/* 0x00000348 */ 0x00000348,
	/* 0x00000349 */ 0x00000349,
	/* 0x0000034a */ 0x0000034a,
	/* 0x0000034b */ 0x0000034b,
	/* 0x0000034c */ 0x0000034c,
	/* 0x0000034d */ 0x0000034d,
	/* 0x0000034e */ 0x0000034e,
	/* 0x0000034f */ 0x0000034f,
	/* 0x00000350 */ 0x00000350,
	/* 0x00000351 */ 0x00000351,
	/* 0x00000352 */ 0x00000352,
	/* 0x00000353 */ 0x00000353,
	/* 0x00000354 */ 0x00000354,
	/* 0x00000355 */ 0x00000355,
	/* 0x00000356 */ 0x00000356,
	/* 0x00000357 */ 0x00000357,
	/* 0x00000358 */ 0x00000358,
	/* 0x00000359 */ 0x00000359,
	/* 0x0000035a */ 0x0000035a,
	/* 0x0000035b */ 0x0000035b,
	/* 0x0000035c */ 0x0000035c,
	/* 0x0000035d */ 0x0000035d,
	/* 0x0000035e */ 0x0000035e,
	/* 0x0000035f */ 0x0000035f,
	/* 0x00000360 */ 0x00000360,
	/* 0x00000361 */ 0x00000361,
	/* 0x00000362 */ 0x00000362,
	/* 0x00000363 */ 0x00000363,
	/* 0x00000364 */ 0x00000364,
	/* 0x00000365 */ 0x00000365,
	/* 0x00000366 */ 0x00000366,
	/* 0x00000367 */ 0x00000367,
	/* 0x00000368 */ 0x00000368,
	/* 0x00000369 */ 0x00000369,
	/* 0x0000036a */ 0x0000036a,
	/* 0x0000036b */ 0x0000036b,
	/* 0x0000036c */ 0x0000036c,
	/* 0x0000036d */ 0x0000036d,
	/* 0x0000036e */ 0x0000036e,
	/* 0x0000036f */ 0x0000036f,
	/* 0x00000370 */ 0x00000371,
	/* 0x00000371 */ 0x00000371,
	/* 0x00000372 */ 0x00000373,
	/* 0x00000373 */ 0x00000373,
	/* 0x00000374 */ 0x00000374,
	/* 0x00000375 */ 0x00000375,
	/* 0x00000376 */ 0x00000377,
	/* 0x00000377 */ 0x00000377,
	/* 0x00000378 */ 0x00000378,
	/* 0x00000379 */ 0x00000379,
	/* 0x0000037a */ 0x0000037a,
	/* 0x0000037b */ 0x0000037b,
	/* 0x0000037c */ 0x0000037c,
	/* 0x0000037d */ 0x0000037d,
	/* 0x0000037e */ 0x0000037e,
	/* 0x0000037f */ 0x000003f3,
	/* 0x00000380 */ 0x00000380,
	/* 0x00000381 */ 0x00000381,
	/* 0x00000382 */ 0x00000382,
	/* 0x00000383 */ 0x00000383,
	/* 0x00000384 */ 0x00000384,
	/* 0x00000385 */ 0x00000385,
	/* 0x00000386 */ 0x000003ac,
	/* 0x00000387 */ 0x00000387,
	/* 0x00000388 */ 0x000003ad,
	/* 0x00000389 */ 0x000003ae,
	/* 0x0000038a */ 0x000003af,
	/* 0x0000038b */ 0x0000038b,
	/* 0x0000038c */ 0x000003cc,
	/* 0x0000038d */ 0x0000038d,
	/* 0x0000038e */ 0x000003cd,
	/* 0x0000038f */ 0x000003ce,
	/* 0x00000390 */ 0x00000390,
	/* 0x00000391 */ 0x000003b1,
	/* 0x00000392 */ 0x000003b2,
	/* 0x00000393 */ 0x000003b3,
	/* 0x00000394 */ 0x000003b4,
	/* 0x00000395 */ 0x000003b5,
	/* 0x00000396 */ 0x000003b6,
	/* 0x00000397 */ 0x000003b7,
	/* 0x00000398 */ 0x000003b8,
	/* 0x00000399 */ 0x000003b9,
	/* 0x0000039a */ 0x000003ba,
	/* 0x0000039b */ 0x000003bb,
	/* 0x0000039c */ 0x000003bc,
	/* 0x0000039d */ 0x000003bd,
	/* 0x0000039e */ 0x000003be,
	/* 0x0000039f */ 0x000003bf,
	/* 0x000003a0 */ 0x000003c0,
	/* 0x000003a1 */ 0x000003c1,
	/* 0x000003a2 */ 0x000003a2,
	/* 0x000003a3 */ 0x000003c3,
	/* 0x000003a4 */ 0x000003c4,
	/* 0x000003a5 */ 0x000003c5,
	/* 0x000003a6 */ 0x000003c6,
	/* 0x000003a7 */ 0x000003c7,
	/* 0x000003a8 */ 0x000003c8,
	/* 0x000003a9 */ 0x000003c9,
	/* 0x000003aa */ 0x000003ca,
	/* 0x000003ab */ 0x000003cb,
	/* 0x000003ac */ 0x000003ac,
	/* 0x000003ad */ 0x000003ad,
	/* 0x000003ae */ 0x000003ae,
	/* 0x000003af */ 0x000003af,
	/* 0x000003b0 */ 0x000003b0,
	/* 0x000003b1 */ 0x000003b1,
	/* 0x000003b2 */ 0x000003b2,
	/* 0x000003b3 */ 0x000003b3,
	/* 0x000003b4 */ 0x000003b4,
	/* 0x000003b5 */ 0x000003b5,
	/* 0x000003b6 */ 0x000003b6,
	/* 0x000003b7 */ 0x000003b7,
	/* 0x000003b8 */ 0x000003b8,
	/* 0x000003b9 */ 0x000003b9,
	/* 0x000003ba */ 0x000003ba,
	/* 0x000003bb */ 0x000003bb,
	/* 0x000003bc */ 0x000003bc,
	/* 0x000003bd */ 0x000003bd,
	/* 0x000003be */ 0x000003be,
	/* 0x000003bf */ 0x000003bf,
	/* 0x000003c0 */ 0x000003c0,
	/* 0x000003c1 */ 0x000003c1,
	/* 0x000003c2 */ 0x000003c3,
	/* 0x000003c3 */ 0x000003c3,
	/* 0x000003c4 */ 0x000003c4,
	/* 0x000003c5 */ 0x000003c5,
	/* 0x000003c6 */ 0x000003c6,
	/* 0x000003c7 */ 0x000003c7,
	/* 0x000003c8 */ 0x000003c8,
	/* 0x000003c9 */ 0x000003c9,
	/* 0x000003ca */ 0x000003ca,
	/* 0x000003cb */ 0x000003cb,
	/* 0x000003cc */ 0x000003cc,
	/* 0x000003cd */ 0x000003cd,
	/* 0x000003ce */ 0x000003ce,
	/* 0x000003cf */ 0x000003d7,
	/* 0x000003d0 */ 0x000003b2,
	/* 0x000003d1 */ 0x000003b8,
	/* 0x000003d2 */ 0x000003d2,
	/* 0x000003d3 */ 0x000003d3,
	/* 0x000003d4 */ 0x000003d4,
	/* 0x000003d5 */ 0x000003c6,
	/* 0x000003d6 */ 0x000003c0,
	/* 0x000003d7 */ 0x000003d7,
	/* 0x000003d8 */ 0x000003d9,
	/* 0x000003d9 */ 0x000003d9,
	/* 0x000003da */ 0x000003db,
	/* 0x000003db */ 0x000003db,
	/* 0x000003dc */ 0x000003dd,
	/* 0x000003dd */ 0x000003dd,
	/* 0x000003de */ 0x000003df,
	/* 0x000003df */ 0x000003df,
	/* 0x000003e0 */ 0x000003e1,
	/* 0x000003e1 */ 0x000003e1,
	/* 0x000003e2 */ 0x000003e3,
	/* 0x000003e3 */ 0x000003e3,
	/* 0x000003e4 */ 0x000003e5,
	/* 0x000003e5 */ 0x000003e5,
	/* 0x000003e6 */ 0x000003e7,
	/* 0x000003e7 */ 0x000003e7,
	/* 0x000003e8 */ 0x000003e9,
	/* 0x000003e9 */ 0x000003e9,
	/* 0x000003ea */ 0x000003eb,
	/* 0x000003eb */ 0x000003eb,
	/* 0x000003ec */ 0x000003ed,
	/* 0x000003ed */ 0x000003ed,
	/* 0x000003ee */ 0x000003ef,
	/* 0x000003ef */ 0x000003ef,
	/* 0x000003f0 */ 0x000003ba,
	/* 0x000003f1 */ 0x000003c1,
	/* 0x000003f2 */ 0x000003f2,
	/* 0x000003f3 */ 0x000003f3,
	/* 0x000003f4 */ 0x000003b8,
	/* 0x000003f5 */ 0x000003b5,
	/* 0x000003f6 */ 0x000003f6,
	/* 0x000003f7 */ 0x000003f8,
	/* 0x000003f8 */ 0x000003f8,
	/* 0x000003f9 */ 0x000003f9,
	/* 0x000003fa */ 0x000003fb,
	/* 0x000003fb */ 0x000003fb,
	/* 0x000003fc */ 0x000003fc,
	/* 0x000003fd */ 0x0000037b,
	/* 0x000003fe */ 0x0000037c,
	/* 0x000003ff */ 0x0000037d,
	/* 0x00000400 */ 0x00000450,
	/* 0x00000401 */ 0x00000451,
	/* 0x00000402 */ 0x00000452,
	/* 0x00000403 */ 0x00000453,
	/* 0x00000404 */ 0x00000454,
	/* 0x00000405 */ 0x00000455,
	/* 0x00000406 */ 0x00000456,
	/* 0x00000407 */ 0x00000457,
	/* 0x00000408 */ 0x00000458,
	/* 0x00000409 */ 0x00000459,
	/* 0x0000040a */ 0x0000045a,
	/* 0x0000040b */ 0x0000045b,
	/* 0x0000040c */ 0x0000045c,
	/* 0x0000040d */ 0x0000045d,
	/* 0x0000040e */ 0x0000045e,
	/* 0x0000040f */ 0x0000045f,
	/* 0x00000410 */ 0x00000430,
	/* 0x00000411 */ 0x00000431,
	/* 0x00000412 */ 0x00000432,
	/* 0x00000413 */ 0x00000433,
	/* 0x00000414 */ 0x00000434,
	/* 0x00000415 */ 0x00000435,
	/* 0x00000416 */ 0x00000436,
	/* 0x00000417 */ 0x00000437,
	/* 0x00000418 */ 0x00000438,
	/* 0x00000419 */ 0x00000439,
	/* 0x0000041a */ 0x0000043a,
	/* 0x0000041b */ 0x0000043b,
	/* 0x0000041c */ 0x0000043c,
	/* 0x0000041d */ 0x0000043d,
	/* 0x0000041e */ 0x0000043e,
	/* 0x0000041f */ 0x0000043f,
	/* 0x00000420 */ 0x00000440,
	/* 0x00000421 */ 0x00000441,
	/* 0x00000422 */ 0x00000442,
	/* 0x00000423 */ 0x00000443,
	/* 0x00000424 */ 0x00000444,
	/* 0x00000425 */ 0x00000445,
	/* 0x00000426 */ 0x00000446,
	/* 0x00000427 */ 0x00000447,
	/* 0x00000428 */ 0x00000448,
	/* 0x00000429 */ 0x00000449,
	/* 0x0000042a */ 0x0000044a,
	/* 0x0000042b */ 0x0000044b,
	/* 0x0000042c */ 0x0000044c,
	/* 0x0000042d */ 0x0000044d,
	/* 0x0000042e */ 0x0000044e,
	/* 0x0000042f */ 0x0000044f,
	/* 0x00000430 */ 0x00000430,
	/* 0x00000431 */ 0x00000431,
	/* 0x00000432 */ 0x00000432,
	/* 0x00000433 */ 0x00000433,
	/* 0x00000434 */ 0x00000434,
	/* 0x00000435 */ 0x00000435,
	/* 0x00000436 */ 0x00000436,
	/* 0x00000437 */ 0x00000437,
	/* 0x00000438 */ 0x00000438,
	/* 0x00000439 */ 0x00000439,
	/* 0x0000043a */ 0x0000043a,
	/* 0x0000043b */ 0x0000043b,
	/* 0x0000043c */ 0x0000043c,
	/* 0x0000043d */ 0x0000043d,
	/* 0x0000043e */ 0x0000043e,
	/* 0x0000043f */ 0x0000043f,
	/* 0x00000440 */ 0x00000440,
	/* 0x00000441 */ 0x00000441,
	/* 0x00000442 */ 0x00000442,
	/* 0x00000443 */ 0x00000443,
	/* 0x00000444 */ 0x00000444,
	/* 0x00000445 */ 0x00000445,
	/* 0x00000446 */ 0x00000446,
	/* 0x00000447 */ 0x00000447,
	/* 0x00000448 */ 0x00000448,
	/* 0x00000449 */ 0x00000449,
	/* 0x0000044a */ 0x0000044a,
	/* 0x0000044b */ 0x0000044b,
	/* 0x0000044c */ 0x0000044c,
	/* 0x0000044d */ 0x0000044d,
	/* 0x0000044e */ 0x0000044e,
	/* 0x0000044f */ 0x0000044f,
	/* 0x00000450 */ 0x00000450,
	/* 0x00000451 */ 0x00000451,
	/* 0x00000452 */ 0x00000452,
	/* 0x00000453 */ 0x00000453,
	/* 0x00000454 */ 0x00000454,
	/* 0x00000455 */ 0x00000455,
	/* 0x00000456 */ 0x00000456,
	/* 0x00000457 */ 0x00000457,
	/* 0x00000458 */ 0x00000458,
	/* 0x00000459 */ 0x00000459,
	/* 0x0000045a */ 0x0000045a,
	/* 0x0000045b */ 0x0000045b,
	/* 0x0000045c */ 0x0000045c,
	/* 0x0000045d */ 0x0000045d,
	/* 0x0000045e */ 0x0000045e,
	/* 0x0000045f */ 0x0000045f,
	/* 0x00000460 */ 0x00000461,
	/* 0x00000461 */ 0x00000461,
	/* 0x00000462 */ 0x00000463,
	/* 0x00000463 */ 0x00000463,
	/* 0x00000464 */ 0x00000465,
	/* 0x00000465 */ 0x00000465,
	/* 0x00000466 */ 0x00000467,
	/* 0x00000467 */ 0x00000467,
	/* 0x00000468 */ 0x00000469,
	/* 0x00000469 */ 0x00000469,
	/* 0x0000046a */ 0x0000046b,
	/* 0x0000046b */ 0x0000046b,
	/* 0x0000046c */ 0x0000046d,
	/* 0x0000046d */ 0x0000046d,
	/* 0x0000046e */ 0x0000046f,
	/* 0x0000046f */ 0x0000046f,
	/* 0x00000470 */ 0x00000471,
	/* 0x00000471 */ 0x00000471,
	/* 0x00000472 */ 0x00000473,
	/* 0x00000473 */ 0x00000473,
	/* 0x00000474 */ 0x00000475,
	/* 0x00000475 */ 0x00000475,
	/* 0x00000476 */ 0x00000477,
	/* 0x00000477 */ 0x00000477,
	/* 0x00000478 */ 0x00000479,
	/* 0x00000479 */ 0x00000479,
	/* 0x0000047a */ 0x0000047b,
	/* 0x0000047b */ 0x0000047b,
	/* 0x0000047c */ 0x0000047d,
	/* 0x0000047d */ 0x0000047d,
	/* 0x0000047e */ 0x0000047f,
	/* 0x0000047f */ 0x0000047f,
	/* 0x00000480 */ 0x00000481,
	/* 0x00000481 */ 0x00000481,
	/* 0x00000482 */ 0x00000482,
	/* 0x00000483 */ 0x00000483,
	/* 0x00000484 */ 0x00000484,
	/* 0x00000485 */ 0x00000485,
	/* 0x00000486 */ 0x00000486,
	/* 0x00000487 */ 0x00000487,
	/* 0x00000488 */ 0x00000488,
	/* 0x00000489 */ 0x00000489,
	/* 0x0000048a */ 0x0000048b,
	/* 0x0000048b */ 0x0000048b,
	/* 0x0000048c */ 0x0000048d,
	/* 0x0000048d */ 0x0000048d,
	/* 0x0000048e */ 0x0000048f,
	/* 0x0000048f */ 0x0000048f,
	/* 0x00000490 */ 0x00000491,
	/* 0x00000491 */ 0x00000491,
	/* 0x00000492 */ 0x00000493,
	/* 0x00000493 */ 0x00000493,
	/* 0x00000494 */ 0x00000495,
	/* 0x00000495 */ 0x00000495,
	/* 0x00000496 */ 0x00000497,
	/* 0x00000497 */ 0x00000497,
	/* 0x00000498 */ 0x00000499,
	/* 0x00000499 */ 0x00000499,
	/* 0x0000049a */ 0x0000049b,
	/* 0x0000049b */ 0x0000049b,
	/* 0x0000049c */ 0x0000049d,
	/* 0x0000049d */ 0x0000049d,
	/* 0x0000049e */ 0x0000049f,
	/* 0x0000049f */ 0x0000049f,
	/* 0x000004a0 */ 0x000004a1,
	/* 0x000004a1 */ 0x000004a1,
	/* 0x000004a2 */ 0x000004a3,
	/* 0x000004a3 */ 0x000004a3,
	/* 0x000004a4 */ 0x000004a5,
	/* 0x000004a5 */ 0x000004a5,
	/* 0x000004a6 */ 0x000004a7,
	/* 0x000004a7 */ 0x000004a7,
	/* 0x000004a8 */ 0x000004a9,
	/* 0x000004a9 */ 0x000004a9,
	/* 0x000004aa */ 0x000004ab,
	/* 0x000004ab */ 0x000004ab,
	/* 0x000004ac */ 0x000004ad,
	/* 0x000004ad */ 0x000004ad,
	/* 0x000004ae */ 0x000004af,
	/* 0x000004af */ 0x000004af,
	/* 0x000004b0 */ 0x000004b1,
	/* 0x000004b1 */ 0x000004b1,
	/* 0x000004b2 */ 0x000004b3,
	/* 0x000004b3 */ 0x000004b3,
	/* 0x000004b4 */ 0x000004b5,
	/* 0x000004b5 */ 0x000004b5,
	/* 0x000004b6 */ 0x000004b7,
	/* 0x000004b7 */ 0x000004b7,
	/* 0x000004b8 */ 0x000004b9,
	/* 0x000004b9 */ 0x000004b9,
	/* 0x000004ba */ 0x000004bb,
	/* 0x000004bb */ 0x000004bb,
	/* 0x000004bc */ 0x000004bd,
	/* 0x000004bd */ 0x000004bd,
	/* 0x000004be */ 0x000004bf,
	/* 0x000004bf */ 0x000004bf,
	/* 0x000004c0 */ 0x000004cf,
	/* 0x000004c1 */ 0x000004c2,
	/* 0x000004c2 */ 0x000004c2,
	/* 0x000004c3 */ 0x000004c4,
	/* 0x000004c4 */ 0x000004c4,
	/* 0x000004c5 */ 0x000004c6,
	/* 0x000004c6 */ 0x000004c6,
	/* 0x000004c7 */ 0x000004c8,
	/* 0x000004c8 */ 0x000004c8,
	/* 0x000004c9 */ 0x000004ca,
	/* 0x000004ca */ 0x000004ca,
	/* 0x000004cb */ 0x000004cc,
	/* 0x000004cc */ 0x000004cc,
	/* 0x000004cd */ 0x000004ce,
	/* 0x000004ce */ 0x000004ce,
	/* 0x000004cf */ 0x000004cf,
	/* 0x000004d0 */ 0x000004d1,
	/* 0x000004d1 */ 0x000004d1,
	/* 0x000004d2 */ 0x000004d3,
	/* 0x000004d3 */ 0x000004d3,
	/* 0x000004d4 */ 0x000004d5,
	/* 0x000004d5 */ 0x000004d5,
	/* 0x000004d6 */ 0x000004d7,
	/* 0x000004d7 */ 0x000004d7,
	/* 0x000004d8 */ 0x000004d9,
	/* 0x000004d9 */ 0x000004d9,
	/* 0x000004da */ 0x000004db,
	/* 0x000004db */ 0x000004db,
	/* 0x000004dc */ 0x000004dd,
	/* 0x000004dd */ 0x000004dd,
	/* 0x000004de */ 0x000004df,
	/* 0x000004df */ 0x000004df,
	/* 0x000004e0 */ 0x000004e1,
	/* 0x000004e1 */ 0x000004e1,
	/* 0x000004e2 */ 0x000004e3,
	/* 0x000004e3 */ 0x000004e3,
	/* 0x000004e4 */ 0x000004e5,
	/* 0x000004e5 */ 0x000004e5,
	/* 0x000004e6 */ 0x000004e7,
	/* 0x000004e7 */ 0x000004e7,
	/* 0x000004e8 */ 0x000004e9,
	/* 0x000004e9 */ 0x000004e9,
	/* 0x000004ea */ 0x000004eb,
	/* 0x000004eb */ 0x000004eb,
	/* 0x000004ec */ 0x000004ed,
	/* 0x000004ed */ 0x000004ed,
	/* 0x000004ee */ 0x000004ef,
	/* 0x000004ef */ 0x000004ef,
	/* 0x000004f0 */ 0x000004f1,
	/* 0x000004f1 */ 0x000004f1,
	/* 0x000004f2 */ 0x000004f3,
	/* 0x000004f3 */ 0x000004f3,
	/* 0x000004f4 */ 0x000004f5,
	/* 0x000004f5 */ 0x000004f5,
	/* 0x000004f6 */ 0x000004f7,
	/* 0x000004f7 */ 0x000004f7,
	/* 0x000004f8 */ 0x000004f9,
	/* 0x000004f9 */ 0x000004f9,
	/* 0x000004fa */ 0x000004fb,
	/* 0x000004fb */ 0x000004fb,
	/* 0x000004fc */ 0x000004fd,
	/* 0x000004fd */ 0x000004fd,
	/* 0x000004fe */ 0x000004ff,
	/* 0x000004ff */ 0x000004ff,
	/* 0x00000500 */ 0x00000501,
	/* 0x00000501 */ 0x00000501,
	/* 0x00000502 */ 0x00000503,
	/* 0x00000503 */ 0x00000503,
	/* 0x00000504 */ 0x00000505,
	/* 0x00000505 */ 0x00000505,
	/* 0x00000506 */ 0x00000507,
	/* 0x00000507 */ 0x00000507,
	/* 0x00000508 */ 0x00000509,
	/* 0x00000509 */ 0x00000509,
	/* 0x0000050a */ 0x0000050b,
	/* 0x0000050b */ 0x0000050b,
	/* 0x0000050c */ 0x0000050d,
	/* 0x0000050d */ 0x0000050d,
	/* 0x0000050e */ 0x0000050f,
	/* 0x0000050f */ 0x0000050f,
	/* 0x00000510 */ 0x00000511,
	/* 0x00000511 */ 0x00000511,
	/* 0x00000512 */ 0x00000513,
	/* 0x00000513 */ 0x00000513,
	/* 0x00000514 */ 0x00000515,
	/* 0x00000515 */ 0x00000515,
	/* 0x00000516 */ 0x00000517,
	/* 0x00000517 */ 0x00000517,
	/* 0x00000518 */ 0x00000519,
	/* 0x00000519 */ 0x00000519,
	/* 0x0000051a */ 0x0000051b,
	/* 0x0000051b */ 0x0000051b,
	/* 0x0000051c */ 0x0000051d,
	/* 0x0000051d */ 0x0000051d,
	/* 0x0000051e */ 0x0000051f,
	/* 0x0000051f */ 0x0000051f,
	/* 0x00000520 */ 0x00000521,
	/* 0x00000521 */ 0x00000521,
	/* 0x00000522 */ 0x00000523,
	/* 0x00000523 */ 0x00000523,
	/* 0x00000524 */ 0x00000525,
	/* 0x00000525 */ 0x00000525,
	/* 0x00000526 */ 0x00000527,
	/* 0x00000527 */ 0x00000527,
	/* 0x00000528 */ 0x00000529,
	/* 0x00000529 */ 0x00000529,
	/* 0x0000052a */ 0x0000052b,
	/* 0x0000052b */ 0x0000052b,
	/* 0x0000052c */ 0x0000052d,
	/* 0x0000052d */ 0x0000052d,
	/* 0x0000052e */ 0x0000052f,
	/* 0x0000052f */ 0x0000052f,
	/* 0x00000530 */ 0x00000530,
	/* 0x00000531 */ 0x00000561,
	/* 0x00000532 */ 0x00000562,
	/* 0x00000533 */ 0x00000563,
	/* 0x00000534 */ 0x00000564,
	/* 0x00000535 */ 0x00000565,
	/* 0x00000536 */ 0x00000566,
	/* 0x00000537 */ 0x00000567,
	/* 0x00000538 */ 0x00000568,
	/* 0x00000539 */ 0x00000569,
	/* 0x0000053a */ 0x0000056a,
	/* 0x0000053b */ 0x0000056b,
	/* 0x0000053c */ 0x0000056c,
	/* 0x0000053d */ 0x0000056d,
	/* 0x0000053e */ 0x0000056e,
	/* 0x0000053f */ 0x0000056f,
	/* 0x00000540 */ 0x00000570,
	/* 0x00000541 */ 0x00000571,
	/* 0x00000542 */ 0x00000572,
	/* 0x00000543 */ 0x00000573,
	/* 0x00000544 */ 0x00000574,
	/* 0x00000545 */ 0x00000575,
	/* 0x00000546 */ 0x00000576,
	/* 0x00000547 */ 0x00000577,
	/* 0x00000548 */ 0x00000578,
	/* 0x00000549 */ 0x00000579,
	/* 0x0000054a */ 0x0000057a,
	/* 0x0000054b */ 0x0000057b,
	/* 0x0000054c */ 0x0000057c,
	/* 0x0000054d */ 0x0000057d,
	/* 0x0000054e */ 0x0000057e,
	/* 0x0000054f */ 0x0000057f,
	/* 0x00000550 */ 0x00000580,
	/* 0x00000551 */ 0x00000581,
	/* 0x00000552 */ 0x00000582,
	/* 0x00000553 */ 0x00000583,
	/* 0x00000554 */ 0x00000584,
	/* 0x00000555 */ 0x00000585,
	/* 0x00000556 */ 0x00000586,
	/* 0x00000557 */ 0x00000557
};

uint32_t libfshfs_name_case_folding_mappings_0x000010a0[ 48 ] = {
	/* 0x000010a0 */ 0x00002d00,
	/* 0x000010a1 */ 0x00002d01,
	/* 0x000010a2 */ 0x00002d02,
	/* 0x000010a3 */ 0x00002d03,
	/* 0x000010a4 */ 0x00002d04,
	/* 0x000010a5 */ 0x00002d05,
	/* 0x000010a6 */ 0x00002d06,
	/* 0x000010a7 */ 0x00002d07,
	/* 0x000010a8 */ 0x00002d08,
	/* 0x000010a9 */ 0x00002d09,
	/* 0x000010aa */ 0x00002d0a,
	/* 0x000010ab */ 0x00002d0b,
	/* 0x000010ac */ 0x00002d0c,
	/* 0x000010ad */ 0x00002d0d,
	/* 0x000010ae */ 0x00002d0e,
	/* 0x000010af */ 0x00002d0f,
	/* 0x000010b0 */ 0x00002d10,
	/* 0x000010b1 */ 0x00002d11,
	/* 0x000010b2 */ 0x00002d12,
	/* 0x000010b3 */ 0x00002d13,
	/* 0x000010b4 */ 0x00002d14,
	/* 0x000010b5 */ 0x00002d15,
	/* 0x000010b6 */ 0x00002d16,
	/* 0x000010b7 */ 0x00002d17,
	/* 0x000010b8 */ 0x00002d18,
	/* 0x000010b9 */ 0x00002d19,
	/* 0x000010ba */ 0x00002d1a,
	/* 0x000010bb */ 0x00002d1b,
	/* 0x000010bc */ 0x00002d1c,
	/* 0x000010bd */ 0x00002d1d,
	/* 0x000010be */ 0x00002d1e,
	/* 0x000010bf */ 0x00002d1f,
	/* 0x000010c0 */ 0x00002d20,
	/* 0x000010c1 */ 0x00002d21,
	/* 0x000010c2 */ 0x00002d22,
	/* 0x000010c3 */ 0x00002d23,
	/* 0x000010c4 */ 0x00002d24,
	/* 0x000010c5 */ 0x00002d25,
	/* 0x000010c6 */ 0x000010c6,
	/* 0x000010c7 */ 0x00002d27,
	/* 0x000010c8 */ 0x000010c8,
	/* 0x000010c9 */ 0x000010c9,
	/* 0x000010ca */ 0x000010ca,
	/* 0x000010cb */ 0x000010cb,
	/* 0x000010cc */ 0x000010cc,
	/* 0x000010cd */ 0x00002d2d,
	/* 0x000010ce */ 0x000010ce,
	/* 0x000010cf */ 0x000010cf
};

uint32_t libfshfs_name_case_folding_mappings_0x000013f8[ 8 ] = {
	/* 0x000013f8 */ 0x000013f0,
	/* 0x000013f9 */ 0x000013f1,
	/* 0x000013fa */ 0x000013f2,
	/* 0x000013fb */ 0x000013f3,
	/* 0x000013fc */ 0x000013f4,
	/* 0x000013fd */ 0x000013f5,
	/* 0x000013fe */ 0x000013fe,
	/* 0x000013ff */ 0x000013ff
};

uint32_t libfshfs_name_case_folding_mappings_0x00001c80[ 16 ] = {
	/* 0x00001c80 */ 0x00000432,
	/* 0x00001c81 */ 0x00000434,
	/* 0x00001c82 */ 0x0000043e,
	/* 0x00001c83 */ 0x00000441,
	/* 0x00001c84 */ 0x00000442,
	/* 0x00001c85 */ 0x00000442,
	/* 0x00001c86 */ 0x0000044a,
	/* 0x00001c87 */ 0x00000463,
	/* 0x00001c88 */ 0x0000a64b,
	/* 0x00001c89 */ 0x00001c89,
	/* 0x00001c8a */ 0x00001c8a,
	/* 0x00001c8b */ 0x00001c8b,
	/* 0x00001c8c */ 0x00001c8c,
	/* 0x00001c8d */ 0x00001c8d,
	/* 0x00001c8e */ 0x00001c8e,
	/* 0x00001c8f */ 0x00001c8f
};

uint32_t libfshfs_name_case_folding_mappings_0x00001e00[ 512 ] = {
	/* 0x00001e00 */ 0x00001e01,
	/* 0x00001e01 */ 0x00001e01,
	/* 0x00001e02 */ 0x00001e03,
	/* 0x00001e03 */ 0x00001e03,
	/* 0x00001e04 */ 0x00001e05,
	/* 0x00001e05 */ 0x00001e05,
	/* 0x00001e06 */ 0x00001e07,
	/* 0x00001e07 */ 0x00001e07,
	/* 0x00001e08 */ 0x00001e09,
	/* 0x00001e09 */ 0x00001e09,
	/* 0x00001e0a */ 0x00001e0b,
	/* 0x00001e0b */ 0x00001e0b,
	/* 0x00001e0c */ 0x00001e0d,
	/* 0x00001e0d */ 0x00001e0d,
	/* 0x00001e0e */ 0x00001e0f,
	/* 0x00001e0f */ 0x00001e0f,
	/* 0x00001e10 */ 0x00001e11,
	/* 0x00001e11 */ 0x00001e11,
	/* 0x00001e12 */ 0x00001e13,
	/* 0x00001e13 */ 0x00001e13,
	/* 0x00001e14 */ 0x00001e15,
	/* 0x00001e15 */ 0x00001e15,
	/* 0x00001e16 */ 0x00001e17,
	/* 0x00001e17 */ 0x00001e17,
	/* 0x00001e18 */ 0x00001e19,
	/* 0x00001e19 */ 0x00001e19,
	/* 0x00001e1a */ 0x00001e1b,
	/* 0x00001e1b */ 0x00001e1b,
	/* 0x00001e1c */ 0x00001e1d,
	/* 0x00001e1d */ 0x00001e1d,
	/* 0x00001e1e */ 0x00001e1f,
	/* 0x00001e1f */ 0x00001e1f,
	/* 0x00001e20 */ 0x00001e21,
	/* 0x00001e21 */ 0x00001e21,
	/* 0x00001e22 */ 0x00001e23,
	/* 0x00001e23 */ 0x00001e23,
	/* 0x00001e24 */ 0x00001e25,
	/* 0x00001e25 */ 0x00001e25,
	/* 0x00001e26 */ 0x00001e27,
	/* 0x00001e27 */ 0x00001e27,
	/* 0x00001e28 */ 0x00001e29,
	/* 0x00001e29 */ 0x00001e29,
	/* 0x00001e2a */ 0x00001e2b,
	/* 0x00001e2b */ 0x00001e2b,
	/* 0x00001e2c */ 0x00001e2d,
	/* 0x00001e2d */ 0x00001e2d,
	/* 0x00001e2e */ 0x00001e2f,
	/* 0x00001e2f */ 0x00001e2f,
	/* 0x00001e30 */ 0x00001e31,
	/* 0x00001e31 */ 0x00001e31,
	/* 0x00001e32 */ 0x00001e33,
	/* 0x00001e33 */ 0x00001e33,
	/* 0x00001e34 */ 0x00001e35,
	/* 0x00001e35 */ 0x00001e35,
	/* 0x00001e36 */ 0x00001e37,
	/* 0x00001e37 */ 0x00001e37,
	/* 0x00001e38 */ 0x00001e39,
	/* 0x00001e39 */ 0x00001e39,
	/* 0x00001e3a */ 0x00001e3b,
	/* 0x00001e3b */ 0x00001e3b,
	/* 0x00001e3c */ 0x00001e3d,
	/* 0x00001e3d */ 0x00001e3d,
	/* 0x00001e3e */ 0x00001e3f,
	/* 0x00001e3f */ 0x00001e3f,
	/* 0x00001e40 */ 0x00001e41,
	/* 0x00001e41 */ 0x00001e41,
	/* 0x00001e42 */ 0x00001e43,
	/* 0x00001e43 */ 0x00001e43,
	/* 0x00001e44 */ 0x00001e45,
	/* 0x00001e45 */ 0x00001e45,
	/* 0x00001e46 */ 0x00001e47,
	/* 0x00001e47 */ 0x00001e47,
	/* 0x00001e48 */ 0x00001e49,
	/* 0x00001e49 */ 0x00001e49,
	/* 0x00001e4a */ 0x00001e4b,
	/* 0x00001e4b */ 0x00001e4b,
	/* 0x00001e4c */ 0x00001e4d,
	/* 0x00001e4d */ 0x00001e4d,
	/* 0x00001e4e */ 0x00001e4f,
	/* 0x00001e4f */ 0x00001e4f,
	/* 0x00001e50 */ 0x00001e51,
	/* 0x00001e51 */ 0x00001e51,
	/* 0x00001e52 */ 0x00001e53,
	/* 0x00001e53 */ 0x00001e53,
	/* 0x00001e54 */ 0x00001e55,
	/* 0x00001e55 */ 0x00001e55,
	/* 0x00001e56 */ 0x00001e57,
	/* 0x00001e57 */ 0x00001e57,
	/* 0x00001e58 */ 0x00001e59,
	/* 0x00001e59 */ 0x00001e59,
	/* 0x00001e5a */ 0x00001e5b,
	/* 0x00001e5b */ 0x00001e5b,
	/* 0x00001e5c */ 0x00001e5d,
	/* 0x00001e5d */ 0x00001e5d,
	/* 0x00001e5e */ 0x00001e5f,
	/* 0x00001e5f */ 0x00001e5f,
	/* 0x00001e60 */ 0x00001e61,
	/* 0x00001e61 */ 0x00001e61,
	/* 0x00001e62 */ 0x00001e63,
	/* 0x00001e63 */ 0x00001e63,
	/* 0x00001e64 */ 0x00001e65,
	/* 0x00001e65 */ 0x00001e65,
	/* 0x00001e66 */ 0x00001e67,
	/* 0x00001e67 */ 0x00001e67,
	/* 0x00001e68 */ 0x00001e69,
	/* 0x00001e69 */ 0x00001e69,
	/* 0x00001e6a */ 0x00001e6b,
	/* 0x00001e6b */ 0x00001e6b,
	/* 0x00001e6c */ 0x00001e6d,
	/* 0x00001e6d */ 0x00001e6d,
	/* 0x00001e6e */ 0x00001e6f,
	/* 0x00001e6f */ 0x00001e6f,
	/* 0x00001e70 */ 0x00001e71,
	/* 0x00001e71 */ 0x00001e71,
	/* 0x00001e72 */ 0x00001e73,
	/* 0x00001e73 */ 0x00001e73,
	/* 0x00001e74 */ 0x00001e75,
	/* 0x00001e75 */ 0x00001e75,
	/* 0x00001e76 */ 0x00001e77,
	/* 0x00001e77 */ 0x00001e77,
	/* 0x00001e78 */ 0x00001e79,
	/* 0x00001e79 */ 0x00001e79,
	/* 0x00001e7a */ 0x00001e7b,
	/* 0x00001e7b */ 0x00001e7b,
	/* 0x00001e7c */ 0x00001e7d,
	/* 0x00001e7d */ 0x00001e7d,
	/* 0x00001e7e */ 0x00001e7f,
	/* 0x00001e7f */ 0x00001e7f,
	/* 0x00001e80 */ 0x00001e81,
	/* 0x00001e81 */ 0x00001e81,
	/* 0x00001e82 */ 0x00001e83,
	/* 0x00001e83 */ 0x00001e83,
	/* 0x00001e84 */ 0x00001e85,
	/* 0x00001e85 */ 0x00001e85,
	/* 0x00001e86 */ 0x00001e87,
	/* 0x00001e87 */ 0x00001e87,
	/* 0x00001e88 */ 0x00001e89,
	/* 0x00001e89 */ 0x00001e89,
	/* 0x00001e8a */ 0x00001e8b,
	/* 0x00001e8b */ 0x00001e8b,
	/* 0x00001e8c */ 0x00001e8d,
	/* 0x00001e8d */ 0x00001e8d,
	/* 0x00001e8e */ 0x00001e8f,
	/* 0x00001e8f */ 0x00001e8f,
	/* 0x00001e90 */ 0x00001e91,
	/* 0x00001e91 */ 0x00001e91,
	/* 0x00001e92 */ 0x00001e93,
	/* 0x00001e93 */ 0x00001e93,
	/* 0x00001e94 */ 0x00001e95,
	/* 0x00001e95 */ 0x00001e95,
	/* 0x00001e96 */ 0x00001e96,
	/* 0x00001e97 */ 0x00001e97,
	/* 0x00001e98 */ 0x00001e98,
	/* 0x00001e99 */ 0x00001e99,
	/* 0x00001e9a */ 0x00001e9a,
	/* 0x00001e9b */ 0x00001e61,
	/* 0x00001e9c */ 0x00001e9c,
	/* 0x00001e9d */ 0x00001e9d,
	/* 0x00001e9e */ 0x000000df,
	/* 0x00001e9f */ 0x00001e9f,
	/* 0x00001ea0 */ 0x00001ea1,
	/* 0x00001ea1 */ 0x00001ea1,
	/* 0x00001ea2 */ 0x00001ea3,
	/* 0x00001ea3 */ 0x00001ea3,
	/* 0x00001ea4 */ 0x00001ea5,
	/* 0x00001ea5 */ 0x00001ea5,
	/* 0x00001ea6 */ 0x00001ea7,
	/* 0x00001ea7 */ 0x00001ea7,
	/* 0x00001ea8 */ 0x00001ea9,
	/* 0x00001ea9 */ 0x00001ea9,
	/* 0x00001eaa */ 0x00001eab,
	/* 0x00001eab */ 0x00001eab,
	/* 0x00001eac */ 0x00001ead,
	/* 0x00001ead */ 0x00001ead,
	/* 0x00001eae */ 0x00001eaf,
	/* 0x00001eaf */ 0x00001eaf,
	/* 0x00001eb0 */ 0x00001eb1,
	/* 0x00001eb1 */ 0x00001eb1,
	/* 0x00001eb2 */ 0x00001eb3,
	/* 0x00001eb3 */ 0x00001eb3,
	/* 0x00001eb4 */ 0x00001eb5,
	/* 0x00001eb5 */ 0x00001eb5,
	/* 0x00001eb6 */ 0x00001eb7,
	/* 0x00001eb7 */ 0x00001eb7,
	/* 0x00001eb8 */ 0x00001eb9,
	/* 0x00001eb9 */ 0x00001eb9,
	/* 0x00001eba */ 0x00001ebb,
	/* 0x00001ebb */ 0x00001ebb,
	/* 0x00001ebc */ 0x00001ebd,
	/* 0x00001ebd */ 0x00001ebd,
	/* 0x00001ebe */ 0x00001ebf,
	/* 0x00001ebf */ 0x00001ebf,
	/* 0x00001ec0 */ 0x00001ec1,
	/* 0x00001ec1 */ 0x00001ec1,
	/* 0x00001ec2 */ 0x00001ec3,
	/* 0x00001ec3 */ 0x00001ec3,
	/* 0x00001ec4 */ 0x00001ec5,
	/* 0x00001ec5 */ 0x00001ec5,
	/* 0x00001ec6 */ 0x00001ec7,
	/* 0x00001ec7 */ 0x00001ec7,
	/* 0x00001ec8 */ 0x00001ec9,
	/* 0x00001ec9 */ 0x00001ec9,
	/* 0x00001eca */ 0x00001ecb,
	/* 0x00001ecb */ 0x00001ecb,
	/* 0x00001ecc */ 0x00001ecd,
	/* 0x00001ecd */ 0x00001ecd,
	/* 0x00001ece */ 0x00001ecf,
	/* 0x00001ecf */ 0x00001ecf,
	/* 0x00001ed0 */ 0x00001ed1,
	/* 0x00001ed1 */ 0x00001ed1,
	/* 0x00001ed2 */ 0x00001ed3,
	/* 0x00001ed3 */ 0x00001ed3,
	/* 0x00001ed4 */ 0x00001ed5,
	/* 0x00001ed5 */ 0x00001ed5,
	/* 0x00001ed6 */ 0x00001ed7,
	/* 0x00001ed7 */ 0x00001ed7,
	/* 0x00001ed8 */ 0x00001ed9,
	/* 0x00001ed9 */ 0x00001ed9,
	/* 0x00001eda */ 0x00001edb,
	/* 0x00001edb */ 0x00001edb,
	/* 0x00001edc */ 0x00001edd,
	/* 0x00001edd */ 0x00001edd,
	/* 0x00001ede */ 0x00001edf,
	/* 0x00001edf */ 0x00001edf,
	/* 0x00001ee0 */ 0x00001ee1,
	/* 0x00001ee1 */ 0x00001ee1,
	/* 0x00001ee2 */ 0x00001ee3,
	/* 0x00001ee3 */ 0x00001ee3,
	/* 0x00001ee4 */ 0x00001ee5,
	/* 0x00001ee5 */ 0x00001ee5,
	/* 0x00001ee6 */ 0x00001ee7,
	/* 0x00001ee7 */ 0x00001ee7,
	/* 0x00001ee8 */ 0x00001ee9,
	/* 0x00001ee9 */ 0x00001ee9,
	/* 0x00001eea */ 0x00001eeb,
	/* 0x00001eeb */ 0x00001eeb,
	/* 0x00001eec */ 0x00001eed,
	/* 0x00001eed */ 0x00001eed,
	/* 0x00001eee */ 0x00001eef,
	/* 0x00001eef */ 0x00001eef,
	/* 0x00001ef0 */ 0x00001ef1,
	/* 0x00001ef1 */ 0x00001ef1,
	/* 0x00001ef2 */ 0x00001ef3,
	/* 0x00001ef3 */ 0x00001ef3,
	/* 0x00001ef4 */ 0x00001ef5,
	/* 0x00001ef5 */ 0x00001ef5,
	/* 0x00001ef6 */ 0x00001ef7,
	/* 0x00001ef7 */ 0x00001ef7,
	/* 0x00001ef8 */ 0x00001ef9,
	/* 0x00001ef9 */ 0x00001ef9,
	/* 0x00001efa */ 0x00001efb,
	/* 0x00001efb */ 0x00001efb,
	/* 0x00001efc */ 0x00001efd,
	/* 0x00001efd */ 0x00001efd,
	/* 0x00001efe */ 0x00001eff,
	/* 0x00001eff */ 0x00001eff,
	/* 0x00001f00 */ 0x00001f00,
	/* 0x00001f01 */ 0x00001f01,
	/* 0x00001f02 */ 0x00001f02,
	/* 0x00001f03 */ 0x00001f03,
	/* 0x00001f04 */ 0x00001f04,
	/* 0x00001f05 */ 0x00001f05,
	/* 0x00001f06 */ 0x00001f06,
	/* 0x00001f07 */ 0x00001f07,
	/* 0x00001f08 */ 0x00001f00,
	/* 0x00001f09 */ 0x00001f01,
	/* 0x00001f0a */ 0x00001f02,
	/* 0x00001f0b */ 0x00001f03,
	/* 0x00001f0c */ 0x00001f04,
	/* 0x00001f0d */ 0x00001f05,
	/* 0x00001f0e */ 0x00001f06,
	/* 0x00001f0f */ 0x00001f07,
	/* 0x00001f10 */ 0x00001f10,
	/* 0x00001f11 */ 0x00001f11,
	/* 0x00001f12 */ 0x00001f12,
	/* 0x00001f13 */ 0x00001f13,
	/* 0x00001f14 */ 0x00001f14,
	/* 0x00001f15 */ 0x00001f15,
	/* 0x00001f16 */ 0x00001f16,
	/* 0x00001f17 */ 0x00001f17,
	/* 0x00001f18 */ 0x00001f10,
	/* 0x00001f19 */ 0x00001f11,
	/* 0x00001f1a */ 0x00001f12,
	/* 0x00001f1b */ 0x00001f13,
	/* 0x00001f1c */ 0x00001f14,
	/* 0x00001f1d */ 0x00001f15,
	/* 0x00001f1e */ 0x00001f1e,
	/* 0x00001f1f */ 0x00001f1f,
	/* 0x00001f20 */ 0x00001f20,
	/* 0x00001f21 */ 0x00001f21,
	/* 0x00001f22 */ 0x00001f22,
	/* 0x00001f23 */ 0x00001f23,
	/* 0x00001f24 */ 0x00001f24,
	/* 0x00001f25 */ 0x00001f25,
	/* 0x00001f26 */ 0x00001f26,
	/* 0x00001f27 */ 0x00001f27,
	/* 0x00001f28 */ 0x00001f20,
	/* 0x00001f29 */ 0x00001f21,
	/* 0x00001f2a */ 0x00001f22,
	/* 0x00001f2b */ 0x00001f23,
	/* 0x00001f2c */ 0x00001f24,
	/* 0x00001f2d */ 0x00001f25,
	/* 0x00001f2e */ 0x00001f26,
	/* 0x00001f2f */ 0x00001f27,
	/* 0x00001f30 */ 0x00001f30,
	/* 0x00001f31 */ 0x00001f31,
	/* 0x00001f32 */ 0x00001f32,
	/* 0x00001f33 */ 0x00001f33,
	/* 0x00001f34 */ 0x00001f34,
	/* 0x00001f35 */ 0x00001f35,
	/* 0x00001f36 */ 0x00001f36,
	/* 0x00001f37 */ 0x00001f37,
	/* 0x00001f38 */ 0x00001f30,
	/* 0x00001f39 */ 0x00001f31,
	/* 0x00001f3a */ 0x00001f32,
	/* 0x00001f3b */ 0x00001f33,
	/* 0x00001f3c */ 0x00001f34,
	/* 0x00001f3d */ 0x00001f35,
	/* 0x00001f3e */ 0x00001f36,
	/* 0x00001f3f */ 0x00001f37,
	/* 0x00001f40 */ 0x00001f40,
	/* 0x00001f41 */ 0x00001f41,
	/* 0x00001f42 */ 0x00001f42,
	/* 0x00001f43 */ 0x00001f43,
	/* 0x00001f44 */ 0x00001f44,
	/* 0x00001f45 */ 0x00001f45,
	/* 0x00001f46 */ 0x00001f46,
	/* 0x00001f47 */ 0x00001f47,
	/* 0x00001f48 */ 0x00001f40,
	/* 0x00001f49 */ 0x00001f41,
	/* 0x00001f4a */ 0x00001f42,
	/* 0x00001f4b */ 0x00001f43,
	/* 0x00001f4c */ 0x00001f44,
	/* 0x00001f4d */ 0x00001f45,
	/* 0x00001f4e */ 0x00001f4e,
	/* 0x00001f4f */ 0x00001f4f,
	/* 0x00001f50 */ 0x00001f50,
	/* 0x00001f51 */ 0x00001f51,
	/* 0x00001f52 */ 0x00001f52,
	/* 0x00001f53 */ 0x00001f53,
	/* 0x00001f54 */ 0x00001f54,
	/* 0x00001f55 */ 0x00001f55,
	/* 0x00001f56 */ 0x00001f56,
	/* 0x00001f57 */ 0x00001f57,
	/* 0x00001f58 */ 0x00001f58,
	/* 0x00001f59 */ 0x00001f51,
	/* 0x00001f5a */ 0x00001f5a,
	/* 0x00001f5b */ 0x00001f53,
	/* 0x00001f5c */ 0x00001f5c,
	/* 0x00001f5d */ 0x00001f55,
	/* 0x00001f5e */ 0x00001f5e,
	/* 0x00001f5f */ 0x00001f57,
	/* 0x00001f60 */ 0x00001f60,
	/* 0x00001f61 */ 0x00001f61,
	/* 0x00001f62 */ 0x00001f62,
	/* 0x00001f63 */ 0x00001f63,
	/* 0x00001f64 */ 0x00001f64,
	/* 0x00001f65 */ 0x00001f65,
	/* 0x00001f66 */ 0x00001f66,
	/* 0x00001f67 */ 0x00001f67,
	/* 0x00001f68 */ 0x00001f60,
	/* 0x00001f69 */ 0x00001f61,
	/* 0x00001f6a */ 0x00001f62,
	/* 0x00001f6b */ 0x00001f63,
	/* 0x00001f6c */ 0x00001f64,
	/* 0x00001f6d */ 0x00001f65,
	/* 0x00001f6e */ 0x00001f66,
	/* 0x00001f6f */ 0x00001f67,
	/* 0x00001f70 */ 0x00001f70,
	/* 0x00001f71 */ 0x00001f71,
	/* 0x00001f72 */ 0x00001f72,
	/* 0x00001f73 */ 0x00001f73,
	/* 0x00001f74 */ 0x00001f74,
	/* 0x00001f75 */ 0x00001f75,
	/* 0x00001f76 */ 0x00001f76,
	/* 0x00001f77 */ 0x00001f77,
	/* 0x00001f78 */ 0x00001f78,
	/* 0x00001f79 */ 0x00001f79,
	/* 0x00001f7a */ 0x00001f7a,
	/* 0x00001f7b */ 0x00001f7b,
	/* 0x00001f7c */ 0x00001f7c,
	/* 0x00001f7d */ 0x00001f7d,
	/* 0x00001f7e */ 0x00001f7e,
	/* 0x00001f7f */ 0x00001f7f,
	/* 0x00001f80 */ 0x00001f80,
	/* 0x00001f81 */ 0x00001f81,
	/* 0x00001f82 */ 0x00001f82,
	/* 0x00001f83 */ 0x00001f83,
	/* 0x00001f84 */ 0x00001f84,
	/* 0x00001f85 */ 0x00001f85,
	/* 0x00001f86 */ 0x00001f86,
	/* 0x00001f87 */ 0x00001f87,
	/* 0x00001f88 */ 0x00001f80,
	/* 0x00001f89 */ 0x00001f81,
	/* 0x00001f8a */ 0x00001f82,
	/* 0x00001f8b */ 0x00001f83,
	/* 0x00001f8c */ 0x00001f84,
	/* 0x00001f8d */ 0x00001f85,
	/* 0x00001f8e */ 0x00001f86,
	/* 0x00001f8f */ 0x00001f87,
	/* 0x00001f90 */ 0x00001f90,
	/* 0x00001f91 */ 0x00001f91,
	/* 0x00001f92 */ 0x00001f92,
	/* 0x00001f93 */ 0x00001f93,
	/* 0x00001f94 */ 0x00001f94,
	/* 0x00001f95 */ 0x00001f95,
	/* 0x00001f96 */ 0x00001f96,
	/* 0x00001f97 */ 0x00001f97,
	/* 0x00001f98 */ 0x00001f90,
	/* 0x00001f99 */ 0x00001f91,
	/* 0x00001f9a */ 0x00001f92,
	/* 0x00001f9b */ 0x00001f93,
	/* 0x00001f9c */ 0x00001f94,
	/* 0x00001f9d */ 0x00001f95,
	/* 0x00001f9e */ 0x00001f96,
	/* 0x00001f9f */ 0x00001f97,
	/* 0x00001fa0 */ 0x00001fa0,
	/* 0x00001fa1 */ 0x00001fa1,
	/* 0x00001fa2 */ 0x00001fa2,
	/* 0x00001fa3 */ 0x00001fa3,
	/* 0x00001fa4 */ 0x00001fa4,
	/* 0x00001fa5 */ 0x00001fa5,
	/* 0x00001fa6 */ 0x00001fa6,
	/* 0x00001fa7 */ 0x00001fa7,
	/* 0x00001fa8 */ 0x00001fa0,
	/* 0x00001fa9 */ 0x00001fa1,
	/* 0x00001faa */ 0x00001fa2,
	/* 0x00001fab */ 0x00001fa3,
	/* 0x00001fac */ 0x00001fa4,
	/* 0x00001fad */ 0x00001fa5,
	/* 0x00001fae */ 0x00001fa6,
	/* 0x00001faf */ 0x00001fa7,
	/* 0x00001fb0 */ 0x00001fb0,
	/* 0x00001fb1 */ 0x00001fb1,
	/* 0x00001fb2 */ 0x00001fb2,
	/* 0x00001fb3 */ 0x00001fb3,
	/* 0x00001fb4 */ 0x00001fb4,
	/* 0x00001fb5 */ 0x00001fb5,
	/* 0x00001fb6 */ 0x00001fb6,
	/* 0x00001fb7 */ 0x00001fb7,
	/* 0x00001fb8 */ 0x00001fb0,
	/* 0x00001fb9 */ 0x00001fb1,
	/* 0x00001fba */ 0x00001f70,
	/* 0x00001fbb */ 0x00001f71,
	/* 0x00001fbc */ 0x00001fb3,
	/* 0x00001fbd */ 0x00001fbd,
	/* 0x00001fbe */ 0x000003b9,
	/* 0x00001fbf */ 0x00001fbf,
	/* 0x00001fc0 */ 0x00001fc0,
	/* 0x00001fc1 */ 0x00001fc1,
	/* 0x00001fc2 */ 0x00001fc2,
	/* 0x00001fc3 */ 0x00001fc3,
	/* 0x00001fc4 */ 0x00001fc4,
	/* 0x00001fc5 */ 0x00001fc5,
	/* 0x00001fc6 */ 0x00001fc6,
	/* 0x00001fc7 */ 0x00001fc7,
	/* 0x00001fc8 */ 0x00001f72,
	/* 0x00001fc9 */ 0x00001f73,
	/* 0x00001fca */ 0x00001f74,
	/* 0x00001fcb */ 0x00001f75,
	/* 0x00001fcc */ 0x00001fc3,
	/* 0x00001fcd */ 0x00001fcd,
	/* 0x00001fce */ 0x00001fce,
	/* 0x00001fcf */ 0x00001fcf,
	/* 0x00001fd0 */ 0x00001fd0,
	/* 0x00001fd1 */ 0x00001fd1,
	/* 0x00001fd2 */ 0x00001fd2,
	/* 0x00001fd3 */ 0x00001fd3,
	/* 0x00001fd4 */ 0x00001fd4,
	/* 0x00001fd5 */ 0x00001fd5,
	/* 0x00001fd6 */ 0x00001fd6,
	/* 0x00001fd7 */ 0x00001fd7,
	/* 0x00001fd8 */ 0x00001fd0,
	/* 0x00001fd9 */ 0x00001fd1,
	/* 0x00001fda */ 0x00001f76,
	/* 0x00001fdb */ 0x00001f77,
	/* 0x00001fdc */ 0x00001fdc,
	/* 0x00001fdd */ 0x00001fdd,
	/* 0x00001fde */ 0x00001fde,
	/* 0x00001fdf */ 0x00001fdf,
	/* 0x00001fe0 */ 0x00001fe0,
	/* 0x00001fe1 */ 0x00001fe1,
	/* 0x00001fe2 */ 0x00001fe2,
	/* 0x00001fe3 */ 0x00001fe3,
	/* 0x00001fe4 */ 0x00001fe4,
	/* 0x00001fe5 */ 0x00001fe5,
	/* 0x00001fe6 */ 0x00001fe6,
	/* 0x00001fe7 */ 0x00001fe7,
	/* 0x00001fe8 */ 0x00001fe0,
	/* 0x00001fe9 */ 0x00001fe1,
	/* 0x00001fea */ 0x00001f7a,
	/* 0x00001feb */ 0x00001f7b,
	/* 0x00001fec */ 0x00001fe5,
	/* 0x00001fed */ 0x00001fed,
	/* 0x00001fee */ 0x00001fee,
	/* 0x00001fef */ 0x00001fef,
	/* 0x00001ff0 */ 0x00001ff0,
	/* 0x00001ff1 */ 0x00001ff1,
	/* 0x00001ff2 */ 0x00001ff2,
	/* 0x00001ff3 */ 0x00001ff3,
	/* 0x00001ff4 */ 0x00001ff4,
	/* 0x00001ff5 */ 0x00001ff5,
	/* 0x00001ff6 */ 0x00001ff6,
	/* 0x00001ff7 */ 0x00001ff7,
	/* 0x00001ff8 */ 0x00001f78,
	/* 0x00001ff9 */ 0x00001f79,
	/* 0x00001ffa */ 0x00001f7c,
	/* 0x00001ffb */ 0x00001f7d,
	/* 0x00001ffc */ 0x00001ff3,
	/* 0x00001ffd */ 0x00001ffd,
	/* 0x00001ffe */ 0x00001ffe,
	/* 0x00001fff */ 0x00001fff
};

uint32_t libfshfs_name_case_folding_mappings_0x00002120[ 104 ] = {
	/* 0x00002120 */ 0x00002120,
	/* 0x00002121 */ 0x00002121,
	/* 0x00002122 */ 0x00002122,
	/* 0x00002123 */ 0x00002123,
	/* 0x00002124 */ 0x00002124,
	/* 0x00002125 */ 0x00002125,
	/* 0x00002126 */ 0x000003c9,
	/* 0x00002127 */ 0x00002127,
	/* 0x00002128 */ 0x00002128,
	/* 0x00002129 */ 0x00002129,
	/* 0x0000212a */ 0x0000006b,
	/* 0x0000212b */ 0x000000e5,
	/* 0x0000212c */ 0x0000212c,
	/* 0x0000212d */ 0x0000212d,
	/* 0x0000212e */ 0x0000212e,
	/* 0x0000212f */ 0x0000212f,
	/* 0x00002130 */ 0x00002130,
	/* 0x00002131 */ 0x00002131,
	/* 0x00002132 */ 0x0000214e,
	/* 0x00002133 */ 0x00002133,
	/* 0x00002134 */ 0x00002134,
	/* 0x00002135 */ 0x00002135,
	/* 0x00002136 */ 0x00002136,
	/* 0x00002137 */ 0x00002137,
	/* 0x00002138 */ 0x00002138,
	/* 0x00002139 */ 0x00002139,
	/* 0x0000213a */ 0x0000213a,
	/* 0x0000213b */ 0x0000213b,
	/* 0x0000213c */ 0x0000213c,
	/* 0x0000213d */ 0x0000213d,
	/* 0x0000213e */ 0x0000213e,
	/* 0x0000213f */ 0x0000213f,
	/* 0x00002140 */ 0x00002140,
	/* 0x00002141 */ 0x00002141,
	/* 0x00002142 */ 0x00002142,
	/* 0x00002143 */ 0x00002143,
	/* 0x00002144 */ 0x00002144,
	/* 0x00002145 */ 0x00002145,
	/* 0x00002146 */ 0x00002146,
	/* 0x00002147 */ 0x00002147,
	/* 0x00002148 */ 0x00002148,
	/* 0x00002149 */ 0x00002149,
	/* 0x0000214a */ 0x0000214a,
	/* 0x0000214b */ 0x0000214b,
	/* 0x0000214c */ 0x0000214c,
	/* 0x0000214d */ 0x0000214d,
	/* 0x0000214e */ 0x0000214e,
	/* 0x0000214f */ 0x0000214f,
	/* 0x00002150 */ 0x00002150,
	/* 0x00002151 */ 0x00002151,
	/* 0x00002152 */ 0x00002152,
	/* 0x00002153 */ 0x00002153,
	/* 0x00002154 */ 0x00002154,
	/* 0x00002155 */ 0x00002155,
	/* 0x00002156 */ 0x00002156,
	/* 0x00002157 */ 0x00002157,
	/* 0x00002158 */ 0x00002158,
	/* 0x00002159 */ 0x00002159,
	/* 0x0000215a */ 0x0000215a,
	/* 0x0000215b */ 0x0000215b,
	/* 0x0000215c */ 0x0000215c,
	/* 0x0000215d */ 0x0000215d,
	/* 0x0000215e */ 0x0000215e,
	/* 0x0000215f */ 0x0000215f,
	/* 0x00002160 */ 0x00002170,
	/* 0x00002161 */ 0x00002171,
	/* 0x00002162 */ 0x00002172,
	/* 0x00002163 */ 0x00002173,
	/* 0x00002164 */ 0x00002174,
	/* 0x00002165 */ 0x00002175,
	/* 0x00002166 */ 0x00002176,
	/* 0x00002167 */ 0x00002177,
	/* 0x00002168 */ 0x00002178,
	/* 0x00002169 */ 0x00002179,
	/* 0x0000216a */ 0x0000217a,
	/* 0x0000216b */ 0x0000217b,
	/* 0x0000216c */ 0x0000217c,
	/* 0x0000216d */ 0x0000217d,
	/* 0x0000216e */ 0x0000217e,
	/* 0x0000216f */ 0x0000217f,
	/* 0x00002170 */ 0x00002170,
	/* 0x00002171 */ 0x00002171,
	/* 0x00002172 */ 0x00002172,
	/* 0x00002173 */ 0x00002173,
	/* 0x00002174 */ 0x00002174,
	/* 0x00002175 */ 0x00002175,
	/* 0x00002176 */ 0x00002176,
	/* 0x00002177 */ 0x00002177,
	/* 0x00002178 */ 0x00002178,
	/* 0x00002179 */ 0x00002179,
	/* 0x0000217a */ 0x0000217a,
	/* 0x0000217b */ 0x0000217b,
	/* 0x0000217c */ 0x0000217c,
	/* 0x0000217d */ 0x0000217d,
	/* 0x0000217e */ 0x0000217e,
	/* 0x0000217f */ 0x0000217f,
	/* 0x00002180 */ 0x00002180,
	/* 0x00002181 */ 0x00002181,
	/* 0x00002182 */ 0x00002182,
	/* 0x00002183 */ 0x00002184,
	/* 0x00002184 */ 0x00002184,
	/* 0x00002185 */ 0x00002185,
	/* 0x00002186 */ 0x00002186,
	/* 0x00002187 */ 0x00002187
};

uint32_t libfshfs_name_case_folding_mappings_0x000024b0[ 32 ] = {
	/* 0x000024b0 */ 0x000024b0,
	/* 0x000024b1 */ 0x000024b1,
	/* 0x000024b2 */ 0x000024b2,
	/* 0x000024b3 */ 0x000024b3,
	/* 0x000024b4 */ 0x000024b4,
	/* 0x000024b5 */ 0x000024b5,
	/* 0x000024b6 */ 0x000024d0,
	/* 0x000024b7 */ 0x000024d1,
	/* 0x000024b8 */ 0x000024d2,
	/* 0x000024b9 */ 0x000024d3,
	/* 0x000024ba */ 0x000024d4,
	/* 0x000024bb */ 0x000024d5,
	/* 0x000024bc */ 0x000024d6,
	/* 0x000024bd */ 0x000024d7,
	/* 0x000024be */ 0x000024d8,
	/* 0x000024bf */ 0x000024d9,
	/* 0x000024c0 */ 0x000024da,
	/* 0x000024c1 */ 0x000024db,
	/* 0x000024c2 */ 0x000024dc,
	/* 0x000024c3 */ 0x000024dd,
	/* 0x000024c4 */ 0x000024de,
	/* 0x000024c5 */ 0x000024df,
	/* 0x000024c6 */ 0x000024e0,
	/* 0x000024c7 */ 0x000024e1,
	/* 0x000024c8 */ 0x000024e2,
	/* 0x000024c9 */ 0x000024e3,
	/* 0x000024ca */ 0x000024e4,
	/* 0x000024cb */ 0x000024e5,
	/* 0x000024cc */ 0x000024e6,
	/* 0x000024cd */ 0x000024e7,
	/* 0x000024ce */ 0x000024e8,
	/* 0x000024cf */ 0x000024e9
};

uint32_t libfshfs_name_case_folding_mappings_0x00002c00[ 248 ] = {
	/* 0x00002c00 */ 0x00002c30,
	/* 0x00002c01 */ 0x00002c31,
	/* 0x00002c02 */ 0x00002c32,
	/* 0x00002c03 */ 0x00002c33,
	/* 0x00002c04 */ 0x00002c34,
	/* 0x00002c05 */ 0x00002c35,
	/* 0x00002c06 */ 0x00002c36,
	/* 0x00002c07 */ 0x00002c37,
	/* 0x00002c08 */ 0x00002c38,
	/* 0x00002c09 */ 0x00002c39,
	/* 0x00002c0a */ 0x00002c3a,
	/* 0x00002c0b */ 0x00002c3b,
	/* 0x00002c0c */ 0x00002c3c,
	/* 0x00002c0d */ 0x00002c3d,
	/* 0x00002c0e */ 0x00002c3e,
	/* 0x00002c0f */ 0x00002c3f,
	/* 0x00002c10 */ 0x00002c40,
	/* 0x00002c11 */ 0x00002c41,
	/* 0x00002c12 */ 0x00002c42,
	/* 0x00002c13 */ 0x00002c43,
	/* 0x00002c14 */ 0x00002c44,
	/* 0x00002c15 */ 0x00002c45,
	/* 0x00002c16 */ 0x00002c46,
	/* 0x00002c17 */ 0x00002c47,
	/* 0x00002c18 */ 0x00002c48,
	/* 0x00002c19 */ 0x00002c49,
	/* 0x00002c1a */ 0x00002c4a,
	/* 0x00002c1b */ 0x00002c4b,
	/* 0x00002c1c */ 0x00002c4c,
	/* 0x00002c1d */ 0x00002c4d,
	/* 0x00002c1e */ 0x00002c4e,
	/* 0x00002c1f */ 0x00002c4f,
	/* 0x00002c20 */ 0x00002c50,
	/* 0x00002c21 */ 0x00002c51,
	/* 0x00002c22 */ 0x00002c52,
	/* 0x00002c23 */ 0x00002c53,
	/* 0x00002c24 */ 0x00002c54,
	/* 0x00002c25 */ 0x00002c55,
	/* 0x00002c26 */ 0x00002c56,
	/* 0x00002c27 */ 0x00002c57,
	/* 0x00002c28 */ 0x00002c58,
	/* 0x00002c29 */ 0x00002c59,
	/* 0x00002c2a */ 0x00002c5a,
	/* 0x00002c2b */ 0x00002c5b,
	/* 0x00002c2c */ 0x00002c5c,
	/* 0x00002c2d */ 0x00002c5d,
	/* 0x00002c2e */ 0x00002c5e,
	/* 0x00002c2f */ 0x00002c2f,
	/* 0x00002c30 */ 0x00002c30,
	/* 0x00002c31 */ 0x00002c31,
	/* 0x00002c32 */ 0x00002c32,
	/* 0x00002c33 */ 0x00002c33,
	/* 0x00002c34 */ 0x00002c34,
	/* 0x00002c35 */ 0x00002c35,
	/* 0x00002c36 */ 0x00002c36,
	/* 0x00002c37 */ 0x00002c37,
	/* 0x00002c38 */ 0x00002c38,
	/* 0x00002c39 */ 0x00002c39,
	/* 0x00002c3a */ 0x00002c3a,
	/* 0x00002c3b */ 0x00002c3b,
	/* 0x00002c3c */ 0x00002c3c,
	/* 0x00002c3d */ 0x00002c3d,
	/* 0x00002c3e */ 0x00002c3e,
	/* 0x00002c3f */ 0x00002c3f,
	/* 0x00002c40 */ 0x00002c40,
	/* 0x00002c41 */ 0x00002c41,
	/* 0x00002c42 */ 0x00002c42,
	/* 0x00002c43 */ 0x00002c43,
	/* 0x00002c44 */ 0x00002c44,
	/* 0x00002c45 */ 0x00002c45,
	/* 0x00002c46 */ 0x00002c46,
	/* 0x00002c47 */ 0x00002c47,
	/* 0x00002c48 */ 0x00002c48,
	/* 0x00002c49 */ 0x00002c49,
	/* 0x00002c4a */ 0x00002c4a,
	/* 0x00002c4b */ 0x00002c4b,
	/* 0x00002c4c */ 0x00002c4c,
	/* 0x00002c4d */ 0x00002c4d,
	/* 0x00002c4e */ 0x00002c4e,
	/* 0x00002c4f */ 0x00002c4f,
	/* 0x00002c50 */ 0x00002c50,
	/* 0x00002c51 */ 0x00002c51,
	/* 0x00002c52 */ 0x00002c52,
	/* 0x00002c53 */ 0x00002c53,
	/* 0x00002c54 */ 0x00002c54,
	/* 0x00002c55 */ 0x00002c55,
	/* 0x00002c56 */ 0x00002c56,
	/* 0x00002c57 */ 0x00002c57,
	/* 0x00002c58 */ 0x00002c58,
	/* 0x00002c59 */ 0x00002c59,
	/* 0x00002c5a */ 0x00002c5a,
	/* 0x00002c5b */ 0x00002c5b,
	/* 0x00002c5c */ 0x00002c5c,
	/* 0x00002c5d */ 0x00002c5d,
	/* 0x00002c5e */ 0x00002c5e,
	/* 0x00002c5f */ 0x00002c5f,
	/* 0x00002c60 */ 0x00002c61,
	/* 0x00002c61 */ 0x00002c61,
	/* 0x00002c62 */ 0x0000026b,
	/* 0x00002c63 */ 0x00001d7d,
	/* 0x00002c64 */ 0x0000027d,
	/* 0x00002c65 */ 0x00002c65,
	/* 0x00002c66 */ 0x00002c66,
	/* 0x00002c67 */ 0x00002c68,
	/* 0x00002c68 */ 0x00002c68,
	/* 0x00002c69 */ 0x00002c6a,
	/* 0x00002c6a */ 0x00002c6a,
	/* 0x00002c6b */ 0x00002c6c,
	/* 0x00002c6c */ 0x00002c6c,
	/* 0x00002c6d */ 0x00000251,
	/* 0x00002c6e */ 0x00000271,
	/* 0x00002c6f */ 0x00000250,
	/* 0x00002c70 */ 0x00000252,
	/* 0x00002c71 */ 0x00002c71,
	/* 0x00002c72 */ 0x00002c73,
	/* 0x00002c73 */ 0x00002c73,
	/* 0x00002c74 */ 0x00002c74,
	/* 0x00002c75 */ 0x00002c76,
	/* 0x00002c76 */ 0x00002c76,
	/* 0x00002c77 */ 0x00002c77,
	/* 0x00002c78 */ 0x00002c78,
	/* 0x00002c79 */ 0x00002c79,
	/* 0x00002c7a */ 0x00002c7a,
	/* 0x00002c7b */ 0x00002c7b,
	/* 0x00002c7c */ 0x00002c7c,
	/* 0x00002c7d */ 0x00002c7d,
	/* 0x00002c7e */ 0x0000023f,
	/* 0x00002c7f */ 0x00000240,
	/* 0x00002c80 */ 0x00002c81,
	/* 0x00002c81 */ 0x00002c81,
	/* 0x00002c82 */ 0x00002c83,
	/* 0x00002c83 */ 0x00002c83,
	/* 0x00002c84 */ 0x00002c85,
	/* 0x00002c85 */ 0x00002c85,
	/* 0x00002c86 */ 0x00002c87,
	/* 0x00002c87 */ 0x00002c87,
	/* 0x00002c88 */ 0x00002c89,
	/* 0x00002c89 */ 0x00002c89,
	/* 0x00002c8a */ 0x00002c8b,
	/* 0x00002c8b */ 0x00002c8b,
	/* 0x00002c8c */ 0x00002c8d,
	/* 0x00002c8d */ 0x00002c8d,
	/* 0x00002c8e */ 0x00002c8f,
	/* 0x00002c8f */ 0x00002c8f,
	/* 0x00002c90 */ 0x00002c91,
	/* 0x00002c91 */ 0x00002c91,
	/* 0x00002c92 */ 0x00002c93,
	/* 0x00002c93 */ 0x00002c93,
	/* 0x00002c94 */ 0x00002c95,
	/* 0x00002c95 */ 0x00002c95,
	/* 0x00002c96 */ 0x00002c97,
	/* 0x00002c97 */ 0x00002c97,
	/* 0x00002c98 */ 0x00002c99,
	/* 0x00002c99 */ 0x00002c99,
	/* 0x00002c9a */ 0x00002c9b,
	/* 0x00002c9b */ 0x00002c9b,
	/* 0x00002c9c */ 0x00002c9d,
	/* 0x00002c9d */ 0x00002c9d,
	/* 0x00002c9e */ 0x00002c9f,
	/* 0x00002c9f */ 0x00002c9f,
	/* 0x00002ca0 */ 0x00002ca1,
	/* 0x00002ca1 */ 0x00002ca1,
	/* 0x00002ca2 */ 0x00002ca3,
	/* 0x00002ca3 */ 0x00002ca3,
	/* 0x00002ca4 */ 0x00002ca5,
	/* 0x00002ca5 */ 0x00002ca5,
	/* 0x00002ca6 */ 0x00002ca7,
	/* 0x00002ca7 */ 0x00002ca7,
	/* 0x00002ca8 */ 0x00002ca9,
	/* 0x00002ca9 */ 0x00002ca9,
	/* 0x00002caa */ 0x00002cab,
	/* 0x00002cab */ 0x00002cab,
	/* 0x00002cac */ 0x00002cad,
	/* 0x00002cad */ 0x00002cad,
	/* 0x00002cae */ 0x00002caf,
	/* 0x00002caf */ 0x00002caf,
	/* 0x00002cb0 */ 0x00002cb1,
	/* 0x00002cb1 */ 0x00002cb1,
	/* 0x00002cb2 */ 0x00002cb3,
	/* 0x00002cb3 */ 0x00002cb3,
	/* 0x00002cb4 */ 0x00002cb5,
	/* 0x00002cb5 */ 0x00002cb5,
	/* 0x00002cb6 */ 0x00002cb7,
	/* 0x00002cb7 */ 0x00002cb7,
	/* 0x00002cb8 */ 0x00002cb9,
	/* 0x00002cb9 */ 0x00002cb9,
	/* 0x00002cba */ 0x00002cbb,
	/* 0x00002cbb */ 0x00002cbb,
	/* 0x00002cbc */ 0x00002cbd,
	/* 0x00002cbd */ 0x00002cbd,
	/* 0x00002cbe */ 0x00002cbf,
	/* 0x00002cbf */ 0x00002cbf,
	/* 0x00002cc0 */ 0x00002cc1,
	/* 0x00002cc1 */ 0x00002cc1,
	/* 0x00002cc2 */ 0x00002cc3,
	/* 0x00002cc3 */ 0x00002cc3,
	/* 0x00002cc4 */ 0x00002cc5,
	/* 0x00002cc5 */ 0x00002cc5,
	/* 0x00002cc6 */ 0x00002cc7,
	/* 0x00002cc7 */ 0x00002cc7,
	/* 0x00002cc8 */ 0x00002cc9,
	/* 0x00002cc9 */ 0x00002cc9,
	/* 0x00002cca */ 0x00002ccb,
	/* 0x00002ccb */ 0x00002ccb,
	/* 0x00002ccc */ 0x00002ccd,
	/* 0x00002ccd */ 0x00002ccd,
	/* 0x00002cce */ 0x00002ccf,
	/* 0x00002ccf */ 0x00002ccf,
	/* 0x00002cd0 */ 0x00002cd1,
	/* 0x00002cd1 */ 0x00002cd1,
	/* 0x00002cd2 */ 0x00002cd3,
	/* 0x00002cd3 */ 0x00002cd3,
	/* 0x00002cd4 */ 0x00002cd5,
	/* 0x00002cd5 */ 0x00002cd5,
	/* 0x00002cd6 */ 0x00002cd7,
	/* 0x00002cd7 */ 0x00002cd7,
	/* 0x00002cd8 */ 0x00002cd9,
	/* 0x00002cd9 */ 0x00002cd9,
	/* 0x00002cda */ 0x00002cdb,
	/* 0x00002cdb */ 0x00002cdb,
	/* 0x00002cdc */ 0x00002cdd,
	/* 0x00002cdd */ 0x00002cdd,
	/* 0x00002cde */ 0x00002cdf,
	/* 0x00002cdf */ 0x00002cdf,
	/* 0x00002ce0 */ 0x00002ce1,
	/* 0x00002ce1 */ 0x00002ce1,
	/* 0x00002ce2 */ 0x00002ce3,
	/* 0x00002ce3 */ 0x00002ce3,
	/* 0x00002ce4 */ 0x00002ce4,
	/* 0x00002ce5 */ 0x00002ce5,
	/* 0x00002ce6 */ 0x00002ce6,
	/* 0x00002ce7 */ 0x00002ce7,
	/* 0x00002ce8 */ 0x00002ce8,
	/* 0x00002ce9 */ 0x00002ce9,
	/* 0x00002cea */ 0x00002cea,
	/* 0x00002ceb */ 0x00002cec,
	/* 0x00002cec */ 0x00002cec,
	/* 0x00002ced */ 0x00002cee,
	/* 0x00002cee */ 0x00002cee,
	/* 0x00002cef */ 0x00002cef,
	/* 0x00002cf0 */ 0x00002cf0,
	/* 0x00002cf1 */ 0x00002cf1,
	/* 0x00002cf2 */ 0x00002cf3,
	/* 0x00002cf3 */ 0x00002cf3,
	/* 0x00002cf4 */ 0x00002cf4,
	/* 0x00002cf5 */ 0x00002cf5,
	/* 0x00002cf6 */ 0x00002cf6,
	/* 0x00002cf7 */ 0x00002cf7
};

uint32_t libfshfs_name_case_folding_mappings_0x0000a640[ 96 ] = {
	/* 0x0000a640 */ 0x0000a641,
	/* 0x0000a641 */ 0x0000a641,
	/* 0x0000a642 */ 0x0000a643,
	/* 0x0000a643 */ 0x0000a643,
	/* 0x0000a644 */ 0x0000a645,
	/* 0x0000a645 */ 0x0000a645,
	/* 0x0000a646 */ 0x0000a647,
	/* 0x0000a647 */ 0x0000a647,
	/* 0x0000a648 */ 0x0000a649,
	/* 0x0000a649 */ 0x0000a649,
	/* 0x0000a64a */ 0x0000a64b,
	/* 0x0000a64b */ 0x0000a64b,
	/* 0x0000a64c */ 0x0000a64d,
	/* 0x0000a64d */ 0x0000a64d,
	/* 0x0000a64e */ 0x0000a64f,
	/* 0x0000a64f */ 0x0000a64f,
	/* 0x0000a650 */ 0x0000a651,
	/* 0x0000a651 */ 0x0000a651,
	/* 0x0000a652 */ 0x0000a653,
	/* 0x0000a653 */ 0x0000a653,
	/* 0x0000a654 */ 0x0000a655,
	/* 0x0000a655 */ 0x0000a655,
	/* 0x0000a656 */ 0x0000a657,
	/* 0x0000a657 */ 0x0000a657,
	/* 0x0000a658 */ 0x0000a659,
	/* 0x0000a659 */ 0x0000a659,
	/* 0x0000a65a */ 0x0000a65b,
	/* 0x0000a65b */ 0x0000a65b,
	/* 0x0000a65c */ 0x0000a65d,
	/* 0x0000a65d */ 0x0000a65d,
	/* 0x0000a65e */ 0x0000a65f,
	/* 0x0000a65f */ 0x0000a65f,
	/* 0x0000a660 */ 0x0000a661,
	/* 0x0000a661 */ 0x0000a661,
	/* 0x0000a662 */ 0x0000a663,
	/* 0x0000a663 */ 0x0000a663,
	/* 0x0000a664 */ 0x0000a665,
	/* 0x0000a665 */ 0x0000a665,
	/* 0x0000a666 */ 0x0000a667,
	/* 0x0000a667 */ 0x0000a667,
	/* 0x0000a668 */ 0x0000a669,
	/* 0x0000a669 */ 0x0000a669,
	/* 0x0000a66a */ 0x0000a66b,
	/* 0x0000a66b */ 0x0000a66b,
	/* 0x0000a66c */ 0x0000a66d,
	/* 0x0000a66d */ 0x0000a66d,
	/* 0x0000a66e */ 0x0000a66e,
	/* 0x0000a66f */ 0x0000a66f,
	/* 0x0000a670 */ 0x0000a670,
	/* 0x0000a671 */ 0x0000a671,
	/* 0x0000a672 */ 0x0000a672,
	/* 0x0000a673 */ 0x0000a673,
	/* 0x0000a674 */ 0x0000a674,
	/* 0x0000a675 */ 0x0000a675,
	/* 0x0000a676 */ 0x0000a676,
	/* 0x0000a677 */ 0x0000a677,
	/* 0x0000a678 */ 0x0000a678,
	/* 0x0000a679 */ 0x0000a679,
	/* 0x0000a67a */ 0x0000a67a,
	/* 0x0000a67b */ 0x0000a67b,
	/* 0x0000a67c */ 0x0000a67c,
	/* 0x0000a67d */ 0x0000a67d,
	/* 0x0000a67e */ 0x0000a67e,
	/* 0x0000a67f */ 0x0000a67f,
	/* 0x0000a680 */ 0x0000a681,
	/* 0x0000a681 */ 0x0000a681,
	/* 0x0000a682 */ 0x0000a683,
	/* 0x0000a683 */ 0x0000a683,
	/* 0x0000a684 */ 0x0000a685,
	/* 0x0000a685 */ 0x0000a685,
	/* 0x0000a686 */ 0x0000a687,
	/* 0x0000a687 */ 0x0000a687,
	/* 0x0000a688 */ 0x0000a689,
	/* 0x0000a689 */ 0x0000a689,
	/* 0x0000a68a */ 0x0000a68b,
	/* 0x0000a68b */ 0x0000a68b,
	/* 0x0000a68c */ 0x0000a68d,
	/* 0x0000a68d */ 0x0000a68d,
	/* 0x0000a68e */ 0x0000a68f,
	/* 0x0000a68f */ 0x0000a68f,
	/* 0x0000a690 */ 0x0000a691,
	/* 0x0000a691 */ 0x0000a691,
	/* 0x0000a692 */ 0x0000a693,
	/* 0x0000a693 */ 0x0000a693,
	/* 0x0000a694 */ 0x0000a695,
	/* 0x0000a695 */ 0x0000a695,
	/* 0x0000a696 */ 0x0000a697,
	/* 0x0000a697 */ 0x0000a697,
	/* 0x0000a698 */ 0x0000a699,
	/* 0x0000a699 */ 0x0000a699,
	/* 0x0000a69a */ 0x0000a69b,
	/* 0x0000a69b */ 0x0000a69b,
	/* 0x0000a69c */ 0x0000a69c,
	/* 0x0000a69d */ 0x0000a69d,
	/* 0x0000a69e */ 0x0000a69e,
	/* 0x0000a69f */ 0x0000a69f
};

uint32_t libfshfs_name_case_folding_mappings_0x0000a720[ 152 ] = {
	/* 0x0000a720 */ 0x0000a720,
	/* 0x0000a721 */ 0x0000a721,
	/* 0x0000a722 */ 0x0000a723,
	/* 0x0000a723 */ 0x0000a723,
	/* 0x0000a724 */ 0x0000a725,
	/* 0x0000a725 */ 0x0000a725,
	/* 0x0000a726 */ 0x0000a727,
	/* 0x0000a727 */ 0x0000a727,
	/* 0x0000a728 */ 0x0000a729,
	/* 0x0000a729 */ 0x0000a729,
	/* 0x0000a72a */ 0x0000a72b,
	/* 0x0000a72b */ 0x0000a72b,
	/* 0x0000a72c */ 0x0000a72d,
	/* 0x0000a72d */ 0x0000a72d,
	/* 0x0000a72e */ 0x0000a72f,
	/* 0x0000a72f */ 0x0000a72f,
	/* 0x0000a730 */ 0x0000a730,
	/* 0x0000a731 */ 0x0000a731,
	/* 0x0000a732 */ 0x0000a733,
	/* 0x0000a733 */ 0x0000a733,
	/* 0x0000a734 */ 0x0000a735,
	/* 0x0000a735 */ 0x0000a735,
	/* 0x0000a736 */ 0x0000a737,
	/* 0x0000a737 */ 0x0000a737,
	/* 0x0000a738 */ 0x0000a739,
	/* 0x0000a739 */ 0x0000a739,
	/* 0x0000a73a */ 0x0000a73b,
	/* 0x0000a73b */ 0x0000a73b,
	/* 0x0000a73c */ 0x0000a73d,
	/* 0x0000a73d */ 0x0000a73d,
	/* 0x0000a73e */ 0x0000a73f,
	/* 0x0000a73f */ 0x0000a73f,
	/* 0x0000a740 */ 0x0000a741,
	/* 0x0000a741 */ 0x0000a741,
	/* 0x0000a742 */ 0x0000a743,
	/* 0x0000a743 */ 0x0000a743,
	/* 0x0000a744 */ 0x0000a745,
	/* 0x0000a745 */ 0x0000a745,
	/* 0x0000a746 */ 0x0000a747,
	/* 0x0000a747 */ 0x0000a747,
	/* 0x0000a748 */ 0x0000a749,
	/* 0x0000a749 */ 0x0000a749,
	/* 0x0000a74a */ 0x0000a74b,
	/* 0x0000a74b */ 0x0000a74b,
	/* 0x0000a74c */ 0x0000a74d,
	/* 0x0000a74d */ 0x0000a74d,
	/* 0x0000a74e */ 0x0000a74f,
	/* 0x0000a74f */ 0x0000a74f,
	/* 0x0000a750 */ 0x0000a751,
	/* 0x0000a751 */ 0x0000a751,
	/* 0x0000a752 */ 0x0000a753,
	/* 0x0000a753 */ 0x0000a753,
	/* 0x0000a754 */ 0x0000a755,
	/* 0x0000a755 */ 0x0000a755,
	/* 0x0000a756 */ 0x0000a757,
	/* 0x0000a757 */ 0x0000a757,
	/* 0x0000a758 */ 0x0000a759,
	/* 0x0000a759 */ 0x0000a759,
	/* 0x0000a75a */ 0x0000a75b,
	/* 0x0000a75b */ 0x0000a75b,
	/* 0x0000a75c */ 0x0000a75d,
	/* 0x0000a75d */ 0x0000a75d,
	/* 0x0000a75e */ 0x0000a75f,
	/* 0x0000a75f */ 0x0000a75f,
	/* 0x0000a760 */ 0x0000a761,
	/* 0x0000a761 */ 0x0000a761,
	/* 0x0000a762 */ 0x0000a763,
	/* 0x0000a763 */ 0x0000a763,
	/* 0x0000a764 */ 0x0000a765,
	/* 0x0000a765 */ 0x0000a765,
	/* 0x0000a766 */ 0x0000a767,
	/* 0x0000a767 */ 0x0000a767,
	/* 0x0000a768 */ 0x0000a769,
	/* 0x0000a769 */ 0x0000a769,
	/* 0x0000a76a */ 0x0000a76b,
	/* 0x0000a76b */ 0x0000a76b,
	/* 0x0000a76c */ 0x0000a76d,
	/* 0x0000a76d */ 0x0000a76d,
	/* 0x0000a76e */ 0x0000a76f,
	/* 0x0000a76f */ 0x0000a76f,
	/* 0x0000a770 */ 0x0000a770,
	/* 0x0000a771 */ 0x0000a771,
	/* 0x0000a772 */ 0x0000a772,
	/* 0x0000a773 */ 0x0000a773,
	/* 0x0000a774 */ 0x0000a774,
	/* 0x0000a775 */ 0x0000a775,
	/* 0x0000a776 */ 0x0000a776,
	/* 0x0000a777 */ 0x0000a777,
	/* 0x0000a778 */ 0x0000a778,
	/* 0x0000a779 */ 0x0000a77a,
	/* 0x0000a77a */ 0x0000a77a,
	/* 0x0000a77b */ 0x0000a77c,
	/* 0x0000a77c */ 0x0000a77c,
	/* 0x0000a77d */ 0x00001d79,
	/* 0x0000a77e */ 0x0000a77f,
	/* 0x0000a77f */ 0x0000a77f,
	/* 0x0000a780 */ 0x0000a781,
	/* 0x0000a781 */ 0x0000a781,
	/* 0x0000a782 */ 0x0000a783,
	/* 0x0000a783 */ 0x0000a783,
	/* 0x0000a784 */ 0x0000a785,
	/* 0x0000a785 */ 0x0000a785,
	/* 0x0000a786 */ 0x0000a787,
	/* 0x0000a787 */ 0x0000a787,
	/* 0x0000a788 */ 0x0000a788,
	/* 0x0000a789 */ 0x0000a789,
	/* 0x0000a78a */ 0x0000a78a,
	/* 0x0000a78b */ 0x0000a78c,
	/* 0x0000a78c */ 0x0000a78c,
	/* 0x0000a78d */ 0x00000265,
	/* 0x0000a78e */ 0x0000a78e,
	/* 0x0000a78f */ 0x0000a78f,
	/* 0x0000a790 */ 0x0000a791,
	/* 0x0000a791 */ 0x0000a791,
	/* 0x0000a792 */ 0x0000a793,
	/* 0x0000a793 */ 0x0000a793,
	/* 0x0000a794 */ 0x0000a794,
	/* 0x0000a795 */ 0x0000a795,
	/* 0x0000a796 */ 0x0000a797,
	/* 0x0000a797 */ 0x0000a797,
	/* 0x0000a798 */ 0x0000a799,
	/* 0x0000a799 */ 0x0000a799,
	/* 0x0000a79a */ 0x0000a79b,
	/* 0x0000a79b */ 0x0000a79b,
	/* 0x0000a79c */ 0x0000a79d,
	/* 0x0000a79d */ 0x0000a79d,
	/* 0x0000a79e */ 0x0000a79f,
	/* 0x0000a79f */ 0x0000a79f,
	/* 0x0000a7a0 */ 0x0000a7a1,
	/* 0x0000a7a1 */ 0x0000a7a1,
	/* 0x0000a7a2 */ 0x0000a7a3,
	/* 0x0000a7a3 */ 0x0000a7a3,
	/* 0x0000a7a4 */ 0x0000a7a5,
	/* 0x0000a7a5 */ 0x0000a7a5,
	/* 0x0000a7a6 */ 0x0000a7a7,
	/* 0x0000a7a7 */ 0x0000a7a7,
	/* 0x0000a7a8 */ 0x0000a7a9,
	/* 0x0000a7a9 */ 0x0000a7a9,
	/* 0x0000a7aa */ 0x00000266,
	/* 0x0000a7ab */ 0x0000025c,
	/* 0x0000a7ac */ 0x00000261,
	/* 0x0000a7ad */ 0x0000026c,
	/* 0x0000a7ae */ 0x0000026a,
	/* 0x0000a7af */ 0x0000a7af,
	/* 0x0000a7b0 */ 0x0000029e,
	/* 0x0000a7b1 */ 0x00000287,
	/* 0x0000a7b2 */ 0x0000029d,
	/* 0x0000a7b3 */ 0x0000ab53,
	/* 0x0000a7b4 */ 0x0000a7b5,
	/* 0x0000a7b5 */ 0x0000a7b5,
	/* 0x0000a7b6 */ 0x0000a7b7,
	/* 0x0000a7b7 */ 0x0000a7b7
};

uint32_t libfshfs_name_case_folding_mappings_0x0000ab70[ 80 ] = {
	/* 0x0000ab70 */ 0x000013a0,
	/* 0x0000ab71 */ 0x000013a1,
	/* 0x0000ab72 */ 0x000013a2,
	/* 0x0000ab73 */ 0x000013a3,
	/* 0x0000ab74 */ 0x000013a4,
	/* 0x0000ab75 */ 0x000013a5,
	/* 0x0000ab76 */ 0x000013a6,
	/* 0x0000ab77 */ 0x000013a7,
	/* 0x0000ab78 */ 0x000013a8,
	/* 0x0000ab79 */ 0x000013a9,
	/* 0x0000ab7a */ 0x000013aa,
	/* 0x0000ab7b */ 0x000013ab,
	/* 0x0000ab7c */ 0x000013ac,
	/* 0x0000ab7d */ 0x000013ad,
	/* 0x0000ab7e */ 0x000013ae,
	/* 0x0000ab7f */ 0x000013af,
	/* 0x0000ab80 */ 0x000013b0,
	/* 0x0000ab81 */ 0x000013b1,
	/* 0x0000ab82 */ 0x000013b2,
	/* 0x0000ab83 */ 0x000013b3,
	/* 0x0000ab84 */ 0x000013b4,
	/* 0x0000ab85 */ 0x000013b5,
	/* 0x0000ab86 */ 0x000013b6,
	/* 0x0000ab87 */ 0x000013b7,
	/* 0x0000ab88 */ 0x000013b8,
	/* 0x0000ab89 */ 0x000013b9,
	/* 0x0000ab8a */ 0x000013ba,
	/* 0x0000ab8b */ 0x000013bb,
	/* 0x0000ab8c */ 0x000013bc,
	/* 0x0000ab8d */ 0x000013bd,
	/* 0x0000ab8e */ 0x000013be,
	/* 0x0000ab8f */ 0x000013bf,
	/* 0x0000ab90 */ 0x000013c0,
	/* 0x0000ab91 */ 0x000013c1,
	/* 0x0000ab92 */ 0x000013c2,
	/* 0x0000ab93 */ 0x000013c3,
	/* 0x0000ab94 */ 0x000013c4,
	/* 0x0000ab95 */ 0x000013c5,
	/* 0x0000ab96 */ 0x000013c6,
	/* 0x0000ab97 */ 0x000013c7,
	/* 0x0000ab98 */ 0x000013c8,
	/* 0x0000ab99 */ 0x000013c9,
	/* 0x0000ab9a */ 0x000013ca,
	/* 0x0000ab9b */ 0x000013cb,
	/* 0x0000ab9c */ 0x000013cc,
	/* 0x0000ab9d */ 0x000013cd,
	/* 0x0000ab9e */ 0x000013ce,
	/* 0x0000ab9f */ 0x000013cf,
	/* 0x0000aba0 */ 0x000013d0,
	/* 0x0000aba1 */ 0x000013d1,
	/* 0x0000aba2 */ 0x000013d2,
	/* 0x0000aba3 */ 0x000013d3,
	/* 0x0000aba4 */ 0x000013d4,
	/* 0x0000aba5 */ 0x000013d5,
	/* 0x0000aba6 */ 0x000013d6,
	/* 0x0000aba7 */ 0x000013d7,
	/* 0x0000aba8 */ 0x000013d8,
	/* 0x0000aba9 */ 0x000013d9,
	/* 0x0000abaa */ 0x000013da,
	/* 0x0000abab */ 0x000013db,
	/* 0x0000abac */ 0x000013dc,
	/* 0x0000abad */ 0x000013dd,
	/* 0x0000abae */ 0x000013de,
	/* 0x0000abaf */ 0x000013df,
	/* 0x0000abb0 */ 0x000013e0,
	/* 0x0000abb1 */ 0x000013e1,
	/* 0x0000abb2 */ 0x000013e2,
	/* 0x0000abb3 */ 0x000013e3,
	/* 0x0000abb4 */ 0x000013e4,
	/* 0x0000abb5 */ 0x000013e5,
	/* 0x0000abb6 */ 0x000013e6,
	/* 0x0000abb7 */ 0x000013e7,
	/* 0x0000abb8 */ 0x000013e8,
	/* 0x0000abb9 */ 0x000013e9,
	/* 0x0000abba */ 0x000013ea,
	/* 0x0000abbb */ 0x000013eb,
	/* 0x0000abbc */ 0x000013ec,
	/* 0x0000abbd */ 0x000013ed,
	/* 0x0000abbe */ 0x000013ee,
	/* 0x0000abbf */ 0x000013ef
};

uint32_t libfshfs_name_case_folding_mappings_0x0000ff20[ 32 ] = {
	/* 0x0000ff20 */ 0x0000ff20,
	/* 0x0000ff21 */ 0x0000ff41,
	/* 0x0000ff22 */ 0x0000ff42,
	/* 0x0000ff23 */ 0x0000ff43,
	/* 0x0000ff24 */ 0x0000ff44,
	/* 0x0000ff25 */ 0x0000ff45,
	/* 0x0000ff26 */ 0x0000ff46,
	/* 0x0000ff27 */ 0x0000ff47,
	/* 0x0000ff28 */ 0x0000ff48,
	/* 0x0000ff29 */ 0x0000ff49,
	/* 0x0000ff2a */ 0x0000ff4a,
	/* 0x0000ff2b */ 0x0000ff4b,
	/* 0x0000ff2c */ 0x0000ff4c,
	/* 0x0000ff2d */ 0x0000ff4d,
	/* 0x0000ff2e */ 0x0000ff4e,
	/* 0x0000ff2f */ 0x0000ff4f,
	/* 0x0000ff30 */ 0x0000ff50,
	/* 0x0000ff31 */ 0x0000ff51,
	/* 0x0000ff32 */ 0x0000ff52,
	/* 0x0000ff33 */ 0x0000ff53,
	/* 0x0000ff34 */ 0x0000ff54,
	/* 0x0000ff35 */ 0x0000ff55,
	/* 0x0000ff36 */ 0x0000ff56,
	/* 0x0000ff37 */ 0x0000ff57,
	/* 0x0000ff38 */ 0x0000ff58,
	/* 0x0000ff39 */ 0x0000ff59,
	/* 0x0000ff3a */ 0x0000ff5a,
	/* 0x0000ff3b */ 0x0000ff3b,
	/* 0x0000ff3c */ 0x0000ff3c,
	/* 0x0000ff3d */ 0x0000ff3d,
	/* 0x0000ff3e */ 0x0000ff3e,
	/* 0x0000ff3f */ 0x0000ff3f
};

uint32_t libfshfs_name_case_folding_mappings_0x00010400[ 40 ] = {
	/* 0x00010400 */ 0x00010428,
	/* 0x00010401 */ 0x00010429,
	/* 0x00010402 */ 0x0001042a,
	/* 0x00010403 */ 0x0001042b,
	/* 0x00010404 */ 0x0001042c,
	/* 0x00010405 */ 0x0001042d,
	/* 0x00010406 */ 0x0001042e,
	/* 0x00010407 */ 0x0001042f,
	/* 0x00010408 */ 0x00010430,
	/* 0x00010409 */ 0x00010431,
	/* 0x0001040a */ 0x00010432,
	/* 0x0001040b */ 0x00010433,
	/* 0x0001040c */ 0x00010434,
	/* 0x0001040d */ 0x00010435,
	/* 0x0001040e */ 0x00010436,
	/* 0x0001040f */ 0x00010437,
	/* 0x00010410 */ 0x00010438,
	/* 0x00010411 */ 0x00010439,
	/* 0x00010412 */ 0x0001043a,
	/* 0x00010413 */ 0x0001043b,
	/* 0x00010414 */ 0x0001043c,
	/* 0x00010415 */ 0x0001043d,
	/* 0x00010416 */ 0x0001043e,
	/* 0x00010417 */ 0x0001043f,
	/* 0x00010418 */ 0x00010440,
	/* 0x00010419 */ 0x00010441,
	/* 0x0001041a */ 0x00010442,
	/* 0x0001041b */ 0x00010443,
	/* 0x0001041c */ 0x00010444,
	/* 0x0001041d */ 0x00010445,
	/* 0x0001041e */ 0x00010446,
	/* 0x0001041f */ 0x00010447,
	/* 0x00010420 */ 0x00010448,
	/* 0x00010421 */ 0x00010449,
	/* 0x00010422 */ 0x0001044a,
	/* 0x00010423 */ 0x0001044b,
	/* 0x00010424 */ 0x0001044c,
	/* 0x00010425 */ 0x0001044d,
	/* 0x00010426 */ 0x0001044e,
	/* 0x00010427 */ 0x0001044f
};

uint32_t libfshfs_name_case_folding_mappings_0x000104b0[ 40 ] = {
	/* 0x000104b0 */ 0x000104d8,
	/* 0x000104b1 */ 0x000104d9,
	/* 0x000104b2 */ 0x000104da,
	/* 0x000104b3 */ 0x000104db,
	/* 0x000104b4 */ 0x000104dc,
	/* 0x000104b5 */ 0x000104dd,
	/* 0x000104b6 */ 0x000104de,
	/* 0x000104b7 */ 0x000104df,
	/* 0x000104b8 */ 0x000104e0,
	/* 0x000104b9 */ 0x000104e1,
	/* 0x000104ba */ 0x000104e2,
	/* 0x000104bb */ 0x000104e3,
	/* 0x000104bc */ 0x000104e4,
	/* 0x000104bd */ 0x000104e5,
	/* 0x000104be */ 0x000104e6,
	/* 0x000104bf */ 0x000104e7,
	/* 0x000104c0 */ 0x000104e8,
	/* 0x000104c1 */ 0x000104e9,
	/* 0x000104c2 */ 0x000104ea,
	/* 0x000104c3 */ 0x000104eb,
	/* 0x000104c4 */ 0x000104ec,
	/* 0x000104c5 */ 0x000104ed,
	/* 0x000104c6 */ 0x000104ee,
	/* 0x000104c7 */ 0x000104ef,
	/* 0x000104c8 */ 0x000104f0,
	/* 0x000104c9 */ 0x000104f1,
	/* 0x000104ca */ 0x000104f2,
	/* 0x000104cb */ 0x000104f3,
	/* 0x000104cc */ 0x000104f4,
	/* 0x000104cd */ 0x000104f5,
	/* 0x000104ce */ 0x000104f6,
	/* 0x000104cf */ 0x000104f7,
	/* 0x000104d0 */ 0x000104f8,
	/* 0x000104d1 */ 0x000104f9,
	/* 0x000104d2 */ 0x000104fa,
	/* 0x000104d3 */ 0x000104fb,
	/* 0x000104d4 */ 0x000104d4,
	/* 0x000104d5 */ 0x000104d5,
	/* 0x000104d6 */ 0x000104d6,
	/* 0x000104d7 */ 0x000104d7
};

uint32_t libfshfs_name_case_folding_mappings_0x00010c80[ 56 ] = {
	/* 0x00010c80 */ 0x00010cc0,
	/* 0x00010c81 */ 0x00010cc1,
	/* 0x00010c82 */ 0x00010cc2,
	/* 0x00010c83 */ 0x00010cc3,
	/* 0x00010c84 */ 0x00010cc4,
	/* 0x00010c85 */ 0x00010cc5,
	/* 0x00010c86 */ 0x00010cc6,
	/* 0x00010c87 */ 0x00010cc7,
	/* 0x00010c88 */ 0x00010cc8,
	/* 0x00010c89 */ 0x00010cc9,
	/* 0x00010c8a */ 0x00010cca,
	/* 0x00010c8b */ 0x00010ccb,
	/* 0x00010c8c */ 0x00010ccc,
	/* 0x00010c8d */ 0x00010ccd,
	/* 0x00010c8e */ 0x00010cce,
	/* 0x00010c8f */ 0x00010ccf,
	/* 0x00010c90 */ 0x00010cd0,
	/* 0x00010c91 */ 0x00010cd1,
	/* 0x00010c92 */ 0x00010cd2,
	/* 0x00010c93 */ 0x00010cd3,
	/* 0x00010c94 */ 0x00010cd4,
	/* 0x00010c95 */ 0x00010cd5,
	/* 0x00010c96 */ 0x00010cd6,
	/* 0x00010c97 */ 0x00010cd7,
	/* 0x00010c98 */ 0x00010cd8,
	/* 0x00010c99 */ 0x00010cd9,
	/* 0x00010c9a */ 0x00010cda,
	/* 0x00010c9b */ 0x00010cdb,
	/* 0x00010c9c */ 0x00010cdc,
	/* 0x00010c9d */ 0x00010cdd,
	/* 0x00010c9e */ 0x00010cde,
	/* 0x00010c9f */ 0x00010cdf,
	/* 0x00010ca0 */ 0x00010ce0,
	/* 0x00010ca1 */ 0x00010ce1,
	/* 0x00010ca2 */ 0x00010ce2,
	/* 0x00010ca3 */ 0x00010ce3,
	/* 0x00010ca4 */ 0x00010ce4,
	/* 0x00010ca5 */ 0x00010ce5,
	/* 0x00010ca6 */ 0x00010ce6,
	/* 0x00010ca7 */ 0x00010ce7,
	/* 0x00010ca8 */ 0x00010ce8,
	/* 0x00010ca9 */ 0x00010ce9,
	/* 0x00010caa */ 0x00010cea,
	/* 0x00010cab */ 0x00010ceb,
	/* 0x00010cac */ 0x00010cec,
	/* 0x00010cad */ 0x00010ced,
	/* 0x00010cae */ 0x00010cee,
	/* 0x00010caf */ 0x00010cef,
	/* 0x00010cb0 */ 0x00010cf0,
	/* 0x00010cb1 */ 0x00010cf1,
	/* 0x00010cb2 */ 0x00010cf2,
	/* 0x00010cb3 */ 0x00010cb3,
	/* 0x00010cb4 */ 0x00010cb4,
	/* 0x00010cb5 */ 0x00010cb5,
	/* 0x00010cb6 */ 0x00010cb6,
	/* 0x00010cb7 */ 0x00010cb7
};

uint32_t libfshfs_name_case_folding_mappings_0x000118a0[ 32 ] = {
	/* 0x000118a0 */ 0x000118c0,
	/* 0x000118a1 */ 0x000118c1,
	/* 0x000118a2 */ 0x000118c2,
	/* 0x000118a3 */ 0x000118c3,
	/* 0x000118a4 */ 0x000118c4,
	/* 0x000118a5 */ 0x000118c5,
	/* 0x000118a6 */ 0x000118c6,
	/* 0x000118a7 */ 0x000118c7,
	/* 0x000118a8 */ 0x000118c8,
	/* 0x000118a9 */ 0x000118c9,
	/* 0x000118aa */ 0x000118ca,
	/* 0x000118ab */ 0x000118cb,
	/* 0x000118ac */ 0x000118cc,
	/* 0x000118ad */ 0x000118cd,
	/* 0x000118ae */ 0x000118ce,
	/* 0x000118af */ 0x000118cf,
	/* 0x000118b0 */ 0x000118d0,
	/* 0x000118b1 */ 0x000118d1,
	/* 0x000118b2 */ 0x000118d2,
	/* 0x000118b3 */ 0x000118d3,
	/* 0x000118b4 */ 0x000118d4,
	/* 0x000118b5 */ 0x000118d5,
	/* 0x000118b6 */ 0x000118d6,
	/* 0x000118b7 */ 0x000118d7,
	/* 0x000118b8 */ 0x000118d8,
	/* 0x000118b9 */ 0x000118d9,
	/* 0x000118ba */ 0x000118da,
	/* 0x000118bb */ 0x000118db,
	/* 0x000118bc */ 0x000118dc,
	/* 0x000118bd */ 0x000118dd,
	/* 0x000118be */ 0x000118de,
	/* 0x000118bf */ 0x000118df
};

uint32_t libfshfs_name_case_folding_mappings_0x0001e900[ 40 ] = {
	/* 0x0001e900 */ 0x0001e922,
	/* 0x0001e901 */ 0x0001e923,
	/* 0x0001e902 */ 0x0001e924,
	/* 0x0001e903 */ 0x0001e925,
	/* 0x0001e904 */ 0x0001e926,
	/* 0x0001e905 */ 0x0001e927,
	/* 0x0001e906 */ 0x0001e928,
	/* 0x0001e907 */ 0x0001e929,
	/* 0x0001e908 */ 0x0001e92a,
	/* 0x0001e909 */ 0x0001e92b,
	/* 0x0001e90a */ 0x0001e92c,
	/* 0x0001e90b */ 0x0001e92d,
	/* 0x0001e90c */ 0x0001e92e,
	/* 0x0001e90d */ 0x0001e92f,
	/* 0x0001e90e */ 0x0001e930,
	/* 0x0001e90f */ 0x0001e931,
	/* 0x0001e910 */ 0x0001e932,
	/* 0x0001e911 */ 0x0001e933,
	/* 0x0001e912 */ 0x0001e934,
	/* 0x0001e913 */ 0x0001e935,
	/* 0x0001e914 */ 0x0001e936,
	/* 0x0001e915 */ 0x0001e937,
	/* 0x0001e916 */ 0x0001e938,
	/* 0x0001e917 */ 0x0001e939,
	/* 0x0001e918 */ 0x0001e93a,
	/* 0x0001e919 */ 0x0001e93b,
	/* 0x0001e91a */ 0x0001e93c,
	/* 0x0001e91b */ 0x0001e93d,
	/* 0x0001e91c */ 0x0001e93e,
	/* 0x0001e91d */ 0x0001e93f,
	/* 0x0001e91e */ 0x0001e940,
	/* 0x0001e91f */ 0x0001e941,
	/* 0x0001e920 */ 0x0001e942,
	/* 0x0001e921 */ 0x0001e943,
	/* 0x0001e922 */ 0x0001e922,
	/* 0x0001e923 */ 0x0001e923,
	/* 0x0001e924 */ 0x0001e924,
	/* 0x0001e925 */ 0x0001e925,
	/* 0x0001e926 */ 0x0001e926,
	/* 0x0001e927 */ 0x0001e927
};

libfshfs_name_decomposition_mapping_t libfshfs_name_decomposition_mappings_0x000000c0[ 192 ] = {
	/* 0x000000c0 */ { 2, { 0x00000041, 0x00000300 } },
	/* 0x000000c1 */ { 2, { 0x00000041, 0x00000301 } },
	/* 0x000000c2 */ { 2, { 0x00000041, 0x00000302 } },
	/* 0x000000c3 */ { 2, { 0x00000041, 0x00000303 } },
	/* 0x000000c4 */ { 2, { 0x00000041, 0x00000308 } },
	/* 0x000000c5 */ { 2, { 0x00000041, 0x0000030a } },
	/* 0x000000c6 */ { 1, { 0x000000c6 } },
	/* 0x000000c7 */ { 2, { 0x00000043, 0x00000327 } },
	/* 0x000000c8 */ { 2, { 0x00000045, 0x00000300 } },
	/* 0x000000c9 */ { 2, { 0x00000045, 0x00000301 } },
	/* 0x000000ca */ { 2, { 0x00000045, 0x00000302 } },
	/* 0x000000cb */ { 2, { 0x00000045, 0x00000308 } },
	/* 0x000000cc */ { 2, { 0x00000049, 0x00000300 } },
	/* 0x000000cd */ { 2, { 0x00000049, 0x00000301 } },
	/* 0x000000ce */ { 2, { 0x00000049, 0x00000302 } },
	/* 0x000000cf */ { 2, { 0x00000049, 0x00000308 } },
	/* 0x000000d0 */ { 1, { 0x000000d0 } },
	/* 0x000000d1 */ { 2, { 0x0000004e, 0x00000303 } },
	/* 0x000000d2 */ { 2, { 0x0000004f, 0x00000300 } },
	/* 0x000000d3 */ { 2, { 0x0000004f, 0x00000301 } },
	/* 0x000000d4 */ { 2, { 0x0000004f, 0x00000302 } },
	/* 0x000000d5 */ { 2, { 0x0000004f, 0x00000303 } },
	/* 0x000000d6 */ { 2, { 0x0000004f, 0x00000308 } },
	/* 0x000000d7 */ { 1, { 0x000000d7 } },
	/* 0x000000d8 */ { 1, { 0x000000d8 } },
	/* 0x000000d9 */ { 2, { 0x00000055, 0x00000300 } },
	/* 0x000000da */ { 2, { 0x00000055, 0x00000301 } },
	/* 0x000000db */ { 2, { 0x00000055, 0x00000302 } },
	/* 0x000000dc */ { 2, { 0x00000055, 0x00000308 } },
	/* 0x000000dd */ { 2, { 0x00000059, 0x00000301 } },
	/* 0x000000de */ { 1, { 0x000000de } },
	/* 0x000000df */ { 1, { 0x000000df } },
	/* 0x000000e0 */ { 2, { 0x00000061, 0x00000300 } },
	/* 0x000000e1 */ { 2, { 0x00000061, 0x00000301 } },
	/* 0x000000e2 */ { 2, { 0x00000061, 0x00000302 } },
	/* 0x000000e3 */ { 2, { 0x00000061, 0x00000303 } },
	/* 0x000000e4 */ { 2, { 0x00000061, 0x00000308 } },
	/* 0x000000e5 */ { 2, { 0x00000061, 0x0000030a } },
	/* 0x000000e6 */ { 1, { 0x000000e6 } },
	/* 0x000000e7 */ { 2, { 0x00000063, 0x00000327 } },
	/* 0x000000e8 */ { 2, { 0x00000065, 0x00000300 } },
	/* 0x000000e9 */ { 2, { 0x00000065, 0x00000301 } },
	/* 0x000000ea */ { 2, { 0x00000065, 0x00000302 } },
	/* 0x000000eb */ { 2, { 0x00000065, 0x00000308 } },
	/* 0x000000ec */ { 2, { 0x00000069, 0x00000300 } },
	/* 0x000000ed */ { 2, { 0x00000069, 0x00000301 } },
	/* 0x000000ee */ { 2, { 0x00000069, 0x00000302 } },
	/* 0x000000ef */ { 2, { 0x00000069, 0x00000308 } },
	/* 0x000000f0 */ { 1, { 0x000000f0 } },
	/* 0x000000f1 */ { 2, { 0x0000006e, 0x00000303 } },
	/* 0x000000f2 */ { 2, { 0x0000006f, 0x00000300 } },
	/* 0x000000f3 */ { 2, { 0x0000006f, 0x00000301 } },
	/* 0x000000f4 */ { 2, { 0x0000006f, 0x00000302 } },
	/* 0x000000f5 */ { 2, { 0x0000006f, 0x00000303 } },
	/* 0x000000f6 */ { 2, { 0x0000006f, 0x00000308 } },
	/* 0x000000f7 */ { 1, { 0x000000f7 } },
	/* 0x000000f8 */ { 1, { 0x000000f8 } },
	/* 0x000000f9 */ { 2, { 0x00000075, 0x00000300 } },
	/* 0x000000fa */ { 2, { 0x00000075, 0x00000301 } },
	/* 0x000000fb */ { 2, { 0x00000075, 0x00000302 } },
	/* 0x000000fc */ { 2, { 0x00000075, 0x00000308 } },
	/* 0x000000fd */ { 2, { 0x00000079, 0x00000301 } },
	/* 0x000000fe */ { 1, { 0x000000fe } },
	/* 0x000000ff */ { 2, { 0x00000079, 0x00000308 } },
	/* 0x00000100 */ { 2, { 0x00000041, 0x00000304 } },
	/* 0x00000101 */ { 2, { 0x00000061, 0x00000304 } },
	/* 0x00000102 */ { 2, { 0x00000041, 0x00000306 } },
	/* 0x00000103 */ { 2, { 0x00000061, 0x00000306 } },
	/* 0x00000104 */ { 2, { 0x00000041, 0x00000328 } },
	/* 0x00000105 */ { 2, { 0x00000061, 0x00000328 } },
	/* 0x00000106 */ { 2, { 0x00000043, 0x00000301 } },
	/* 0x00000107 */ { 2, { 0x00000063, 0x00000301 } },
	/* 0x00000108 */ { 2, { 0x00000043, 0x00000302 } },
	/* 0x00000109 */ { 2, { 0x00000063, 0x00000302 } },
	/* 0x0000010a */ { 2, { 0x00000043, 0x00000307 } },
	/* 0x0000010b */ { 2, { 0x00000063, 0x00000307 } },
	/* 0x0000010c */ { 2, { 0x00000043, 0x0000030c } },
	/* 0x0000010d */ { 2, { 0x00000063, 0x0000030c } },
	/* 0x0000010e */ { 2, { 0x00000044, 0x0000030c } },
	/* 0x0000010f */ { 2, { 0x00000064, 0x0000030c } },
	/* 0x00000110 */ { 1, { 0x00000110 } },
	/* 0x00000111 */ { 1, { 0x00000111 } },
	/* 0x00000112 */ { 2, { 0x00000045, 0x00000304 } },
	/* 0x00000113 */ { 2, { 0x00000065, 0x00000304 } },
	/* 0x00000114 */ { 2, { 0x00000045, 0x00000306 } },
	/* 0x00000115 */ { 2, { 0x00000065, 0x00000306 } },
	/* 0x00000116 */ { 2, { 0x00000045, 0x00000307 } },
	/* 0x00000117 */ { 2, { 0x00000065, 0x00000307 } },
	/* 0x00000118 */ { 2, { 0x00000045, 0x00000328 } },
	/* 0x00000119 */ { 2, { 0x00000065, 0x00000328 } },
	/* 0x0000011a */ { 2, { 0x00000045, 0x0000030c } },
	/* 0x0000011b */ { 2, { 0x00000065, 0x0000030c } },
	/* 0x0000011c */ { 2, { 0x00000047, 0x00000302 } },
	/* 0x0000011d */ { 2, { 0x00000067, 0x00000302 } },
	/* 0x0000011e */ { 2, { 0x00000047, 0x00000306 } },
	/* 0x0000011f */ { 2, { 0x00000067, 0x00000306 } },
	/* 0x00000120 */ { 2, { 0x00000047, 0x00000307 } },
	/* 0x00000121 */ { 2, { 0x00000067, 0x00000307 } },
	/* 0x00000122 */ { 2, { 0x00000047, 0x00000327 } },
	/* 0x00000123 */ { 2, { 0x00000067, 0x00000327 } },
	/* 0x00000124 */ { 2, { 0x00000048, 0x00000302 } },
	/* 0x00000125 */ { 2, { 0x00000068, 0x00000302 } },
	/* 0x00000126 */ { 1, { 0x00000126 } },
	/* 0x00000127 */ { 1, { 0x00000127 } },
	/* 0x00000128 */ { 2, { 0x00000049, 0x00000303 } },
	/* 0x00000129 */ { 2, { 0x00000069, 0x00000303 } },
	/* 0x0000012a */ { 2, { 0x00000049, 0x00000304 } },
	/* 0x0000012b */ { 2, { 0x00000069, 0x00000304 } },
	/* 0x0000012c */ { 2, { 0x00000049, 0x00000306 } },
	/* 0x0000012d */ { 2, { 0x00000069, 0x00000306 } },
	/* 0x0000012e */ { 2, { 0x00000049, 0x00000328 } },
	/* 0x0000012f */ { 2, { 0x00000069, 0x00000328 } },
	/* 0x00000130 */ { 2, { 0x00000049, 0x00000307 } },
	/* 0x00000131 */ { 1, { 0x00000131 } },
	/* 0x00000132 */ { 1, { 0x00000132 } },
	/* 0x00000133 */ { 1, { 0x00000133 } },
	/* 0x00000134 */ { 2, { 0x0000004a, 0x00000302 } },
	/* 0x00000135 */ { 2, { 0x0000006a, 0x00000302 } },
	/* 0x00000136 */ { 2, { 0x0000004b, 0x00000327 } },
	/* 0x00000137 */ { 2, { 0x0000006b, 0x00000327 } },
	/* 0x00000138 */ { 1, { 0x00000138 } },
	/* 0x00000139 */ { 2, { 0x0000004c, 0x00000301 } },
	/* 0x0000013a */ { 2, { 0x0000006c, 0x00000301 } },
	/* 0x0000013b */ { 2, { 0x0000004c, 0x00000327 } },
	/* 0x0000013c */ { 2, { 0x0000006c, 0x00000327 } },
	/* 0x0000013d */ { 2, { 0x0000004c, 0x0000030c } },
	/* 0x0000013e */ { 2, { 0x0000006c, 0x0000030c } },
	/* 0x0000013f */ { 1, { 0x0000013f } },
	/* 0x00000140 */ { 1, { 0x00000140 } },
	/* 0x00000141 */ { 1, { 0x00000141 } },
	/* 0x00000142 */ { 1, { 0x00000142 } },
	/* 0x00000143 */ { 2, { 0x0000004e, 0x00000301 } },
	/* 0x00000144 */ { 2, { 0x0000006e, 0x00000301 } },
	/* 0x00000145 */ { 2, { 0x0000004e, 0x00000327 } },
	/* 0x00000146 */ { 2, { 0x0000006e, 0x00000327 } },
	/* 0x00000147 */ { 2, { 0x0000004e, 0x0000030c } },
	/* 0x00000148 */ { 2, { 0x0000006e, 0x0000030c } },
	/* 0x00000149 */ { 1, { 0x00000149 } },
	/* 0x0000014a */ { 1, { 0x0000014a } },
	/* 0x0000014b */ { 1, { 0x0000014b } },
	/* 0x0000014c */ { 2, { 0x0000004f, 0x00000304 } },
	/* 0x0000014d */ { 2, { 0x0000006f, 0x00000304 } },
	/* 0x0000014e */ { 2, { 0x0000004f, 0x00000306 } },
	/* 0x0000014f */ { 2, { 0x0000006f, 0x00000306 } },
	/* 0x00000150 */ { 2, { 0x0000004f, 0x0000030b } },
	/* 0x00000151 */ { 2, { 0x0000006f, 0x0000030b } },
	/* 0x00000152 */ { 1, { 0x00000152 } },
	/* 0x00000153 */ { 1, { 0x00000153 } },
	/* 0x00000154 */ { 2, { 0x00000052, 0x00000301 } },
	/* 0x00000155 */ { 2, { 0x00000072, 0x00000301 } },
	/* 0x00000156 */ { 2, { 0x00000052, 0x00000327 } },
	/* 0x00000157 */ { 2, { 0x00000072, 0x00000327 } },
	/* 0x00000158 */ { 2, { 0x00000052, 0x0000030c } },
	/* 0x00000159 */ { 2, { 0x00000072, 0x0000030c } },
	/* 0x0000015a */ { 2, { 0x00000053, 0x00000301 } },
	/* 0x0000015b */ { 2, { 0x00000073, 0x00000301 } },
	/* 0x0000015c */ { 2, { 0x00000053, 0x00000302 } },
	/* 0x0000015d */ { 2, { 0x00000073, 0x00000302 } },
	/* 0x0000015e */ { 2, { 0x00000053, 0x00000327 } },
	/* 0x0000015f */ { 2, { 0x00000073, 0x00000327 } },
	/* 0x00000160 */ { 2, { 0x00000053, 0x0000030c } },
	/* 0x00000161 */ { 2, { 0x00000073, 0x0000030c } },
	/* 0x00000162 */ { 2, { 0x00000054, 0x00000327 } },
	/* 0x00000163 */ { 2, { 0x00000074, 0x00000327 } },
	/* 0x00000164 */ { 2, { 0x00000054, 0x0000030c } },
	/* 0x00000165 */ { 2, { 0x00000074, 0x0000030c } },
	/* 0x00000166 */ { 1, { 0x00000166 } },
	/* 0x00000167 */ { 1, { 0x00000167 } },
	/* 0x00000168 */ { 2, { 0x00000055, 0x00000303 } },
	/* 0x00000169 */ { 2, { 0x00000075, 0x00000303 } },
	/* 0x0000016a */ { 2, { 0x00000055, 0x00000304 } },
	/* 0x0000016b */ { 2, { 0x00000075, 0x00000304 } },
	/* 0x0000016c */ { 2, { 0x00000055, 0x00000306 } },
	/* 0x0000016d */ { 2, { 0x00000075, 0x00000306 } },
	/* 0x0000016e */ { 2, { 0x00000055, 0x0000030a } },
	/* 0x0000016f */ { 2, { 0x00000075, 0x0000030a } },
	/* 0x00000170 */ { 2, { 0x00000055, 0x0000030b } },
	/* 0x00000171 */ { 2, { 0x00000075, 0x0000030b } },
	/* 0x00000172 */ { 2, { 0x00000055, 0x00000328 } },
	/* 0x00000173 */ { 2, { 0x00000075, 0x00000328 } },
	/* 0x00000174 */ { 2, { 0x00000057, 0x00000302 } },
	/* 0x00000175 */ { 2, { 0x00000077, 0x00000302 } },
	/* 0x00000176 */ { 2, { 0x00000059, 0x00000302 } },
	/* 0x00000177 */ { 2, { 0x00000079, 0x00000302 } },
	/* 0x00000178 */ { 2, { 0x00000059, 0x00000308 } },
	/* 0x00000179 */ { 2, { 0x0000005a, 0x00000301 } },
	/* 0x0000017a */ { 2, { 0x0000007a, 0x00000301 } },
	/* 0x0000017b */ { 2, { 0x0000005a, 0x00000307 } },
	/* 0x0000017c */ { 2, { 0x0000007a, 0x00000307 } },
	/* 0x0000017d */ { 2, { 0x0000005a, 0x0000030c } },
	/* 0x0000017e */ { 2, { 0x0000007a, 0x0000030c } },
	/* 0x0000017f */ { 1, { 0x0000017f } }
};

libfshfs_name_decomposition_mapping_t libfshfs_name_decomposition_mappings_0x000001a0[ 152 ] = {
	/* 0x000001a0 */ { 2, { 0x0000004f, 0x0000031b } },
	/* 0x000001a1 */ { 2, { 0x0000006f, 0x0000031b } },
	/* 0x000001a2 */ { 1, { 0x000001a2 } },
	/* 0x000001a3 */ { 1, { 0x000001a3 } },
	/* 0x000001a4 */ { 1, { 0x000001a4 } },
	/* 0x000001a5 */ { 1, { 0x000001a5 } },
	/* 0x000001a6 */ { 1, { 0x000001a6 } },
	/* 0x000001a7 */ { 1, { 0x000001a7 } },
	/* 0x000001a8 */ { 1, { 0x000001a8 } },
	/* 0x000001a9 */ { 1, { 0x000001a9 } },
	/* 0x000001aa */ { 1, { 0x000001aa } },
	/* 0x000001ab */ { 1, { 0x000001ab } },
	/* 0x000001ac */ { 1, { 0x000001ac } },
	/* 0x000001ad */ { 1, { 0x000001ad } },
	/* 0x000001ae */ { 1, { 0x000001ae } },
	/* 0x000001af */ { 2, { 0x00000055, 0x0000031b } },
	/* 0x000001b0 */ { 2, { 0x00000075, 0x0000031b } },
	/* 0x000001b1 */ { 1, { 0x000001b1 } },
	/* 0x000001b2 */ { 1, { 0x000001b2 } },
	/* 0x000001b3 */ { 1, { 0x000001b3 } },
	/* 0x000001b4 */ { 1, { 0x000001b4 } },
	/* 0x000001b5 */ { 1, { 0x000001b5 } },
	/* 0x000001b6 */ { 1, { 0x000001b6 } },
	/* 0x000001b7 */ { 1, { 0x000001b7 } },
	/* 0x000001b8 */ { 1, { 0x000001b8 } },
	/* 0x000001b9 */ { 1, { 0x000001b9 } },
	/* 0x000001ba */ { 1, { 0x000001ba } },
	/* 0x000001bb */ { 1, { 0x000001bb } },
	/* 0x000001bc */ { 1, { 0x000001bc } },
	/* 0x000001bd */ { 1, { 0x000001bd } },
	/* 0x000001be */ { 1, { 0x000001be } },
	/* 0x000001bf */ { 1, { 0x000001bf } },
	/* 0x000001c0 */ { 1, { 0x000001c0 } },
	/* 0x000001c1 */ { 1, { 0x000001c1 } },
	/* 0x000001c2 */ { 1, { 0x000001c2 } },
	/* 0x000001c3 */ { 1, { 0x000001c3 } },
	/* 0x000001c4 */ { 1, { 0x000001c4 } },
	/* 0x000001c5 */ { 1, { 0x000001c5 } },
	/* 0x000001c6 */ { 1, { 0x000001c6 } },
	/* 0x000001c7 */ { 1, { 0x000001c7 } },
	/* 0x000001c8 */ { 1, { 0x000001c8 } },
	/* 0x000001c9 */ { 1, { 0x000001c9 } },
	/* 0x000001ca */ { 1, { 0x000001ca } },
	/* 0x000001cb */ { 1, { 0x000001cb } },
	/* 0x000001cc */ { 1, { 0x000001cc } },
	/* 0x000001cd */ { 2, { 0x00000041, 0x0000030c } },
	/* 0x000001ce */ { 2, { 0x00000061, 0x0000030c } },
	/* 0x000001cf */ { 2, { 0x00000049, 0x0000030c } },
	/* 0x000001d0 */ { 2, { 0x00000069, 0x0000030c } },
	/* 0x000001d1 */ { 2, { 0x0000004f, 0x0000030c } },
	/* 0x000001d2 */ { 2, { 0x0000006f, 0x0000030c } },
	/* 0x000001d3 */ { 2, { 0x00000055, 0x0000030c } },
	/* 0x000001d4 */ { 2, { 0x00000075, 0x0000030c } },
	/* 0x000001d5 */ { 3, { 0x00000055, 0x00000308, 0x00000304 } },
	/* 0x000001d6 */ { 3, { 0x00000075, 0x00000308, 0x00000304 } },
	/* 0x000001d7 */ { 3, { 0x00000055, 0x00000308, 0x00000301 } },
	/* 0x000001d8 */ { 3, { 0x00000075, 0x00000308, 0x00000301 } },
	/* 0x000001d9 */ { 3, { 0x00000055, 0x00000308, 0x0000030c } },
	/* 0x000001da */ { 3, { 0x00000075, 0x00000308, 0x0000030c } },
	/* 0x000001db */ { 3, { 0x00000055, 0x00000308, 0x00000300 } },
	/* 0x000001dc */ { 3, { 0x00000075, 0x00000308, 0x00000300 } },
	/* 0x000001dd */ { 1, { 0x000001dd } },
	/* 0x000001de */ { 3, { 0x00000041, 0x00000308, 0x00000304 } },
	/* 0x000001df */ { 3, { 0x00000061, 0x00000308, 0x00000304 } },
	/* 0x000001e0 */ { 3, { 0x00000041, 0x00000307, 0x00000304 } },
	/* 0x000001e1 */ { 3, { 0x00000061, 0x00000307, 0x00000304 } },
	/* 0x000001e2 */ { 2, { 0x000000c6, 0x00000304 } },
	/* 0x000001e3 */ { 2, { 0x000000e6, 0x00000304 } },
	/* 0x000001e4 */ { 1, { 0x000001e4 } },
	/* 0x000001e5 */ { 1, { 0x000001e5 } },
	/* 0x000001e6 */ { 2, { 0x00000047, 0x0000030c } },
	/* 0x000001e7 */ { 2, { 0x00000067, 0x0000030c } },
	/* 0x000001e8 */ { 2, { 0x0000004b, 0x0000030c } },
	/* 0x000001e9 */ { 2, { 0x0000006b, 0x0000030c } },
	/* 0x000001ea */ { 2, { 0x0000004f, 0x00000328 } },
	/* 0x000001eb */ { 2, { 0x0000006f, 0x00000328 } },
	/* 0x000001ec */ { 3, { 0x0000004f, 0x00000328, 0x00000304 } },
	/* 0x000001ed */ { 3, { 0x0000006f, 0x00000328, 0x00000304 } },
	/* 0x000001ee */ { 2, { 0x000001b7, 0x0000030c } },
	/* 0x000001ef */ { 2, { 0x00000292, 0x0000030c } },
	/* 0x000001f0 */ { 2, { 0x0000006a, 0x0000030c } },
	/* 0x000001f1 */ { 1, { 0x000001f1 } },
	/* 0x000001f2 */ { 1, { 0x000001f2 } },
	/* 0x000001f3 */ { 1, { 0x000001f3 } },
	/* 0x000001f4 */ { 2, { 0x00000047, 0x00000301 } },
	/* 0x000001f5 */ { 2, { 0x00000067, 0x00000301 } },
	/* 0x000001f6 */ { 1, { 0x000001f6 } },
	/* 0x000001f7 */ { 1, { 0x000001f7 } },
	/* 0x000001f8 */ { 2, { 0x0000004e, 0x00000300 } },
	/* 0x000001f9 */ { 2, { 0x0000006e, 0x00000300 } },
	/* 0x000001fa */ { 3, { 0x00000041, 0x0000030a, 0x00000301 } },
	/* 0x000001fb */ { 3, { 0x00000061, 0x0000030a, 0x00000301 } },
	/* 0x000001fc */ { 2, { 0x000000c6, 0x00000301 } },
	/* 0x000001fd */ { 2, { 0x000000e6, 0x00000301 } },
	/* 0x000001fe */ { 2, { 0x000000d8, 0x00000301 } },
	/* 0x000001ff */ { 2, { 0x000000f8, 0x00000301 } },
	/* 0x00000200 */ { 2, { 0x00000041, 0x0000030f } },
	/* 0x00000201 */ { 2, { 0x00000061, 0x0000030f } },
	/* 0x00000202 */ { 2, { 0x00000041, 0x00000311 } },
	/* 0x00000203 */ { 2, { 0x00000061, 0x00000311 } },
	/* 0x00000204 */ { 2, { 0x00000045, 0x0000030f } },
	/* 0x00000205 */ { 2, { 0x00000065, 0x0000030f } },
	/* 0x00000206 */ { 2, { 0x00000045, 0x00000311 } },
	/* 0x00000207 */ { 2, { 0x00000065, 0x00000311 } },
	/* 0x00000208 */ { 2, { 0x00000049, 0x0000030f } },
	/* 0x00000209 */ { 2, { 0x00000069, 0x0000030f } },
	/* 0x0000020a */ { 2, { 0x00000049, 0x00000311 } },
	/* 0x0000020b */ { 2, { 0x00000069, 0x00000311 } },
	/* 0x0000020c */ { 2, { 0x0000004f, 0x0000030f } },
	/* 0x0000020d */ { 2, { 0x0000006f, 0x0000030f } },
	/* 0x0000020e */ { 2, { 0x0000004f, 0x00000311 } },
	/* 0x0000020f */ { 2, { 0x0000006f, 0x00000311 } },
	/* 0x00000210 */ { 2, { 0x00000052, 0x0000030f } },
	/* 0x00000211 */ { 2, { 0x00000072, 0x0000030f } },
	/* 0x00000212 */ { 2, { 0x00000052, 0x00000311 } },
	/* 0x00000213 */ { 2, { 0x00000072, 0x00000311 } },
	/* 0x00000214 */ { 2, { 0x00000055, 0x0000030f } },
	/* 0x00000215 */ { 2, { 0x00000075, 0x0000030f } },
	/* 0x00000216 */ { 2, { 0x00000055, 0x00000311 } },
	/* 0x00000217 */ { 2, { 0x00000075, 0x00000311 } },
	/* 0x00000218 */ { 2, { 0x00000053, 0x00000326 } },
	/* 0x00000219 */ { 2, { 0x00000073, 0x00000326 } },
	/* 0x0000021a */ { 2, { 0x00000054, 0x00000326 } },
	/* 0x0000021b */ { 2, { 0x00000074, 0x00000326 } },
	/* 0x0000021c */ { 1, { 0x0000021c } },
	/* 0x0000021d */ { 1, { 0x0000021d } },
	/* 0x0000021e */ { 2, { 0x00000048, 0x0000030c } },
	/* 0x0000021f */ { 2, { 0x00000068, 0x0000030c } },
	/* 0x00000220 */ { 1, { 0x00000220 } },
	/* 0x00000221 */ { 1, { 0x00000221 } },
	/* 0x00000222 */ { 1, { 0x00000222 } },
	/* 0x00000223 */ { 1, { 0x00000223 } },
	/* 0x00000224 */ { 1, { 0x00000224 } },
	/* 0x00000225 */ { 1, { 0x00000225 } },
	/* 0x00000226 */ { 2, { 0x00000041, 0x00000307 } },
	/* 0x00000227 */ { 2, { 0x00000061, 0x00000307 } },
	/* 0x00000228 */ { 2, { 0x00000045, 0x00000327 } },
	/* 0x00000229 */ { 2, { 0x00000065, 0x00000327 } },
	/* 0x0000022a */ { 3, { 0x0000004f, 0x00000308, 0x00000304 } },
	/* 0x0000022b */ { 3, { 0x0000006f, 0x00000308, 0x00000304 } },
	/* 0x0000022c */ { 3, { 0x0000004f, 0x00000303, 0x00000304 } },
	/* 0x0000022d */ { 3, { 0x0000006f, 0x00000303, 0x00000304 } },
	/* 0x0000022e */ { 2, { 0x0000004f, 0x00000307 } },
	/* 0x0000022f */ { 2, { 0x0000006f, 0x00000307 } },
	/* 0x00000230 */ { 3, { 0x0000004f, 0x00000307, 0x00000304 } },
	/* 0x00000231 */ { 3, { 0x0000006f, 0x00000307, 0x00000304 } },
	/* 0x00000232 */ { 2, { 0x00000059, 0x00000304 } },
	/* 0x00000233 */ { 2, { 0x00000079, 0x00000304 } },
	/* 0x00000234 */ { 1, { 0x00000234 } },
	/* 0x00000235 */ { 1, { 0x00000235 } },
	/* 0x00000236 */ { 1, { 0x00000236 } },
	/* 0x00000237 */ { 1, { 0x00000237 } }
};

libfshfs_name_decomposition_mapping_t libfshfs_name_decomposition_mappings_0x00000340[ 152 ] = {
	/* 0x00000340 */ { 1, { 0x00000300 } },
	/* 0x00000341 */ { 1, { 0x00000301 } },
	/* 0x00000342 */ { 1, { 0x00000342 } },
	/* 0x00000343 */ { 1, { 0x00000313 } },
	/* 0x00000344 */ { 2, { 0x00000308, 0x00000301 } },
	/* 0x00000345 */ { 1, { 0x00000345 } },
	/* 0x00000346 */ { 1, { 0x00000346 } },
	/* 0x00000347 */ { 1, { 0x00000347 } },
	/* 0x00000348 */ { 1, { 0x00000348 } },
	/* 0x00000349 */ { 1, { 0x00000349 } },
	/* 0x0000034a */ { 1, { 0x0000034a } },
	/* 0x0000034b */ { 1, { 0x0000034b } },
	/* 0x0000034c */ { 1, { 0x0000034c } },
	/* 0x0000034d */ { 1, { 0x0000034d } },
	/* 0x0000034e */ { 1, { 0x0000034e } },
	/* 0x0000034f */ { 1, { 0x0000034f } },
	/* 0x00000350 */ { 1, { 0x00000350 } },
	/* 0x00000351 */ { 1, { 0x00000351 } },
	/* 0x00000352 */ { 1, { 0x00000352 } },
	/* 0x00000353 */ { 1, { 0x00000353 } },
	/* 0x00000354 */ { 1, { 0x00000354 } },
	/* 0x00000355 */ { 1, { 0x00000355 } },
	/* 0x00000356 */ { 1, { 0x00000356 } },
	/* 0x00000357 */ { 1, { 0x00000357 } },
	/* 0x00000358 */ { 1, { 0x00000358 } },
	/* 0x00000359 */ { 1, { 0x00000359 } },
	/* 0x0000035a */ { 1, { 0x0000035a } },
	/* 0x0000035b */ { 1, { 0x0000035b } },
	/* 0x0000035c */ { 1, { 0x0000035c } },
	/* 0x0000035d */ { 1, { 0x0000035d } },
	/* 0x0000035e */ { 1, { 0x0000035e } },
	/* 0x0000035f */ { 1, { 0x0000035f } },
	/* 0x00000360 */ { 1, { 0x00000360 } },
	/* 0x00000361 */ { 1, { 0x00000361 } },
	/* 0x00000362 */ { 1, { 0x00000362 } },
	/* 0x00000363 */ { 1, { 0x00000363 } },
	/* 0x00000364 */ { 1, { 0x00000364 } },
	/* 0x00000365 */ { 1, { 0x00000365 } },
	/* 0x00000366 */ { 1, { 0x00000366 } },
	/* 0x00000367 */ { 1, { 0x00000367 } },
	/* 0x00000368 */ { 1, { 0x00000368 } },
	/* 0x00000369 */ { 1, { 0x00000369 } },
	/* 0x0000036a */ { 1, { 0x0000036a } },
	/* 0x0000036b */ { 1, { 0x0000036b } },
	/* 0x0000036c */ { 1, { 0x0000036c } },
	/* 0x0000036d */ { 1, { 0x0000036d } },
	/* 0x0000036e */ { 1, { 0x0000036e } },
	/* 0x0000036f */ { 1, { 0x0000036f } },
	/* 0x00000370 */ { 1, { 0x00000370 } },
	/* 0x00000371 */ { 1, { 0x00000371 } },
	/* 0x00000372 */ { 1, { 0x00000372 } },
	/* 0x00000373 */ { 1, { 0x00000373 } },
	/* 0x00000374 */ { 1, { 0x000002b9 } },
	/* 0x00000375 */ { 1, { 0x00000375 } },
	/* 0x00000376 */ { 1, { 0x00000376 } },
	/* 0x00000377 */ { 1, { 0x00000377 } },
	/* 0x00000378 */ { 1, { 0x00000378 } },
	/* 0x00000379 */ { 1, { 0x00000379 } },
	/* 0x0000037a */ { 1, { 0x0000037a } },
	/* 0x0000037b */ { 1, { 0x0000037b } },
	/* 0x0000037c */ { 1, { 0x0000037c } },
	/* 0x0000037d */ { 1, { 0x0000037d } },
	/* 0x0000037e */ { 1, { 0x0000003b } },
	/* 0x0000037f */ { 1, { 0x0000037f } },
	/* 0x00000380 */ { 1, { 0x00000380 } },
	/* 0x00000381 */ { 1, { 0x00000381 } },
	/* 0x00000382 */ { 1, { 0x00000382 } },
	/* 0x00000383 */ { 1, { 0x00000383 } },
	/* 0x00000384 */ { 1, { 0x00000384 } },
	/* 0x00000385 */ { 2, { 0x000000a8, 0x00000301 } },
	/* 0x00000386 */ { 2, { 0x00000391, 0x00000301 } },
	/* 0x00000387 */ { 1, { 0x000000b7 } },
	/* 0x00000388 */ { 2, { 0x00000395, 0x00000301 } },
	/* 0x00000389 */ { 2, { 0x00000397, 0x00000301 } },
	/* 0x0000038a */ { 2, { 0x00000399, 0x00000301 } },
	/* 0x0000038b */ { 1, { 0x0000038b } },
	/* 0x0000038c */ { 2, { 0x0000039f, 0x00000301 } },
	/* 0x0000038d */ { 1, { 0x0000038d } },
	/* 0x0000038e */ { 2, { 0x000003a5, 0x00000301 } },
	/* 0x0000038f */ { 2, { 0x000003a9, 0x00000301 } },
	/* 0x00000390 */ { 3, { 0x000003b9, 0x00000308, 0x00000301 } },
	/* 0x00000391 */ { 1, { 0x00000391 } },
	/* 0x00000392 */ { 1, { 0x00000392 } },
	/* 0x00000393 */ { 1, { 0x00000393 } },
	/* 0x00000394 */ { 1, { 0x00000394 } },
	/* 0x00000395 */ { 1, { 0x00000395 } },
	/* 0x00000396 */ { 1, { 0x00000396 } },
	/* 0x00000397 */ { 1, { 0x00000397 } },
	/* 0x00000398 */ { 1, { 0x00000398 } },
	/* 0x00000399 */ { 1, { 0x00000399 } },
	/* 0x0000039a */ { 1, { 0x0000039a } },
	/* 0x0000039b */ { 1, { 0x0000039b } },
	/* 0x0000039c */ { 1, { 0x0000039c } },
	/* 0x0000039d */ { 1, { 0x0000039d } },
	/* 0x0000039e */ { 1, { 0x0000039e } },
	/* 0x0000039f */ { 1, { 0x0000039f } },
	/* 0x000003a0 */ { 1, { 0x000003a0 } },
	/* 0x000003a1 */ { 1, { 0x000003a1 } },
	/* 0x000003a2 */ { 1, { 0x000003a2 } },
	/* 0x000003a3 */ { 1, { 0x000003a3 } },
	/* 0x000003a4 */ { 1, { 0x000003a4 } },
	/* 0x000003a5 */ { 1, { 0x000003a5 } },
	/* 0x000003a6 */ { 1, { 0x000003a6 } },
	/* 0x000003a7 */ { 1, { 0x000003a7 } },
	/* 0x000003a8 */ { 1, { 0x000003a8 } },
	/* 0x000003a9 */ { 1, { 0x000003a9 } },
	/* 0x000003aa */ { 2, { 0x00000399, 0x00000308 } },
	/* 0x000003ab */ { 2, { 0x000003a5, 0x00000308 } },
	/* 0x000003ac */ { 2, { 0x000003b1, 0x00000301 } },
	/* 0x000003ad */ { 2, { 0x000003b5, 0x00000301 } },
	/* 0x000003ae */ { 2, { 0x000003b7, 0x00000301 } },
	/* 0x000003af */ { 2, { 0x000003b9, 0x00000301 } },
	/* 0x000003b0 */ { 3, { 0x000003c5, 0x00000308, 0x00000301 } },
	/* 0x000003b1 */ { 1, { 0x000003b1 } },
	/* 0x000003b2 */ { 1, { 0x000003b2 } },
	/* 0x000003b3 */ { 1, { 0x000003b3 } },
	/* 0x000003b4 */ { 1, { 0x000003b4 } },
	/* 0x000003b5 */ { 1, { 0x000003b5 } },
	/* 0x000003b6 */ { 1, { 0x000003b6 } },
	/* 0x000003b7 */ { 1, { 0x000003b7 } },
	/* 0x000003b8 */ { 1, { 0x000003b8 } },
	/* 0x000003b9 */ { 1, { 0x000003b9 } },
	/* 0x000003ba */ { 1, { 0x000003ba } },
	/* 0x000003bb */ { 1, { 0x000003bb } },
	/* 0x000003bc */ { 1, { 0x000003bc } },
	/* 0x000003bd */ { 1, { 0x000003bd } },
	/* 0x000003be */ { 1, { 0x000003be } },
	/* 0x000003bf */ { 1, { 0x000003bf } },
	/* 0x000003c0 */ { 1, { 0x000003c0 } },
	/* 0x000003c1 */ { 1, { 0x000003c1 } },
	/* 0x000003c2 */ { 1, { 0x000003c2 } },
	/* 0x000003c3 */ { 1, { 0x000003c3 } },
	/* 0x000003c4 */ { 1, { 0x000003c4 } },
	/* 0x000003c5 */ { 1, { 0x000003c5 } },
	/* 0x000003c6 */ { 1, { 0x000003c6 } },
	/* 0x000003c7 */ { 1, { 0x000003c7 } },
	/* 0x000003c8 */ { 1, { 0x000003c8 } },
	/* 0x000003c9 */ { 1, { 0x000003c9 } },
	/* 0x000003ca */ { 2, { 0x000003b9, 0x00000308 } },
	/* 0x000003cb */ { 2, { 0x000003c5, 0x00000308 } },
	/* 0x000003cc */ { 2, { 0x000003bf, 0x00000301 } },
	/* 0x000003cd */ { 2, { 0x000003c5, 0x00000301 } },
	/* 0x000003ce */ { 2, { 0x000003c9, 0x00000301 } },
	/* 0x000003cf */ { 1, { 0x000003cf } },
	/* 0x000003d0 */ { 1, { 0x000003d0 } },
	/* 0x000003d1 */ { 1, { 0x000003d1 } },
	/* 0x000003d2 */ { 1, { 0x000003d2 } },
	/* 0x000003d3 */ { 2, { 0x000003d2, 0x00000301 } },
	/* 0x000003d4 */ { 2, { 0x000003d2, 0x00000308 } },
	/* 0x000003d5 */ { 1, { 0x000003d5 } },
	/* 0x000003d6 */ { 1, { 0x000003d6 } },
	/* 0x000003d7 */ { 1, { 0x000003d7 } }
};

libfshfs_name_decomposition_mapping_t libfshfs_name_decomposition_mappings_0x00000400[ 256 ] = {
	/* 0x00000400 */ { 2, { 0x00000415, 0x00000300 } },
	/* 0x00000401 */ { 2, { 0x00000415, 0x00000308 } },
	/* 0x00000402 */ { 1, { 0x00000402 } },
	/* 0x00000403 */ { 2, { 0x00000413, 0x00000301 } },
	/* 0x00000404 */ { 1, { 0x00000404 } },
	/* 0x00000405 */ { 1, { 0x00000405 } },
	/* 0x00000406 */ { 1, { 0x00000406 } },
	/* 0x00000407 */ { 2, { 0x00000406, 0x00000308 } },
	/* 0x00000408 */ { 1, { 0x00000408 } },
	/* 0x00000409 */ { 1, { 0x00000409 } },
	/* 0x0000040a */ { 1, { 0x0000040a } },
	/* 0x0000040b */ { 1, { 0x0000040b } },
	/* 0x0000040c */ { 2, { 0x0000041a, 0x00000301 } },
	/* 0x0000040d */ { 2, { 0x00000418, 0x00000300 } },
	/* 0x0000040e */ { 2, { 0x00000423, 0x00000306 } },
	/* 0x0000040f */ { 1, { 0x0000040f } },
	/* 0x00000410 */ { 1, { 0x00000410 } },
	/* 0x00000411 */ { 1, { 0x00000411 } },
	/* 0x00000412 */ { 1, { 0x00000412 } },
	/* 0x00000413 */ { 1, { 0x00000413 } },
	/* 0x00000414 */ { 1, { 0x00000414 } },
	/* 0x00000415 */ { 1, { 0x00000415 } },
	/* 0x00000416 */ { 1, { 0x00000416 } },
	/* 0x00000417 */ { 1, { 0x00000417 } },
	/* 0x00000418 */ { 1, { 0x00000418 } },
	/* 0x00000419 */ { 2, { 0x00000418, 0x00000306 } },
	/* 0x0000041a */ { 1, { 0x0000041a } },
	/* 0x0000041b */ { 1, { 0x0000041b } },
	/* 0x0000041c */ { 1, { 0x0000041c } },
	/* 0x0000041d */ { 1, { 0x0000041d } },
	/* 0x0000041e */ { 1, { 0x0000041e } },
	/* 0x0000041f */ { 1, { 0x0000041f } },
	/* 0x00000420 */ { 1, { 0x00000420 } },
	/* 0x00000421 */ { 1, { 0x00000421 } },
	/* 0x00000422 */ { 1, { 0x00000422 } },
	/* 0x00000423 */ { 1, { 0x00000423 } },
	/* 0x00000424 */ { 1, { 0x00000424 } },
	/* 0x00000425 */ { 1, { 0x00000425 } },
	/* 0x00000426 */ { 1, { 0x00000426 } },
	/* 0x00000427 */ { 1, { 0x00000427 } },
	/* 0x00000428 */ { 1, { 0x00000428 } },
	/* 0x00000429 */ { 1, { 0x00000429 } },
	/* 0x0000042a */ { 1, { 0x0000042a } },
	/* 0x0000042b */ { 1, { 0x0000042b } },
	/* 0x0000042c */ { 1, { 0x0000042c } },
	/* 0x0000042d */ { 1, { 0x0000042d } },
	/* 0x0000042e */ { 1, { 0x0000042e } },
	/* 0x0000042f */ { 1, { 0x0000042f } },
	/* 0x00000430 */ { 1, { 0x00000430 } },
	/* 0x00000431 */ { 1, { 0x00000431 } },
	/* 0x00000432 */ { 1, { 0x00000432 } },
	/* 0x00000433 */ { 1, { 0x00000433 } },
	/* 0x00000434 */ { 1, { 0x00000434 } },
	/* 0x00000435 */ { 1, { 0x00000435 } },
	/* 0x00000436 */ { 1, { 0x00000436 } },
	/* 0x00000437 */ { 1, { 0x00000437 } },
	/* 0x00000438 */ { 1, { 0x00000438 } },
	/* 0x00000439 */ { 2, { 0x00000438, 0x00000306 } },
	/* 0x0000043a */ { 1, { 0x0000043a } },
	/* 0x0000043b */ { 1, { 0x0000043b } },
	/* 0x0000043c */ { 1, { 0x0000043c } },
	/* 0x0000043d */ { 1, { 0x0000043d } },
	/* 0x0000043e */ { 1, { 0x0000043e } },
	/* 0x0000043f */ { 1, { 0x0000043f } },
	/* 0x00000440 */ { 1, { 0x00000440 } },
	/* 0x00000441 */ { 1, { 0x00000441 } },
	/* 0x00000442 */ { 1, { 0x00000442 } },
	/* 0x00000443 */ { 1, { 0x00000443 } },
	/* 0x00000444 */ { 1, { 0x00000444 } },
	/* 0x00000445 */ { 1, { 0x00000445 } },
	/* 0x00000446 */ { 1, { 0x00000446 } },
	/* 0x00000447 */ { 1, { 0x00000447 } },
	/* 0x00000448 */ { 1, { 0x00000448 } },
	/* 0x00000449 */ { 1, { 0x00000449 } },
	/* 0x0000044a */ { 1, { 0x0000044a } },
	/* 0x0000044b */ { 1, { 0x0000044b } },
	/* 0x0000044c */ { 1, { 0x0000044c } },
	/* 0x0000044d */ { 1, { 0x0000044d } },
	/* 0x0000044e */ { 1, { 0x0000044e } },
	/* 0x0000044f */ { 1, { 0x0000044f } },
	/* 0x00000450 */ { 2, { 0x00000435, 0x00000300 } },
	/* 0x00000451 */ { 2, { 0x00000435, 0x00000308 } },
	/* 0x00000452 */ { 1, { 0x00000452 } },
	/* 0x00000453 */ { 2, { 0x00000433, 0x00000301 } },
	/* 0x00000454 */ { 1, { 0x00000454 } },
	/* 0x00000455 */ { 1, { 0x00000455 } },
	/* 0x00000456 */ { 1, { 0x00000456 } },
	/* 0x00000457 */ { 2, { 0x00000456, 0x00000308 } },
	/* 0x00000458 */ { 1, { 0x00000458 } },
	/* 0x00000459 */ { 1, { 0x00000459 } },
	/* 0x0000045a */ { 1, { 0x0000045a } },
	/* 0x0000045b */ { 1, { 0x0000045b } },
	/* 0x0000045c */ { 2, { 0x0000043a, 0x00000301 } },
	/* 0x0000045d */ { 2, { 0x00000438, 0x00000300 } },
	/* 0x0000045e */ { 2, { 0x00000443, 0x00000306 } },
	/* 0x0000045f */ { 1, { 0x0000045f } },
	/* 0x00000460 */ { 1, { 0x00000460 } },
	/* 0x00000461 */ { 1, { 0x00000461 } },
	/* 0x00000462 */ { 1, { 0x00000462 } },
	/* 0x00000463 */ { 1, { 0x00000463 } },
	/* 0x00000464 */ { 1, { 0x00000464 } },
	/* 0x00000465 */ { 1, { 0x00000465 } },
	/* 0x00000466 */ { 1, { 0x00000466 } },
	/* 0x00000467 */ { 1, { 0x00000467 } },
	/* 0x00000468 */ { 1, { 0x00000468 } },
	/* 0x00000469 */ { 1, { 0x00000469 } },
	/* 0x0000046a */ { 1, { 0x0000046a } },
	/* 0x0000046b */ { 1, { 0x0000046b } },
	/* 0x0000046c */ { 1, { 0x0000046c } },
	/* 0x0000046d */ { 1, { 0x0000046d } },
	/* 0x0000046e */ { 1, { 0x0000046e } },
	/* 0x0000046f */ { 1, { 0x0000046f } },
	/* 0x00000470 */ { 1, { 0x00000470 } },
	/* 0x00000471 */ { 1, { 0x00000471 } },
	/* 0x00000472 */ { 1, { 0x00000472 } },
	/* 0x00000473 */ { 1, { 0x00000473 } },
	/* 0x00000474 */ { 1, { 0x00000474 } },
	/* 0x00000475 */ { 1, { 0x00000475 } },
	/* 0x00000476 */ { 2, { 0x00000474, 0x0000030f } },
	/* 0x00000477 */ { 2, { 0x00000475, 0x0000030f } },
	/* 0x00000478 */ { 1, { 0x00000478 } },
	/* 0x00000479 */ { 1, { 0x00000479 } },
	/* 0x0000047a */ { 1, { 0x0000047a } },
	/* 0x0000047b */ { 1, { 0x0000047b } },
	/* 0x0000047c */ { 1, { 0x0000047c } },
	/* 0x0000047d */ { 1, { 0x0000047d } },
	/* 0x0000047e */ { 1, { 0x0000047e } },
	/* 0x0000047f */ { 1, { 0x0000047f } },
	/* 0x00000480 */ { 1, { 0x00000480 } },
	/* 0x00000481 */ { 1, { 0x00000481 } },
	/* 0x00000482 */ { 1, { 0x00000482 } },
	/* 0x00000483 */ { 1, { 0x00000483 } },
	/* 0x00000484 */ { 1, { 0x00000484 } },
	/* 0x00000485 */ { 1, { 0x00000485 } },
	/* 0x00000486 */ { 1, { 0x00000486 } },
	/* 0x00000487 */ { 1, { 0x00000487 } },
	/* 0x00000488 */ { 1, { 0x00000488 } },
	/* 0x00000489 */ { 1, { 0x00000489 } },
	/* 0x0000048a */ { 1, { 0x0000048a } },
	/* 0x0000048b */ { 1, { 0x0000048b } },
	/* 0x0000048c */ { 1, { 0x0000048c } },
	/* 0x0000048d */ { 1, { 0x0000048d } },
	/* 0x0000048e */ { 1, { 0x0000048e } },
	/* 0x0000048f */ { 1, { 0x0000048f } },
	/* 0x00000490 */ { 1, { 0x00000490 } },
	/* 0x00000491 */ { 1, { 0x00000491 } },
	/* 0x00000492 */ { 1, { 0x00000492 } },
	/* 0x00000493 */ { 1, { 0x00000493 } },
	/* 0x00000494 */ { 1, { 0x00000494 } },
	/* 0x00000495 */ { 1, { 0x00000495 } },
	/* 0x00000496 */ { 1, { 0x00000496 } },
	/* 0x00000497 */ { 1, { 0x00000497 } },
	/* 0x00000498 */ { 1, { 0x00000498 } },
	/* 0x00000499 */ { 1, { 0x00000499 } },
	/* 0x0000049a */ { 1, { 0x0000049a } },
	/* 0x0000049b */ { 1, { 0x0000049b } },
	/* 0x0000049c */ { 1, { 0x0000049c } },
	/* 0x0000049d */ { 1, { 0x0000049d } },
	/* 0x0000049e */ { 1, { 0x0000049e } },
	/* 0x0000049f */ { 1, { 0x0000049f } },
	/* 0x000004a0 */ { 1, { 0x000004a0 } },
	/* 0x000004a1 */ { 1, { 0x000004a1 } },
	/* 0x000004a2 */ { 1, { 0x000004a2 } },
	/* 0x000004a3 */ { 1, { 0x000004a3 } },
	/* 0x000004a4 */ { 1, { 0x000004a4 } },
	/* 0x000004a5 */ { 1, { 0x000004a5 } },
	/* 0x000004a6 */ { 1, { 0x000004a6 } },
	/* 0x000004a7 */ { 1, { 0x000004a7 } },
	/* 0x000004a8 */ { 1, { 0x000004a8 } },
	/* 0x000004a9 */ { 1, { 0x000004a9 } },
	/* 0x000004aa */ { 1, { 0x000004aa } },
	/* 0x000004ab */ { 1, { 0x000004ab } },
	/* 0x000004ac */ { 1, { 0x000004ac } },
	/* 0x000004ad */ { 1, { 0x000004ad } },
	/* 0x000004ae */ { 1, { 0x000004ae } },
	/* 0x000004af */ { 1, { 0x000004af } },
	/* 0x000004b0 */ { 1, { 0x000004b0 } },
	/* 0x000004b1 */ { 1, { 0x000004b1 } },
	/* 0x000004b2 */ { 1, { 0x000004b2 } },
	/* 0x000004b3 */ { 1, { 0x000004b3 } },
	/* 0x000004b4 */ { 1, { 0x000004b4 } },
	/* 0x000004b5 */ { 1, { 0x000004b5 } },
	/* 0x000004b6 */ { 1, { 0x000004b6 } },
	/* 0x000004b7 */ { 1, { 0x000004b7 } },
	/* 0x000004b8 */ { 1, { 0x000004b8 } },
	/* 0x000004b9 */ { 1, { 0x000004b9 } },
	/* 0x000004ba */ { 1, { 0x000004ba } },
	/* 0x000004bb */ { 1, { 0x000004bb } },
	/* 0x000004bc */ { 1, { 0x000004bc } },
	/* 0x000004bd */ { 1, { 0x000004bd } },
	/* 0x000004be */ { 1, { 0x000004be } },
	/* 0x000004bf */ { 1, { 0x000004bf } },
	/* 0x000004c0 */ { 1, { 0x000004c0 } },
	/* 0x000004c1 */ { 2, { 0x00000416, 0x00000306 } },
	/* 0x000004c2 */ { 2, { 0x00000436, 0x00000306 } },
	/* 0x000004c3 */ { 1, { 0x000004c3 } },
	/* 0x000004c4 */ { 1, { 0x000004c4 } },
	/* 0x000004c5 */ { 1, { 0x000004c5 } },
	/* 0x000004c6 */ { 1, { 0x000004c6 } },
	/* 0x000004c7 */ { 1, { 0x000004c7 } },
	/* 0x000004c8 */ { 1, { 0x000004c8 } },
	/* 0x000004c9 */ { 1, { 0x000004c9 } },
	/* 0x000004ca */ { 1, { 0x000004ca } },
	/* 0x000004cb */ { 1, { 0x000004cb } },
	/* 0x000004cc */ { 1, { 0x000004cc } },
	/* 0x000004cd */ { 1, { 0x000004cd } },
	/* 0x000004ce */ { 1, { 0x000004ce } },
	/* 0x000004cf */ { 1, { 0x000004cf } },
	/* 0x000004d0 */ { 2, { 0x00000410, 0x00000306 } },
	/* 0x000004d1 */ { 2, { 0x00000430, 0x00000306 } },
	/* 0x000004d2 */ { 2, { 0x00000410, 0x00000308 } },
	/* 0x000004d3 */ { 2, { 0x00000430, 0x00000308 } },
	/* 0x000004d4 */ { 1, { 0x000004d4 } },
	/* 0x000004d5 */ { 1, { 0x000004d5 } },
	/* 0x000004d6 */ { 2, { 0x00000415, 0x00000306 } },
	/* 0x000004d7 */ { 2, { 0x00000435, 0x00000306 } },
	/* 0x000004d8 */ { 1, { 0x000004d8 } },
	/* 0x000004d9 */ { 1, { 0x000004d9 } },
	/* 0x000004da */ { 2, { 0x000004d8, 0x00000308 } },
	/* 0x000004db */ { 2, { 0x000004d9, 0x00000308 } },
	/* 0x000004dc */ { 2, { 0x00000416, 0x00000308 } },
	/* 0x000004dd */ { 2, { 0x00000436, 0x00000308 } },
	/* 0x000004de */ { 2, { 0x00000417, 0x00000308 } },
	/* 0x000004df */ { 2, { 0x00000437, 0x00000308 } },
	/* 0x000004e0 */ { 1, { 0x000004e0 } },
	/* 0x000004e1 */ { 1, { 0x000004e1 } },
	/* 0x000004e2 */ { 2, { 0x00000418, 0x00000304 } },
	/* 0x000004e3 */ { 2, { 0x00000438, 0x00000304 } },
	/* 0x000004e4 */ { 2, { 0x00000418, 0x00000308 } },
	/* 0x000004e5 */ { 2, { 0x00000438, 0x00000308 } },
	/* 0x000004e6 */ { 2, { 0x0000041e, 0x00000308 } },
	/* 0x000004e7 */ { 2, { 0x0000043e, 0x00000308 } },
	/* 0x000004e8 */ { 1, { 0x000004e8 } },
	/* 0x000004e9 */ { 1, { 0x000004e9 } },
	/* 0x000004ea */ { 2, { 0x000004e8, 0x00000308 } },
	/* 0x000004eb */ { 2, { 0x000004e9, 0x00000308 } },
	/* 0x000004ec */ { 2, { 0x0000042d, 0x00000308 } },
	/* 0x000004ed */ { 2, { 0x0000044d, 0x00000308 } },
	/* 0x000004ee */ { 2, { 0x00000423, 0x00000304 } },
	/* 0x000004ef */ { 2, { 0x00000443, 0x00000304 } },
	/* 0x000004f0 */ { 2, { 0x00000423, 0x00000308 } },
	/* 0x000004f1 */ { 2, { 0x00000443, 0x00000308 } },
	/* 0x000004f2 */ { 2, { 0x00000423, 0x0000030b } },
	/* 0x000004f3 */ { 2, { 0x00000443, 0x0000030b } },
	/* 0x000004f4 */ { 2, { 0x00000427, 0x00000308 } },
	/* 0x000004f5 */ { 2, { 0x00000447, 0x00000308 } },
	/* 0x000004f6 */ { 1, { 0x000004f6 } },
	/* 0x000004f7 */ { 1, { 0x000004f7 } },
	/* 0x000004f8 */ { 2, { 0x0000042b, 0x00000308 } },
	/* 0x000004f9 */ { 2, { 0x0000044b, 0x00000308 } },
	/* 0x000004fa */ { 1, { 0x000004fa } },
	/* 0x000004fb */ { 1, { 0x000004fb } },
	/* 0x000004fc */ { 1, { 0x000004fc } },
	/* 0x000004fd */ { 1, { 0x000004fd } },
	/* 0x000004fe */ { 1, { 0x000004fe } },
	/* 0x000004ff */ { 1, { 0x000004ff } }
};

libfshfs_name_decomposition_mapping_t libfshfs_name_decomposition_mappings_0x00000620[ 184 ] = {
	/* 0x00000620 */ { 1, { 0x00000620 } },
	/* 0x00000621 */ { 1, { 0x00000621 } },
	/* 0x00000622 */ { 2, { 0x00000627, 0x00000653 } },
	/* 0x00000623 */ { 2, { 0x00000627, 0x00000654 } },
	/* 0x00000624 */ { 2, { 0x00000648, 0x00000654 } },
	/* 0x00000625 */ { 2, { 0x00000627, 0x00000655 } },
	/* 0x00000626 */ { 2, { 0x0000064a, 0x00000654 } },
	/* 0x00000627 */ { 1, { 0x00000627 } },
	/* 0x00000628 */ { 1, { 0x00000628 } },
	/* 0x00000629 */ { 1, { 0x00000629 } },
	/* 0x0000062a */ { 1, { 0x0000062a } },
	/* 0x0000062b */ { 1, { 0x0000062b } },
	/* 0x0000062c */ { 1, { 0x0000062c } },
	/* 0x0000062d */ { 1, { 0x0000062d } },
	/* 0x0000062e */ { 1, { 0x0000062e } },
	/* 0x0000062f */ { 1, { 0x0000062f } },
	/* 0x00000630 */ { 1, { 0x00000630 } },
	/* 0x00000631 */ { 1, { 0x00000631 } },
	/* 0x00000632 */ { 1, { 0x00000632 } },
	/* 0x00000633 */ { 1, { 0x00000633 } },
	/* 0x00000634 */ { 1, { 0x00000634 } },
	/* 0x00000635 */ { 1, { 0x00000635 } },
	/* 0x00000636 */ { 1, { 0x00000636 } },
	/* 0x00000637 */ { 1, { 0x00000637 } },
	/* 0x00000638 */ { 1, { 0x00000638 } },
	/* 0x00000639 */ { 1, { 0x00000639 } },
	/* 0x0000063a */ { 1, { 0x0000063a } },
	/* 0x0000063b */ { 1, { 0x0000063b } },
	/* 0x0000063c */ { 1, { 0x0000063c } },
	/* 0x0000063d */ { 1, { 0x0000063d } },
	/* 0x0000063e */ { 1, { 0x0000063e } },
	/* 0x0000063f */ { 1, { 0x0000063f } },
	/* 0x00000640 */ { 1, { 0x00000640 } },
	/* 0x00000641 */ { 1, { 0x00000641 } },
	/* 0x00000642 */ { 1, { 0x00000642 } },
	/* 0x00000643 */ { 1, { 0x00000643 } },
	/* 0x00000644 */ { 1, { 0x00000644 } },
	/* 0x00000645 */ { 1, { 0x00000645 } },
	/* 0x00000646 */ { 1, { 0x00000646 } },
	/* 0x00000647 */ { 1, { 0x00000647 } },
	/* 0x00000648 */ { 1, { 0x00000648 } },
	/* 0x00000649 */ { 1, { 0x00000649 } },
	/* 0x0000064a */ { 1, { 0x0000064a } },
	/* 0x0000064b */ { 1, { 0x0000064b } },
	/* 0x0000064c */ { 1, { 0x0000064c } },
	/* 0x0000064d */ { 1, { 0x0000064d } },
	/* 0x0000064e */ { 1, { 0x0000064e } },
	/* 0x0000064f */ { 1, { 0x0000064f } },
	/* 0x00000650 */ { 1, { 0x00000650 } },
	/* 0x00000651 */ { 1, { 0x00000651 } },
	/* 0x00000652 */ { 1, { 0x00000652 } },
	/* 0x00000653 */ { 1, { 0x00000653 } },
	/* 0x00000654 */ { 1, { 0x00000654 } },
	/* 0x00000655 */ { 1, { 0x00000655 } },
	/* 0x00000656 */ { 1, { 0x00000656 } },
	/* 0x00000657 */ { 1, { 0x00000657 } },
	/* 0x00000658 */ { 1, { 0x00000658 } },
	/* 0x00000659 */ { 1, { 0x00000659 } },
	/* 0x0000065a */ { 1, { 0x0000065a } },
	/* 0x0000065b */ { 1, { 0x0000065b } },
	/* 0x0000065c */ { 1, { 0x0000065c } },
	/* 0x0000065d */ { 1, { 0x0000065d } },
	/* 0x0000065e */ { 1, { 0x0000065e } },
	/* 0x0000065f */ { 1, { 0x0000065f } },
	/* 0x00000660 */ { 1, { 0x00000660 } },
	/* 0x00000661 */ { 1, { 0x00000661 } },
	/* 0x00000662 */ { 1, { 0x00000662 } },
	/* 0x00000663 */ { 1, { 0x00000663 } },
	/* 0x00000664 */ { 1, { 0x00000664 } },
	/* 0x00000665 */ { 1, { 0x00000665 } },
	/* 0x00000666 */ { 1, { 0x00000666 } },
	/* 0x00000667 */ { 1, { 0x00000667 } },
	/* 0x00000668 */ { 1, { 0x00000668 } },
	/* 0x00000669 */ { 1, { 0x00000669 } },
	/* 0x0000066a */ { 1, { 0x0000066a } },
	/* 0x0000066b */ { 1, { 0x0000066b } },
	/* 0x0000066c */ { 1, { 0x0000066c } },
	/* 0x0000066d */ { 1, { 0x0000066d } },
	/* 0x0000066e */ { 1, { 0x0000066e } },
	/* 0x0000066f */ { 1, { 0x0000066f } },
	/* 0x00000670 */ { 1, { 0x00000670 } },
	/* 0x00000671 */ { 1, { 0x00000671 } },
	/* 0x00000672 */ { 1, { 0x00000672 } },
	/* 0x00000673 */ { 1, { 0x00000673 } },
	/* 0x00000674 */ { 1, { 0x00000674 } },
	/* 0x00000675 */ { 1, { 0x00000675 } },
	/* 0x00000676 */ { 1, { 0x00000676 } },
	/* 0x00000677 */ { 1, { 0x00000677 } },
	/* 0x00000678 */ { 1, { 0x00000678 } },
	/* 0x00000679 */ { 1, { 0x00000679 } },
	/* 0x0000067a */ { 1, { 0x0000067a } },
	/* 0x0000067b */ { 1, { 0x0000067b } },
	/* 0x0000067c */ { 1, { 0x0000067c } },
	/* 0x0000067d */ { 1, { 0x0000067d } },
	/* 0x0000067e */ { 1, { 0x0000067e } },
	/* 0x0000067f */ { 1, { 0x0000067f } },
	/* 0x00000680 */ { 1, { 0x00000680 } },
	/* 0x00000681 */ { 1, { 0x00000681 } },
	/* 0x00000682 */ { 1, { 0x00000682 } },
	/* 0x00000683 */ { 1, { 0x00000683 } },
	/* 0x00000684 */ { 1, { 0x00000684 } },
	/* 0x00000685 */ { 1, { 0x00000685 } },
	/* 0x00000686 */ { 1, { 0x00000686 } },
	/* 0x00000687 */ { 1, { 0x00000687 } },
	/* 0x00000688 */ { 1, { 0x00000688 } },
	/* 0x00000689 */ { 1, { 0x00000689 } },
	/* 0x0000068a */ { 1, { 0x0000068a } },
	/* 0x0000068b */ { 1, { 0x0000068b } },
	/* 0x0000068c */ { 1, { 0x0000068c } },
	/* 0x0000068d */ { 1, { 0x0000068d } },
	/* 0x0000068e */ { 1, { 0x0000068e } },
	/* 0x0000068f */ { 1, { 0x0000068f } },
	/* 0x00000690 */ { 1, { 0x00000690 } },
	/* 0x00000691 */ { 1, { 0x00000691 } },
	/* 0x00000692 */ { 1, { 0x00000692 } },
	/* 0x00000693 */ { 1, { 0x00000693 } },
	/* 0x00000694 */ { 1, { 0x00000694 } },
	/* 0x00000695 */ { 1, { 0x00000695 } },
	/* 0x00000696 */ { 1, { 0x00000696 } },
	/* 0x00000697 */ { 1, { 0x00000697 } },
	/* 0x00000698 */ { 1, { 0x00000698 } },
	/* 0x00000699 */ { 1, { 0x00000699 } },
	/* 0x0000069a */ { 1, { 0x0000069a } },
	/* 0x0000069b */ { 1, { 0x0000069b } },
	/* 0x0000069c */ { 1, { 0x0000069c } },
	/* 0x0000069d */ { 1, { 0x0000069d } },
	/* 0x0000069e */ { 1, { 0x0000069e } },
	/* 0x0000069f */ { 1, { 0x0000069f } },
	/* 0x000006a0 */ { 1, { 0x000006a0 } },
	/* 0x000006a1 */ { 1, { 0x000006a1 } },
	/* 0x000006a2 */ { 1, { 0x000006a2 } },
	/* 0x000006a3 */ { 1, { 0x000006a3 } },
	/* 0x000006a4 */ { 1, { 0x000006a4 } },
	/* 0x000006a5 */ { 1, { 0x000006a5 } },
	/* 0x000006a6 */ { 1, { 0x000006a6 } },
	/* 0x000006a7 */ { 1, { 0x000006a7 } },
	/* 0x000006a8 */ { 1, { 0x000006a8 } },
	/* 0x000006a9 */ { 1, { 0x000006a9 } },
	/* 0x000006aa */ { 1, { 0x000006aa } },
	/* 0x000006ab */ { 1, { 0x000006ab } },
	/* 0x000006ac */ { 1, { 0x000006ac } },
	/* 0x000006ad */ { 1, { 0x000006ad } },
	/* 0x000006ae */ { 1, { 0x000006ae } },
	/* 0x000006af */ { 1, { 0x000006af } },
	/* 0x000006b0 */ { 1, { 0x000006b0 } },
	/* 0x000006b1 */ { 1, { 0x000006b1 } },
	/* 0x000006b2 */ { 1, { 0x000006b2 } },
	/* 0x000006b3 */ { 1, { 0x000006b3 } },
	/* 0x000006b4 */ { 1, { 0x000006b4 } },
	/* 0x000006b5 */ { 1, { 0x000006b5 } },
	/* 0x000006b6 */ { 1, { 0x000006b6 } },
	/* 0x000006b7 */ { 1, { 0x000006b7 } },
	/* 0x000006b8 */ { 1, { 0x000006b8 } },
	/* 0x000006b9 */ { 1, { 0x000006b9 } },
	/* 0x000006ba */ { 1, { 0x000006ba } },
	/* 0x000006bb */ { 1, { 0x000006bb } },
	/* 0x000006bc */ { 1, { 0x000006bc } },
	/* 0x000006bd */ { 1, { 0x000006bd } },
	/* 0x000006be */ { 1, { 0x000006be } },
	/* 0x000006bf */ { 1, { 0x000006bf } },
	/* 0x000006c0 */ { 2, { 0x000006d5, 0x00000654 } },
	/* 0x000006c1 */ { 1, { 0x000006c1 } },
	/* 0x000006c2 */ { 2, { 0x000006c1, 0x00000654 } },
	/* 0x000006c3 */ { 1, { 0x000006c3 } },
	/* 0x000006c4 */ { 1, { 0x000006c4 } },
	/* 0x000006c5 */ { 1, { 0x000006c5 } },
	/* 0x000006c6 */ { 1, { 0x000006c6 } },
	/* 0x000006c7 */ { 1, { 0x000006c7 } },
	/* 0x000006c8 */ { 1, { 0x000006c8 } },
	/* 0x000006c9 */ { 1, { 0x000006c9 } },
	/* 0x000006ca */ { 1, { 0x000006ca } },
	/* 0x000006cb */ { 1, { 0x000006cb } },
	/* 0x000006cc */ { 1, { 0x000006cc } },
	/* 0x000006cd */ { 1, { 0x000006cd } },
	/* 0x000006ce */ { 1, { 0x000006ce } },
	/* 0x000006cf */ { 1, { 0x000006cf } },
	/* 0x000006d0 */ { 1, { 0x000006d0 } },
	/* 0x000006d1 */ { 1, { 0x000006d1 } },
	/* 0x000006d2 */ { 1, { 0x000006d2 } },
	/* 0x000006d3 */ { 2, { 0x000006d2, 0x00000654 } },
	/* 0x000006d4 */ { 1, { 0x000006d4 } },
	/* 0x000006d5 */ { 1, { 0x000006d5 } },
	/* 0x000006d6 */ { 1, { 0x000006d6 } },
	/* 0x000006d7 */ { 1, { 0x000006d7 } }
};

libfshfs_name_decomposition_mapping_t libfshfs_name_decomposition_mappings_0x00000928[ 184 ] = {
	/* 0x00000928 */ { 1, { 0x00000928 } },
	/* 0x00000929 */ { 2, { 0x00000928, 0x0000093c } },
	/* 0x0000092a */ { 1, { 0x0000092a } },
	/* 0x0000092b */ { 1, { 0x0000092b } },
	/* 0x0000092c */ { 1, { 0x0000092c } },
	/* 0x0000092d */ { 1, { 0x0000092d } },
	/* 0x0000092e */ { 1, { 0x0000092e } },
	/* 0x0000092f */ { 1, { 0x0000092f } },
	/* 0x00000930 */ { 1, { 0x00000930 } },
	/* 0x00000931 */ { 2, { 0x00000930, 0x0000093c } },
	/* 0x00000932 */ { 1, { 0x00000932 } },
	/* 0x00000933 */ { 1, { 0x00000933 } },
	/* 0x00000934 */ { 2, { 0x00000933, 0x0000093c } },
	/* 0x00000935 */ { 1, { 0x00000935 } },
	/* 0x00000936 */ { 1, { 0x00000936 } },
	/* 0x00000937 */ { 1, { 0x00000937 } },
	/* 0x00000938 */ { 1, { 0x00000938 } },
	/* 0x00000939 */ { 1, { 0x00000939 } },
	/* 0x0000093a */ { 1, { 0x0000093a } },
	/* 0x0000093b */ { 1, { 0x0000093b } },
	/* 0x0000093c */ { 1, { 0x0000093c } },
	/* 0x0000093d */ { 1, { 0x0000093d } },
	/* 0x0000093e */ { 1, { 0x0000093e } },
	/* 0x0000093f */ { 1, { 0x0000093f } },
	/* 0x00000940 */ { 1, { 0x00000940 } },
	/* 0x00000941 */ { 1, { 0x00000941 } },
	/* 0x00000942 */ { 1, { 0x00000942 } },
	/* 0x00000943 */ { 1, { 0x00000943 } },
	/* 0x00000944 */ { 1, { 0x00000944 } },
	/* 0x00000945 */ { 1, { 0x00000945 } },
	/* 0x00000946 */ { 1, { 0x00000946 } },
	/* 0x00000947 */ { 1, { 0x00000947 } },
	/* 0x00000948 */ { 1, { 0x00000948 } },
	/* 0x00000949 */ { 1, { 0x00000949 } },
	/* 0x0000094a */ { 1, { 0x0000094a } },
	/* 0x0000094b */ { 1, { 0x0000094b } },
	/* 0x0000094c */ { 1, { 0x0000094c } },
	/* 0x0000094d */ { 1, { 0x0000094d } },
	/* 0x0000094e */ { 1, { 0x0000094e } },
	/* 0x0000094f */ { 1, { 0x0000094f } },
	/* 0x00000950 */ { 1, { 0x00000950 } },
	/* 0x00000951 */ { 1, { 0x00000951 } },
	/* 0x00000952 */ { 1, { 0x00000952 } },
	/* 0x00000953 */ { 1, { 0x00000953 } },
	/* 0x00000954 */ { 1, { 0x00000954 } },
	/* 0x00000955 */ { 1, { 0x00000955 } },
	/* 0x00000956 */ { 1, { 0x00000956 } },
	/* 0x00000957 */ { 1, { 0x00000957 } },
	/* 0x00000958 */ { 2, { 0x00000915, 0x0000093c } },
	/* 0x00000959 */ { 2, { 0x00000916, 0x0000093c } },
	/* 0x0000095a */ { 2, { 0x00000917, 0x0000093c } },
	/* 0x0000095b */ { 2, { 0x0000091c, 0x0000093c } },
	/* 0x0000095c */ { 2, { 0x00000921, 0x0000093c } },
	/* 0x0000095d */ { 2, { 0x00000922, 0x0000093c } },
	/* 0x0000095e */ { 2, { 0x0000092b, 0x0000093c } },
	/* 0x0000095f */ { 2, { 0x0000092f, 0x0000093c } },
	/* 0x00000960 */ { 1, { 0x00000960 } },
	/* 0x00000961 */ { 1, { 0x00000961 } },
	/* 0x00000962 */ { 1, { 0x00000962 } },
	/* 0x00000963 */ { 1, { 0x00000963 } },
	/* 0x00000964 */ { 1, { 0x00000964 } },
	/* 0x00000965 */ { 1, { 0x00000965 } },
	/* 0x00000966 */ { 1, { 0x00000966 } },
	/* 0x00000967 */ { 1, { 0x00000967 } },
	/* 0x00000968 */ { 1, { 0x00000968 } },
	/* 0x00000969 */ { 1, { 0x00000969 } },
	/* 0x0000096a */ { 1, { 0x0000096a } },
	/* 0x0000096b */ { 1, { 0x0000096b } },
	/* 0x0000096c */ { 1, { 0x0000096c } },
	/* 0x0000096d */ { 1, { 0x0000096d } },
	/* 0x0000096e */ { 1, { 0x0000096e } },
	/* 0x0000096f */ { 1, { 0x0000096f } },
	/* 0x00000970 */ { 1, { 0x00000970 } },
	/* 0x00000971 */ { 1, { 0x00000971 } },
	/* 0x00000972 */ { 1, { 0x00000972 } },
	/* 0x00000973 */ { 1, { 0x00000973 } },
	/* 0x00000974 */ { 1, { 0x00000974 } },
	/* 0x00000975 */ { 1, { 0x00000975 } },
	/* 0x00000976 */ { 1, { 0x00000976 } },
	/* 0x00000977 */ { 1, { 0x00000977 } },
	/* 0x00000978 */ { 1, { 0x00000978 } },
	/* 0x00000979 */ { 1, { 0x00000979 } },
	/* 0x0000097a */ { 1, { 0x0000097a } },
	/* 0x0000097b */ { 1, { 0x0000097b } },
	/* 0x0000097c */ { 1, { 0x0000097c } },
	/* 0x0000097d */ { 1, { 0x0000097d } },
	/* 0x0000097e */ { 1, { 0x0000097e } },
	/* 0x0000097f */ { 1, { 0x0000097f } },
	/* 0x00000980 */ { 1, { 0x00000980 } },
	/* 0x00000981 */ { 1, { 0x00000981 } },
	/* 0x00000982 */ { 1, { 0x00000982 } },
	/* 0x00000983 */ { 1, { 0x00000983 } },
	/* 0x00000984 */ { 1, { 0x00000984 } },
	/* 0x00000985 */ { 1, { 0x00000985 } },
	/* 0x00000986 */ { 1, { 0x00000986 } },
	/* 0x00000987 */ { 1, { 0x00000987 } },
	/* 0x00000988 */ { 1, { 0x00000988 } },
	/* 0x00000989 */ { 1, { 0x00000989 } },
	/* 0x0000098a */ { 1, { 0x0000098a } },
	/* 0x0000098b */ { 1, { 0x0000098b } },
	/* 0x0000098c */ { 1, { 0x0000098c } },
	/* 0x0000098d */ { 1, { 0x0000098d } },
	/* 0x0000098e */ { 1, { 0x0000098e } },
	/* 0x0000098f */ { 1, { 0x0000098f } },
	/* 0x00000990 */ { 1, { 0x00000990 } },
	/* 0x00000991 */ { 1, { 0x00000991 } },
	/* 0x00000992 */ { 1, { 0x00000992 } },
	/* 0x00000993 */ { 1, { 0x00000993 } },
	/* 0x00000994 */ { 1, { 0x00000994 } },
	/* 0x00000995 */ { 1, { 0x00000995 } },
	/* 0x00000996 */ { 1, { 0x00000996 } },
	/* 0x00000997 */ { 1, { 0x00000997 } },
	/* 0x00000998 */ { 1, { 0x00000998 } },
	/* 0x00000999 */ { 1, { 0x00000999 } },
	/* 0x0000099a */ { 1, { 0x0000099a } },
	/* 0x0000099b */ { 1, { 0x0000099b } },
	/* 0x0000099c */ { 1, { 0x0000099c } },
	/* 0x0000099d */ { 1, { 0x0000099d } },
	/* 0x0000099e */ { 1, { 0x0000099e } },
	/* 0x0000099f */ { 1, { 0x0000099f } },
	/* 0x000009a0 */ { 1, { 0x000009a0 } },
	/* 0x000009a1 */ { 1, { 0x000009a1 } },
	/* 0x000009a2 */ { 1, { 0x000009a2 } },
	/* 0x000009a3 */ { 1, { 0x000009a3 } },
	/* 0x000009a4 */ { 1, { 0x000009a4 } },
	/* 0x000009a5 */ { 1, { 0x000009a5 } },
	/* 0x000009a6 */ { 1, { 0x000009a6 } },
	/* 0x000009a7 */ { 1, { 0x000009a7 } },
	/* 0x000009a8 */ { 1, { 0x000009a8 } },
	/* 0x000009a9 */ { 1, { 0x000009a9 } },
	/* 0x000009aa */ { 1, { 0x000009aa } },
	/* 0x000009ab */ { 1, { 0x000009ab } },
	/* 0x000009ac */ { 1, { 0x000009ac } },
	/* 0x000009ad */ { 1, { 0x000009ad } },
	/* 0x000009ae */ { 1, { 0x000009ae } },
	/* 0x000009af */ { 1, { 0x000009af } },
	/* 0x000009b0 */ { 1, { 0x000009b0 } },
	/* 0x000009b1 */ { 1, { 0x000009b1 } },
	/* 0x000009b2 */ { 1, { 0x000009b2 } },
	/* 0x000009b3 */ { 1, { 0x000009b3 } },
	/* 0x000009b4 */ { 1, { 0x000009b4 } },
	/* 0x000009b5 */ { 1, { 0x000009b5 } },
	/* 0x000009b6 */ { 1, { 0x000009b6 } },
	/* 0x000009b7 */ { 1, { 0x000009b7 } },
	/* 0x000009b8 */ { 1, { 0x000009b8 } },
	/* 0x000009b9 */ { 1, { 0x000009b9 } },
	/* 0x000009ba */ { 1, { 0x000009ba } },
	/* 0x000009bb */ { 1, { 0x000009bb } },
	/* 0x000009bc */ { 1, { 0x000009bc } },
	/* 0x000009bd */ { 1, { 0x000009bd } },
	/* 0x000009be */ { 1, { 0x000009be } },
	/* 0x000009bf */ { 1, { 0x000009bf } },
	/* 0x000009c0 */ { 1, { 0x000009c0 } },
	/* 0x000009c1 */ { 1, { 0x000009c1 } },
	/* 0x000009c2 */ { 1, { 0x000009c2 } },
	/* 0x000009c3 */ { 1, { 0x000009c3 } },
	/* 0x000009c4 */ { 1, { 0x000009c4 } },
	/* 0x000009c5 */ { 1, { 0x000009c5 } },
	/* 0x000009c6 */ { 1, { 0x000009c6 } },
	/* 0x000009c7 */ { 1, { 0x000009c7 } },
	/* 0x000009c8 */ { 1, { 0x000009c8 } },
	/* 0x000009c9 */ { 1, { 0x000009c9 } },
	/* 0x000009ca */ { 1, { 0x000009ca } },
	/* 0x000009cb */ { 2, { 0x000009c7, 0x000009be } },
	/* 0x000009cc */ { 2, { 0x000009c7, 0x000009d7 } },
	/* 0x000009cd */ { 1, { 0x000009cd } },
	/* 0x000009ce */ { 1, { 0x000009ce } },
	/* 0x000009cf */ { 1, { 0x000009cf } },
	/* 0x000009d0 */ { 1, { 0x000009d0 } },
	/* 0x000009d1 */ { 1, { 0x000009d1 } },
	/* 0x000009d2 */ { 1, { 0x000009d2 } },
	/* 0x000009d3 */ { 1, { 0x000009d3 } },
	/* 0x000009d4 */ { 1, { 0x000009d4 } },
	/* 0x000009d5 */ { 1, { 0x000009d5 } },
	/* 0x000009d6 */ { 1, { 0x000009d6 } },
	/* 0x000009d7 */ { 1, { 0x000009d7 } },
	/* 0x000009d8 */ { 1, { 0x000009d8 } },
	/* 0x000009d9 */ { 1, { 0x000009d9 } },
	/* 0x000009da */ { 1, { 0x000009da } },
	/* 0x000009db */ { 1, { 0x000009db } },
	/* 0x000009dc */ { 2, { 0x000009a1, 0x000009bc } },
	/* 0x000009dd */ { 2, { 0x000009a2, 0x000009bc } },
	/* 0x000009de */ { 1, { 0x000009de } },
	/* 0x000009df */ { 2, { 0x000009af, 0x000009bc } }
};

libfshfs_name_decomposition_mapping_t libfshfs_name_decomposition_mappings_0x00000a30[ 48 ] = {
	/* 0x00000a30 */ { 1, { 0x00000a30 } },
	/* 0x00000a31 */ { 1, { 0x00000a31 } },
	/* 0x00000a32 */ { 1, { 0x00000a32 } },
	/* 0x00000a33 */ { 2, { 0x00000a32, 0x00000a3c } },
	/* 0x00000a34 */ { 1, { 0x00000a34 } },
	/* 0x00000a35 */ { 1, { 0x00000a35 } },
	/* 0x00000a36 */ { 2, { 0x00000a38, 0x00000a3c } },
	/* 0x00000a37 */ { 1, { 0x00000a37 } },
	/* 0x00000a38 */ { 1, { 0x00000a38 } },
	/* 0x00000a39 */ { 1, { 0x00000a39 } },
	/* 0x00000a3a */ { 1, { 0x00000a3a } },
	/* 0x00000a3b */ { 1, { 0x00000a3b } },
	/* 0x00000a3c */ { 1, { 0x00000a3c } },
	/* 0x00000a3d */ { 1, { 0x00000a3d } },
	/* 0x00000a3e */ { 1, { 0x00000a3e } },
	/* 0x00000a3f */ { 1, { 0x00000a3f } },
	/* 0x00000a40 */ { 1, { 0x00000a40 } },
	/* 0x00000a41 */ { 1, { 0x00000a41 } },
	/* 0x00000a42 */ { 1, { 0x00000a42 } },
	/* 0x00000a43 */ { 1, { 0x00000a43 } },
	/* 0x00000a44 */ { 1, { 0x00000a44 } },
	/* 0x00000a45 */ { 1, { 0x00000a45 } },
	/* 0x00000a46 */ { 1, { 0x00000a46 } },
	/* 0x00000a47 */ { 1, { 0x00000a47 } },
	/* 0x00000a48 */ { 1, { 0x00000a48 } },
	/* 0x00000a49 */ { 1, { 0x00000a49 } },
	/* 0x00000a4a */ { 1, { 0x00000a4a } },
	/* 0x00000a4b */ { 1, { 0x00000a4b } },
	/* 0x00000a4c */ { 1, { 0x00000a4c } },
	/* 0x00000a4d */ { 1, { 0x00000a4d } },
	/* 0x00000a4e */ { 1, { 0x00000a4e } },
	/* 0x00000a4f */ { 1, { 0x00000a4f } },
	/* 0x00000a50 */ { 1, { 0x00000a50 } },
	/* 0x00000a51 */ { 1, { 0x00000a51 } },
	/* 0x00000a52 */ { 1, { 0x00000a52 } },
	/* 0x00000a53 */ { 1, { 0x00000a53 } },
	/* 0x00000a54 */ { 1, { 0x00000a54 } },
	/* 0x00000a55 */ { 1, { 0x00000a55 } },
	/* 0x00000a56 */ { 1, { 0x00000a56 } },
	/* 0x00000a57 */ { 1, { 0x00000a57 } },
	/* 0x00000a58 */ { 1, { 0x00000a58 } },
	/* 0x00000a59 */ { 2, { 0x00000a16, 0x00000a3c } },
	/* 0x00000a5a */ { 2, { 0x00000a17, 0x00000a3c } },
	/* 0x00000a5b */ { 2, { 0x00000a1c, 0x00000a3c } },
	/* 0x00000a5c */ { 1, { 0x00000a5c } },
	/* 0x00000a5d */ { 1, { 0x00000a5d } },
	/* 0x00000a5e */ { 2, { 0x00000a2b, 0x00000a3c } },
	/* 0x00000a5f */ { 1, { 0x00000a5f } }
};

libfshfs_name_decomposition_mapping_t libfshfs_name_decomposition_mappings_0x00000b48[ 136 ] = {
	/* 0x00000b48 */ { 2, { 0x00000b47, 0x00000b56 } },
	/* 0x00000b49 */ { 1, { 0x00000b49 } },
	/* 0x00000b4a */ { 1, { 0x00000b4a } },
	/* 0x00000b4b */ { 2, { 0x00000b47, 0x00000b3e } },
	/* 0x00000b4c */ { 2, { 0x00000b47, 0x00000b57 } },
	/* 0x00000b4d */ { 1, { 0x00000b4d } },
	/* 0x00000b4e */ { 1, { 0x00000b4e } },
	/* 0x00000b4f */ { 1, { 0x00000b4f } },
	/* 0x00000b50 */ { 1, { 0x00000b50 } },
	/* 0x00000b51 */ { 1, { 0x00000b51 } },
	/* 0x00000b52 */ { 1, { 0x00000b52 } },
	/* 0x00000b53 */ { 1, { 0x00000b53 } },
	/* 0x00000b54 */ { 1, { 0x00000b54 } },
	/* 0x00000b55 */ { 1, { 0x00000b55 } },
	/* 0x00000b56 */ { 1, { 0x00000b56 } },
	/* 0x00000b57 */ { 1, { 0x00000b57 } },
	/* 0x00000b58 */ { 1, { 0x00000b58 } },
	/* 0x00000b59 */ { 1, { 0x00000b59 } },
	/* 0x00000b5a */ { 1, { 0x00000b5a } },
	/* 0x00000b5b */ { 1, { 0x00000b5b } },
	/* 0x00000b5c */ { 2, { 0x00000b21, 0x00000b3c } },
	/* 0x00000b5d */ { 2, { 0x00000b22, 0x00000b3c } },
	/* 0x00000b5e */ { 1, { 0x00000b5e } },
	/* 0x00000b5f */ { 1, { 0x00000b5f } },
	/* 0x00000b60 */ { 1, { 0x00000b60 } },
	/* 0x00000b61 */ { 1, { 0x00000b61 } },
	/* 0x00000b62 */ { 1, { 0x00000b62 } },
	/* 0x00000b63 */ { 1, { 0x00000b63 } },
	/* 0x00000b64 */ { 1, { 0x00000b64 } },
	/* 0x00000b65 */ { 1, { 0x00000b65 } },
	/* 0x00000b66 */ { 1, { 0x00000b66 } },
	/* 0x00000b67 */ { 1, { 0x00000b67 } },
	/* 0x00000b68 */ { 1, { 0x00000b68 } },
	/* 0x00000b69 */ { 1, { 0x00000b69 } },
	/* 0x00000b6a */ { 1, { 0x00000b6a } },
	/* 0x00000b6b */ { 1, { 0x00000b6b } },
	/* 0x00000b6c */ { 1, { 0x00000b6c } },
	/* 0x00000b6d */ { 1, { 0x00000b6d } },
	/* 0x00000b6e */ { 1, { 0x00000b6e } },
	/* 0x00000b6f */ { 1, { 0x00000b6f } },
	/* 0x00000b70 */ { 1, { 0x00000b70 } },
	/* 0x00000b71 */ { 1, { 0x00000b71 } },
	/* 0x00000b72 */ { 1, { 0x00000b72 } },
	/* 0x00000b73 */ { 1, { 0x00000b73 } },
	/* 0x00000b74 */ { 1, { 0x00000b74 } },
	/* 0x00000b75 */ { 1, { 0x00000b75 } },
	/* 0x00000b76 */ { 1, { 0x00000b76 } },
	/* 0x00000b77 */ { 1, { 0x00000b77 } },
	/* 0x00000b78 */ { 1, { 0x00000b78 } },
	/* 0x00000b79 */ { 1, { 0x00000b79 } },
	/* 0x00000b7a */ { 1, { 0x00000b7a } },
	/* 0x00000b7b */ { 1, { 0x00000b7b } },
	/* 0x00000b7c */ { 1, { 0x00000b7c } },
	/* 0x00000b7d */ { 1, { 0x00000b7d } },
	/* 0x00000b7e */ { 1, { 0x00000b7e } },
	/* 0x00000b7f */ { 1, { 0x00000b7f } },
	/* 0x00000b80 */ { 1, { 0x00000b80 } },
	/* 0x00000b81 */ { 1, { 0x00000b81 } },
	/* 0x00000b82 */ { 1, { 0x00000b82 } },
	/* 0x00000b83 */ { 1, { 0x00000b83 } },
	/* 0x00000b84 */ { 1, { 0x00000b84 } },
	/* 0x00000b85 */ { 1, { 0x00000b85 } },
	/* 0x00000b86 */ { 1, { 0x00000b86 } },
	/* 0x00000b87 */ { 1, { 0x00000b87 } },
	/* 0x00000b88 */ { 1, { 0x00000b88 } },
	/* 0x00000b89 */ { 1, { 0x00000b89 } },
	/* 0x00000b8a */ { 1, { 0x00000b8a } },
	/* 0x00000b8b */ { 1, { 0x00000b8b } },
	/* 0x00000b8c */ { 1, { 0x00000b8c } },
	/* 0x00000b8d */ { 1, { 0x00000b8d } },
	/* 0x00000b8e */ { 1, { 0x00000b8e } },
	/* 0x00000b8f */ { 1, { 0x00000b8f } },
	/* 0x00000b90 */ { 1, { 0x00000b90 } },
	/* 0x00000b91 */ { 1, { 0x00000b91 } },
	/* 0x00000b92 */ { 1, { 0x00000b92 } },
	/* 0x00000b93 */ { 1, { 0x00000b93 } },
	/* 0x00000b94 */ { 2, { 0x00000b92, 0x00000bd7 } },
	/* 0x00000b95 */ { 1, { 0x00000b95 } },
	/* 0x00000b96 */ { 1, { 0x00000b96 } },
	/* 0x00000b97 */ { 1, { 0x00000b97 } },
	/* 0x00000b98 */ { 1, { 0x00000b98 } },
	/* 0x00000b99 */ { 1, { 0x00000b99 } },
	/* 0x00000b9a */ { 1, { 0x00000b9a } },
	/* 0x00000b9b */ { 1, { 0x00000b9b } },
	/* 0x00000b9c */ { 1, { 0x00000b9c } },
	/* 0x00000b9d */ { 1, { 0x00000b9d } },
	/* 0x00000b9e */ { 1, { 0x00000b9e } },
	/* 0x00000b9f */ { 1, { 0x00000b9f } },
	/* 0x00000ba0 */ { 1, { 0x00000ba0 } },
	/* 0x00000ba1 */ { 1, { 0x00000ba1 } },
	/* 0x00000ba2 */ { 1, { 0x00000ba2 } },
	/* 0x00000ba3 */ { 1, { 0x00000ba3 } },
	/* 0x00000ba4 */ { 1, { 0x00000ba4 } },
	/* 0x00000ba5 */ { 1, { 0x00000ba5 } },
	/* 0x00000ba6 */ { 1, { 0x00000ba6 } },
	/* 0x00000ba7 */ { 1, { 0x00000ba7 } },
	/* 0x00000ba8 */ { 1, { 0x00000ba8 } },
	/* 0x00000ba9 */ { 1, { 0x00000ba9 } },
	/* 0x00000baa */ { 1, { 0x00000baa } },
	/* 0x00000bab */ { 1, { 0x00000bab } },
	/* 0x00000bac */ { 1, { 0x00000bac } },
	/* 0x00000bad */ { 1, { 0x00000bad } },
	/* 0x00000bae */ { 1, { 0x00000bae } },
	/* 0x00000baf */ { 1, { 0x00000baf } },
	/* 0x00000bb0 */ { 1, { 0x00000bb0 } },
	/* 0x00000bb1 */ { 1, { 0x00000bb1 } },
	/* 0x00000bb2 */ { 1, { 0x00000bb2 } },
	/* 0x00000bb3 */ { 1, { 0x00000bb3 } },
	/* 0x00000bb4 */ { 1, { 0x00000bb4 } },
	/* 0x00000bb5 */ { 1, { 0x00000bb5 } },
	/* 0x00000bb6 */ { 1, { 0x00000bb6 } },
	/* 0x00000bb7 */ { 1, { 0x00000bb7 } },
	/* 0x00000bb8 */ { 1, { 0x00000bb8 } },
	/* 0x00000bb9 */ { 1, { 0x00000bb9 } },
	/* 0x00000bba */ { 1, { 0x00000bba } },
	/* 0x00000bbb */ { 1, { 0x00000bbb } },
	/* 0x00000bbc */ { 1, { 0x00000bbc } },
	/* 0x00000bbd */ { 1, { 0x00000bbd } },
	/* 0x00000bbe */ { 1, { 0x00000bbe } },
	/* 0x00000bbf */ { 1, { 0x00000bbf } },
	/* 0x00000bc0 */ { 1, { 0x00000bc0 } },
	/* 0x00000bc1 */ { 1, { 0x00000bc1 } },
	/* 0x00000bc2 */ { 1, { 0x00000bc2 } },
	/* 0x00000bc3 */ { 1, { 0x00000bc3 } },
	/* 0x00000bc4 */ { 1, { 0x00000bc4 } },
	/* 0x00000bc5 */ { 1, { 0x00000bc5 } },
	/* 0x00000bc6 */ { 1, { 0x00000bc6 } },
	/* 0x00000bc7 */ { 1, { 0x00000bc7 } },
	/* 0x00000bc8 */ { 1, { 0x00000bc8 } },
	/* 0x00000bc9 */ { 1, { 0x00000bc9 } },
	/* 0x00000bca */ { 2, { 0x00000bc6, 0x00000bbe } },
	/* 0x00000bcb */ { 2, { 0x00000bc7, 0x00000bbe } },
	/* 0x00000bcc */ { 2, { 0x00000bc6, 0x00000bd7 } },
	/* 0x00000bcd */ { 1, { 0x00000bcd } },
	/* 0x00000bce */ { 1, { 0x00000bce } },
	/* 0x00000bcf */ { 1, { 0x00000bcf } }
};

libfshfs_name_decomposition_mapping_t libfshfs_name_decomposition_mappings_0x00000c48[ 136 ] = {
	/* 0x00000c48 */ { 2, { 0x00000c46, 0x00000c56 } },
	/* 0x00000c49 */ { 1, { 0x00000c49 } },
	/* 0x00000c4a */ { 1, { 0x00000c4a } },
	/* 0x00000c4b */ { 1, { 0x00000c4b } },
	/* 0x00000c4c */ { 1, { 0x00000c4c } },
	/* 0x00000c4d */ { 1, { 0x00000c4d } },
	/* 0x00000c4e */ { 1, { 0x00000c4e } },
	/* 0x00000c4f */ { 1, { 0x00000c4f } },
	/* 0x00000c50 */ { 1, { 0x00000c50 } },
	/* 0x00000c51 */ { 1, { 0x00000c51 } },
	/* 0x00000c52 */ { 1, { 0x00000c52 } },
	/* 0x00000c53 */ { 1, { 0x00000c53 } },
	/* 0x00000c54 */ { 1, { 0x00000c54 } },
	/* 0x00000c55 */ { 1, { 0x00000c55 } },
	/* 0x00000c56 */ { 1, { 0x00000c56 } },
	/* 0x00000c57 */ { 1, { 0x00000c57 } },
	/* 0x00000c58 */ { 1, { 0x00000c58 } },
	/* 0x00000c59 */ { 1, { 0x00000c59 } },
	/* 0x00000c5a */ { 1, { 0x00000c5a } },
	/* 0x00000c5b */ { 1, { 0x00000c5b } },
	/* 0x00000c5c */ { 1, { 0x00000c5c } },
	/* 0x00000c5d */ { 1, { 0x00000c5d } },
	/* 0x00000c5e */ { 1, { 0x00000c5e } },
	/* 0x00000c5f */ { 1, { 0x00000c5f } },
	/* 0x00000c60 */ { 1, { 0x00000c60 } },
	/* 0x00000c61 */ { 1, { 0x00000c61 } },
	/* 0x00000c62 */ { 1, { 0x00000c62 } },
	/* 0x00000c63 */ { 1, { 0x00000c63 } },
	/* 0x00000c64 */ { 1, { 0x00000c64 } },
	/* 0x00000c65 */ { 1, { 0x00000c65 } },
	/* 0x00000c66 */ { 1, { 0x00000c66 } },
	/* 0x00000c67 */ { 1, { 0x00000c67 } },
	/* 0x00000c68 */ { 1, { 0x00000c68 } },
	/* 0x00000c69 */ { 1, { 0x00000c69 } },
	/* 0x00000c6a */ { 1, { 0x00000c6a } },
	/* 0x00000c6b */ { 1, { 0x00000c6b } },
	/* 0x00000c6c */ { 1, { 0x00000c6c } },
	/* 0x00000c6d */ { 1, { 0x00000c6d } },
	/* 0x00000c6e */ { 1, { 0x00000c6e } },
	/* 0x00000c6f */ { 1, { 0x00000c6f } },
	/* 0x00000c70 */ { 1, { 0x00000c70 } },
	/* 0x00000c71 */ { 1, { 0x00000c71 } },
	/* 0x00000c72 */ { 1, { 0x00000c72 } },
	/* 0x00000c73 */ { 1, { 0x00000c73 } },
	/* 0x00000c74 */ { 1, { 0x00000c74 } },
	/* 0x00000c75 */ { 1, { 0x00000c75 } },
	/* 0x00000c76 */ { 1, { 0x00000c76 } },
	/* 0x00000c77 */ { 1, { 0x00000c77 } },
	/* 0x00000c78 */ { 1, { 0x00000c78 } },
	/* 0x00000c79 */ { 1, { 0x00000c79 } },
	/* 0x00000c7a */ { 1, { 0x00000c7a } },
	/* 0x00000c7b */ { 1, { 0x00000c7b } },
	/* 0x00000c7c */ { 1, { 0x00000c7c } },
	/* 0x00000c7d */ { 1, { 0x00000c7d } },
	/* 0x00000c7e */ { 1, { 0x00000c7e } },
	/* 0x00000c7f */ { 1, { 0x00000c7f } },
	/* 0x00000c80 */ { 1, { 0x00000c80 } },
	/* 0x00000c81 */ { 1, { 0x00000c81 } },
	/* 0x00000c82 */ { 1, { 0x00000c82 } },
	/* 0x00000c83 */ { 1, { 0x00000c83 } },
	/* 0x00000c84 */ { 1, { 0x00000c84 } },
	/* 0x00000c85 */ { 1, { 0x00000c85 } },
	/* 0x00000c86 */ { 1, { 0x00000c86 } },
	/* 0x00000c87 */ { 1, { 0x00000c87 } },
	/* 0x00000c88 */ { 1, { 0x00000c88 } },
	/* 0x00000c89 */ { 1, { 0x00000c89 } },
	/* 0x00000c8a */ { 1, { 0x00000c8a } },
	/* 0x00000c8b */ { 1, { 0x00000c8b } },
	/* 0x00000c8c */ { 1, { 0x00000c8c } },
	/* 0x00000c8d */ { 1, { 0x00000c8d } },
	/* 0x00000c8e */ { 1, { 0x00000c8e } },
	/* 0x00000c8f */ { 1, { 0x00000c8f } },
	/* 0x00000c90 */ { 1, { 0x00000c90 } },
	/* 0x00000c91 */ { 1, { 0x00000c91 } },
	/* 0x00000c92 */ { 1, { 0x00000c92 } },
	/* 0x00000c93 */ { 1, { 0x00000c93 } },
	/* 0x00000c94 */ { 1, { 0x00000c94 } },
	/* 0x00000c95 */ { 1, { 0x00000c95 } },
	/* 0x00000c96 */ { 1, { 0x00000c96 } },
	/* 0x00000c97 */ { 1, { 0x00000c97 } },
	/* 0x00000c98 */ { 1, { 0x00000c98 } },
	/* 0x00000c99 */ { 1, { 0x00000c99 } },
	/* 0x00000c9a */ { 1, { 0x00000c9a } },
	/* 0x00000c9b */ { 1, { 0x00000c9b } },
	/* 0x00000c9c */ { 1, { 0x00000c9c } },
	/* 0x00000c9d */ { 1, { 0x00000c9d } },
	/* 0x00000c9e */ { 1, { 0x00000c9e } },
	/* 0x00000c9f */ { 1, { 0x00000c9f } },
	/* 0x00000ca0 */ { 1, { 0x00000ca0 } },
	/* 0x00000ca1 */ { 1, { 0x00000ca1 } },
	/* 0x00000ca2 */ { 1, { 0x00000ca2 } },
	/* 0x00000ca3 */ { 1, { 0x00000ca3 } },
	/* 0x00000ca4 */ { 1, { 0x00000ca4 } },
	/* 0x00000ca5 */ { 1, { 0x00000ca5 } },
	/* 0x00000ca6 */ { 1, { 0x00000ca6 } },
	/* 0x00000ca7 */ { 1, { 0x00000ca7 } },
	/* 0x00000ca8 */ { 1, { 0x00000ca8 } },
	/* 0x00000ca9 */ { 1, { 0x00000ca9 } },
	/* 0x00000caa */ { 1, { 0x00000caa } },
	/* 0x00000cab */ { 1, { 0x00000cab } },
	/* 0x00000cac */ { 1, { 0x00000cac } },
	/* 0x00000cad */ { 1, { 0x00000cad } },
	/* 0x00000cae */ { 1, { 0x00000cae } },
	/* 0x00000caf */ { 1, { 0x00000caf } },
	/* 0x00000cb0 */ { 1, { 0x00000cb0 } },
	/* 0x00000cb1 */ { 1, { 0x00000cb1 } },
	/* 0x00000cb2 */ { 1, { 0x00000cb2 } },
	/* 0x00000cb3 */ { 1, { 0x00000cb3 } },
	/* 0x00000cb4 */ { 1, { 0x00000cb4 } },
	/* 0x00000cb5 */ { 1, { 0x00000cb5 } },
	/* 0x00000cb6 */ { 1, { 0x00000cb6 } },
	/* 0x00000cb7 */ { 1, { 0x00000cb7 } },
	/* 0x00000cb8 */ { 1, { 0x00000cb8 } },
	/* 0x00000cb9 */ { 1, { 0x00000cb9 } },
	/* 0x00000cba */ { 1, { 0x00000cba } },
	/* 0x00000cbb */ { 1, { 0x00000cbb } },
	/* 0x00000cbc */ { 1, { 0x00000cbc } },
	/* 0x00000cbd */ { 1, { 0x00000cbd } },
	/* 0x00000cbe */ { 1, { 0x00000cbe } },
	/* 0x00000cbf */ { 1, { 0x00000cbf } },
	/* 0x00000cc0 */ { 2, { 0x00000cbf, 0x00000cd5 } },
	/* 0x00000cc1 */ { 1, { 0x00000cc1 } },
	/* 0x00000cc2 */ { 1, { 0x00000cc2 } },
	/* 0x00000cc3 */ { 1, { 0x00000cc3 } },
	/* 0x00000cc4 */ { 1, { 0x00000cc4 } },
	/* 0x00000cc5 */ { 1, { 0x00000cc5 } },
	/* 0x00000cc6 */ { 1, { 0x00000cc6 } },
	/* 0x00000cc7 */ { 2, { 0x00000cc6, 0x00000cd5 } },
	/* 0x00000cc8 */ { 2, { 0x00000cc6, 0x00000cd6 } },
	/* 0x00000cc9 */ { 1, { 0x00000cc9 } },
	/* 0x00000cca */ { 2, { 0x00000cc6, 0x00000cc2 } },
	/* 0x00000ccb */ { 3, { 0x00000cc6, 0x00000cc2, 0x00000cd5 } },
	/* 0x00000ccc */ { 1, { 0x00000ccc } },
	/* 0x00000ccd */ { 1, { 0x00000ccd } },
	/* 0x00000cce */ { 1, { 0x00000cce } },
	/* 0x00000ccf */ { 1, { 0x00000ccf } }
};

libfshfs_name_decomposition_mapping_t libfshfs_name_decomposition_mappings_0x00000d48[ 152 ] = {
	/* 0x00000d48 */ { 1, { 0x00000d48 } },
	/* 0x00000d49 */ { 1, { 0x00000d49 } },
	/* 0x00000d4a */ { 2, { 0x00000d46, 0x00000d3e } },
	/* 0x00000d4b */ { 2, { 0x00000d47, 0x00000d3e } },
	/* 0x00000d4c */ { 2, { 0x00000d46, 0x00000d57 } },
	/* 0x00000d4d */ { 1, { 0x00000d4d } },
	/* 0x00000d4e */ { 1, { 0x00000d4e } },
	/* 0x00000d4f */ { 1, { 0x00000d4f } },
	/* 0x00000d50 */ { 1, { 0x00000d50 } },
	/* 0x00000d51 */ { 1, { 0x00000d51 } },
	/* 0x00000d52 */ { 1, { 0x00000d52 } },
	/* 0x00000d53 */ { 1, { 0x00000d53 } },
	/* 0x00000d54 */ { 1, { 0x00000d54 } },
	/* 0x00000d55 */ { 1, { 0x00000d55 } },
	/* 0x00000d56 */ { 1, { 0x00000d56 } },
	/* 0x00000d57 */ { 1, { 0x00000d57 } },
	/* 0x00000d58 */ { 1, { 0x00000d58 } },
	/* 0x00000d59 */ { 1, { 0x00000d59 } },
	/* 0x00000d5a */ { 1, { 0x00000d5a } },
	/* 0x00000d5b */ { 1, { 0x00000d5b } },
	/* 0x00000d5c */ { 1, { 0x00000d5c } },
	/* 0x00000d5d */ { 1, { 0x00000d5d } },
	/* 0x00000d5e */ { 1, { 0x00000d5e } },
	/* 0x00000d5f */ { 1, { 0x00000d5f } },
	/* 0x00000d60 */ { 1, { 0x00000d60 } },
	/* 0x00000d61 */ { 1, { 0x00000d61 } },
	/* 0x00000d62 */ { 1, { 0x00000d62 } },
	/* 0x00000d63 */ { 1, { 0x00000d63 } },
	/* 0x00000d64 */ { 1, { 0x00000d64 } },
	/* 0x00000d65 */ { 1, { 0x00000d65 } },
	/* 0x00000d66 */ { 1, { 0x00000d66 } },
	/* 0x00000d67 */ { 1, { 0x00000d67 } },
	/* 0x00000d68 */ { 1, { 0x00000d68 } },
	/* 0x00000d69 */ { 1, { 0x00000d69 } },
	/* 0x00000d6a */ { 1, { 0x00000d6a } },
	/* 0x00000d6b */ { 1, { 0x00000d6b } },
	/* 0x00000d6c */ { 1, { 0x00000d6c } },
	/* 0x00000d6d */ { 1, { 0x00000d6d } },
	/* 0x00000d6e */ { 1, { 0x00000d6e } },
	/* 0x00000d6f */ { 1, { 0x00000d6f } },
	/* 0x00000d70 */ { 1, { 0x00000d70 } },
	/* 0x00000d71 */ { 1, { 0x00000d71 } },
	/* 0x00000d72 */ { 1, { 0x00000d72 } },
	/* 0x00000d73 */ { 1, { 0x00000d73 } },
	/* 0x00000d74 */ { 1, { 0x00000d74 } },
	/* 0x00000d75 */ { 1, { 0x00000d75 } },
	/* 0x00000d76 */ { 1, { 0x00000d76 } },
	/* 0x00000d77 */ { 1, { 0x00000d77 } },
	/* 0x00000d78 */ { 1, { 0x00000d78 } },
	/* 0x00000d79 */ { 1, { 0x00000d79 } },
	/* 0x00000d7a */ { 1, { 0x00000d7a } },
	/* 0x00000d7b */ { 1, { 0x00000d7b } },
	/* 0x00000d7c */ { 1, { 0x00000d7c } },
	/* 0x00000d7d */ { 1, { 0x00000d7d } },
	/* 0x00000d7e */ { 1, { 0x00000d7e } },
	/* 0x00000d7f */ { 1, { 0x00000d7f } },
	/* 0x00000d80 */ { 1, { 0x00000d80 } },
	/* 0x00000d81 */ { 1, { 0x00000d81 } },
	/* 0x00000d82 */ { 1, { 0x00000d82 } },
	/* 0x00000d83 */ { 1, { 0x00000d83 } },
	/* 0x00000d84 */ { 1, { 0x00000d84 } },
	/* 0x00000d85 */ { 1, { 0x00000d85 } },
	/* 0x00000d86 */ { 1, { 0x00000d86 } },
	/* 0x00000d87 */ { 1, { 0x00000d87 } },
	/* 0x00000d88 */ { 1, { 0x00000d88 } },
	/* 0x00000d89 */ { 1, { 0x00000d89 } },
	/* 0x00000d8a */ { 1, { 0x00000d8a } },
	/* 0x00000d8b */ { 1, { 0x00000d8b } },
	/* 0x00000d8c */ { 1, { 0x00000d8c } },
	/* 0x00000d8d */ { 1, { 0x00000d8d } },
	/* 0x00000d8e */ { 1, { 0x00000d8e } },
	/* 0x00000d8f */ { 1, { 0x00000d8f } },
	/* 0x00000d90 */ { 1, { 0x00000d90 } },
	/* 0x00000d91 */ { 1, { 0x00000d91 } },
	/* 0x00000d92 */ { 1, { 0x00000d92 } },
	/* 0x00000d93 */ { 1, { 0x00000d93 } },
	/* 0x00000d94 */ { 1, { 0x00000d94 } },
	/* 0x00000d95 */ { 1, { 0x00000d95 } },
	/* 0x00000d96 */ { 1, { 0x00000d96 } },
	/* 0x00000d97 */ { 1, { 0x00000d97 } },
	/* 0x00000d98 */ { 1, { 0x00000d98 } },
	/* 0x00000d99 */ { 1, { 0x00000d99 } },
	/* 0x00000d9a */ { 1, { 0x00000d9a } },
	/* 0x00000d9b */ { 1, { 0x00000d9b } },
	/* 0x00000d9c */ { 1, { 0x00000d9c } },
	/* 0x00000d9d */ { 1, { 0x00000d9d } },
	/* 0x00000d9e */ { 1, { 0x00000d9e } },
	/* 0x00000d9f */ { 1, { 0x00000d9f } },
	/* 0x00000da0 */ { 1, { 0x00000da0 } },
	/* 0x00000da1 */ { 1, { 0x00000da1 } },
	/* 0x00000da2 */ { 1, { 0x00000da2 } },
	/* 0x00000da3 */ { 1, { 0x00000da3 } },
	/* 0x00000da4 */ { 1, { 0x00000da4 } },
	/* 0x00000da5 */ { 1, { 0x00000da5 } },
	/* 0x00000da6 */ { 1, { 0x00000da6 } },
	/* 0x00000da7 */ { 1, { 0x00000da7 } },
	/* 0x00000da8 */ { 1, { 0x00000da8 } },
	/* 0x00000da9 */ { 1, { 0x00000da9 } },
	/* 0x00000daa */ { 1, { 0x00000daa } },
	/* 0x00000dab */ { 1, { 0x00000dab } },
	/* 0x00000dac */ { 1, { 0x00000dac } },
	/* 0x00000dad */ { 1, { 0x00000dad } },
	/* 0x00000dae */ { 1, { 0x00000dae } },
	/* 0x00000daf */ { 1, { 0x00000daf } },
	/* 0x00000db0 */ { 1, { 0x00000db0 } },
	/* 0x00000db1 */ { 1, { 0x00000db1 } },
	/* 0x00000db2 */ { 1, { 0x00000db2 } },
	/* 0x00000db3 */ { 1, { 0x00000db3 } },
	/* 0x00000db4 */ { 1, { 0x00000db4 } },
	/* 0x00000db5 */ { 1, { 0x00000db5 } },
	/* 0x00000db6 */ { 1, { 0x00000db6 } },
	/* 0x00000db7 */ { 1, { 0x00000db7 } },
	/* 0x00000db8 */ { 1, { 0x00000db8 } },
	/* 0x00000db9 */ { 1, { 0x00000db9 } },
	/* 0x00000dba */ { 1, { 0x00000dba } },
	/* 0x00000dbb */ { 1, { 0x00000dbb } },
	/* 0x00000dbc */ { 1, { 0x00000dbc } },
	/* 0x00000dbd */ { 1, { 0x00000dbd } },
	/* 0x00000dbe */ { 1, { 0x00000dbe } },
	/* 0x00000dbf */ { 1, { 0x00000dbf } },
	/* 0x00000dc0 */ { 1, { 0x00000dc0 } },
	/* 0x00000dc1 */ { 1, { 0x00000dc1 } },
	/* 0x00000dc2 */ { 1, { 0x00000dc2 } },
	/* 0x00000dc3 */ { 1, { 0x00000dc3 } },
	/* 0x00000dc4 */ { 1, { 0x00000dc4 } },
	/* 0x00000dc5 */ { 1, { 0x00000dc5 } },
	/* 0x00000dc6 */ { 1, { 0x00000dc6 } },
	/* 0x00000dc7 */ { 1, { 0x00000dc7 } },
	/* 0x00000dc8 */ { 1, { 0x00000dc8 } },
	/* 0x00000dc9 */ { 1, { 0x00000dc9 } },
	/* 0x00000dca */ { 1, { 0x00000dca } },
	/* 0x00000dcb */ { 1, { 0x00000dcb } },
	/* 0x00000dcc */ { 1, { 0x00000dcc } },
	/* 0x00000dcd */ { 1, { 0x00000dcd } },
	/* 0x00000dce */ { 1, { 0x00000dce } },
	/* 0x00000dcf */ { 1, { 0x00000dcf } },
	/* 0x00000dd0 */ { 1, { 0x00000dd0 } },
	/* 0x00000dd1 */ { 1, { 0x00000dd1 } },
	/* 0x00000dd2 */ { 1, { 0x00000dd2 } },
	/* 0x00000dd3 */ { 1, { 0x00000dd3 } },
	/* 0x00000dd4 */ { 1, { 0x00000dd4 } },
	/* 0x00000dd5 */ { 1, { 0x00000dd5 } },
	/* 0x00000dd6 */ { 1, { 0x00000dd6 } },
	/* 0x00000dd7 */ { 1, { 0x00000dd7 } },
	/* 0x00000dd8 */ { 1, { 0x00000dd8 } },
	/* 0x00000dd9 */ { 1, { 0x00000dd9 } },
	/* 0x00000dda */ { 2, { 0x00000dd9, 0x00000dca } },
	/* 0x00000ddb */ { 1, { 0x00000ddb } },
	/* 0x00000ddc */ { 2, { 0x00000dd9, 0x00000dcf } },
	/* 0x00000ddd */ { 3, { 0x00000dd9, 0x00000dcf, 0x00000dca } },
	/* 0x00000dde */ { 2, { 0x00000dd9, 0x00000ddf } },
	/* 0x00000ddf */ { 1, { 0x00000ddf } }
};

libfshfs_name_decomposition_mapping_t libfshfs_name_decomposition_mappings_0x00000f40[ 232 ] = {
	/* 0x00000f40 */ { 1, { 0x00000f40 } },
	/* 0x00000f41 */ { 1, { 0x00000f41 } },
	/* 0x00000f42 */ { 1, { 0x00000f42 } },
	/* 0x00000f43 */ { 2, { 0x00000f42, 0x00000fb7 } },
	/* 0x00000f44 */ { 1, { 0x00000f44 } },
	/* 0x00000f45 */ { 1, { 0x00000f45 } },
	/* 0x00000f46 */ { 1, { 0x00000f46 } },
	/* 0x00000f47 */ { 1, { 0x00000f47 } },
	/* 0x00000f48 */ { 1, { 0x00000f48 } },
	/* 0x00000f49 */ { 1, { 0x00000f49 } },
	/* 0x00000f4a */ { 1, { 0x00000f4a } },
	/* 0x00000f4b */ { 1, { 0x00000f4b } },
	/* 0x00000f4c */ { 1, { 0x00000f4c } },
	/* 0x00000f4d */ { 2, { 0x00000f4c, 0x00000fb7 } },
	/* 0x00000f4e */ { 1, { 0x00000f4e } },
	/* 0x00000f4f */ { 1, { 0x00000f4f } },
	/* 0x00000f50 */ { 1, { 0x00000f50 } },
	/* 0x00000f51 */ { 1, { 0x00000f51 } },
	/* 0x00000f52 */ { 2, { 0x00000f51, 0x00000fb7 } },
	/* 0x00000f53 */ { 1, { 0x00000f53 } },
	/* 0x00000f54 */ { 1, { 0x00000f54 } },
	/* 0x00000f55 */ { 1, { 0x00000f55 } },
	/* 0x00000f56 */ { 1, { 0x00000f56 } },
	/* 0x00000f57 */ { 2, { 0x00000f56, 0x00000fb7 } },
	/* 0x00000f58 */ { 1, { 0x00000f58 } },
	/* 0x00000f59 */ { 1, { 0x00000f59 } },
	/* 0x00000f5a */ { 1, { 0x00000f5a } },
	/* 0x00000f5b */ { 1, { 0x00000f5b } },
	/* 0x00000f5c */ { 2, { 0x00000f5b, 0x00000fb7 } },
	/* 0x00000f5d */ { 1, { 0x00000f5d } },
	/* 0x00000f5e */ { 1, { 0x00000f5e } },
	/* 0x00000f5f */ { 1, { 0x00000f5f } },
	/* 0x00000f60 */ { 1, { 0x00000f60 } },
	/* 0x00000f61 */ { 1, { 0x00000f61 } },
	/* 0x00000f62 */ { 1, { 0x00000f62 } },
	/* 0x00000f63 */ { 1, { 0x00000f63 } },
	/* 0x00000f64 */ { 1, { 0x00000f64 } },
	/* 0x00000f65 */ { 1, { 0x00000f65 } },
	/* 0x00000f66 */ { 1, { 0x00000f66 } },
	/* 0x00000f67 */ { 1, { 0x00000f67 } },
	/* 0x00000f68 */ { 1, { 0x00000f68 } },
	/* 0x00000f69 */ { 2, { 0x00000f40, 0x00000fb5 } },
	/* 0x00000f6a */ { 1, { 0x00000f6a } },
	/* 0x00000f6b */ { 1, { 0x00000f6b } },
	/* 0x00000f6c */ { 1, { 0x00000f6c } },
	/* 0x00000f6d */ { 1, { 0x00000f6d } },
	/* 0x00000f6e */ { 1, { 0x00000f6e } },
	/* 0x00000f6f */ { 1, { 0x00000f6f } },
	/* 0x00000f70 */ { 1, { 0x00000f70 } },
	/* 0x00000f71 */ { 1, { 0x00000f71 } },
	/* 0x00000f72 */ { 1, { 0x00000f72 } },
	/* 0x00000f73 */ { 2, { 0x00000f71, 0x00000f72 } },
	/* 0x00000f74 */ { 1, { 0x00000f74 } },
	/* 0x00000f75 */ { 2, { 0x00000f71, 0x00000f74 } },
	/* 0x00000f76 */ { 2, { 0x00000fb2, 0x00000f80 } },
	/* 0x00000f77 */ { 1, { 0x00000f77 } },
	/* 0x00000f78 */ { 2, { 0x00000fb3, 0x00000f80 } },
	/* 0x00000f79 */ { 1, { 0x00000f79 } },
	/* 0x00000f7a */ { 1, { 0x00000f7a } },
	/* 0x00000f7b */ { 1, { 0x00000f7b } },
	/* 0x00000f7c */ { 1, { 0x00000f7c } },
	/* 0x00000f7d */ { 1, { 0x00000f7d } },
	/* 0x00000f7e */ { 1, { 0x00000f7e } },
	/* 0x00000f7f */ { 1, { 0x00000f7f } },
	/* 0x00000f80 */ { 1, { 0x00000f80 } },
	/* 0x00000f81 */ { 2, { 0x00000f71, 0x00000f80 } },
	/* 0x00000f82 */ { 1, { 0x00000f82 } },
	/* 0x00000f83 */ { 1, { 0x00000f83 } },
	/* 0x00000f84 */ { 1, { 0x00000f84 } },
	/* 0x00000f85 */ { 1, { 0x00000f85 } },
	/* 0x00000f86 */ { 1, { 0x00000f86 } },
	/* 0x00000f87 */ { 1, { 0x00000f87 } },
	/* 0x00000f88 */ { 1, { 0x00000f88 } },
	/* 0x00000f89 */ { 1, { 0x00000f89 } },
	/* 0x00000f8a */ { 1, { 0x00000f8a } },
	/* 0x00000f8b */ { 1, { 0x00000f8b } },
	/* 0x00000f8c */ { 1, { 0x00000f8c } },
	/* 0x00000f8d */ { 1, { 0x00000f8d } },
	/* 0x00000f8e */ { 1, { 0x00000f8e } },
	/* 0x00000f8f */ { 1, { 0x00000f8f } },
	/* 0x00000f90 */ { 1, { 0x00000f90 } },
	/* 0x00000f91 */ { 1, { 0x00000f91 } },
	/* 0x00000f92 */ { 1, { 0x00000f92 } },
	/* 0x00000f93 */ { 2, { 0x00000f92, 0x00000fb7 } },
	/* 0x00000f94 */ { 1, { 0x00000f94 } },
	/* 0x00000f95 */ { 1, { 0x00000f95 } },
	/* 0x00000f96 */ { 1, { 0x00000f96 } },
	/* 0x00000f97 */ { 1, { 0x00000f97 } },
	/* 0x00000f98 */ { 1, { 0x00000f98 } },
	/* 0x00000f99 */ { 1, { 0x00000f99 } },
	/* 0x00000f9a */ { 1, { 0x00000f9a } },
	/* 0x00000f9b */ { 1, { 0x00000f9b } },
	/* 0x00000f9c */ { 1, { 0x00000f9c } },
	/* 0x00000f9d */ { 2, { 0x00000f9c, 0x00000fb7 } },
	/* 0x00000f9e */ { 1, { 0x00000f9e } },
	/* 0x00000f9f */ { 1, { 0x00000f9f } },
	/* 0x00000fa0 */ { 1, { 0x00000fa0 } },
	/* 0x00000fa1 */ { 1, { 0x00000fa1 } },
	/* 0x00000fa2 */ { 2, { 0x00000fa1, 0x00000fb7 } },
	/* 0x00000fa3 */ { 1, { 0x00000fa3 } },
	/* 0x00000fa4 */ { 1, { 0x00000fa4 } },
	/* 0x00000fa5 */ { 1, { 0x00000fa5 } },
	/* 0x00000fa6 */ { 1, { 0x00000fa6 } },
	/* 0x00000fa7 */ { 2, { 0x00000fa6, 0x00000fb7 } },
	/* 0x00000fa8 */ { 1, { 0x00000fa8 } },
	/* 0x00000fa9 */ { 1, { 0x00000fa9 } },
	/* 0x00000faa */ { 1, { 0x00000faa } },
	/* 0x00000fab */ { 1, { 0x00000fab } },
	/* 0x00000fac */ { 2, { 0x00000fab, 0x00000fb7 } },
	/* 0x00000fad */ { 1, { 0x00000fad } },
	/* 0x00000fae */ { 1, { 0x00000fae } },
	/* 0x00000faf */ { 1, { 0x00000faf } },
	/* 0x00000fb0 */ { 1, { 0x00000fb0 } },
	/* 0x00000fb1 */ { 1, { 0x00000fb1 } },
	/* 0x00000fb2 */ { 1, { 0x00000fb2 } },
	/* 0x00000fb3 */ { 1, { 0x00000fb3 } },
	/* 0x00000fb4 */ { 1, { 0x00000fb4 } },
	/* 0x00000fb5 */ { 1, { 0x00000fb5 } },
	/* 0x00000fb6 */ { 1, { 0x00000fb6 } },
	/* 0x00000fb7 */ { 1, { 0x00000fb7 } },
	/* 0x00000fb8 */ { 1, { 0x00000fb8 } },
	/* 0x00000fb9 */ { 2, { 0x00000f90, 0x00000fb5 } },
	/* 0x00000fba */ { 1, { 0x00000fba } },
	/* 0x00000fbb */ { 1, { 0x00000fbb } },
	/* 0x00000fbc */ { 1, { 0x00000fbc } },
	/* 0x00000fbd */ { 1, { 0x00000fbd } },
	/* 0x00000fbe */ { 1, { 0x00000fbe } },
	/* 0x00000fbf */ { 1, { 0x00000fbf } },
	/* 0x00000fc0 */ { 1, { 0x00000fc0 } },
	/* 0x00000fc1 */ { 1, { 0x00000fc1 } },
	/* 0x00000fc2 */ { 1, { 0x00000fc2 } },
	/* 0x00000fc3 */ { 1, { 0x00000fc3 } },
	/* 0x00000fc4 */ { 1, { 0x00000fc4 } },
	/* 0x00000fc5 */ { 1, { 0x00000fc5 } },
	/* 0x00000fc6 */ { 1, { 0x00000fc6 } },
	/* 0x00000fc7 */ { 1, { 0x00000fc7 } },
	/* 0x00000fc8 */ { 1, { 0x00000fc8 } },
	/* 0x00000fc9 */ { 1, { 0x00000fc9 } },
	/* 0x00000fca */ { 1, { 0x00000fca } },
	/* 0x00000fcb */ { 1, { 0x00000fcb } },
	/* 0x00000fcc */ { 1, { 0x00000fcc } },
	/* 0x00000fcd */ { 1, { 0x00000fcd } },
	/* 0x00000fce */ { 1, { 0x00000fce } },
	/* 0x00000fcf */ { 1, { 0x00000fcf } },
	/* 0x00000fd0 */ { 1, { 0x00000fd0 } },
	/* 0x00000fd1 */ { 1, { 0x00000fd1 } },
	/* 0x00000fd2 */ { 1, { 0x00000fd2 } },
	/* 0x00000fd3 */ { 1, { 0x00000fd3 } },
	/* 0x00000fd4 */ { 1, { 0x00000fd4 } },
	/* 0x00000fd5 */ { 1, { 0x00000fd5 } },
	/* 0x00000fd6 */ { 1, { 0x00000fd6 } },
	/* 0x00000fd7 */ { 1, { 0x00000fd7 } },
	/* 0x00000fd8 */ { 1, { 0x00000fd8 } },
	/* 0x00000fd9 */ { 1, { 0x00000fd9 } },
	/* 0x00000fda */ { 1, { 0x00000fda } },
	/* 0x00000fdb */ { 1, { 0x00000fdb } },
	/* 0x00000fdc */ { 1, { 0x00000fdc } },
	/* 0x00000fdd */ { 1, { 0x00000fdd } },
	/* 0x00000fde */ { 1, { 0x00000fde } },
	/* 0x00000fdf */ { 1, { 0x00000fdf } },
	/* 0x00000fe0 */ { 1, { 0x00000fe0 } },
	/* 0x00000fe1 */ { 1, { 0x00000fe1 } },
	/* 0x00000fe2 */ { 1, { 0x00000fe2 } },
	/* 0x00000fe3 */ { 1, { 0x00000fe3 } },
	/* 0x00000fe4 */ { 1, { 0x00000fe4 } },
	/* 0x00000fe5 */ { 1, { 0x00000fe5 } },
	/* 0x00000fe6 */ { 1, { 0x00000fe6 } },
	/* 0x00000fe7 */ { 1, { 0x00000fe7 } },
	/* 0x00000fe8 */ { 1, { 0x00000fe8 } },
	/* 0x00000fe9 */ { 1, { 0x00000fe9 } },
	/* 0x00000fea */ { 1, { 0x00000fea } },
	/* 0x00000feb */ { 1, { 0x00000feb } },
	/* 0x00000fec */ { 1, { 0x00000fec } },
	/* 0x00000fed */ { 1, { 0x00000fed } },
	/* 0x00000fee */ { 1, { 0x00000fee } },
	/* 0x00000fef */ { 1, { 0x00000fef } },
	/* 0x00000ff0 */ { 1, { 0x00000ff0 } },
	/* 0x00000ff1 */ { 1, { 0x00000ff1 } },
	/* 0x00000ff2 */ { 1, { 0x00000ff2 } },
	/* 0x00000ff3 */ { 1, { 0x00000ff3 } },
	/* 0x00000ff4 */ { 1, { 0x00000ff4 } },
	/* 0x00000ff5 */ { 1, { 0x00000ff5 } },
	/* 0x00000ff6 */ { 1, { 0x00000ff6 } },
	/* 0x00000ff7 */ { 1, { 0x00000ff7 } },
	/* 0x00000ff8 */ { 1, { 0x00000ff8 } },
	/* 0x00000ff9 */ { 1, { 0x00000ff9 } },
	/* 0x00000ffa */ { 1, { 0x00000ffa } },
	/* 0x00000ffb */ { 1, { 0x00000ffb } },
	/* 0x00000ffc */ { 1, { 0x00000ffc } },
	/* 0x00000ffd */ { 1, { 0x00000ffd } },
	/* 0x00000ffe */ { 1, { 0x00000ffe } },
	/* 0x00000fff */ { 1, { 0x00000fff } },
	/* 0x00001000 */ { 1, { 0x00001000 } },
	/* 0x00001001 */ { 1, { 0x00001001 } },
	/* 0x00001002 */ { 1, { 0x00001002 } },
	/* 0x00001003 */ { 1, { 0x00001003 } },
	/* 0x00001004 */ { 1, { 0x00001004 } },
	/* 0x00001005 */ { 1, { 0x00001005 } },
	/* 0x00001006 */ { 1, { 0x00001006 } },
	/* 0x00001007 */ { 1, { 0x00001007 } },
	/* 0x00001008 */ { 1, { 0x00001008 } },
	/* 0x00001009 */ { 1, { 0x00001009 } },
	/* 0x0000100a */ { 1, { 0x0000100a } },
	/* 0x0000100b */ { 1, { 0x0000100b } },
	/* 0x0000100c */ { 1, { 0x0000100c } },
	/* 0x0000100d */ { 1, { 0x0000100d } },
	/* 0x0000100e */ { 1, { 0x0000100e } },
	/* 0x0000100f */ { 1, { 0x0000100f } },
	/* 0x00001010 */ { 1, { 0x00001010 } },
	/* 0x00001011 */ { 1, { 0x00001011 } },
	/* 0x00001012 */ { 1, { 0x00001012 } },
	/* 0x00001013 */ { 1, { 0x00001013 } },
	/* 0x00001014 */ { 1, { 0x00001014 } },
	/* 0x00001015 */ { 1, { 0x00001015 } },
	/* 0x00001016 */ { 1, { 0x00001016 } },
	/* 0x00001017 */ { 1, { 0x00001017 } },
	/* 0x00001018 */ { 1, { 0x00001018 } },
	/* 0x00001019 */ { 1, { 0x00001019 } },
	/* 0x0000101a */ { 1, { 0x0000101a } },
	/* 0x0000101b */ { 1, { 0x0000101b } },
	/* 0x0000101c */ { 1, { 0x0000101c } },
	/* 0x0000101d */ { 1, { 0x0000101d } },
	/* 0x0000101e */ { 1, { 0x0000101e } },
	/* 0x0000101f */ { 1, { 0x0000101f } },
	/* 0x00001020 */ { 1, { 0x00001020 } },
	/* 0x00001021 */ { 1, { 0x00001021 } },
	/* 0x00001022 */ { 1, { 0x00001022 } },
	/* 0x00001023 */ { 1, { 0x00001023 } },
	/* 0x00001024 */ { 1, { 0x00001024 } },
	/* 0x00001025 */ { 1, { 0x00001025 } },
	/* 0x00001026 */ { 2, { 0x00001025, 0x0000102e } },
	/* 0x00001027 */ { 1, { 0x00001027 } }
};

libfshfs_name_decomposition_mapping_t libfshfs_name_decomposition_mappings_0x00001e00[ 512 ] = {
	/* 0x00001e00 */ { 2, { 0x00000041, 0x00000325 } },
	/* 0x00001e01 */ { 2, { 0x00000061, 0x00000325 } },
	/* 0x00001e02 */ { 2, { 0x00000042, 0x00000307 } },
	/* 0x00001e03 */ { 2, { 0x00000062, 0x00000307 } },
	/* 0x00001e04 */ { 2, { 0x00000042, 0x00000323 } },
	/* 0x00001e05 */ { 2, { 0x00000062, 0x00000323 } },
	/* 0x00001e06 */ { 2, { 0x00000042, 0x00000331 } },
	/* 0x00001e07 */ { 2, { 0x00000062, 0x00000331 } },
	/* 0x00001e08 */ { 3, { 0x00000043, 0x00000327, 0x00000301 } },
	/* 0x00001e09 */ { 3, { 0x00000063, 0x00000327, 0x00000301 } },
	/* 0x00001e0a */ { 2, { 0x00000044, 0x00000307 } },
	/* 0x00001e0b */ { 2, { 0x00000064, 0x00000307 } },
	/* 0x00001e0c */ { 2, { 0x00000044, 0x00000323 } },
	/* 0x00001e0d */ { 2, { 0x00000064, 0x00000323 } },
	/* 0x00001e0e */ { 2, { 0x00000044, 0x00000331 } },
	/* 0x00001e0f */ { 2, { 0x00000064, 0x00000331 } },
	/* 0x00001e10 */ { 2, { 0x00000044, 0x00000327 } },
	/* 0x00001e11 */ { 2, { 0x00000064, 0x00000327 } },
	/* 0x00001e12 */ { 2, { 0x00000044, 0x0000032d } },
	/* 0x00001e13 */ { 2, { 0x00000064, 0x0000032d } },
	/* 0x00001e14 */ { 3, { 0x00000045, 0x00000304, 0x00000300 } },
	/* 0x00001e15 */ { 3, { 0x00000065, 0x00000304, 0x00000300 } },
	/* 0x00001e16 */ { 3, { 0x00000045, 0x00000304, 0x00000301 } },
	/* 0x00001e17 */ { 3, { 0x00000065, 0x00000304, 0x00000301 } },
	/* 0x00001e18 */ { 2, { 0x00000045, 0x0000032d } },
	/* 0x00001e19 */ { 2, { 0x00000065, 0x0000032d } },
	/* 0x00001e1a */ { 2, { 0x00000045, 0x00000330 } },
	/* 0x00001e1b */ { 2, { 0x00000065, 0x00000330 } },
	/* 0x00001e1c */ { 3, { 0x00000045, 0x00000327, 0x00000306 } },
	/* 0x00001e1d */ { 3, { 0x00000065, 0x00000327, 0x00000306 } },
	/* 0x00001e1e */ { 2, { 0x00000046, 0x00000307 } },
	/* 0x00001e1f */ { 2, { 0x00000066, 0x00000307 } },
	/* 0x00001e20 */ { 2, { 0x00000047, 0x00000304 } },
	/* 0x00001e21 */ { 2, { 0x00000067, 0x00000304 } },
	/* 0x00001e22 */ { 2, { 0x00000048, 0x00000307 } },
	/* 0x00001e23 */ { 2, { 0x00000068, 0x00000307 } },
	/* 0x00001e24 */ { 2, { 0x00000048, 0x00000323 } },
	/* 0x00001e25 */ { 2, { 0x00000068, 0x00000323 } },
	/* 0x00001e26 */ { 2, { 0x00000048, 0x00000308 } },
	/* 0x00001e27 */ { 2, { 0x00000068, 0x00000308 } },
	/* 0x00001e28 */ { 2, { 0x00000048, 0x00000327 } },
	/* 0x00001e29 */ { 2, { 0x00000068, 0x00000327 } },
	/* 0x00001e2a */ { 2, { 0x00000048, 0x0000032e } },
	/* 0x00001e2b */ { 2, { 0x00000068, 0x0000032e } },
	/* 0x00001e2c */ { 2, { 0x00000049, 0x00000330 } },
	/* 0x00001e2d */ { 2, { 0x00000069, 0x00000330 } },
	/* 0x00001e2e */ { 3, { 0x00000049, 0x00000308, 0x00000301 } },
	/* 0x00001e2f */ { 3, { 0x00000069, 0x00000308, 0x00000301 } },
	/* 0x00001e30 */ { 2, { 0x0000004b, 0x00000301 } },
	/* 0x00001e31 */ { 2, { 0x0000006b, 0x00000301 } },
	/* 0x00001e32 */ { 2, { 0x0000004b, 0x00000323 } },
	/* 0x00001e33 */ { 2, { 0x0000006b, 0x00000323 } },
	/* 0x00001e34 */ { 2, { 0x0000004b, 0x00000331 } },
	/* 0x00001e35 */ { 2, { 0x0000006b, 0x00000331 } },
	/* 0x00001e36 */ { 2, { 0x0000004c, 0x00000323 } },
	/* 0x00001e37 */ { 2, { 0x0000006c, 0x00000323 } },
	/* 0x00001e38 */ { 3, { 0x0000004c, 0x00000323, 0x00000304 } },
	/* 0x00001e39 */ { 3, { 0x0000006c, 0x00000323, 0x00000304 } },
	/* 0x00001e3a */ { 2, { 0x0000004c, 0x00000331 } },
	/* 0x00001e3b */ { 2, { 0x0000006c, 0x00000331 } },
	/* 0x00001e3c */ { 2, { 0x0000004c, 0x0000032d } },
	/* 0x00001e3d */ { 2, { 0x0000006c, 0x0000032d } },
	/* 0x00001e3e */ { 2, { 0x0000004d, 0x00000301 } },
	/* 0x00001e3f */ { 2, { 0x0000006d, 0x00000301 } },
	/* 0x00001e40 */ { 2, { 0x0000004d, 0x00000307 } },
	/* 0x00001e41 */ { 2, { 0x0000006d, 0x00000307 } },
	/* 0x00001e42 */ { 2, { 0x0000004d, 0x00000323 } },
	/* 0x00001e43 */ { 2, { 0x0000006d, 0x00000323 } },
	/* 0x00001e44 */ { 2, { 0x0000004e, 0x00000307 } },
	/* 0x00001e45 */ { 2, { 0x0000006e, 0x00000307 } },
	/* 0x00001e46 */ { 2, { 0x0000004e, 0x00000323 } },
	/* 0x00001e47 */ { 2, { 0x0000006e, 0x00000323 } },
	/* 0x00001e48 */ { 2, { 0x0000004e, 0x00000331 } },
	/* 0x00001e49 */ { 2, { 0x0000006e, 0x00000331 } },
	/* 0x00001e4a */ { 2, { 0x0000004e, 0x0000032d } },
	/* 0x00001e4b */ { 2, { 0x0000006e, 0x0000032d } },
	/* 0x00001e4c */ { 3, { 0x0000004f, 0x00000303, 0x00000301 } },
	/* 0x00001e4d */ { 3, { 0x0000006f, 0x00000303, 0x00000301 } },
	/* 0x00001e4e */ { 3, { 0x0000004f, 0x00000303, 0x00000308 } },
	/* 0x00001e4f */ { 3, { 0x0000006f, 0x00000303, 0x00000308 } },
	/* 0x00001e50 */ { 3, { 0x0000004f, 0x00000304, 0x00000300 } },
	/* 0x00001e51 */ { 3, { 0x0000006f, 0x00000304, 0x00000300 } },
	/* 0x00001e52 */ { 3, { 0x0000004f, 0x00000304, 0x00000301 } },
	/* 0x00001e53 */ { 3, { 0x0000006f, 0x00000304, 0x00000301 } },
	/* 0x00001e54 */ { 2, { 0x00000050, 0x00000301 } },
	/* 0x00001e55 */ { 2, { 0x00000070, 0x00000301 } },
	/* 0x00001e56 */ { 2, { 0x00000050, 0x00000307 } },
	/* 0x00001e57 */ { 2, { 0x00000070, 0x00000307 } },
	/* 0x00001e58 */ { 2, { 0x00000052, 0x00000307 } },
	/* 0x00001e59 */ { 2, { 0x00000072, 0x00000307 } },
	/* 0x00001e5a */ { 2, { 0x00000052, 0x00000323 } },
	/* 0x00001e5b */ { 2, { 0x00000072, 0x00000323 } },
	/* 0x00001e5c */ { 3, { 0x00000052, 0x00000323, 0x00000304 } },
	/* 0x00001e5d */ { 3, { 0x00000072, 0x00000323, 0x00000304 } },
	/* 0x00001e5e */ { 2, { 0x00000052, 0x00000331 } },
	/* 0x00001e5f */ { 2, { 0x00000072, 0x00000331 } },
	/* 0x00001e60 */ { 2, { 0x00000053, 0x00000307 } },
	/* 0x00001e61 */ { 2, { 0x00000073, 0x00000307 } },
	/* 0x00001e62 */ { 2, { 0x00000053, 0x00000323 } },
	/* 0x00001e63 */ { 2, { 0x00000073, 0x00000323 } },
	/* 0x00001e64 */ { 3, { 0x00000053, 0x00000301, 0x00000307 } },
	/* 0x00001e65 */ { 3, { 0x00000073, 0x00000301, 0x00000307 } },
	/* 0x00001e66 */ { 3, { 0x00000053, 0x0000030c, 0x00000307 } },
	/* 0x00001e67 */ { 3, { 0x00000073, 0x0000030c, 0x00000307 } },
	/* 0x00001e68 */ { 3, { 0x00000053, 0x00000323, 0x00000307 } },
	/* 0x00001e69 */ { 3, { 0x00000073, 0x00000323, 0x00000307 } },
	/* 0x00001e6a */ { 2, { 0x00000054, 0x00000307 } },
	/* 0x00001e6b */ { 2, { 0x00000074, 0x00000307 } },
	/* 0x00001e6c */ { 2, { 0x00000054, 0x00000323 } },
	/* 0x00001e6d */ { 2, { 0x00000074, 0x00000323 } },
	/* 0x00001e6e */ { 2, { 0x00000054, 0x00000331 } },
	/* 0x00001e6f */ { 2, { 0x00000074, 0x00000331 } },
	/* 0x00001e70 */ { 2, { 0x00000054, 0x0000032d } },
	/* 0x00001e71 */ { 2, { 0x00000074, 0x0000032d } },
	/* 0x00001e72 */ { 2, { 0x00000055, 0x00000324 } },
	/* 0x00001e73 */ { 2, { 0x00000075, 0x00000324 } },
	/* 0x00001e74 */ { 2, { 0x00000055, 0x00000330 } },
	/* 0x00001e75 */ { 2, { 0x00000075, 0x00000330 } },
	/* 0x00001e76 */ { 2, { 0x00000055, 0x0000032d } },
	/* 0x00001e77 */ { 2, { 0x00000075, 0x0000032d } },
	/* 0x00001e78 */ { 3, { 0x00000055, 0x00000303, 0x00000301 } },
	/* 0x00001e79 */ { 3, { 0x00000075, 0x00000303, 0x00000301 } },
	/* 0x00001e7a */ { 3, { 0x00000055, 0x00000304, 0x00000308 } },
	/* 0x00001e7b */ { 3, { 0x00000075, 0x00000304, 0x00000308 } },
	/* 0x00001e7c */ { 2, { 0x00000056, 0x00000303 } },
	/* 0x00001e7d */ { 2, { 0x00000076, 0x00000303 } },
	/* 0x00001e7e */ { 2, { 0x00000056, 0x00000323 } },
	/* 0x00001e7f */ { 2, { 0x00000076, 0x00000323 } },
	/* 0x00001e80 */ { 2, { 0x00000057, 0x00000300 } },
	/* 0x00001e81 */ { 2, { 0x00000077, 0x00000300 } },
	/* 0x00001e82 */ { 2, { 0x00000057, 0x00000301 } },
	/* 0x00001e83 */ { 2, { 0x00000077, 0x00000301 } },
	/* 0x00001e84 */ { 2, { 0x00000057, 0x00000308 } },
	/* 0x00001e85 */ { 2, { 0x00000077, 0x00000308 } },
	/* 0x00001e86 */ { 2, { 0x00000057, 0x00000307 } },
	/* 0x00001e87 */ { 2, { 0x00000077, 0x00000307 } },
	/* 0x00001e88 */ { 2, { 0x00000057, 0x00000323 } },
	/* 0x00001e89 */ { 2, { 0x00000077, 0x00000323 } },
	/* 0x00001e8a */ { 2, { 0x00000058, 0x00000307 } },
	/* 0x00001e8b */ { 2, { 0x00000078, 0x00000307 } },
	/* 0x00001e8c */ { 2, { 0x00000058, 0x00000308 } },
	/* 0x00001e8d */ { 2, { 0x00000078, 0x00000308 } },
	/* 0x00001e8e */ { 2, { 0x00000059, 0x00000307 } },
	/* 0x00001e8f */ { 2, { 0x00000079, 0x00000307 } },
	/* 0x00001e90 */ { 2, { 0x0000005a, 0x00000302 } },
	/* 0x00001e91 */ { 2, { 0x0000007a, 0x00000302 } },
	/* 0x00001e92 */ { 2, { 0x0000005a, 0x00000323 } },
	/* 0x00001e93 */ { 2, { 0x0000007a, 0x00000323 } },
	/* 0x00001e94 */ { 2, { 0x0000005a, 0x00000331 } },
	/* 0x00001e95 */ { 2, { 0x0000007a, 0x00000331 } },
	/* 0x00001e96 */ { 2, { 0x00000068, 0x00000331 } },
	/* 0x00001e97 */ { 2, { 0x00000074, 0x00000308 } },
	/* 0x00001e98 */ { 2, { 0x00000077, 0x0000030a } },
	/* 0x00001e99 */ { 2, { 0x00000079, 0x0000030a } },
	/* 0x00001e9a */ { 1, { 0x00001e9a } },
	/* 0x00001e9b */ { 2, { 0x0000017f, 0x00000307 } },
	/* 0x00001e9c */ { 1, { 0x00001e9c } },
	/* 0x00001e9d */ { 1, { 0x00001e9d } },
	/* 0x00001e9e */ { 1, { 0x00001e9e } },
	/* 0x00001e9f */ { 1, { 0x00001e9f } },
	/* 0x00001ea0 */ { 2, { 0x00000041, 0x00000323 } },
	/* 0x00001ea1 */ { 2, { 0x00000061, 0x00000323 } },
	/* 0x00001ea2 */ { 2, { 0x00000041, 0x00000309 } },
	/* 0x00001ea3 */ { 2, { 0x00000061, 0x00000309 } },
	/* 0x00001ea4 */ { 3, { 0x00000041, 0x00000302, 0x00000301 } },
	/* 0x00001ea5 */ { 3, { 0x00000061, 0x00000302, 0x00000301 } },
	/* 0x00001ea6 */ { 3, { 0x00000041, 0x00000302, 0x00000300 } },
	/* 0x00001ea7 */ { 3, { 0x00000061, 0x00000302, 0x00000300 } },
	/* 0x00001ea8 */ { 3, { 0x00000041, 0x00000302, 0x00000309 } },
	/* 0x00001ea9 */ { 3, { 0x00000061, 0x00000302, 0x00000309 } },
	/* 0x00001eaa */ { 3, { 0x00000041, 0x00000302, 0x00000303 } },
	/* 0x00001eab */ { 3, { 0x00000061, 0x00000302, 0x00000303 } },
	/* 0x00001eac */ { 3, { 0x00000041, 0x00000323, 0x00000302 } },
	/* 0x00001ead */ { 3, { 0x00000061, 0x00000323, 0x00000302 } },
	/* 0x00001eae */ { 3, { 0x00000041, 0x00000306, 0x00000301 } },
	/* 0x00001eaf */ { 3, { 0x00000061, 0x00000306, 0x00000301 } },
	/* 0x00001eb0 */ { 3, { 0x00000041, 0x00000306, 0x00000300 } },
	/* 0x00001eb1 */ { 3, { 0x00000061, 0x00000306, 0x00000300 } },
	/* 0x00001eb2 */ { 3, { 0x00000041, 0x00000306, 0x00000309 } },
	/* 0x00001eb3 */ { 3, { 0x00000061, 0x00000306, 0x00000309 } },
	/* 0x00001eb4 */ { 3, { 0x00000041, 0x00000306, 0x00000303 } },
	/* 0x00001eb5 */ { 3, { 0x00000061, 0x00000306, 0x00000303 } },
	/* 0x00001eb6 */ { 3, { 0x00000041, 0x00000323, 0x00000306 } },
	/* 0x00001eb7 */ { 3, { 0x00000061, 0x00000323, 0x00000306 } },
	/* 0x00001eb8 */ { 2, { 0x00000045, 0x00000323 } },
	/* 0x00001eb9 */ { 2, { 0x00000065, 0x00000323 } },
	/* 0x00001eba */ { 2, { 0x00000045, 0x00000309 } },
	/* 0x00001ebb */ { 2, { 0x00000065, 0x00000309 } },
	/* 0x00001ebc */ { 2, { 0x00000045, 0x00000303 } },
	/* 0x00001ebd */ { 2, { 0x00000065, 0x00000303 } },
	/* 0x00001ebe */ { 3, { 0x00000045, 0x00000302, 0x00000301 } },
	/* 0x00001ebf */ { 3, { 0x00000065, 0x00000302, 0x00000301 } },
	/* 0x00001ec0 */ { 3, { 0x00000045, 0x00000302, 0x00000300 } },
	/* 0x00001ec1 */ { 3, { 0x00000065, 0x00000302, 0x00000300 } },
	/* 0x00001ec2 */ { 3, { 0x00000045, 0x00000302, 0x00000309 } },
	/* 0x00001ec3 */ { 3, { 0x00000065, 0x00000302, 0x00000309 } },
	/* 0x00001ec4 */ { 3, { 0x00000045, 0x00000302, 0x00000303 } },
	/* 0x00001ec5 */ { 3, { 0x00000065, 0x00000302, 0x00000303 } },
	/* 0x00001ec6 */ { 3, { 0x00000045, 0x00000323, 0x00000302 } },
	/* 0x00001ec7 */ { 3, { 0x00000065, 0x00000323, 0x00000302 } },
	/* 0x00001ec8 */ { 2, { 0x00000049, 0x00000309 } },
	/* 0x00001ec9 */ { 2, { 0x00000069, 0x00000309 } },
	/* 0x00001eca */ { 2, { 0x00000049, 0x00000323 } },
	/* 0x00001ecb */ { 2, { 0x00000069, 0x00000323 } },
	/* 0x00001ecc */ { 2, { 0x0000004f, 0x00000323 } },
	/* 0x00001ecd */ { 2, { 0x0000006f, 0x00000323 } },
	/* 0x00001ece */ { 2, { 0x0000004f, 0x00000309 } },
	/* 0x00001ecf */ { 2, { 0x0000006f, 0x00000309 } },
	/* 0x00001ed0 */ { 3, { 0x0000004f, 0x00000302, 0x00000301 } },
	/* 0x00001ed1 */ { 3, { 0x0000006f, 0x00000302, 0x00000301 } },
	/* 0x00001ed2 */ { 3, { 0x0000004f, 0x00000302, 0x00000300 } },
	/* 0x00001ed3 */ { 3, { 0x0000006f, 0x00000302, 0x00000300 } },
	/* 0x00001ed4 */ { 3, { 0x0000004f, 0x00000302, 0x00000309 } },
	/* 0x00001ed5 */ { 3, { 0x0000006f, 0x00000302, 0x00000309 } },
	/* 0x00001ed6 */ { 3, { 0x0000004f, 0x00000302, 0x00000303 } },
	/* 0x00001ed7 */ { 3, { 0x0000006f, 0x00000302, 0x00000303 } },
	/* 0x00001ed8 */ { 3, { 0x0000004f, 0x00000323, 0x00000302 } },
	/* 0x00001ed9 */ { 3, { 0x0000006f, 0x00000323, 0x00000302 } },
	/* 0x00001eda */ { 3, { 0x0000004f, 0x0000031b, 0x00000301 } },
	/* 0x00001edb */ { 3, { 0x0000006f, 0x0000031b, 0x00000301 } },
	/* 0x00001edc */ { 3, { 0x0000004f, 0x0000031b, 0x00000300 } },
	/* 0x00001edd */ { 3, { 0x0000006f, 0x0000031b, 0x00000300 } },
	/* 0x00001ede */ { 3, { 0x0000004f, 0x0000031b, 0x00000309 } },
	/* 0x00001edf */ { 3, { 0x0000006f, 0x0000031b, 0x00000309 } },
	/* 0x00001ee0 */ { 3, { 0x0000004f, 0x0000031b, 0x00000303 } },
	/* 0x00001ee1 */ { 3, { 0x0000006f, 0x0000031b, 0x00000303 } },
	/* 0x00001ee2 */ { 3, { 0x0000004f, 0x0000031b, 0x00000323 } },
	/* 0x00001ee3 */ { 3, { 0x0000006f, 0x0000031b, 0x00000323 } },
	/* 0x00001ee4 */ { 2, { 0x00000055, 0x00000323 } },
	/* 0x00001ee5 */ { 2, { 0x00000075, 0x00000323 } },
	/* 0x00001ee6 */ { 2, { 0x00000055, 0x00000309 } },
	/* 0x00001ee7 */ { 2, { 0x00000075, 0x00000309 } },
	/* 0x00001ee8 */ { 3, { 0x00000055, 0x0000031b, 0x00000301 } },
	/* 0x00001ee9 */ { 3, { 0x00000075, 0x0000031b, 0x00000301 } },
	/* 0x00001eea */ { 3, { 0x00000055, 0x0000031b, 0x00000300 } },
	/* 0x00001eeb */ { 3, { 0x00000075, 0x0000031b, 0x00000300 } },
	/* 0x00001eec */ { 3, { 0x00000055, 0x0000031b, 0x00000309 } },
	/* 0x00001eed */ { 3, { 0x00000075, 0x0000031b, 0x00000309 } },
	/* 0x00001eee */ { 3, { 0x00000055, 0x0000031b, 0x00000303 } },
	/* 0x00001eef */ { 3, { 0x00000075, 0x0000031b, 0x00000303 } },
	/* 0x00001ef0 */ { 3, { 0x00000055, 0x0000031b, 0x00000323 } },
	/* 0x00001ef1 */ { 3, { 0x00000075, 0x0000031b, 0x00000323 } },
	/* 0x00001ef2 */ { 2, { 0x00000059, 0x00000300 } },
	/* 0x00001ef3 */ { 2, { 0x00000079, 0x00000300 } },
	/* 0x00001ef4 */ { 2, { 0x00000059, 0x00000323 } },
	/* 0x00001ef5 */ { 2, { 0x00000079, 0x00000323 } },
	/* 0x00001ef6 */ { 2, { 0x00000059, 0x00000309 } },
	/* 0x00001ef7 */ { 2, { 0x00000079, 0x00000309 } },
	/* 0x00001ef8 */ { 2, { 0x00000059, 0x00000303 } },
	/* 0x00001ef9 */ { 2, { 0x00000079, 0x00000303 } },
	/* 0x00001efa */ { 1, { 0x00001efa } },
	/* 0x00001efb */ { 1, { 0x00001efb } },
	/* 0x00001efc */ { 1, { 0x00001efc } },
	/* 0x00001efd */ { 1, { 0x00001efd } },
	/* 0x00001efe */ { 1, { 0x00001efe } },
	/* 0x00001eff */ { 1, { 0x00001eff } },
	/* 0x00001f00 */ { 2, { 0x000003b1, 0x00000313 } },
	/* 0x00001f01 */ { 2, { 0x000003b1, 0x00000314 } },
	/* 0x00001f02 */ { 3, { 0x000003b1, 0x00000313, 0x00000300 } },
	/* 0x00001f03 */ { 3, { 0x000003b1, 0x00000314, 0x00000300 } },
	/* 0x00001f04 */ { 3, { 0x000003b1, 0x00000313, 0x00000301 } },
	/* 0x00001f05 */ { 3, { 0x000003b1, 0x00000314, 0x00000301 } },
	/* 0x00001f06 */ { 3, { 0x000003b1, 0x00000313, 0x00000342 } },
	/* 0x00001f07 */ { 3, { 0x000003b1, 0x00000314, 0x00000342 } },
	/* 0x00001f08 */ { 2, { 0x00000391, 0x00000313 } },
	/* 0x00001f09 */ { 2, { 0x00000391, 0x00000314 } },
	/* 0x00001f0a */ { 3, { 0x00000391, 0x00000313, 0x00000300 } },
	/* 0x00001f0b */ { 3, { 0x00000391, 0x00000314, 0x00000300 } },
	/* 0x00001f0c */ { 3, { 0x00000391, 0x00000313, 0x00000301 } },
	/* 0x00001f0d */ { 3, { 0x00000391, 0x00000314, 0x00000301 } },
	/* 0x00001f0e */ { 3, { 0x00000391, 0x00000313, 0x00000342 } },
	/* 0x00001f0f */ { 3, { 0x00000391, 0x00000314, 0x00000342 } },
	/* 0x00001f10 */ { 2, { 0x000003b5, 0x00000313 } },
	/* 0x00001f11 */ { 2, { 0x000003b5, 0x00000314 } },
	/* 0x00001f12 */ { 3, { 0x000003b5, 0x00000313, 0x00000300 } },
	/* 0x00001f13 */ { 3, { 0x000003b5, 0x00000314, 0x00000300 } },
	/* 0x00001f14 */ { 3, { 0x000003b5, 0x00000313, 0x00000301 } },
	/* 0x00001f15 */ { 3, { 0x000003b5, 0x00000314, 0x00000301 } },
	/* 0x00001f16 */ { 1, { 0x00001f16 } },
	/* 0x00001f17 */ { 1, { 0x00001f17 } },
	/* 0x00001f18 */ { 2, { 0x00000395, 0x00000313 } },
	/* 0x00001f19 */ { 2, { 0x00000395, 0x00000314 } },
	/* 0x00001f1a */ { 3, { 0x00000395, 0x00000313, 0x00000300 } },
	/* 0x00001f1b */ { 3, { 0x00000395, 0x00000314, 0x00000300 } },
	/* 0x00001f1c */ { 3, { 0x00000395, 0x00000313, 0x00000301 } },
	/* 0x00001f1d */ { 3, { 0x00000395, 0x00000314, 0x00000301 } },
	/* 0x00001f1e */ { 1, { 0x00001f1e } },
	/* 0x00001f1f */ { 1, { 0x00001f1f } },
	/* 0x00001f20 */ { 2, { 0x000003b7, 0x00000313 } },
	/* 0x00001f21 */ { 2, { 0x000003b7, 0x00000314 } },
	/* 0x00001f22 */ { 3, { 0x000003b7, 0x00000313, 0x00000300 } },
	/* 0x00001f23 */ { 3, { 0x000003b7, 0x00000314, 0x00000300 } },
	/* 0x00001f24 */ { 3, { 0x000003b7, 0x00000313, 0x00000301 } },
	/* 0x00001f25 */ { 3, { 0x000003b7, 0x00000314, 0x00000301 } },
	/* 0x00001f26 */ { 3, { 0x000003b7, 0x00000313, 0x00000342 } },
	/* 0x00001f27 */ { 3, { 0x000003b7, 0x00000314, 0x00000342 } },
	/* 0x00001f28 */ { 2, { 0x00000397, 0x00000313 } },
	/* 0x00001f29 */ { 2, { 0x00000397, 0x00000314 } },
	/* 0x00001f2a */ { 3, { 0x00000397, 0x00000313, 0x00000300 } },
	/* 0x00001f2b */ { 3, { 0x00000397, 0x00000314, 0x00000300 } },
	/* 0x00001f2c */ { 3, { 0x00000397, 0x00000313, 0x00000301 } },
	/* 0x00001f2d */ { 3, { 0x00000397, 0x00000314, 0x00000301 } },
	/* 0x00001f2e */ { 3, { 0x00000397, 0x00000313, 0x00000342 } },
	/* 0x00001f2f */ { 3, { 0x00000397, 0x00000314, 0x00000342 } },
	/* 0x00001f30 */ { 2, { 0x000003b9, 0x00000313 } },
	/* 0x00001f31 */ { 2, { 0x000003b9, 0x00000314 } },
	/* 0x00001f32 */ { 3, { 0x000003b9, 0x00000313, 0x00000300 } },
	/* 0x00001f33 */ { 3, { 0x000003b9, 0x00000314, 0x00000300 } },
	/* 0x00001f34 */ { 3, { 0x000003b9, 0x00000313, 0x00000301 } },
	/* 0x00001f35 */ { 3, { 0x000003b9, 0x00000314, 0x00000301 } },
	/* 0x00001f36 */ { 3, { 0x000003b9, 0x00000313, 0x00000342 } },
	/* 0x00001f37 */ { 3, { 0x000003b9, 0x00000314, 0x00000342 } },
	/* 0x00001f38 */ { 2, { 0x00000399, 0x00000313 } },
	/* 0x00001f39 */ { 2, { 0x00000399, 0x00000314 } },
	/* 0x00001f3a */ { 3, { 0x00000399, 0x00000313, 0x00000300 } },
	/* 0x00001f3b */ { 3, { 0x00000399, 0x00000314, 0x00000300 } },
	/* 0x00001f3c */ { 3, { 0x00000399, 0x00000313, 0x00000301 } },
	/* 0x00001f3d */ { 3, { 0x00000399, 0x00000314, 0x00000301 } },
	/* 0x00001f3e */ { 3, { 0x00000399, 0x00000313, 0x00000342 } },
	/* 0x00001f3f */ { 3, { 0x00000399, 0x00000314, 0x00000342 } },
	/* 0x00001f40 */ { 2, { 0x000003bf, 0x00000313 } },
	/* 0x00001f41 */ { 2, { 0x000003bf, 0x00000314 } },
	/* 0x00001f42 */ { 3, { 0x000003bf, 0x00000313, 0x00000300 } },
	/* 0x00001f43 */ { 3, { 0x000003bf, 0x00000314, 0x00000300 } },
	/* 0x00001f44 */ { 3, { 0x000003bf, 0x00000313, 0x00000301 } },
	/* 0x00001f45 */ { 3, { 0x000003bf, 0x00000314, 0x00000301 } },
	/* 0x00001f46 */ { 1, { 0x00001f46 } },
	/* 0x00001f47 */ { 1, { 0x00001f47 } },
	/* 0x00001f48 */ { 2, { 0x0000039f, 0x00000313 } },
	/* 0x00001f49 */ { 2, { 0x0000039f, 0x00000314 } },
	/* 0x00001f4a */ { 3, { 0x0000039f, 0x00000313, 0x00000300 } },
	/* 0x00001f4b */ { 3, { 0x0000039f, 0x00000314, 0x00000300 } },
	/* 0x00001f4c */ { 3, { 0x0000039f, 0x00000313, 0x00000301 } },
	/* 0x00001f4d */ { 3, { 0x0000039f, 0x00000314, 0x00000301 } },
	/* 0x00001f4e */ { 1, { 0x00001f4e } },
	/* 0x00001f4f */ { 1, { 0x00001f4f } },
	/* 0x00001f50 */ { 2, { 0x000003c5, 0x00000313 } },
	/* 0x00001f51 */ { 2, { 0x000003c5, 0x00000314 } },
	/* 0x00001f52 */ { 3, { 0x000003c5, 0x00000313, 0x00000300 } },
	/* 0x00001f53 */ { 3, { 0x000003c5, 0x00000314, 0x00000300 } },
	/* 0x00001f54 */ { 3, { 0x000003c5, 0x00000313, 0x00000301 } },
	/* 0x00001f55 */ { 3, { 0x000003c5, 0x00000314, 0x00000301 } },
	/* 0x00001f56 */ { 3, { 0x000003c5, 0x00000313, 0x00000342 } },
	/* 0x00001f57 */ { 3, { 0x000003c5, 0x00000314, 0x00000342 } },
	/* 0x00001f58 */ { 1, { 0x00001f58 } },
	/* 0x00001f59 */ { 2, { 0x000003a5, 0x00000314 } },
	/* 0x00001f5a */ { 1, { 0x00001f5a } },
	/* 0x00001f5b */ { 3, { 0x000003a5, 0x00000314, 0x00000300 } },
	/* 0x00001f5c */ { 1, { 0x00001f5c } },
	/* 0x00001f5d */ { 3, { 0x000003a5, 0x00000314, 0x00000301 } },
	/* 0x00001f5e */ { 1, { 0x00001f5e } },
	/* 0x00001f5f */ { 3, { 0x000003a5, 0x00000314, 0x00000342 } },
	/* 0x00001f60 */ { 2, { 0x000003c9, 0x00000313 } },
	/* 0x00001f61 */ { 2, { 0x000003c9, 0x00000314 } },
	/* 0x00001f62 */ { 3, { 0x000003c9, 0x00000313, 0x00000300 } },
	/* 0x00001f63 */ { 3, { 0x000003c9, 0x00000314, 0x00000300 } },
	/* 0x00001f64 */ { 3, { 0x000003c9, 0x00000313, 0x00000301 } },
	/* 0x00001f65 */ { 3, { 0x000003c9, 0x00000314, 0x00000301 } },
	/* 0x00001f66 */ { 3, { 0x000003c9, 0x00000313, 0x00000342 } },
	/* 0x00001f67 */ { 3, { 0x000003c9, 0x00000314, 0x00000342 } },
	/* 0x00001f68 */ { 2, { 0x000003a9, 0x00000313 } },
	/* 0x00001f69 */ { 2, { 0x000003a9, 0x00000314 } },
	/* 0x00001f6a */ { 3, { 0x000003a9, 0x00000313, 0x00000300 } },
	/* 0x00001f6b */ { 3, { 0x000003a9, 0x00000314, 0x00000300 } },
	/* 0x00001f6c */ { 3, { 0x000003a9, 0x00000313, 0x00000301 } },
	/* 0x00001f6d */ { 3, { 0x000003a9, 0x00000314, 0x00000301 } },
	/* 0x00001f6e */ { 3, { 0x000003a9, 0x00000313, 0x00000342 } },
	/* 0x00001f6f */ { 3, { 0x000003a9, 0x00000314, 0x00000342 } },
	/* 0x00001f70 */ { 2, { 0x000003b1, 0x00000300 } },
	/* 0x00001f71 */ { 2, { 0x000003b1, 0x00000301 } },
	/* 0x00001f72 */ { 2, { 0x000003b5, 0x00000300 } },
	/* 0x00001f73 */ { 2, { 0x000003b5, 0x00000301 } },
	/* 0x00001f74 */ { 2, { 0x000003b7, 0x00000300 } },
	/* 0x00001f75 */ { 2, { 0x000003b7, 0x00000301 } },
	/* 0x00001f76 */ { 2, { 0x000003b9, 0x00000300 } },
	/* 0x00001f77 */ { 2, { 0x000003b9, 0x00000301 } },
	/* 0x00001f78 */ { 2, { 0x000003bf, 0x00000300 } },
	/* 0x00001f79 */ { 2, { 0x000003bf, 0x00000301 } },
	/* 0x00001f7a */ { 2, { 0x000003c5, 0x00000300 } },
	/* 0x00001f7b */ { 2, { 0x000003c5, 0x00000301 } },
	/* 0x00001f7c */ { 2, { 0x000003c9, 0x00000300 } },
	/* 0x00001f7d */ { 2, { 0x000003c9, 0x00000301 } },
	/* 0x00001f7e */ { 1, { 0x00001f7e } },
	/* 0x00001f7f */ { 1, { 0x00001f7f } },
	/* 0x00001f80 */ { 3, { 0x000003b1, 0x00000313, 0x00000345 } },
	/* 0x00001f81 */ { 3, { 0x000003b1, 0x00000314, 0x00000345 } },
	/* 0x00001f82 */ { 4, { 0x000003b1, 0x00000313, 0x00000300, 0x00000345 } },
	/* 0x00001f83 */ { 4, { 0x000003b1, 0x00000314, 0x00000300, 0x00000345 } },
	/* 0x00001f84 */ { 4, { 0x000003b1, 0x00000313, 0x00000301, 0x00000345 } },
	/* 0x00001f85 */ { 4, { 0x000003b1, 0x00000314, 0x00000301, 0x00000345 } },
	/* 0x00001f86 */ { 4, { 0x000003b1, 0x00000313, 0x00000342, 0x00000345 } },
	/* 0x00001f87 */ { 4, { 0x000003b1, 0x00000314, 0x00000342, 0x00000345 } },
	/* 0x00001f88 */ { 3, { 0x00000391, 0x00000313, 0x00000345 } },
	/* 0x00001f89 */ { 3, { 0x00000391, 0x00000314, 0x00000345 } },
	/* 0x00001f8a */ { 4, { 0x00000391, 0x00000313, 0x00000300, 0x00000345 } },
	/* 0x00001f8b */ { 4, { 0x00000391, 0x00000314, 0x00000300, 0x00000345 } },
	/* 0x00001f8c */ { 4, { 0x00000391, 0x00000313, 0x00000301, 0x00000345 } },
	/* 0x00001f8d */ { 4, { 0x00000391, 0x00000314, 0x00000301, 0x00000345 } },
	/* 0x00001f8e */ { 4, { 0x00000391, 0x00000313, 0x00000342, 0x00000345 } },
	/* 0x00001f8f */ { 4, { 0x00000391, 0x00000314, 0x00000342, 0x00000345 } },
	/* 0x00001f90 */ { 3, { 0x000003b7, 0x00000313, 0x00000345 } },
	/* 0x00001f91 */ { 3, { 0x000003b7, 0x00000314, 0x00000345 } },
	/* 0x00001f92 */ { 4, { 0x000003b7, 0x00000313, 0x00000300, 0x00000345 } },
	/* 0x00001f93 */ { 4, { 0x000003b7, 0x00000314, 0x00000300, 0x00000345 } },
	/* 0x00001f94 */ { 4, { 0x000003b7, 0x00000313, 0x00000301, 0x00000345 } },
	/* 0x00001f95 */ { 4, { 0x000003b7, 0x00000314, 0x00000301, 0x00000345 } },
	/* 0x00001f96 */ { 4, { 0x000003b7, 0x00000313, 0x00000342, 0x00000345 } },
	/* 0x00001f97 */ { 4, { 0x000003b7, 0x00000314, 0x00000342, 0x00000345 } },
	/* 0x00001f98 */ { 3, { 0x00000397, 0x00000313, 0x00000345 } },
	/* 0x00001f99 */ { 3, { 0x00000397, 0x00000314, 0x00000345 } },
	/* 0x00001f9a */ { 4, { 0x00000397, 0x00000313, 0x00000300, 0x00000345 } },
	/* 0x00001f9b */ { 4, { 0x00000397, 0x00000314, 0x00000300, 0x00000345 } },
	/* 0x00001f9c */ { 4, { 0x00000397, 0x00000313, 0x00000301, 0x00000345 } },
	/* 0x00001f9d */ { 4, { 0x00000397, 0x00000314, 0x00000301, 0x00000345 } },
	/* 0x00001f9e */ { 4, { 0x00000397, 0x00000313, 0x00000342, 0x00000345 } },
	/* 0x00001f9f */ { 4, { 0x00000397, 0x00000314, 0x00000342, 0x00000345 } },
	/* 0x00001fa0 */ { 3, { 0x000003c9, 0x00000313, 0x00000345 } },
	/* 0x00001fa1 */ { 3, { 0x000003c9, 0x00000314, 0x00000345 } },
	/* 0x00001fa2 */ { 4, { 0x000003c9, 0x00000313, 0x00000300, 0x00000345 } },
	/* 0x00001fa3 */ { 4, { 0x000003c9, 0x00000314, 0x00000300, 0x00000345 } },
	/* 0x00001fa4 */ { 4, { 0x000003c9, 0x00000313, 0x00000301, 0x00000345 } },
	/* 0x00001fa5 */ { 4, { 0x000003c9, 0x00000314, 0x00000301, 0x00000345 } },
	/* 0x00001fa6 */ { 4, { 0x000003c9, 0x00000313, 0x00000342, 0x00000345 } },
	/* 0x00001fa7 */ { 4, { 0x000003c9, 0x00000314, 0x00000342, 0x00000345 } },
	/* 0x00001fa8 */ { 3, { 0x000003a9, 0x00000313, 0x00000345 } },
	/* 0x00001fa9 */ { 3, { 0x000003a9, 0x00000314, 0x00000345 } },
	/* 0x00001faa */ { 4, { 0x000003a9, 0x00000313, 0x00000300, 0x00000345 } },
	/* 0x00001fab */ { 4, { 0x000003a9, 0x00000314, 0x00000300, 0x00000345 } },
	/* 0x00001fac */ { 4, { 0x000003a9, 0x00000313, 0x00000301, 0x00000345 } },
	/* 0x00001fad */ { 4, { 0x000003a9, 0x00000314, 0x00000301, 0x00000345 } },
	/* 0x00001fae */ { 4, { 0x000003a9, 0x00000313, 0x00000342, 0x00000345 } },
	/* 0x00001faf */ { 4, { 0x000003a9, 0x00000314, 0x00000342, 0x00000345 } },
	/* 0x00001fb0 */ { 2, { 0x000003b1, 0x00000306 } },
	/* 0x00001fb1 */ { 2, { 0x000003b1, 0x00000304 } },
	/* 0x00001fb2 */ { 3, { 0x000003b1, 0x00000300, 0x00000345 } },
	/* 0x00001fb3 */ { 2, { 0x000003b1, 0x00000345 } },
	/* 0x00001fb4 */ { 3, { 0x000003b1, 0x00000301, 0x00000345 } },
	/* 0x00001fb5 */ { 1, { 0x00001fb5 } },
	/* 0x00001fb6 */ { 2, { 0x000003b1, 0x00000342 } },
	/* 0x00001fb7 */ { 3, { 0x000003b1, 0x00000342, 0x00000345 } },
	/* 0x00001fb8 */ { 2, { 0x00000391, 0x00000306 } },
	/* 0x00001fb9 */ { 2, { 0x00000391, 0x00000304 } },
	/* 0x00001fba */ { 2, { 0x00000391, 0x00000300 } },
	/* 0x00001fbb */ { 2, { 0x00000391, 0x00000301 } },
	/* 0x00001fbc */ { 2, { 0x00000391, 0x00000345 } },
	/* 0x00001fbd */ { 1, { 0x00001fbd } },
	/* 0x00001fbe */ { 1, { 0x000003b9 } },
	/* 0x00001fbf */ { 1, { 0x00001fbf } },
	/* 0x00001fc0 */ { 1, { 0x00001fc0 } },
	/* 0x00001fc1 */ { 2, { 0x000000a8, 0x00000342 } },
	/* 0x00001fc2 */ { 3, { 0x000003b7, 0x00000300, 0x00000345 } },
	/* 0x00001fc3 */ { 2, { 0x000003b7, 0x00000345 } },
	/* 0x00001fc4 */ { 3, { 0x000003b7, 0x00000301, 0x00000345 } },
	/* 0x00001fc5 */ { 1, { 0x00001fc5 } },
	/* 0x00001fc6 */ { 2, { 0x000003b7, 0x00000342 } },
	/* 0x00001fc7 */ { 3, { 0x000003b7, 0x00000342, 0x00000345 } },
	/* 0x00001fc8 */ { 2, { 0x00000395, 0x00000300 } },
	/* 0x00001fc9 */ { 2, { 0x00000395, 0x00000301 } },
	/* 0x00001fca */ { 2, { 0x00000397, 0x00000300 } },
	/* 0x00001fcb */ { 2, { 0x00000397, 0x00000301 } },
	/* 0x00001fcc */ { 2, { 0x00000397, 0x00000345 } },
	/* 0x00001fcd */ { 2, { 0x00001fbf, 0x00000300 } },
	/* 0x00001fce */ { 2, { 0x00001fbf, 0x00000301 } },
	/* 0x00001fcf */ { 2, { 0x00001fbf, 0x00000342 } },
	/* 0x00001fd0 */ { 2, { 0x000003b9, 0x00000306 } },
	/* 0x00001fd1 */ { 2, { 0x000003b9, 0x00000304 } },
	/* 0x00001fd2 */ { 3, { 0x000003b9, 0x00000308, 0x00000300 } },
	/* 0x00001fd3 */ { 3, { 0x000003b9, 0x00000308, 0x00000301 } },
	/* 0x00001fd4 */ { 1, { 0x00001fd4 } },
	/* 0x00001fd5 */ { 1, { 0x00001fd5 } },
	/* 0x00001fd6 */ { 2, { 0x000003b9, 0x00000342 } },
	/* 0x00001fd7 */ { 3, { 0x000003b9, 0x00000308, 0x00000342 } },
	/* 0x00001fd8 */ { 2, { 0x00000399, 0x00000306 } },
	/* 0x00001fd9 */ { 2, { 0x00000399, 0x00000304 } },
	/* 0x00001fda */ { 2, { 0x00000399, 0x00000300 } },
	/* 0x00001fdb */ { 2, { 0x00000399, 0x00000301 } },
	/* 0x00001fdc */ { 1, { 0x00001fdc } },
	/* 0x00001fdd */ { 2, { 0x00001ffe, 0x00000300 } },
	/* 0x00001fde */ { 2, { 0x00001ffe, 0x00000301 } },
	/* 0x00001fdf */ { 2, { 0x00001ffe, 0x00000342 } },
	/* 0x00001fe0 */ { 2, { 0x000003c5, 0x00000306 } },
	/* 0x00001fe1 */ { 2, { 0x000003c5, 0x00000304 } },
	/* 0x00001fe2 */ { 3, { 0x000003c5, 0x00000308, 0x00000300 } },
	/* 0x00001fe3 */ { 3, { 0x000003c5, 0x00000308, 0x00000301 } },
	/* 0x00001fe4 */ { 2, { 0x000003c1, 0x00000313 } },
	/* 0x00001fe5 */ { 2, { 0x000003c1, 0x00000314 } },
	/* 0x00001fe6 */ { 2, { 0x000003c5, 0x00000342 } },
	/* 0x00001fe7 */ { 3, { 0x000003c5, 0x00000308, 0x00000342 } },
	/* 0x00001fe8 */ { 2, { 0x000003a5, 0x00000306 } },
	/* 0x00001fe9 */ { 2, { 0x000003a5, 0x00000304 } },
	/* 0x00001fea */ { 2, { 0x000003a5, 0x00000300 } },
	/* 0x00001feb */ { 2, { 0x000003a5, 0x00000301 } },
	/* 0x00001fec */ { 2, { 0x000003a1, 0x00000314 } },
	/* 0x00001fed */ { 2, { 0x000000a8, 0x00000300 } },
	/* 0x00001fee */ { 2, { 0x000000a8, 0x00000301 } },
	/* 0x00001fef */ { 1, { 0x00000060 } },
	/* 0x00001ff0 */ { 1, { 0x00001ff0 } },
	/* 0x00001ff1 */ { 1, { 0x00001ff1 } },
	/* 0x00001ff2 */ { 3, { 0x000003c9, 0x00000300, 0x00000345 } },
	/* 0x00001ff3 */ { 2, { 0x000003c9, 0x00000345 } },
	/* 0x00001ff4 */ { 3, { 0x000003c9, 0x00000301, 0x00000345 } },
	/* 0x00001ff5 */ { 1, { 0x00001ff5 } },
	/* 0x00001ff6 */ { 2, { 0x000003c9, 0x00000342 } },
	/* 0x00001ff7 */ { 3, { 0x000003c9, 0x00000342, 0x00000345 } },
	/* 0x00001ff8 */ { 2, { 0x0000039f, 0x00000300 } },
	/* 0x00001ff9 */ { 2, { 0x0000039f, 0x00000301 } },
	/* 0x00001ffa */ { 2, { 0x000003a9, 0x00000300 } },
	/* 0x00001ffb */ { 2, { 0x000003a9, 0x00000301 } },
	/* 0x00001ffc */ { 2, { 0x000003a9, 0x00000345 } },
	/* 0x00001ffd */ { 1, { 0x000000b4 } },
	/* 0x00001ffe */ { 1, { 0x00001ffe } },
	/* 0x00001fff */ { 1, { 0x00001fff } },
};

libfshfs_name_decomposition_mapping_t libfshfs_name_decomposition_mappings_0x00003048[ 184 ] = {
	/* 0x00003048 */ { 1, { 0x00003048 } },
	/* 0x00003049 */ { 1, { 0x00003049 } },
	/* 0x0000304a */ { 1, { 0x0000304a } },
	/* 0x0000304b */ { 1, { 0x0000304b } },
	/* 0x0000304c */ { 2, { 0x0000304b, 0x00003099 } },
	/* 0x0000304d */ { 1, { 0x0000304d } },
	/* 0x0000304e */ { 2, { 0x0000304d, 0x00003099 } },
	/* 0x0000304f */ { 1, { 0x0000304f } },
	/* 0x00003050 */ { 2, { 0x0000304f, 0x00003099 } },
	/* 0x00003051 */ { 1, { 0x00003051 } },
	/* 0x00003052 */ { 2, { 0x00003051, 0x00003099 } },
	/* 0x00003053 */ { 1, { 0x00003053 } },
	/* 0x00003054 */ { 2, { 0x00003053, 0x00003099 } },
	/* 0x00003055 */ { 1, { 0x00003055 } },
	/* 0x00003056 */ { 2, { 0x00003055, 0x00003099 } },
	/* 0x00003057 */ { 1, { 0x00003057 } },
	/* 0x00003058 */ { 2, { 0x00003057, 0x00003099 } },
	/* 0x00003059 */ { 1, { 0x00003059 } },
	/* 0x0000305a */ { 2, { 0x00003059, 0x00003099 } },
	/* 0x0000305b */ { 1, { 0x0000305b } },
	/* 0x0000305c */ { 2, { 0x0000305b, 0x00003099 } },
	/* 0x0000305d */ { 1, { 0x0000305d } },
	/* 0x0000305e */ { 2, { 0x0000305d, 0x00003099 } },
	/* 0x0000305f */ { 1, { 0x0000305f } },
	/* 0x00003060 */ { 2, { 0x0000305f, 0x00003099 } },
	/* 0x00003061 */ { 1, { 0x00003061 } },
	/* 0x00003062 */ { 2, { 0x00003061, 0x00003099 } },
	/* 0x00003063 */ { 1, { 0x00003063 } },
	/* 0x00003064 */ { 1, { 0x00003064 } },
	/* 0x00003065 */ { 2, { 0x00003064, 0x00003099 } },
	/* 0x00003066 */ { 1, { 0x00003066 } },
	/* 0x00003067 */ { 2, { 0x00003066, 0x00003099 } },
	/* 0x00003068 */ { 1, { 0x00003068 } },
	/* 0x00003069 */ { 2, { 0x00003068, 0x00003099 } },
	/* 0x0000306a */ { 1, { 0x0000306a } },
	/* 0x0000306b */ { 1, { 0x0000306b } },
	/* 0x0000306c */ { 1, { 0x0000306c } },
	/* 0x0000306d */ { 1, { 0x0000306d } },
	/* 0x0000306e */ { 1, { 0x0000306e } },
	/* 0x0000306f */ { 1, { 0x0000306f } },
	/* 0x00003070 */ { 2, { 0x0000306f, 0x00003099 } },
	/* 0x00003071 */ { 2, { 0x0000306f, 0x0000309a } },
	/* 0x00003072 */ { 1, { 0x00003072 } },
	/* 0x00003073 */ { 2, { 0x00003072, 0x00003099 } },
	/* 0x00003074 */ { 2, { 0x00003072, 0x0000309a } },
	/* 0x00003075 */ { 1, { 0x00003075 } },
	/* 0x00003076 */ { 2, { 0x00003075, 0x00003099 } },
	/* 0x00003077 */ { 2, { 0x00003075, 0x0000309a } },
	/* 0x00003078 */ { 1, { 0x00003078 } },
	/* 0x00003079 */ { 2, { 0x00003078, 0x00003099 } },
	/* 0x0000307a */ { 2, { 0x00003078, 0x0000309a } },
	/* 0x0000307b */ { 1, { 0x0000307b } },
	/* 0x0000307c */ { 2, { 0x0000307b, 0x00003099 } },
	/* 0x0000307d */ { 2, { 0x0000307b, 0x0000309a } },
	/* 0x0000307e */ { 1, { 0x0000307e } },
	/* 0x0000307f */ { 1, { 0x0000307f } },
	/* 0x00003080 */ { 1, { 0x00003080 } },
	/* 0x00003081 */ { 1, { 0x00003081 } },
	/* 0x00003082 */ { 1, { 0x00003082 } },
	/* 0x00003083 */ { 1, { 0x00003083 } },
	/* 0x00003084 */ { 1, { 0x00003084 } },
	/* 0x00003085 */ { 1, { 0x00003085 } },
	/* 0x00003086 */ { 1, { 0x00003086 } },
	/* 0x00003087 */ { 1, { 0x00003087 } },
	/* 0x00003088 */ { 1, { 0x00003088 } },
	/* 0x00003089 */ { 1, { 0x00003089 } },
	/* 0x0000308a */ { 1, { 0x0000308a } },
	/* 0x0000308b */ { 1, { 0x0000308b } },
	/* 0x0000308c */ { 1, { 0x0000308c } },
	/* 0x0000308d */ { 1, { 0x0000308d } },
	/* 0x0000308e */ { 1, { 0x0000308e } },
	/* 0x0000308f */ { 1, { 0x0000308f } },
	/* 0x00003090 */ { 1, { 0x00003090 } },
	/* 0x00003091 */ { 1, { 0x00003091 } },
	/* 0x00003092 */ { 1, { 0x00003092 } },
	/* 0x00003093 */ { 1, { 0x00003093 } },
	/* 0x00003094 */ { 2, { 0x00003046, 0x00003099 } },
	/* 0x00003095 */ { 1, { 0x00003095 } },
	/* 0x00003096 */ { 1, { 0x00003096 } },
	/* 0x00003097 */ { 1, { 0x00003097 } },
	/* 0x00003098 */ { 1, { 0x00003098 } },
	/* 0x00003099 */ { 1, { 0x00003099 } },
	/* 0x0000309a */ { 1, { 0x0000309a } },
	/* 0x0000309b */ { 1, { 0x0000309b } },
	/* 0x0000309c */ { 1, { 0x0000309c } },
	/* 0x0000309d */ { 1, { 0x0000309d } },
	/* 0x0000309e */ { 2, { 0x0000309d, 0x00003099 } },
	/* 0x0000309f */ { 1, { 0x0000309f } },
	/* 0x000030a0 */ { 1, { 0x000030a0 } },
	/* 0x000030a1 */ { 1, { 0x000030a1 } },
	/* 0x000030a2 */ { 1, { 0x000030a2 } },
	/* 0x000030a3 */ { 1, { 0x000030a3 } },
	/* 0x000030a4 */ { 1, { 0x000030a4 } },
	/* 0x000030a5 */ { 1, { 0x000030a5 } },
	/* 0x000030a6 */ { 1, { 0x000030a6 } },
	/* 0x000030a7 */ { 1, { 0x000030a7 } },
	/* 0x000030a8 */ { 1, { 0x000030a8 } },
	/* 0x000030a9 */ { 1, { 0x000030a9 } },
	/* 0x000030aa */ { 1, { 0x000030aa } },
	/* 0x000030ab */ { 1, { 0x000030ab } },
	/* 0x000030ac */ { 2, { 0x000030ab, 0x00003099 } },
	/* 0x000030ad */ { 1, { 0x000030ad } },
	/* 0x000030ae */ { 2, { 0x000030ad, 0x00003099 } },
	/* 0x000030af */ { 1, { 0x000030af } },
	/* 0x000030b0 */ { 2, { 0x000030af, 0x00003099 } },
	/* 0x000030b1 */ { 1, { 0x000030b1 } },
	/* 0x000030b2 */ { 2, { 0x000030b1, 0x00003099 } },
	/* 0x000030b3 */ { 1, { 0x000030b3 } },
	/* 0x000030b4 */ { 2, { 0x000030b3, 0x00003099 } },
	/* 0x000030b5 */ { 1, { 0x000030b5 } },
	/* 0x000030b6 */ { 2, { 0x000030b5, 0x00003099 } },
	/* 0x000030b7 */ { 1, { 0x000030b7 } },
	/* 0x000030b8 */ { 2, { 0x000030b7, 0x00003099 } },
	/* 0x000030b9 */ { 1, { 0x000030b9 } },
	/* 0x000030ba */ { 2, { 0x000030b9, 0x00003099 } },
	/* 0x000030bb */ { 1, { 0x000030bb } },
	/* 0x000030bc */ { 2, { 0x000030bb, 0x00003099 } },
	/* 0x000030bd */ { 1, { 0x000030bd } },
	/* 0x000030be */ { 2, { 0x000030bd, 0x00003099 } },
	/* 0x000030bf */ { 1, { 0x000030bf } },
	/* 0x000030c0 */ { 2, { 0x000030bf, 0x00003099 } },
	/* 0x000030c1 */ { 1, { 0x000030c1 } },
	/* 0x000030c2 */ { 2, { 0x000030c1, 0x00003099 } },
	/* 0x000030c3 */ { 1, { 0x000030c3 } },
	/* 0x000030c4 */ { 1, { 0x000030c4 } },
	/* 0x000030c5 */ { 2, { 0x000030c4, 0x00003099 } },
	/* 0x000030c6 */ { 1, { 0x000030c6 } },
	/* 0x000030c7 */ { 2, { 0x000030c6, 0x00003099 } },
	/* 0x000030c8 */ { 1, { 0x000030c8 } },
	/* 0x000030c9 */ { 2, { 0x000030c8, 0x00003099 } },
	/* 0x000030ca */ { 1, { 0x000030ca } },
	/* 0x000030cb */ { 1, { 0x000030cb } },
	/* 0x000030cc */ { 1, { 0x000030cc } },
	/* 0x000030cd */ { 1, { 0x000030cd } },
	/* 0x000030ce */ { 1, { 0x000030ce } },
	/* 0x000030cf */ { 1, { 0x000030cf } },
	/* 0x000030d0 */ { 2, { 0x000030cf, 0x00003099 } },
	/* 0x000030d1 */ { 2, { 0x000030cf, 0x0000309a } },
	/* 0x000030d2 */ { 1, { 0x000030d2 } },
	/* 0x000030d3 */ { 2, { 0x000030d2, 0x00003099 } },
	/* 0x000030d4 */ { 2, { 0x000030d2, 0x0000309a } },
	/* 0x000030d5 */ { 1, { 0x000030d5 } },
	/* 0x000030d6 */ { 2, { 0x000030d5, 0x00003099 } },
	/* 0x000030d7 */ { 2, { 0x000030d5, 0x0000309a } },
	/* 0x000030d8 */ { 1, { 0x000030d8 } },
	/* 0x000030d9 */ { 2, { 0x000030d8, 0x00003099 } },
	/* 0x000030da */ { 2, { 0x000030d8, 0x0000309a } },
	/* 0x000030db */ { 1, { 0x000030db } },
	/* 0x000030dc */ { 2, { 0x000030db, 0x00003099 } },
	/* 0x000030dd */ { 2, { 0x000030db, 0x0000309a } },
	/* 0x000030de */ { 1, { 0x000030de } },
	/* 0x000030df */ { 1, { 0x000030df } },
	/* 0x000030e0 */ { 1, { 0x000030e0 } },
	/* 0x000030e1 */ { 1, { 0x000030e1 } },
	/* 0x000030e2 */ { 1, { 0x000030e2 } },
	/* 0x000030e3 */ { 1, { 0x000030e3 } },
	/* 0x000030e4 */ { 1, { 0x000030e4 } },
	/* 0x000030e5 */ { 1, { 0x000030e5 } },
	/* 0x000030e6 */ { 1, { 0x000030e6 } },
	/* 0x000030e7 */ { 1, { 0x000030e7 } },
	/* 0x000030e8 */ { 1, { 0x000030e8 } },
	/* 0x000030e9 */ { 1, { 0x000030e9 } },
	/* 0x000030ea */ { 1, { 0x000030ea } },
	/* 0x000030eb */ { 1, { 0x000030eb } },
	/* 0x000030ec */ { 1, { 0x000030ec } },
	/* 0x000030ed */ { 1, { 0x000030ed } },
	/* 0x000030ee */ { 1, { 0x000030ee } },
	/* 0x000030ef */ { 1, { 0x000030ef } },
	/* 0x000030f0 */ { 1, { 0x000030f0 } },
	/* 0x000030f1 */ { 1, { 0x000030f1 } },
	/* 0x000030f2 */ { 1, { 0x000030f2 } },
	/* 0x000030f3 */ { 1, { 0x000030f3 } },
	/* 0x000030f4 */ { 2, { 0x000030a6, 0x00003099 } },
	/* 0x000030f5 */ { 1, { 0x000030f5 } },
	/* 0x000030f6 */ { 1, { 0x000030f6 } },
	/* 0x000030f7 */ { 2, { 0x000030ef, 0x00003099 } },
	/* 0x000030f8 */ { 2, { 0x000030f0, 0x00003099 } },
	/* 0x000030f9 */ { 2, { 0x000030f1, 0x00003099 } },
	/* 0x000030fa */ { 2, { 0x000030f2, 0x00003099 } },
	/* 0x000030fb */ { 1, { 0x000030fb } },
	/* 0x000030fc */ { 1, { 0x000030fc } },
	/* 0x000030fd */ { 1, { 0x000030fd } },
	/* 0x000030fe */ { 2, { 0x000030fd, 0x00003099 } },
	/* 0x000030ff */ { 1, { 0x000030ff } }
};

libfshfs_name_decomposition_mapping_t libfshfs_name_decomposition_mappings_0x0000ac00[ 8 ] = {
	/* 0x0000ac00 */ { 2, { 0x00001100, 0x00001161 } },
	/* 0x0000ac01 */ { 1, { 0x0000ac01 } },
	/* 0x0000ac02 */ { 1, { 0x0000ac02 } },
	/* 0x0000ac03 */ { 1, { 0x0000ac03 } },
	/* 0x0000ac04 */ { 1, { 0x0000ac04 } },
	/* 0x0000ac05 */ { 1, { 0x0000ac05 } },
	/* 0x0000ac06 */ { 1, { 0x0000ac06 } },
	/* 0x0000ac07 */ { 1, { 0x0000ac07 } },
};

libfshfs_name_decomposition_mapping_t libfshfs_name_decomposition_mappings_0x0000d7a0[ 8 ] = {
	/* 0x0000d7a0 */ { 1, { 0x0000d7a0 } },
	/* 0x0000d7a1 */ { 1, { 0x0000d7a1 } },
	/* 0x0000d7a2 */ { 1, { 0x0000d7a2 } },
	/* 0x0000d7a3 */ { 3, { 0x00001112, 0x00001175, 0x000011c2 } },
	/* 0x0000d7a4 */ { 1, { 0x0000d7a4 } },
	/* 0x0000d7a5 */ { 1, { 0x0000d7a5 } },
	/* 0x0000d7a6 */ { 1, { 0x0000d7a6 } },
	/* 0x0000d7a7 */ { 1, { 0x0000d7a7 } },
};

libfshfs_name_decomposition_mapping_t libfshfs_name_decomposition_mappings_0x0000fb18[ 56 ] = {
	/* 0x0000fb18 */ { 1, { 0x0000fb18 } },
	/* 0x0000fb19 */ { 1, { 0x0000fb19 } },
	/* 0x0000fb1a */ { 1, { 0x0000fb1a } },
	/* 0x0000fb1b */ { 1, { 0x0000fb1b } },
	/* 0x0000fb1c */ { 1, { 0x0000fb1c } },
	/* 0x0000fb1d */ { 2, { 0x000005d9, 0x000005b4 } },
	/* 0x0000fb1e */ { 1, { 0x0000fb1e } },
	/* 0x0000fb1f */ { 2, { 0x000005f2, 0x000005b7 } },
	/* 0x0000fb20 */ { 1, { 0x0000fb20 } },
	/* 0x0000fb21 */ { 1, { 0x0000fb21 } },
	/* 0x0000fb22 */ { 1, { 0x0000fb22 } },
	/* 0x0000fb23 */ { 1, { 0x0000fb23 } },
	/* 0x0000fb24 */ { 1, { 0x0000fb24 } },
	/* 0x0000fb25 */ { 1, { 0x0000fb25 } },
	/* 0x0000fb26 */ { 1, { 0x0000fb26 } },
	/* 0x0000fb27 */ { 1, { 0x0000fb27 } },
	/* 0x0000fb28 */ { 1, { 0x0000fb28 } },
	/* 0x0000fb29 */ { 1, { 0x0000fb29 } },
	/* 0x0000fb2a */ { 2, { 0x000005e9, 0x000005c1 } },
	/* 0x0000fb2b */ { 2, { 0x000005e9, 0x000005c2 } },
	/* 0x0000fb2c */ { 3, { 0x000005e9, 0x000005bc, 0x000005c1 } },
	/* 0x0000fb2d */ { 3, { 0x000005e9, 0x000005bc, 0x000005c2 } },
	/* 0x0000fb2e */ { 2, { 0x000005d0, 0x000005b7 } },
	/* 0x0000fb2f */ { 2, { 0x000005d0, 0x000005b8 } },
	/* 0x0000fb30 */ { 2, { 0x000005d0, 0x000005bc } },
	/* 0x0000fb31 */ { 2, { 0x000005d1, 0x000005bc } },
	/* 0x0000fb32 */ { 2, { 0x000005d2, 0x000005bc } },
	/* 0x0000fb33 */ { 2, { 0x000005d3, 0x000005bc } },
	/* 0x0000fb34 */ { 2, { 0x000005d4, 0x000005bc } },
	/* 0x0000fb35 */ { 2, { 0x000005d5, 0x000005bc } },
	/* 0x0000fb36 */ { 2, { 0x000005d6, 0x000005bc } },
	/* 0x0000fb37 */ { 1, { 0x0000fb37 } },
	/* 0x0000fb38 */ { 2, { 0x000005d8, 0x000005bc } },
	/* 0x0000fb39 */ { 2, { 0x000005d9, 0x000005bc } },
	/* 0x0000fb3a */ { 2, { 0x000005da, 0x000005bc } },
	/* 0x0000fb3b */ { 2, { 0x000005db, 0x000005bc } },
	/* 0x0000fb3c */ { 2, { 0x000005dc, 0x000005bc } },
	/* 0x0000fb3d */ { 1, { 0x0000fb3d } },
	/* 0x0000fb3e */ { 2, { 0x000005de, 0x000005bc } },
	/* 0x0000fb3f */ { 1, { 0x0000fb3f } },
	/* 0x0000fb40 */ { 2, { 0x000005e0, 0x000005bc } },
	/* 0x0000fb41 */ { 2, { 0x000005e1, 0x000005bc } },
	/* 0x0000fb42 */ { 1, { 0x0000fb42 } },
	/* 0x0000fb43 */ { 2, { 0x000005e3, 0x000005bc } },
	/* 0x0000fb44 */ { 2, { 0x000005e4, 0x000005bc } },
	/* 0x0000fb45 */ { 1, { 0x0000fb45 } },
	/* 0x0000fb46 */ { 2, { 0x000005e6, 0x000005bc } },
	/* 0x0000fb47 */ { 2, { 0x000005e7, 0x000005bc } },
	/* 0x0000fb48 */ { 2, { 0x000005e8, 0x000005bc } },
	/* 0x0000fb49 */ { 2, { 0x000005e9, 0x000005bc } },
	/* 0x0000fb4a */ { 2, { 0x000005ea, 0x000005bc } },
	/* 0x0000fb4b */ { 2, { 0x000005d5, 0x000005b9 } },
	/* 0x0000fb4c */ { 2, { 0x000005d1, 0x000005bf } },
	/* 0x0000fb4d */ { 2, { 0x000005db, 0x000005bf } },
	/* 0x0000fb4e */ { 2, { 0x000005e4, 0x000005bf } },
	/* 0x0000fb4f */ { 1, { 0x0000fb4f } }
};

/* Determines the size of an UTF-8 string from an UTF-16 big-endian encoded file entry name
 * Returns 1 if successful or -1 on error
 */
int libfshfs_name_get_utf8_string_size(
     const uint8_t *name,
     size_t name_size,
     size_t *utf8_string_size,
     libcerror_error_t **error )
{
	static char *function                        = "libfshfs_name_get_utf8_string_size";
	libuna_unicode_character_t unicode_character = 0;
	size_t name_index                            = 0;

	if( name == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid UTF-16 encoded name.",
		 function );

		return( -1 );
	}
	if( name_size > (size_t) SSIZE_MAX )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_EXCEEDS_MAXIMUM,
		 "%s: invalid UTF-16 encoded name size value exceeds maximum.",
		 function );

		return( -1 );
	}
	if( ( name_size % 2 ) != 0 )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_TOO_SMALL,
		 "%s: missing UTF-16 encoded name value.",
		 function );

		return( -1 );
	}
	if( utf8_string_size == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid UTF-8 string size.",
		 function );

		return( -1 );
	}
	*utf8_string_size = 1;

	if( name_size == 0 )
	{
		return( 1 );
	}
	while( ( name_index + 1 ) < name_size )
	{
		/* Convert the UTF-16 stream bytes into an Unicode character
		 */
		if( libuna_unicode_character_copy_from_utf16_stream(
		     &unicode_character,
		     name,
		     name_size,
		     &name_index,
		     LIBUNA_ENDIAN_BIG,
		     error ) != 1 )
		{
			libcerror_error_set(
			 error,
			 LIBCERROR_ERROR_DOMAIN_CONVERSION,
			 LIBCERROR_CONVERSION_ERROR_INPUT_FAILED,
			 "%s: unable to copy Unicode character from UTF-16 encoded name.",
			 function );

			return( -1 );
		}
		/* ':' is stored as '/'
		 */
		if( unicode_character == (libuna_unicode_character_t) '/' )
		{
			unicode_character = (libuna_unicode_character_t) ':';
		}
		/* U+2400 is stored as U+0
		 */
		else if( unicode_character == (libuna_unicode_character_t) 0x00000000UL )
		{
			unicode_character = (libuna_unicode_character_t) 0x00002400UL;
		}
		/* Determine how many UTF-8 character bytes are required
		 */
		if( libuna_unicode_character_size_to_utf8(
		     unicode_character,
		     utf8_string_size,
		     error ) != 1 )
		{
			libcerror_error_set(
			 error,
			 LIBCERROR_ERROR_DOMAIN_CONVERSION,
			 LIBCERROR_CONVERSION_ERROR_INPUT_FAILED,
			 "%s: unable to unable to determine size of Unicode character in UTF-8.",
			 function );

			return( -1 );
		}
	}
	return( 1 );
}

/* Copies an UTF-8 string from an UTF-16 big-endian encoded file entry name
 * Returns 1 if successful or -1 on error
 */
int libfshfs_name_get_utf8_string(
     const uint8_t *name,
     size_t name_size,
     libuna_utf8_character_t *utf8_string,
     size_t utf8_string_size,
     libcerror_error_t **error )
{
	static char *function                        = "libfshfs_name_get_utf8_string";
	libuna_unicode_character_t unicode_character = 0;
	size_t name_index                            = 0;
	size_t utf8_string_index                     = 0;

	if( name == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid UTF-16 encoded name.",
		 function );

		return( -1 );
	}
	if( name_size > (size_t) SSIZE_MAX )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_EXCEEDS_MAXIMUM,
		 "%s: invalid UTF-16 encoded name size value exceeds maximum.",
		 function );

		return( -1 );
	}
	if( ( name_size == 0 )
	 || ( ( name_size % 2 ) != 0 ) )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_TOO_SMALL,
		 "%s: missing UTF-16 encoded name value.",
		 function );

		return( -1 );
	}
	if( utf8_string == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid UTF-8 string.",
		 function );

		return( -1 );
	}
	if( utf8_string_size > (size_t) SSIZE_MAX )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_EXCEEDS_MAXIMUM,
		 "%s: invalid UTF-8 string size value exceeds maximum.",
		 function );

		return( -1 );
	}
	while( ( name_index + 1 ) < name_size )
	{
		/* Convert the UTF-16 stream bytes into an Unicode character
		 */
		if( libuna_unicode_character_copy_from_utf16_stream(
		     &unicode_character,
		     name,
		     name_size,
		     &name_index,
		     LIBUNA_ENDIAN_BIG,
		     error ) != 1 )
		{
			libcerror_error_set(
			 error,
			 LIBCERROR_ERROR_DOMAIN_CONVERSION,
			 LIBCERROR_CONVERSION_ERROR_INPUT_FAILED,
			 "%s: unable to copy Unicode character from UTF-16 encoded name.",
			 function );

			return( -1 );
		}
		/* ':' is stored as '/'
		 */
		if( unicode_character == (libuna_unicode_character_t) '/' )
		{
			unicode_character = (libuna_unicode_character_t) ':';
		}
		/* U+2400 is stored as U+0
		 */
		else if( unicode_character == (libuna_unicode_character_t) 0x00000000UL )
		{
			unicode_character = (libuna_unicode_character_t) 0x00002400UL;
		}
		/* Convert the Unicode character into UTF-8 character bytes
		 */
		if( libuna_unicode_character_copy_to_utf8(
		     unicode_character,
		     utf8_string,
		     utf8_string_size,
		     &utf8_string_index,
		     error ) != 1 )
		{
			libcerror_error_set(
			 error,
			 LIBCERROR_ERROR_DOMAIN_CONVERSION,
			 LIBCERROR_CONVERSION_ERROR_OUTPUT_FAILED,
			 "%s: unable to copy Unicode character to UTF-8.",
			 function );

			return( -1 );
		}
	}
	/* Check if the string is terminated with an end-of-string character
	 */
	if( utf8_string_index >= utf8_string_size )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_TOO_SMALL,
		 "%s: UTF-8 string too small.",
		 function );

		return( -1 );
	}
	utf8_string[ utf8_string_index ] = 0;

	return( 1 );
}

/* Compares an UTF-8 string with an UTF-16 big-endian encoded file entry name
 * Returns LIBUNA_COMPARE_LESS, LIBUNA_COMPARE_EQUAL, LIBUNA_COMPARE_GREATER if successful or -1 on error
 */
int libfshfs_name_compare_with_utf8_string(
     const uint8_t *name,
     size_t name_size,
     const libuna_utf8_character_t *utf8_string,
     size_t utf8_string_length,
     uint8_t use_case_folding,
     libcerror_error_t **error )
{
	libfshfs_name_decomposition_mapping_t utf8_single_nfd_mapping = { 1, { 0 } };

	libfshfs_name_decomposition_mapping_t *utf8_nfd_mapping       = NULL;
	static char *function                                         = "libfshfs_name_compare_with_utf8_string";
	libuna_unicode_character_t name_unicode_character             = 0;
	libuna_unicode_character_t utf8_unicode_character             = 0;
	size_t name_index                                             = 0;
	size_t utf8_string_index                                      = 0;
	uint8_t nfd_character_index                                   = 0;

	if( name == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid UTF-16 encoded name.",
		 function );

		return( -1 );
	}
	if( name_size > (size_t) SSIZE_MAX )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_EXCEEDS_MAXIMUM,
		 "%s: invalid UTF-16 encoded name size value exceeds maximum.",
		 function );

		return( -1 );
	}
	if( name_size == 0 )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_ZERO_OR_LESS,
		 "%s: missing UTF-16 encoded name value.",
		 function );

		return( -1 );
	}
	if( utf8_string == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid UTF-8 string.",
		 function );

		return( -1 );
	}
	if( utf8_string_length > (size_t) SSIZE_MAX )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_EXCEEDS_MAXIMUM,
		 "%s: invalid UTF-8 string length value exceeds maximum.",
		 function );

		return( -1 );
	}
	if( ( utf8_string_length >= 1 )
	 && ( utf8_string[ utf8_string_length - 1 ] == 0 ) )
	{
		utf8_string_length -= 1;
	}
	while( ( name_index < name_size )
	    && ( utf8_string_index < utf8_string_length ) )
	{
		if( libuna_unicode_character_copy_from_utf8(
		     &utf8_unicode_character,
		     utf8_string,
		     utf8_string_length,
		     &utf8_string_index,
		     error ) != 1 )
		{
			libcerror_error_set(
			 error,
			 LIBCERROR_ERROR_DOMAIN_CONVERSION,
			 LIBCERROR_CONVERSION_ERROR_OUTPUT_FAILED,
			 "%s: unable to copy Unicode character from UTF-8 string.",
			 function );

			return( -1 );
		}
		libfshfs_name_get_decomposition_mapping(
		 utf8_unicode_character,
		 utf8_nfd_mapping,
		 utf8_single_nfd_mapping );

		for( nfd_character_index = 0;
		     nfd_character_index < utf8_nfd_mapping->number_of_characters;
		     nfd_character_index++ )
		{
			if( libuna_unicode_character_copy_from_utf16_stream(
			     &name_unicode_character,
			     name,
			     name_size,
			     &name_index,
			     LIBUNA_ENDIAN_BIG,
			     error ) != 1 )
			{
				libcerror_error_set(
				 error,
				 LIBCERROR_ERROR_DOMAIN_CONVERSION,
				 LIBCERROR_CONVERSION_ERROR_INPUT_FAILED,
				 "%s: unable to copy Unicode character from UTF-16 big-endian encoded name.",
				 function );

				return( -1 );
			}
			/* ':' is stored as '/'
			 */
			if( name_unicode_character == (libuna_unicode_character_t) '/' )
			{
				name_unicode_character = (libuna_unicode_character_t) ':';
			}
			/* U+2400 is stored as U+0
			 */
			else if( name_unicode_character == (libuna_unicode_character_t) 0x00000000UL )
			{
				name_unicode_character = (libuna_unicode_character_t) 0x00002400UL;
			}
			else if( use_case_folding != 0 )
			{
				libfshfs_name_get_case_folding_mapping(
				 name_unicode_character );
			}
			utf8_unicode_character = utf8_nfd_mapping->characters[ nfd_character_index ];

			if( use_case_folding != 0 )
			{
				libfshfs_name_get_case_folding_mapping(
				 utf8_unicode_character );
			}
			if( utf8_unicode_character < name_unicode_character )
			{
				return( LIBUNA_COMPARE_LESS );
			}
			else if( utf8_unicode_character > name_unicode_character )
			{
				return( LIBUNA_COMPARE_GREATER );
			}
			if( name_index >= name_size )
			{
				break;
			}
		}
	}
	if( utf8_string_index < utf8_string_length )
	{
		return( LIBUNA_COMPARE_GREATER );
	}
	else if( name_index < name_size )
	{
		return( LIBUNA_COMPARE_LESS );
	}
	return( LIBUNA_COMPARE_EQUAL );
}

/* Determines the size of an UTF-16 string from an UTF-16 big-endian encoded file entry name
 * Returns 1 if successful or -1 on error
 */
int libfshfs_name_get_utf16_string_size(
     const uint8_t *name,
     size_t name_size,
     size_t *utf16_string_size,
     libcerror_error_t **error )
{
	static char *function                        = "libfshfs_name_get_utf16_string_size";
	libuna_unicode_character_t unicode_character = 0;
	size_t name_index                            = 0;

	if( name == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid UTF-16 encoded name.",
		 function );

		return( -1 );
	}
	if( name_size > (size_t) SSIZE_MAX )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_EXCEEDS_MAXIMUM,
		 "%s: invalid UTF-16 encoded name size value exceeds maximum.",
		 function );

		return( -1 );
	}
	if( ( name_size % 2 ) != 0 )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_TOO_SMALL,
		 "%s: missing UTF-16 encoded name value.",
		 function );

		return( -1 );
	}
	if( utf16_string_size == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid UTF-16 string size.",
		 function );

		return( -1 );
	}
	*utf16_string_size = 1;

	if( name_size == 0 )
	{
		return( 1 );
	}
	while( ( name_index + 1 ) < name_size )
	{
		/* Convert the UTF-16 stream bytes into an Unicode character
		 */
		if( libuna_unicode_character_copy_from_utf16_stream(
		     &unicode_character,
		     name,
		     name_size,
		     &name_index,
		     LIBUNA_ENDIAN_BIG,
		     error ) != 1 )
		{
			libcerror_error_set(
			 error,
			 LIBCERROR_ERROR_DOMAIN_CONVERSION,
			 LIBCERROR_CONVERSION_ERROR_INPUT_FAILED,
			 "%s: unable to copy Unicode character from UTF-16 encoded name.",
			 function );

			return( -1 );
		}
		/* ':' is stored as '/'
		 */
		if( unicode_character == (libuna_unicode_character_t) '/' )
		{
			unicode_character = (libuna_unicode_character_t) ':';
		}
		/* U+2400 is stored as U+0
		 */
		else if( unicode_character == (libuna_unicode_character_t) 0x00000000UL )
		{
			unicode_character = (libuna_unicode_character_t) 0x00002400UL;
		}
		/* Determine how many UTF-16 character bytes are required
		 */
		if( libuna_unicode_character_size_to_utf16(
		     unicode_character,
		     utf16_string_size,
		     error ) != 1 )
		{
			libcerror_error_set(
			 error,
			 LIBCERROR_ERROR_DOMAIN_CONVERSION,
			 LIBCERROR_CONVERSION_ERROR_INPUT_FAILED,
			 "%s: unable to unable to determine size of Unicode character in UTF-16.",
			 function );

			return( -1 );
		}
	}
	return( 1 );
}

/* Copies an UTF-16 string from an UTF-16 big-endian encoded file entry name
 * Returns 1 if successful or -1 on error
 */
int libfshfs_name_get_utf16_string(
     const uint8_t *name,
     size_t name_size,
     libuna_utf16_character_t *utf16_string,
     size_t utf16_string_size,
     libcerror_error_t **error )
{
	static char *function                        = "libfshfs_name_get_utf16_string";
	libuna_unicode_character_t unicode_character = 0;
	size_t name_index                            = 0;
	size_t utf16_string_index                    = 0;

	if( name == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid UTF-16 encoded name.",
		 function );

		return( -1 );
	}
	if( name_size > (size_t) SSIZE_MAX )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_EXCEEDS_MAXIMUM,
		 "%s: invalid UTF-16 encoded name size value exceeds maximum.",
		 function );

		return( -1 );
	}
	if( ( name_size == 0 )
	 || ( ( name_size % 2 ) != 0 ) )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_TOO_SMALL,
		 "%s: missing UTF-16 encoded name value.",
		 function );

		return( -1 );
	}
	if( utf16_string == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid UTF-16 string.",
		 function );

		return( -1 );
	}
	if( utf16_string_size > (size_t) SSIZE_MAX )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_EXCEEDS_MAXIMUM,
		 "%s: invalid UTF-16 string size value exceeds maximum.",
		 function );

		return( -1 );
	}
	while( ( name_index + 1 ) < name_size )
	{
		/* Convert the UTF-16 stream bytes into an Unicode character
		 */
		if( libuna_unicode_character_copy_from_utf16_stream(
		     &unicode_character,
		     name,
		     name_size,
		     &name_index,
		     LIBUNA_ENDIAN_BIG,
		     error ) != 1 )
		{
			libcerror_error_set(
			 error,
			 LIBCERROR_ERROR_DOMAIN_CONVERSION,
			 LIBCERROR_CONVERSION_ERROR_INPUT_FAILED,
			 "%s: unable to copy Unicode character from UTF-16 encoded name.",
			 function );

			return( -1 );
		}
		/* ':' is stored as '/'
		 */
		if( unicode_character == (libuna_unicode_character_t) '/' )
		{
			unicode_character = (libuna_unicode_character_t) ':';
		}
		/* U+2400 is stored as U+0
		 */
		else if( unicode_character == (libuna_unicode_character_t) 0x00000000UL )
		{
			unicode_character = (libuna_unicode_character_t) 0x00002400UL;
		}
		/* Convert the Unicode character into UTF-16 character bytes
		 */
		if( libuna_unicode_character_copy_to_utf16(
		     unicode_character,
		     utf16_string,
		     utf16_string_size,
		     &utf16_string_index,
		     error ) != 1 )
		{
			libcerror_error_set(
			 error,
			 LIBCERROR_ERROR_DOMAIN_CONVERSION,
			 LIBCERROR_CONVERSION_ERROR_OUTPUT_FAILED,
			 "%s: unable to copy Unicode character to UTF-16.",
			 function );

			return( -1 );
		}
	}
	if( utf16_string_index >= utf16_string_size )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_TOO_SMALL,
		 "%s: UTF-16 string too small.",
		 function );

		return( -1 );
	}
	utf16_string[ utf16_string_index ] = 0;

	return( 1 );
}

/* Compares an UTF-16 string with an UTF-16 big-endian encoded file entry name
 * Returns LIBUNA_COMPARE_LESS, LIBUNA_COMPARE_EQUAL, LIBUNA_COMPARE_GREATER if successful or -1 on error
 */
int libfshfs_name_compare_with_utf16_string(
     const uint8_t *name,
     size_t name_size,
     const libuna_utf16_character_t *utf16_string,
     size_t utf16_string_length,
     uint8_t use_case_folding,
     libcerror_error_t **error )
{
	libfshfs_name_decomposition_mapping_t utf16_single_nfd_mapping = { 1, { 0 } };

	libfshfs_name_decomposition_mapping_t *utf16_nfd_mapping       = NULL;
	static char *function                                          = "libfshfs_name_compare_with_utf16_string";
	libuna_unicode_character_t name_unicode_character              = 0;
	libuna_unicode_character_t utf16_unicode_character             = 0;
	size_t name_index                                              = 0;
	size_t utf16_string_index                                      = 0;
	uint16_t nfd_character_index                                   = 0;

	if( name == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid UTF-16 encoded name.",
		 function );

		return( -1 );
	}
	if( name_size > (size_t) SSIZE_MAX )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_EXCEEDS_MAXIMUM,
		 "%s: invalid UTF-16 encoded name size value exceeds maximum.",
		 function );

		return( -1 );
	}
	if( name_size == 0 )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_ZERO_OR_LESS,
		 "%s: missing UTF-16 encoded name value.",
		 function );

		return( -1 );
	}
	if( utf16_string == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid UTF-16 string.",
		 function );

		return( -1 );
	}
	if( utf16_string_length > (size_t) SSIZE_MAX )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_EXCEEDS_MAXIMUM,
		 "%s: invalid UTF-16 string length value exceeds maximum.",
		 function );

		return( -1 );
	}
	if( ( utf16_string_length >= 1 )
	 && ( utf16_string[ utf16_string_length - 1 ] == 0 ) )
	{
		utf16_string_length -= 1;
	}
	while( ( name_index < name_size )
	    && ( utf16_string_index < utf16_string_length ) )
	{
		if( libuna_unicode_character_copy_from_utf16(
		     &utf16_unicode_character,
		     utf16_string,
		     utf16_string_length,
		     &utf16_string_index,
		     error ) != 1 )
		{
			libcerror_error_set(
			 error,
			 LIBCERROR_ERROR_DOMAIN_CONVERSION,
			 LIBCERROR_CONVERSION_ERROR_OUTPUT_FAILED,
			 "%s: unable to copy Unicode character from UTF-16 string.",
			 function );

			return( -1 );
		}
		libfshfs_name_get_decomposition_mapping(
		 utf16_unicode_character,
		 utf16_nfd_mapping,
		 utf16_single_nfd_mapping );

		for( nfd_character_index = 0;
		     nfd_character_index < utf16_nfd_mapping->number_of_characters;
		     nfd_character_index++ )
		{
			if( libuna_unicode_character_copy_from_utf16_stream(
			     &name_unicode_character,
			     name,
			     name_size,
			     &name_index,
			     LIBUNA_ENDIAN_BIG,
			     error ) != 1 )
			{
				libcerror_error_set(
				 error,
				 LIBCERROR_ERROR_DOMAIN_CONVERSION,
				 LIBCERROR_CONVERSION_ERROR_INPUT_FAILED,
				 "%s: unable to copy Unicode character from UTF-16 big-endian encoded name.",
				 function );

				return( -1 );
			}
			/* ':' is stored as '/'
			 */
			if( name_unicode_character == (libuna_unicode_character_t) '/' )
			{
				name_unicode_character = (libuna_unicode_character_t) ':';
			}
			/* U+2400 is stored as U+0
			 */
			else if( name_unicode_character == (libuna_unicode_character_t) 0x00000000UL )
			{
				name_unicode_character = (libuna_unicode_character_t) 0x00002400UL;
			}
			else if( use_case_folding != 0 )
			{
				libfshfs_name_get_case_folding_mapping(
				 name_unicode_character );
			}
			utf16_unicode_character = utf16_nfd_mapping->characters[ nfd_character_index ];

			if( use_case_folding != 0 )
			{
				libfshfs_name_get_case_folding_mapping(
				 utf16_unicode_character );
			}
			if( utf16_unicode_character < name_unicode_character )
			{
				return( LIBUNA_COMPARE_LESS );
			}
			else if( utf16_unicode_character > name_unicode_character )
			{
				return( LIBUNA_COMPARE_GREATER );
			}
			if( name_index >= name_size )
			{
				break;
			}
		}
	}
	if( utf16_string_index < utf16_string_length )
	{
		return( LIBUNA_COMPARE_GREATER );
	}
	else if( name_index < name_size )
	{
		return( LIBUNA_COMPARE_LESS );
	}
	return( LIBUNA_COMPARE_EQUAL );
}

