/*
 * Codepage definitions for libfshfs
 *
 * Copyright (C) 2009-2021, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBFSHFS_CODEPAGE_H )
#define _LIBFSHFS_CODEPAGE_H

#include <libfshfs/types.h>

#if defined( __cplusplus )
extern "C" {
#endif

/* The codepage definitions
 */
enum LIBFSHFS_CODEPAGES
{
	LIBFSHFS_CODEPAGE_ASCII				= 20127,

	LIBFSHFS_CODEPAGE_ISO_8859_1			= 28591,
	LIBFSHFS_CODEPAGE_ISO_8859_2			= 28592,
	LIBFSHFS_CODEPAGE_ISO_8859_3			= 28593,
	LIBFSHFS_CODEPAGE_ISO_8859_4			= 28594,
	LIBFSHFS_CODEPAGE_ISO_8859_5			= 28595,
	LIBFSHFS_CODEPAGE_ISO_8859_6			= 28596,
	LIBFSHFS_CODEPAGE_ISO_8859_7			= 28597,
	LIBFSHFS_CODEPAGE_ISO_8859_8			= 28598,
	LIBFSHFS_CODEPAGE_ISO_8859_9			= 28599,
	LIBFSHFS_CODEPAGE_ISO_8859_10			= 28600,
	LIBFSHFS_CODEPAGE_ISO_8859_11			= 28601,
	LIBFSHFS_CODEPAGE_ISO_8859_13			= 28603,
	LIBFSHFS_CODEPAGE_ISO_8859_14			= 28604,
	LIBFSHFS_CODEPAGE_ISO_8859_15			= 28605,
	LIBFSHFS_CODEPAGE_ISO_8859_16			= 28606,

	LIBFSHFS_CODEPAGE_KOI8_R			= 20866,
	LIBFSHFS_CODEPAGE_KOI8_U			= 21866,

	LIBFSHFS_CODEPAGE_WINDOWS_874			= 874,
	LIBFSHFS_CODEPAGE_WINDOWS_932			= 932,
	LIBFSHFS_CODEPAGE_WINDOWS_936			= 936,
	LIBFSHFS_CODEPAGE_WINDOWS_949			= 949,
	LIBFSHFS_CODEPAGE_WINDOWS_950			= 950,
	LIBFSHFS_CODEPAGE_WINDOWS_1250			= 1250,
	LIBFSHFS_CODEPAGE_WINDOWS_1251			= 1251,
	LIBFSHFS_CODEPAGE_WINDOWS_1252			= 1252,
	LIBFSHFS_CODEPAGE_WINDOWS_1253			= 1253,
	LIBFSHFS_CODEPAGE_WINDOWS_1254			= 1254,
	LIBFSHFS_CODEPAGE_WINDOWS_1255			= 1255,
	LIBFSHFS_CODEPAGE_WINDOWS_1256			= 1256,
	LIBFSHFS_CODEPAGE_WINDOWS_1257			= 1257,
	LIBFSHFS_CODEPAGE_WINDOWS_1258			= 1258
};

#define LIBFSHFS_CODEPAGE_US_ASCII			LIBFSHFS_CODEPAGE_ASCII

#define LIBFSHFS_CODEPAGE_ISO_WESTERN_EUROPEAN		LIBFSHFS_CODEPAGE_ISO_8859_1
#define LIBFSHFS_CODEPAGE_ISO_CENTRAL_EUROPEAN		LIBFSHFS_CODEPAGE_ISO_8859_2
#define LIBFSHFS_CODEPAGE_ISO_SOUTH_EUROPEAN		LIBFSHFS_CODEPAGE_ISO_8859_3
#define LIBFSHFS_CODEPAGE_ISO_NORTH_EUROPEAN		LIBFSHFS_CODEPAGE_ISO_8859_4
#define LIBFSHFS_CODEPAGE_ISO_CYRILLIC			LIBFSHFS_CODEPAGE_ISO_8859_5
#define LIBFSHFS_CODEPAGE_ISO_ARABIC			LIBFSHFS_CODEPAGE_ISO_8859_6
#define LIBFSHFS_CODEPAGE_ISO_GREEK			LIBFSHFS_CODEPAGE_ISO_8859_7
#define LIBFSHFS_CODEPAGE_ISO_HEBREW			LIBFSHFS_CODEPAGE_ISO_8859_8
#define LIBFSHFS_CODEPAGE_ISO_TURKISH			LIBFSHFS_CODEPAGE_ISO_8859_9
#define LIBFSHFS_CODEPAGE_ISO_NORDIC			LIBFSHFS_CODEPAGE_ISO_8859_10
#define LIBFSHFS_CODEPAGE_ISO_THAI			LIBFSHFS_CODEPAGE_ISO_8859_11
#define LIBFSHFS_CODEPAGE_ISO_BALTIC			LIBFSHFS_CODEPAGE_ISO_8859_13
#define LIBFSHFS_CODEPAGE_ISO_CELTIC			LIBFSHFS_CODEPAGE_ISO_8859_14

#define LIBFSHFS_CODEPAGE_ISO_LATIN_1			LIBFSHFS_CODEPAGE_ISO_8859_1
#define LIBFSHFS_CODEPAGE_ISO_LATIN_2			LIBFSHFS_CODEPAGE_ISO_8859_2
#define LIBFSHFS_CODEPAGE_ISO_LATIN_3			LIBFSHFS_CODEPAGE_ISO_8859_3
#define LIBFSHFS_CODEPAGE_ISO_LATIN_4			LIBFSHFS_CODEPAGE_ISO_8859_4
#define LIBFSHFS_CODEPAGE_ISO_LATIN_5			LIBFSHFS_CODEPAGE_ISO_8859_9
#define LIBFSHFS_CODEPAGE_ISO_LATIN_6			LIBFSHFS_CODEPAGE_ISO_8859_10
#define LIBFSHFS_CODEPAGE_ISO_LATIN_7			LIBFSHFS_CODEPAGE_ISO_8859_13
#define LIBFSHFS_CODEPAGE_ISO_LATIN_8			LIBFSHFS_CODEPAGE_ISO_8859_14
#define LIBFSHFS_CODEPAGE_ISO_LATIN_9			LIBFSHFS_CODEPAGE_ISO_8859_15
#define LIBFSHFS_CODEPAGE_ISO_LATIN_10			LIBFSHFS_CODEPAGE_ISO_8859_16

#define LIBFSHFS_CODEPAGE_KOI8_RUSSIAN			LIBFSHFS_CODEPAGE_KOI8_R
#define LIBFSHFS_CODEPAGE_KOI8_UKRAINIAN		LIBFSHFS_CODEPAGE_KOI8_U

#define LIBFSHFS_CODEPAGE_WINDOWS_THAI			LIBFSHFS_CODEPAGE_WINDOWS_874
#define LIBFSHFS_CODEPAGE_WINDOWS_JAPANESE		LIBFSHFS_CODEPAGE_WINDOWS_932
#define LIBFSHFS_CODEPAGE_WINDOWS_CHINESE_SIMPLIFIED	LIBFSHFS_CODEPAGE_WINDOWS_936
#define LIBFSHFS_CODEPAGE_WINDOWS_KOREAN		LIBFSHFS_CODEPAGE_WINDOWS_949
#define LIBFSHFS_CODEPAGE_WINDOWS_CHINESE_TRADITIONAL	LIBFSHFS_CODEPAGE_WINDOWS_950
#define LIBFSHFS_CODEPAGE_WINDOWS_CENTRAL_EUROPEAN	LIBFSHFS_CODEPAGE_WINDOWS_1250
#define LIBFSHFS_CODEPAGE_WINDOWS_CYRILLIC		LIBFSHFS_CODEPAGE_WINDOWS_1251
#define LIBFSHFS_CODEPAGE_WINDOWS_WESTERN_EUROPEAN	LIBFSHFS_CODEPAGE_WINDOWS_1252
#define LIBFSHFS_CODEPAGE_WINDOWS_GREEK			LIBFSHFS_CODEPAGE_WINDOWS_1253
#define LIBFSHFS_CODEPAGE_WINDOWS_TURKISH		LIBFSHFS_CODEPAGE_WINDOWS_1254
#define LIBFSHFS_CODEPAGE_WINDOWS_HEBREW		LIBFSHFS_CODEPAGE_WINDOWS_1255
#define LIBFSHFS_CODEPAGE_WINDOWS_ARABIC		LIBFSHFS_CODEPAGE_WINDOWS_1256
#define LIBFSHFS_CODEPAGE_WINDOWS_BALTIC		LIBFSHFS_CODEPAGE_WINDOWS_1257
#define LIBFSHFS_CODEPAGE_WINDOWS_VIETNAMESE		LIBFSHFS_CODEPAGE_WINDOWS_1258

#if defined( __cplusplus )
}
#endif

#endif /* !defined( _LIBFSHFS_CODEPAGE_H ) */

