/*
 * The internal definitions
 *
 * Copyright (C) 2011-2022, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( LIBFUSN_INTERNAL_DEFINITIONS_H )
#define LIBFUSN_INTERNAL_DEFINITIONS_H

#include <common.h>
#include <types.h>

/* Define HAVE_LOCAL_LIBFUSN for local use of libfusn
 */
#if !defined( HAVE_LOCAL_LIBFUSN )
#include <libfusn/definitions.h>

/* The definitions in <libfusn/definitions.h> are copied here
 * for local use of libfusn
 */
#else
#include <byte_stream.h>

#define LIBFUSN_VERSION						20220119

/* The version string
 */
#define LIBFUSN_VERSION_STRING					"20220119"

/* The byte order definitions
 */
#define LIBFUSN_ENDIAN_BIG					_BYTE_STREAM_ENDIAN_BIG
#define LIBFUSN_ENDIAN_LITTLE					_BYTE_STREAM_ENDIAN_LITTLE

/* The update reason flags
 */
enum LIBFUSN_UPDATE_REASON_FLAGS
{
	LIBFUSN_UPDATE_REASON_FLAG_DATA_OVERWRITE		= 0x00000001UL,
	LIBFUSN_UPDATE_REASON_FLAG_DATA_EXTEND			= 0x00000002UL,
	LIBFUSN_UPDATE_REASON_FLAG_DATA_TRUNCATION		= 0x00000004UL,

	LIBFUSN_UPDATE_REASON_FLAG_NAMED_DATA_OVERWRITE		= 0x00000010UL,
	LIBFUSN_UPDATE_REASON_FLAG_NAMED_DATA_EXTEND		= 0x00000020UL,
	LIBFUSN_UPDATE_REASON_FLAG_NAMED_DATA_TRUNCATION	= 0x00000040UL,

	LIBFUSN_UPDATE_REASON_FLAG_FILE_CREATE			= 0x00000100UL,
	LIBFUSN_UPDATE_REASON_FLAG_FILE_DELETE			= 0x00000200UL,
	LIBFUSN_UPDATE_REASON_FLAG_EXTENDED_ATTRIBUTE_CHANGE	= 0x00000400UL,
	LIBFUSN_UPDATE_REASON_FLAG_SECURITY_CHANGE		= 0x00000800UL,
	LIBFUSN_UPDATE_REASON_FLAG_RENAME_OLD_NAME		= 0x00001000UL,
	LIBFUSN_UPDATE_REASON_FLAG_RENAME_NEW_NAME		= 0x00002000UL,
	LIBFUSN_UPDATE_REASON_FLAG_INDEXABLE_CHANGE		= 0x00004000UL,
	LIBFUSN_UPDATE_REASON_FLAG_BASIC_INFO_CHANGE		= 0x00008000UL,
	LIBFUSN_UPDATE_REASON_FLAG_HARD_LINK_CHANGE		= 0x00010000UL,
	LIBFUSN_UPDATE_REASON_FLAG_COMPRESSION_CHANGE		= 0x00020000UL,
	LIBFUSN_UPDATE_REASON_FLAG_ENCRYPTION_CHANGE		= 0x00040000UL,
	LIBFUSN_UPDATE_REASON_FLAG_OBJECT_IDENTIFIER_CHANGE	= 0x00080000UL,
	LIBFUSN_UPDATE_REASON_FLAG_REPARSE_POINT_CHANGE		= 0x00100000UL,
	LIBFUSN_UPDATE_REASON_FLAG_STREAM_CHANGE		= 0x00200000UL,
	LIBFUSN_UPDATE_REASON_TRANSACTED_CHANGE			= 0x00400000UL,

	LIBFUSN_UPDATE_REASON_FLAG_CLOSE			= 0x80000000UL
};

/* The update reason source flags
 */
enum LIBFUSN_UPDATE_SOURCE_FLAGS
{
	LIBFUSN_UPDATE_SOURCE_FLAG_DATA_MANAGEMENT		= 0x00000001UL,
	LIBFUSN_UPDATE_SOURCE_FLAG_AUXILIARY_DATA		= 0x00000002UL,
	LIBFUSN_UPDATE_SOURCE_FLAG_REPLICATION_MANAGEMENT	= 0x00000004UL
};

/* The file attribute flags
 */
enum LIBFUSN_FILE_ATTRIBUTE_FLAGS
{
	LIBFUSN_FILE_ATTRIBUTE_FLAG_READ_ONLY			= 0x00000001UL,
	LIBFUSN_FILE_ATTRIBUTE_FLAG_HIDDEN			= 0x00000002UL,
	LIBFUSN_FILE_ATTRIBUTE_FLAG_SYSTEM			= 0x00000004UL,

	LIBFUSN_FILE_ATTRIBUTE_FLAG_DIRECTORY			= 0x00000010UL,
	LIBFUSN_FILE_ATTRIBUTE_FLAG_ARCHIVE			= 0x00000020UL,
	LIBFUSN_FILE_ATTRIBUTE_FLAG_DEVICE			= 0x00000040UL,
	LIBFUSN_FILE_ATTRIBUTE_FLAG_NORMAL			= 0x00000080UL,
	LIBFUSN_FILE_ATTRIBUTE_FLAG_TEMPORARY			= 0x00000100UL,
	LIBFUSN_FILE_ATTRIBUTE_FLAG_SPARSE_FILE			= 0x00000200UL,
	LIBFUSN_FILE_ATTRIBUTE_FLAG_REPARSE_POINT		= 0x00000400UL,
	LIBFUSN_FILE_ATTRIBUTE_FLAG_COMPRESSED			= 0x00000800UL,
	LIBFUSN_FILE_ATTRIBUTE_FLAG_OFFLINE			= 0x00001000UL,
	LIBFUSN_FILE_ATTRIBUTE_FLAG_NOT_CONTENT_INDEXED		= 0x00002000UL,
	LIBFUSN_FILE_ATTRIBUTE_FLAG_ENCRYPTED			= 0x00004000UL,

	LIBFUSN_FILE_ATTRIBUTE_FLAG_VIRTUAL			= 0x00010000UL
};

#endif

#endif

