#!/usr/bin/env python
#
# Python-bindings manifest type test script
#
# Copyright (C) 2011-2022, Joachim Metz <joachim.metz@gmail.com>
#
# Refer to AUTHORS for acknowledgements.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

from __future__ import unicode_literals

import unittest

import pyfwevt


class ManifestTypeTests(unittest.TestCase):
  """Tests the manifest type."""

  _TEST_DATA = bytes(bytearray([
	  0x43, 0x52, 0x49, 0x4d, 0x78, 0x02, 0x00, 0x00, 0x05, 0x00, 0x01, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x53, 0xea, 0xa2, 0x06, 0x6c, 0xfc, 0xe5, 0x42,
      0x91, 0x76, 0x18, 0x74, 0x9a, 0xb2, 0xca, 0x13, 0x24, 0x00, 0x00, 0x00,
      0x57, 0x45, 0x56, 0x54, 0x54, 0x02, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00,
      0x0d, 0x00, 0x00, 0x00, 0xbc, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
      0x08, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x02, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x20, 0x02, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
      0x2c, 0x02, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x38, 0x02, 0x00, 0x00,
      0x54, 0x54, 0x42, 0x4c, 0x50, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
      0x54, 0x45, 0x4d, 0x50, 0x44, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
      0x02, 0x00, 0x00, 0x00, 0x58, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
      0x33, 0x12, 0x8a, 0x27, 0x65, 0xf6, 0x52, 0x52, 0x0b, 0xa7, 0x2b, 0xca,
      0x59, 0x74, 0x33, 0xa8, 0x0f, 0x01, 0x01, 0x00, 0x01, 0xff, 0xff, 0xac,
      0x00, 0x00, 0x00, 0x44, 0x82, 0x09, 0x00, 0x45, 0x00, 0x76, 0x00, 0x65,
      0x00, 0x6e, 0x00, 0x74, 0x00, 0x44, 0x00, 0x61, 0x00, 0x74, 0x00, 0x61,
      0x00, 0x00, 0x00, 0x02, 0x41, 0xff, 0xff, 0x41, 0x00, 0x00, 0x00, 0x8a,
      0x6f, 0x04, 0x00, 0x44, 0x00, 0x61, 0x00, 0x74, 0x00, 0x61, 0x00, 0x00,
      0x00, 0x29, 0x00, 0x00, 0x00, 0x06, 0x4b, 0x95, 0x04, 0x00, 0x4e, 0x00,
      0x61, 0x00, 0x6d, 0x00, 0x65, 0x00, 0x00, 0x00, 0x05, 0x01, 0x0b, 0x00,
      0x6d, 0x00, 0x65, 0x00, 0x74, 0x00, 0x72, 0x00, 0x69, 0x00, 0x63, 0x00,
      0x5f, 0x00, 0x6e, 0x00, 0x61, 0x00, 0x6d, 0x00, 0x65, 0x00, 0x02, 0x0d,
      0x00, 0x00, 0x01, 0x04, 0x41, 0xff, 0xff, 0x43, 0x00, 0x00, 0x00, 0x8a,
      0x6f, 0x04, 0x00, 0x44, 0x00, 0x61, 0x00, 0x74, 0x00, 0x61, 0x00, 0x00,
      0x00, 0x2b, 0x00, 0x00, 0x00, 0x06, 0x4b, 0x95, 0x04, 0x00, 0x4e, 0x00,
      0x61, 0x00, 0x6d, 0x00, 0x65, 0x00, 0x00, 0x00, 0x05, 0x01, 0x0c, 0x00,
      0x6d, 0x00, 0x65, 0x00, 0x74, 0x00, 0x72, 0x00, 0x69, 0x00, 0x63, 0x00,
      0x5f, 0x00, 0x76, 0x00, 0x61, 0x00, 0x6c, 0x00, 0x75, 0x00, 0x65, 0x00,
      0x02, 0x0d, 0x01, 0x00, 0x07, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x01, 0x00, 0x00,
      0x1c, 0x00, 0x00, 0x00, 0x6d, 0x00, 0x65, 0x00, 0x74, 0x00, 0x72, 0x00,
      0x69, 0x00, 0x63, 0x00, 0x5f, 0x00, 0x6e, 0x00, 0x61, 0x00, 0x6d, 0x00,
      0x65, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x6d, 0x00, 0x65, 0x00,
      0x74, 0x00, 0x72, 0x00, 0x69, 0x00, 0x63, 0x00, 0x5f, 0x00, 0x76, 0x00,
      0x61, 0x00, 0x6c, 0x00, 0x75, 0x00, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x50, 0x52, 0x56, 0x41, 0x4c, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x10, 0xd0, 0x01, 0x00, 0x00, 0x48, 0x00, 0x65, 0x00,
      0x6c, 0x00, 0x6c, 0x00, 0x6f, 0x00, 0x20, 0x00, 0x57, 0x00, 0x6f, 0x00,
      0x72, 0x00, 0x6c, 0x00, 0x64, 0x00, 0x20, 0x00, 0x4d, 0x00, 0x65, 0x00,
      0x74, 0x00, 0x72, 0x00, 0x69, 0x00, 0x63, 0x00, 0x20, 0x00, 0x50, 0x00,
      0x72, 0x00, 0x6f, 0x00, 0x76, 0x00, 0x69, 0x00, 0x64, 0x00, 0x65, 0x00,
      0x72, 0x00, 0x00, 0x00, 0x4f, 0x50, 0x43, 0x4f, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x4c, 0x45, 0x56, 0x4c, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x54, 0x41, 0x53, 0x4b, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x4b, 0x45, 0x59, 0x57, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x45, 0x56, 0x4e, 0x54, 0x40, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x01, 0xb0, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00]))

  def test_copy_from_byte_stream(self):
    """Tests the copy_from_byte_stream function."""
    manifest = pyfwevt.manifest()
    manifest.copy_from_byte_stream(self._TEST_DATA)

    with self.assertRaises(TypeError):
      manifest.copy_from_byte_stream(None)

    with self.assertRaises(IOError):
      manifest.copy_from_byte_stream(b'')

  def test_get_number_of_providers(self):
    """Tests the get_number_of_providers function."""
    manifest = pyfwevt.manifest()
    manifest.copy_from_byte_stream(self._TEST_DATA)

    number_of_providers = manifest.get_number_of_providers()
    self.assertEqual(number_of_providers, 1)

  def test_get_provider(self):
    """Tests the get_provider function."""
    manifest = pyfwevt.manifest()
    manifest.copy_from_byte_stream(self._TEST_DATA)

    provider = manifest.get_provider(0)
    self.assertIsNotNone(provider)


if __name__ == "__main__":
  unittest.main(verbosity=2)
