#!/usr/bin/env python
#
# Python-bindings provider type test script
#
# Copyright (C) 2011-2024, Joachim Metz <joachim.metz@gmail.com>
#
# Refer to AUTHORS for acknowledgements.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

import unittest

import pyfwevt


class ProviderTypeTests(unittest.TestCase):
  """Tests the provider type."""

  _TEST_DATA = bytes(bytearray([
	  0x43, 0x52, 0x49, 0x4d, 0x78, 0x02, 0x00, 0x00, 0x05, 0x00, 0x01, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x53, 0xea, 0xa2, 0x06, 0x6c, 0xfc, 0xe5, 0x42,
      0x91, 0x76, 0x18, 0x74, 0x9a, 0xb2, 0xca, 0x13, 0x24, 0x00, 0x00, 0x00,
      0x57, 0x45, 0x56, 0x54, 0x54, 0x02, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00,
      0x0d, 0x00, 0x00, 0x00, 0xbc, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
      0x08, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x02, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x20, 0x02, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
      0x2c, 0x02, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x38, 0x02, 0x00, 0x00,
      0x54, 0x54, 0x42, 0x4c, 0x50, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
      0x54, 0x45, 0x4d, 0x50, 0x44, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
      0x02, 0x00, 0x00, 0x00, 0x58, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
      0x33, 0x12, 0x8a, 0x27, 0x65, 0xf6, 0x52, 0x52, 0x0b, 0xa7, 0x2b, 0xca,
      0x59, 0x74, 0x33, 0xa8, 0x0f, 0x01, 0x01, 0x00, 0x01, 0xff, 0xff, 0xac,
      0x00, 0x00, 0x00, 0x44, 0x82, 0x09, 0x00, 0x45, 0x00, 0x76, 0x00, 0x65,
      0x00, 0x6e, 0x00, 0x74, 0x00, 0x44, 0x00, 0x61, 0x00, 0x74, 0x00, 0x61,
      0x00, 0x00, 0x00, 0x02, 0x41, 0xff, 0xff, 0x41, 0x00, 0x00, 0x00, 0x8a,
      0x6f, 0x04, 0x00, 0x44, 0x00, 0x61, 0x00, 0x74, 0x00, 0x61, 0x00, 0x00,
      0x00, 0x29, 0x00, 0x00, 0x00, 0x06, 0x4b, 0x95, 0x04, 0x00, 0x4e, 0x00,
      0x61, 0x00, 0x6d, 0x00, 0x65, 0x00, 0x00, 0x00, 0x05, 0x01, 0x0b, 0x00,
      0x6d, 0x00, 0x65, 0x00, 0x74, 0x00, 0x72, 0x00, 0x69, 0x00, 0x63, 0x00,
      0x5f, 0x00, 0x6e, 0x00, 0x61, 0x00, 0x6d, 0x00, 0x65, 0x00, 0x02, 0x0d,
      0x00, 0x00, 0x01, 0x04, 0x41, 0xff, 0xff, 0x43, 0x00, 0x00, 0x00, 0x8a,
      0x6f, 0x04, 0x00, 0x44, 0x00, 0x61, 0x00, 0x74, 0x00, 0x61, 0x00, 0x00,
      0x00, 0x2b, 0x00, 0x00, 0x00, 0x06, 0x4b, 0x95, 0x04, 0x00, 0x4e, 0x00,
      0x61, 0x00, 0x6d, 0x00, 0x65, 0x00, 0x00, 0x00, 0x05, 0x01, 0x0c, 0x00,
      0x6d, 0x00, 0x65, 0x00, 0x74, 0x00, 0x72, 0x00, 0x69, 0x00, 0x63, 0x00,
      0x5f, 0x00, 0x76, 0x00, 0x61, 0x00, 0x6c, 0x00, 0x75, 0x00, 0x65, 0x00,
      0x02, 0x0d, 0x01, 0x00, 0x07, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x01, 0x00, 0x00,
      0x1c, 0x00, 0x00, 0x00, 0x6d, 0x00, 0x65, 0x00, 0x74, 0x00, 0x72, 0x00,
      0x69, 0x00, 0x63, 0x00, 0x5f, 0x00, 0x6e, 0x00, 0x61, 0x00, 0x6d, 0x00,
      0x65, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x6d, 0x00, 0x65, 0x00,
      0x74, 0x00, 0x72, 0x00, 0x69, 0x00, 0x63, 0x00, 0x5f, 0x00, 0x76, 0x00,
      0x61, 0x00, 0x6c, 0x00, 0x75, 0x00, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x50, 0x52, 0x56, 0x41, 0x4c, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x10, 0xd0, 0x01, 0x00, 0x00, 0x48, 0x00, 0x65, 0x00,
      0x6c, 0x00, 0x6c, 0x00, 0x6f, 0x00, 0x20, 0x00, 0x57, 0x00, 0x6f, 0x00,
      0x72, 0x00, 0x6c, 0x00, 0x64, 0x00, 0x20, 0x00, 0x4d, 0x00, 0x65, 0x00,
      0x74, 0x00, 0x72, 0x00, 0x69, 0x00, 0x63, 0x00, 0x20, 0x00, 0x50, 0x00,
      0x72, 0x00, 0x6f, 0x00, 0x76, 0x00, 0x69, 0x00, 0x64, 0x00, 0x65, 0x00,
      0x72, 0x00, 0x00, 0x00, 0x4f, 0x50, 0x43, 0x4f, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x4c, 0x45, 0x56, 0x4c, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x54, 0x41, 0x53, 0x4b, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x4b, 0x45, 0x59, 0x57, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x45, 0x56, 0x4e, 0x54, 0x40, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x01, 0xb0, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00]))

  def test_get_identifier(self):
    """Tests the get_identifier function and identifier property."""
    fwevt_manifest = pyfwevt.manifest()
    fwevt_manifest.copy_from_byte_stream(self._TEST_DATA)

    fwevt_provider = fwevt_manifest.get_provider(0)
    self.assertIsNotNone(fwevt_provider)

    identifier = fwevt_provider.get_identifier()
    self.assertEqual(identifier, '06a2ea53-fc6c-42e5-9176-18749ab2ca13')

    self.assertEqual(fwevt_provider.identifier, '06a2ea53-fc6c-42e5-9176-18749ab2ca13')

  def test_get_number_of_channels(self):
    """Tests the get_number_of_channels function and number_of_channels property."""
    fwevt_manifest = pyfwevt.manifest()
    fwevt_manifest.copy_from_byte_stream(self._TEST_DATA)

    fwevt_provider = fwevt_manifest.get_provider(0)
    self.assertIsNotNone(fwevt_provider)

    number_of_channels = fwevt_provider.get_number_of_channels()
    self.assertEqual(number_of_channels, 0)

    self.assertEqual(fwevt_provider.number_of_channels, 0)

  def test_get_channel(self):
    """Tests the get_channel function."""
    fwevt_manifest = pyfwevt.manifest()
    fwevt_manifest.copy_from_byte_stream(self._TEST_DATA)

    fwevt_provider = fwevt_manifest.get_provider(0)
    self.assertIsNotNone(fwevt_provider)

    with self.assertRaises(IOError):
      fwevt_provider.get_channel(0)

  def test_get_number_of_events(self):
    """Tests the get_number_of_events function and number_of_events property."""
    fwevt_manifest = pyfwevt.manifest()
    fwevt_manifest.copy_from_byte_stream(self._TEST_DATA)

    fwevt_provider = fwevt_manifest.get_provider(0)
    self.assertIsNotNone(fwevt_provider)

    number_of_events = fwevt_provider.get_number_of_events()
    self.assertEqual(number_of_events, 1)

    self.assertEqual(fwevt_provider.number_of_events, 1)

  def test_get_event(self):
    """Tests the get_event function."""
    fwevt_manifest = pyfwevt.manifest()
    fwevt_manifest.copy_from_byte_stream(self._TEST_DATA)

    fwevt_provider = fwevt_manifest.get_provider(0)
    self.assertIsNotNone(fwevt_provider)

    event = fwevt_provider.get_event(0)
    self.assertIsNotNone(event)

  def test_get_number_of_keywords(self):
    """Tests the get_number_of_keywords function and number_of_keywords property."""
    fwevt_manifest = pyfwevt.manifest()
    fwevt_manifest.copy_from_byte_stream(self._TEST_DATA)

    fwevt_provider = fwevt_manifest.get_provider(0)
    self.assertIsNotNone(fwevt_provider)

    number_of_keywords = fwevt_provider.get_number_of_keywords()
    self.assertEqual(number_of_keywords, 0)

    self.assertEqual(fwevt_provider.number_of_keywords, 0)

  def test_get_keyword(self):
    """Tests the get_keyword function."""
    fwevt_manifest = pyfwevt.manifest()
    fwevt_manifest.copy_from_byte_stream(self._TEST_DATA)

    fwevt_provider = fwevt_manifest.get_provider(0)
    self.assertIsNotNone(fwevt_provider)

    with self.assertRaises(IOError):
      fwevt_provider.get_keyword(0)

  def test_get_number_of_levels(self):
    """Tests the get_number_of_levels function and number_of_levels property."""
    fwevt_manifest = pyfwevt.manifest()
    fwevt_manifest.copy_from_byte_stream(self._TEST_DATA)

    fwevt_provider = fwevt_manifest.get_provider(0)
    self.assertIsNotNone(fwevt_provider)

    number_of_levels = fwevt_provider.get_number_of_levels()
    self.assertEqual(number_of_levels, 0)

    self.assertEqual(fwevt_provider.number_of_levels, 0)

  def test_get_level(self):
    """Tests the get_level function."""
    fwevt_manifest = pyfwevt.manifest()
    fwevt_manifest.copy_from_byte_stream(self._TEST_DATA)

    fwevt_provider = fwevt_manifest.get_provider(0)
    self.assertIsNotNone(fwevt_provider)

    with self.assertRaises(IOError):
      fwevt_provider.get_level(0)

  def test_get_number_of_maps(self):
    """Tests the get_number_of_maps function and number_of_maps property."""
    fwevt_manifest = pyfwevt.manifest()
    fwevt_manifest.copy_from_byte_stream(self._TEST_DATA)

    fwevt_provider = fwevt_manifest.get_provider(0)
    self.assertIsNotNone(fwevt_provider)

    number_of_maps = fwevt_provider.get_number_of_maps()
    self.assertEqual(number_of_maps, 0)

    self.assertEqual(fwevt_provider.number_of_maps, 0)

  def test_get_map(self):
    """Tests the get_map function."""
    fwevt_manifest = pyfwevt.manifest()
    fwevt_manifest.copy_from_byte_stream(self._TEST_DATA)

    fwevt_provider = fwevt_manifest.get_provider(0)
    self.assertIsNotNone(fwevt_provider)

    with self.assertRaises(IOError):
      fwevt_provider.get_map(0)

  def test_get_number_of_opcodes(self):
    """Tests the get_number_of_opcodes function and number_of_opcodes property."""
    fwevt_manifest = pyfwevt.manifest()
    fwevt_manifest.copy_from_byte_stream(self._TEST_DATA)

    fwevt_provider = fwevt_manifest.get_provider(0)
    self.assertIsNotNone(fwevt_provider)

    number_of_opcodes = fwevt_provider.get_number_of_opcodes()
    self.assertEqual(number_of_opcodes, 0)

    self.assertEqual(fwevt_provider.number_of_opcodes, 0)

  def test_get_opcode(self):
    """Tests the get_opcode function."""
    fwevt_manifest = pyfwevt.manifest()
    fwevt_manifest.copy_from_byte_stream(self._TEST_DATA)

    fwevt_provider = fwevt_manifest.get_provider(0)
    self.assertIsNotNone(fwevt_provider)

    with self.assertRaises(IOError):
      fwevt_provider.get_opcode(0)

  def test_get_number_of_tasks(self):
    """Tests the get_number_of_tasks function and number_of_tasks property."""
    fwevt_manifest = pyfwevt.manifest()
    fwevt_manifest.copy_from_byte_stream(self._TEST_DATA)

    fwevt_provider = fwevt_manifest.get_provider(0)
    self.assertIsNotNone(fwevt_provider)

    number_of_tasks = fwevt_provider.get_number_of_tasks()
    self.assertEqual(number_of_tasks, 0)

    self.assertEqual(fwevt_provider.number_of_tasks, 0)

  def test_get_task(self):
    """Tests the get_task function."""
    fwevt_manifest = pyfwevt.manifest()
    fwevt_manifest.copy_from_byte_stream(self._TEST_DATA)

    fwevt_provider = fwevt_manifest.get_provider(0)
    self.assertIsNotNone(fwevt_provider)

    with self.assertRaises(IOError):
      fwevt_provider.get_task(0)

  def test_get_number_of_templates(self):
    """Tests the get_number_of_templates function and number_of_templates property."""
    fwevt_manifest = pyfwevt.manifest()
    fwevt_manifest.copy_from_byte_stream(self._TEST_DATA)

    fwevt_provider = fwevt_manifest.get_provider(0)
    self.assertIsNotNone(fwevt_provider)

    number_of_templates = fwevt_provider.get_number_of_templates()
    self.assertEqual(number_of_templates, 1)

    self.assertEqual(fwevt_provider.number_of_templates, 1)

  def test_get_template(self):
    """Tests the get_template function."""
    fwevt_manifest = pyfwevt.manifest()
    fwevt_manifest.copy_from_byte_stream(self._TEST_DATA)

    fwevt_provider = fwevt_manifest.get_provider(0)
    self.assertIsNotNone(fwevt_provider)

    template = fwevt_provider.get_template(0)
    self.assertIsNotNone(template)

  def test_get_template_by_offset(self):
    """Tests the get_template_by_offset function."""
    fwevt_manifest = pyfwevt.manifest()
    fwevt_manifest.copy_from_byte_stream(self._TEST_DATA)

    fwevt_provider = fwevt_manifest.get_provider(0)
    self.assertIsNotNone(fwevt_provider)

    template = fwevt_provider.get_template_by_offset(120)
    self.assertIsNotNone(template)

    template = fwevt_provider.get_template_by_offset(999)
    self.assertIsNone(template)


if __name__ == "__main__":
  unittest.main(verbosity=2)
