Name: libfwevt
Version: 20240426
Release: 1
Summary: Library to support the Windows XML Event Log (EVTX) data types
Group: System Environment/Libraries
License: LGPL-3.0-or-later
Source: %{name}-%{version}.tar.gz
URL: https://github.com/libyal/libfwevt
        
BuildRequires: gcc        

%description -n libfwevt
Library to support the Windows XML Event Log (EVTX) data types

%package -n libfwevt-static
Summary: Library to support the Windows XML Event Log (EVTX) data types
Group: Development/Libraries
Requires: libfwevt = %{version}-%{release}

%description -n libfwevt-static
Static library version of libfwevt.

%package -n libfwevt-devel
Summary: Header files and libraries for developing applications for libfwevt
Group: Development/Libraries
Requires: libfwevt = %{version}-%{release}

%description -n libfwevt-devel
Header files and libraries for developing applications for libfwevt.

%package -n libfwevt-python3
Summary: Python 3 bindings for libfwevt
Group: System Environment/Libraries
Requires: libfwevt = %{version}-%{release} python3
BuildRequires: python3-devel python3-setuptools

%description -n libfwevt-python3
Python 3 bindings for libfwevt

%prep
%setup -q

%build
%configure --prefix=/usr --libdir=%{_libdir} --mandir=%{_mandir} --enable-python
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
%make_install

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files -n libfwevt
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/*.so.*

%files -n libfwevt-static
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/*.a

%files -n libfwevt-devel
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/*.so
%{_libdir}/pkgconfig/libfwevt.pc
%{_includedir}/*
%{_mandir}/man3/*

%files -n libfwevt-python3
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/python3*/site-packages/*.a
%{_libdir}/python3*/site-packages/*.so

%changelog
* Fri Apr 26 2024 Joachim Metz <joachim.metz@gmail.com> 20240426-1
- Auto-generated

