/*
 * Definitions for libfwnt
 *
 * Copyright (C) 2009-2018, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This software is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined( _LIBFWNT_DEFINITIONS_H )
#define _LIBFWNT_DEFINITIONS_H

#include <libfwnt/types.h>

#define LIBFWNT_VERSION				20181215

/* The version string
 */
#define LIBFWNT_VERSION_STRING			"20181215"

/* The byte order definitions
 */
enum LIBFWNT_ENDIAN
{
	LIBFWNT_ENDIAN_BIG			= (int) 'b',
	LIBFWNT_ENDIAN_LITTLE			= (int) 'l'
};

/* The security identifier (SID) authorities
 */
enum LIBFWNT_SECURITY_IDENTIFIER_AUTHORITIES
{
	LIBFWNT_AUTHORITY_NULL			= 0x00,
	LIBFWNT_AUTHORITY_WORLD			= 0x01,
	LIBFWNT_AUTHORITY_LOCAL			= 0x02,
	LIBFWNT_AUTHORITY_CREATOR		= 0x03,
	LIBFWNT_AUTHORITY_NON_UNIQUE		= 0x04,
	LIBFWNT_AUTHORITY_NT_AUTHORITY		= 0x05,

	LIBFWNT_AUTHORITY_EXCHANGE_2007		= 0x09
};

/* The access control types
 */
enum LIBFWNT_ACCESS_CONTROL_TYPES
{
	LIBFWNT_ACCESS_ALLOWED			= 0x00,
	LIBFWNT_ACCESS_DENIED			= 0x01,
	LIBFWNT_SYSTEM_AUDIT			= 0x02,
	LIBFWNT_SYSTEM_ALARM			= 0x03,
	LIBFWNT_ACCESS_ALLOWED_COMPOUND		= 0x04,
	LIBFWNT_ACCESS_ALLOWED_OBJECT		= 0x05,
	LIBFWNT_ACCESS_DENIED_OBJECT		= 0x06,
	LIBFWNT_SYSTEM_AUDIT_OBJECT		= 0x07,
	LIBFWNT_SYSTEM_ALARM_OBJECT		= 0x08,
	LIBFWNT_ACCESS_ALLOWED_CALLBACK		= 0x09,
	LIBFWNT_ACCESS_DENIED_CALLBACK		= 0x0a,
	LIBFWNT_ACCESS_ALLOWED_CALLBACK_OBJECT	= 0x0b,
	LIBFWNT_ACCESS_DENIED_CALLBACK_OBJECT	= 0x0c,
	LIBFWNT_SYSTEM_AUDIT_CALLBACK		= 0x0d,
	LIBFWNT_SYSTEM_ALARM_CALLBACK		= 0x0e,
	LIBFWNT_SYSTEM_AUDIT_CALLBACK_OBJECT	= 0x0f,
	LIBFWNT_SYSTEM_ALARM_CALLBACK_OBJECT	= 0x10,
	LIBFWNT_SYSTEM_MANDATORY_LABEL		= 0x11
};

#endif /* !defined( _LIBFWNT_DEFINITIONS_H ) */

