Name: libfwnt
Version: 20210421
Release: 1
Summary: Library to support common Windows NT specific formats
Group: System Environment/Libraries
License: LGPLv3+
Source: %{name}-%{version}.tar.gz
URL: https://github.com/libyal/libfwnt
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
    
BuildRequires: gcc    

%description -n libfwnt
Library to support common Windows NT specific formats

%package -n libfwnt-static
Summary: Library to support common Windows NT specific formats
Group: Development/Libraries
Requires: libfwnt = %{version}-%{release}

%description -n libfwnt-static
Static library version of libfwnt.

%package -n libfwnt-devel
Summary: Header files and libraries for developing applications for libfwnt
Group: Development/Libraries
Requires: libfwnt = %{version}-%{release}

%description -n libfwnt-devel
Header files and libraries for developing applications for libfwnt.

%package -n libfwnt-python2
Obsoletes: libfwnt-python < %{version}
Provides: libfwnt-python = %{version}
Summary: Python 2 bindings for libfwnt
Group: System Environment/Libraries
Requires: libfwnt = %{version}-%{release} python2
BuildRequires: python2-devel

%description -n libfwnt-python2
Python 2 bindings for libfwnt

%package -n libfwnt-python3
Summary: Python 3 bindings for libfwnt
Group: System Environment/Libraries
Requires: libfwnt = %{version}-%{release} python3
BuildRequires: python3-devel

%description -n libfwnt-python3
Python 3 bindings for libfwnt

%prep
%setup -q

%build
%configure --prefix=/usr --libdir=%{_libdir} --mandir=%{_mandir} --enable-python2 --enable-python3
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
%make_install

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files -n libfwnt
%defattr(644,root,root,755)
%license COPYING COPYING.LESSER
%doc AUTHORS README
%attr(755,root,root) %{_libdir}/*.so.*

%files -n libfwnt-static
%defattr(644,root,root,755)
%license COPYING COPYING.LESSER
%doc AUTHORS README
%attr(755,root,root) %{_libdir}/*.a

%files -n libfwnt-devel
%defattr(644,root,root,755)
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/*.la
%{_libdir}/*.so
%{_libdir}/pkgconfig/libfwnt.pc
%{_includedir}/*
%{_mandir}/man3/*

%files -n libfwnt-python2
%defattr(644,root,root,755)
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/python2*/site-packages/*.a
%{_libdir}/python2*/site-packages/*.la
%{_libdir}/python2*/site-packages/*.so

%files -n libfwnt-python3
%defattr(644,root,root,755)
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/python3*/site-packages/*.a
%{_libdir}/python3*/site-packages/*.la
%{_libdir}/python3*/site-packages/*.so

%changelog
* Sun Apr 25 2021 Joachim Metz <joachim.metz@gmail.com> 20210421-1
- Auto-generated

