/*
 * The internal definitions
 *
 * Copyright (C) 2013-2024, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( LIBFWPS_INTERNAL_DEFINITIONS_H )
#define LIBFWPS_INTERNAL_DEFINITIONS_H

#include <common.h>
#include <types.h>

/* Define HAVE_LOCAL_LIBFWPS for local use of libfwps
 */
#if !defined( HAVE_LOCAL_LIBFWPS )
#include <libfwps/definitions.h>

/* The definitions in <libfwps/definitions.h> are copied here
 * for local use of libfwps
 */
#else
#include <byte_stream.h>

#define LIBFWPS_VERSION					20240224

/* The version string
 */
#define LIBFWPS_VERSION_STRING				"20240224"

/* The byte order definitions
 */
#define LIBFWPS_ENDIAN_BIG				_BYTE_STREAM_ENDIAN_BIG
#define LIBFWPS_ENDIAN_LITTLE				_BYTE_STREAM_ENDIAN_LITTLE

/* The value types
 */
enum LIBFWPS_VALUE_TYPES
{
	LIBFWPS_VALUE_TYPE_EMPTY			= 0x00000000UL,
	LIBFWPS_VALUE_TYPE_NULL				= 0x00000001UL,
	LIBFWPS_VALUE_TYPE_INTEGER_16BIT_SIGNED		= 0x00000002UL,
	LIBFWPS_VALUE_TYPE_INTEGER_32BIT_SIGNED		= 0x00000003UL,
	LIBFWPS_VALUE_TYPE_FLOAT_32BIT			= 0x00000004UL,
	LIBFWPS_VALUE_TYPE_DOUBLE_64BIT			= 0x00000005UL,
	LIBFWPS_VALUE_TYPE_CURRENCY			= 0x00000006UL,
	LIBFWPS_VALUE_TYPE_APPLICATION_TIME		= 0x00000007UL,
	LIBFWPS_VALUE_TYPE_BINARY_STRING		= 0x00000008UL,
	LIBFWPS_VALUE_TYPE_IDISPATCH			= 0x00000009UL,
	LIBFWPS_VALUE_TYPE_ERROR			= 0x0000000aUL,
	LIBFWPS_VALUE_TYPE_BOOLEAN			= 0x0000000bUL,
	LIBFWPS_VALUE_TYPE_VARIANT			= 0x0000000cUL,
	LIBFWPS_VALUE_TYPE_IUNKNOWN			= 0x0000000dUL,
	LIBFWPS_VALUE_TYPE_FIXED_POINT_128BIT		= 0x0000000eUL,

	LIBFWPS_VALUE_TYPE_INTEGER_8BIT_SIGNED		= 0x00000010UL,
	LIBFWPS_VALUE_TYPE_INTEGER_8BIT_UNSIGNED	= 0x00000011UL,
	LIBFWPS_VALUE_TYPE_INTEGER_16BIT_UNSIGNED	= 0x00000012UL,
	LIBFWPS_VALUE_TYPE_INTEGER_32BIT_UNSIGNED	= 0x00000013UL,
	LIBFWPS_VALUE_TYPE_INTEGER_64BIT_SIGNED		= 0x00000014UL,
	LIBFWPS_VALUE_TYPE_INTEGER_64BIT_UNSIGNED	= 0x00000015UL,
	LIBFWPS_VALUE_TYPE_INTEGER_SIGNED		= 0x00000016UL,
	LIBFWPS_VALUE_TYPE_INTEGER_UNSIGNED		= 0x00000017UL,
	LIBFWPS_VALUE_TYPE_VOID				= 0x00000018UL,
	LIBFWPS_VALUE_TYPE_HRESULT			= 0x00000019UL,
	LIBFWPS_VALUE_TYPE_POINTER			= 0x0000001aUL,
	LIBFWPS_VALUE_TYPE_SAFE_ARRAY			= 0x0000001bUL,
	LIBFWPS_VALUE_TYPE_ARRAY			= 0x0000001cUL,
	LIBFWPS_VALUE_TYPE_USER_DEFINED			= 0x0000001dUL,
	LIBFWPS_VALUE_TYPE_STRING_ASCII			= 0x0000001eUL,
	LIBFWPS_VALUE_TYPE_STRING_UNICODE		= 0x0000001fUL,

	LIBFWPS_VALUE_TYPE_FILETIME			= 0x00000040UL,
	LIBFWPS_VALUE_TYPE_BINARY_DATA			= 0x00000041UL,
	LIBFWPS_VALUE_TYPE_STREAM			= 0x00000042UL,
	LIBFWPS_VALUE_TYPE_STORAGE			= 0x00000043UL,
	LIBFWPS_VALUE_TYPE_STREAMED_OBJECT		= 0x00000044UL,
	LIBFWPS_VALUE_TYPE_STORED_OBJECT		= 0x00000045UL,
	LIBFWPS_VALUE_TYPE_BINARY_DATA_OBJECT		= 0x00000046UL,
	LIBFWPS_VALUE_TYPE_CLIPBOARD_FORMAT		= 0x00000047UL,
	LIBFWPS_VALUE_TYPE_GUID				= 0x00000048UL,
	LIBFWPS_VALUE_TYPE_VERSIONED_STREAM		= 0x00000049UL
};

#endif /* !defined( HAVE_LOCAL_LIBFWPS ) */

/* The property record types
 */
enum LIBFWPS_RECORD_TYPES
{
	LIBFWPS_RECORD_TYPE_NAMED			= 1,
	LIBFWPS_RECORD_TYPE_NUMERIC			= 2
};

#endif /* !defined( LIBFWPS_INTERNAL_DEFINITIONS_H ) */

