/*
 * Definitions for libgzipf
 *
 * Copyright (C) 2019-2023, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBGZIPF_DEFINITIONS_H )
#define _LIBGZIPF_DEFINITIONS_H

#include <libgzipf/types.h>

#define LIBGZIPF_VERSION		20231218

/* The libgzipf version string
 */
#define LIBGZIPF_VERSION_STRING		"20231218"

/* The libgzipf file access
 * bit 1        set to 1 for read access
 * bit 2        set to 1 for write access
 * bit 3-8      not used
 */
enum LIBGZIPF_ACCESS_FLAGS
{
	LIBGZIPF_ACCESS_FLAG_READ	= 0x01,
/* Reserved: not supported yet */
	LIBGZIPF_ACCESS_FLAG_WRITE	= 0x02
};

/* The libnlk file access macros
 */
#define LIBGZIPF_OPEN_READ		( LIBGZIPF_ACCESS_FLAG_READ )
/* Reserved: not supported yet */
#define LIBGZIPF_OPEN_WRITE		( LIBGZIPF_ACCESS_FLAG_WRITE )
/* Reserved: not supported yet */
#define LIBGZIPF_OPEN_READ_WRITE	( LIBGZIPF_ACCESS_FLAG_READ | LIBGZIPF_ACCESS_FLAG_WRITE )

#endif /* !defined( _LIBGZIPF_DEFINITIONS_H ) */

