Name: libhmac
Version: 20240417
Release: 1
Summary: Library to support various Hash-based Message Authentication Codes (HMAC)
Group: System Environment/Libraries
License: LGPL-3.0-or-later
Source: %{name}-%{version}.tar.gz
URL: https://github.com/libyal/libhmac
Requires:  openssl 
BuildRequires: gcc  openssl-devel 

%description -n libhmac
Library to support various Hash-based Message Authentication Codes (HMAC)

%package -n libhmac-static
Summary: Library to support various Hash-based Message Authentication Codes (HMAC)
Group: Development/Libraries
Requires: libhmac = %{version}-%{release}

%description -n libhmac-static
Static library version of libhmac.

%package -n libhmac-devel
Summary: Header files and libraries for developing applications for libhmac
Group: Development/Libraries
Requires: libhmac = %{version}-%{release}

%description -n libhmac-devel
Header files and libraries for developing applications for libhmac.

%package -n libhmac-python3
Summary: Python 3 bindings for libhmac
Group: System Environment/Libraries
Requires: libhmac = %{version}-%{release} python3
BuildRequires: python3-devel python3-setuptools

%description -n libhmac-python3
Python 3 bindings for libhmac

%package -n libhmac-tools
Summary: Several tools for calculating Hash-based Message Authentication Codes (HMAC)
Group: Applications/System
Requires: libhmac = %{version}-%{release}      
      

%description -n libhmac-tools
Several tools for calculating Hash-based Message Authentication Codes (HMAC)

%prep
%setup -q

%build
%configure --prefix=/usr --libdir=%{_libdir} --mandir=%{_mandir} --enable-python
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
%make_install

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files -n libhmac
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/*.so.*

%files -n libhmac-static
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/*.a

%files -n libhmac-devel
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/*.so
%{_libdir}/pkgconfig/libhmac.pc
%{_includedir}/*
%{_mandir}/man3/*

%files -n libhmac-python3
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/python3*/site-packages/*.a
%{_libdir}/python3*/site-packages/*.so

%files -n libhmac-tools
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_bindir}/*
%{_mandir}/man1/*

%changelog
* Wed Apr 17 2024 Joachim Metz <joachim.metz@gmail.com> 20240417-1
- Auto-generated

