/* libi8x.c generated by mkpy3capi.py from libi8x.c.in. */
/* DO NOT EDIT THIS FILE, EDIT THE TEMPLATE AND REGENERATE. */

/* Copyright (C) 2017 Red Hat, Inc.
   This file is part of the Infinity Note Execution Library.

   The Infinity Note Execution Library is free software; you can
   redistribute it and/or modify it under the terms of the GNU Lesser
   General Public License as published by the Free Software
   Foundation; either version 2.1 of the License, or (at your option)
   any later version.

   The Infinity Note Execution Library is distributed in the hope that
   it will be useful, but WITHOUT ANY WARRANTY; without even the
   implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
   PURPOSE.  See the GNU Lesser General Public License for more
   details.

   You should have received a copy of the GNU Lesser General Public
   License along with the Infinity Note Execution Library; if not, see
   <http://www.gnu.org/licenses/>.  */

#include <py3c.h>
#include <libi8x.h>
#include <syslog.h>

/* Attribute name under which py8x_encapsulate* stores libi8x
   object PyCapsules in the Python wrapper objects it creates.  */

#define PY8X_CNAME_ATTR "__py8x_private__"

/* Utilities.  */

#define PY8X_MAX(a, b) ((a) > (b) ? (a) : (b))

#define PY8X_STRINGIZE(x) PY8X_STRINGIZE_1(x)
#define PY8X_STRINGIZE_1(x) #x

#define py8x_not_implemented()						\
  do {									\
    PyErr_SetString (PyExc_NotImplementedError,				\
		     __FILE__ ":" PY8X_STRINGIZE (__LINE__));		\
    return NULL;							\
  } while (0)

#define py8x_internal_error(msg)					\
  do {									\
    Py_FatalError ("py8x: " __FILE__ ":" PY8X_STRINGIZE (__LINE__)	\
		   ": internal error: "	 msg);				\
  } while (0);

#define py8x_logf_cond(ctx, priority, arg...)				\
  do {									\
    struct i8x_ctx *__ctx = (ctx);					\
									\
    if (i8x_ctx_get_log_priority (__ctx) >= priority)			\
      py8x_logf (__ctx, priority, __FILE__, __LINE__,			\
		 __FUNCTION__, ## arg);					\
  } while (0)

#define dbg(ctx, arg...) py8x_logf_cond (ctx, LOG_DEBUG, ## arg)
#define info(ctx, arg...) py8x_logf_cond (ctx, LOG_INFO, ## arg)

/* Formatting.  */

#ifdef __LP64__
# define LONG_FMT "l"
#else
# define LONG_FMT ""
#endif
#define LDEC	"%" LONG_FMT "d"
#define ULDEC	"%" LONG_FMT "u"
#define LHEX	"0x%" LONG_FMT "x"

/* Forward declarations.  */

static void py8x_logf (struct i8x_ctx *ctx, int priority,
		       const char *filename, int linenumber,
		       const char *function, const char *format, ...)
  __attribute__ ((format(printf, 6, 7)));

static PyObject *py8x_ctx_get_object_factory_fn (struct i8x_ctx *ctx);

/* Exceptions raised when a libi8x function returns an i8x_err_e
   value other than I8X_OK.

   I8XError
    +-- NoteError
    |    +-- CorruptNoteError		I8X_NOTE_CORRUPT
    |    +-- InvalidNoteError		I8X_NOTE_INVALID
    |    +-- UnhandledNoteError		I8X_NOTE_UNHANDLED
    +-- ExecutionError
         +-- DivideByZeroError		I8X_DIVIDE_BY_ZERO
         +-- StackOverflowError		I8X_STACK_OVERFLOW
         +-- UnresolvedFunctionError	I8X_UNRESOLVED_FUNCTION
         +-- ReturnTypeError		I8X_NATCALL_BAD_FUNCREF_RET

   Note that not all i8x_err_e values have a corresponding class
   in this heirachy:

   * I8X_ENOMEM is handled with Python MemoryError.
   * I8X_EINVAL is handled with Python ValueError.
   * I8X_RELOC_FAILED, I8X_READ_MEM_FAILED and I8X_NATCALL_FAILED
     only occur when something fails
       a) in this file, or
       b) in user-supplied Python functions called by something
          in this file.
     These errors result in Python exceptions.  */

static PyObject *py8x_I8XError;

static PyObject *py8x_NoteError;
static PyObject *py8x_ExecutionError;

static PyObject *py8x_CorruptNoteError;
static PyObject *py8x_InvalidNoteError;
static PyObject *py8x_UnhandledNoteError;

static PyObject *py8x_DivideByZeroError;
static PyObject *py8x_StackOverflowError;
static PyObject *py8x_UnresolvedFunctionError;
static PyObject *py8x_ReturnTypeError;

/* Set an exception from a libi8x error code.  Note that ctx will
   be NULL if the error occurred during i8x_ctx_new.  This function
   always returns with an exception set, though not necessarily an
   I8XError.  */

static void
py8x_set_exception (struct i8x_ctx *ctx, i8x_err_e code)
{
  /* Use PyExc_MemoryError for I8X_ENOMEM.  */
  if (code == I8X_ENOMEM)
    {
      PyErr_NoMemory ();
      return;
    }

  /* Get the error message.  */
  char buf[64];
  const char *msg = i8x_strerror_r (code, buf, sizeof (buf));

  /* Use PyExc_ValueError for I8X_EINVAL.  */
  if (code == I8X_EINVAL)
    {
      PyErr_SetString (PyExc_ValueError, msg);
      return;
    }

  /* Choose which exception to set.  */
  PyObject *errorclass;
  switch (code)
    {
    case I8X_NOTE_CORRUPT:
      errorclass = py8x_CorruptNoteError;
      break;

    case I8X_NOTE_INVALID:
      errorclass = py8x_InvalidNoteError;
      break;

    case I8X_NOTE_UNHANDLED:
      errorclass = py8x_UnhandledNoteError;
      break;

    case I8X_UNRESOLVED_FUNCTION:
      errorclass = py8x_UnresolvedFunctionError;
      break;

    case I8X_STACK_OVERFLOW:
      errorclass = py8x_StackOverflowError;
      break;

    case I8X_DIVIDE_BY_ZERO:
      errorclass = py8x_DivideByZeroError;
      break;

    case I8X_NATCALL_BAD_FUNCREF_RET:
      errorclass = py8x_ReturnTypeError;
      break;

    default:
      errorclass = py8x_I8XError;
    }

  /* Get the error location, if set.  */
  PyObject *last_error_src_offset;
  ssize_t tmp = i8x_ctx_get_last_error_src_offset (ctx);
  if (tmp < 0)
    {
      Py_INCREF (Py_None);
      last_error_src_offset = Py_None;
    }
  else
    {
      last_error_src_offset = PyLong_FromSsize_t (tmp);
      if (last_error_src_offset == NULL)
	return;
    }

  /* Build the arguments.  */
  PyObject *args = Py_BuildValue("(ssO)", msg,
				 i8x_ctx_get_last_error_src_name (ctx),
				 last_error_src_offset);
  Py_DECREF (last_error_src_offset);
  if (args == NULL)
    return;

  /* Set the error.  */
  PyErr_SetObject (errorclass, args);
  Py_DECREF (args);
}

/* Userdata for all libi8x objects we create.  May be extended.
   Every libi8x object we pass into Python-space has one of these.
   It can be supplied to py8x_encapsulate* by the object's creator
   (if the object requires extended userdata).  If not supplied a
   generic userdata will be created.  It has two functions:

    1) It contains a regular reference to the parent object's
       Python wrapper.  This ensures parent objects remain live
       while live Python references to their children exist.
       (Python-side references are all child-parent).

    2) It contains a weak reference to this object's Python
       wrapper.  This interning means that Python objects can
       be compared using "is".  */

struct py8x_userdata;

struct py8x_userdata_ops
{
  const char *name;
  size_t size;
  void (*cleanup) (struct py8x_userdata *ud);
};

struct py8x_userdata
{
  const struct py8x_userdata_ops *ops;

  /* PyCapsule of parent object (referenced by us).
     NULL for i8x_ctx objects.  */
  PyObject *parent;

  /* PyWeakref of our own wrapped PyCapsule.  */
  PyObject *selfwr;
};

#define PY8X_USERDATA_FIELDS struct py8x_userdata _oud

/* Generic userdata ops for nonspecialized objects.  */

static const struct py8x_userdata_ops py8x_ob_udops =
  {
    "i8x_object",
    sizeof (struct py8x_userdata),
  };

/* Allocate and initialize a new py8x_userdata.  */

static struct py8x_userdata *
py8x_userdata_new (const struct py8x_userdata_ops *ops)
{
  struct py8x_userdata *ud;

  ud = calloc (1, ops->size);
  if (ud != NULL)
    ud->ops = ops;

  return ud;
}

/* Userdata cleanup for all objects.  */

static void
py8x_userdata_free (void *ud_p)
{
  struct py8x_userdata *ud = (struct py8x_userdata *) ud_p;

  if (ud->ops->cleanup != NULL)
    ud->ops->cleanup (ud);

  Py_XDECREF (ud->parent);
  Py_XDECREF (ud->selfwr);

  free (ud);
}

/* Get an object's userdata.  */

#define py8x_get_userdata(o)						\
  ((struct py8x_userdata *)						\
     i8x_ob_get_userdata ((struct i8x_object *) (o)))

/* Pointer used as a flag for _py8x_check_call.
   Can be anything that isn't a real i8x_object or NULL.  */
static struct i8x_object *NO_OBJECT = (struct i8x_object *) Py_None;

/* Check the result of a libi8x call.  Returns true if execution
   should continue, false if an error occurred.  Errors can be
   Python exceptions or libi8x errors.  Python exceptions are
   untouched, libi8x errors are translated into Python exceptions:
   there will always a Python exception set if this function returns
   false.  OB will be released on error if not set to NO_OBJECT;
   UD will be freed on error if it is not set to NULL.  Don't call
   this function directly, use the macros below.  */

static bool
_py8x_check_call (struct i8x_ctx *ctx, i8x_err_e err,
		  struct i8x_object *ob, struct py8x_userdata *ud)
{
  bool got_exception = PyErr_Occurred () != NULL;

  if (got_exception && err == I8X_OK && ob != NO_OBJECT)
    {
      /* An exception occurred somewhere, but libi8x didn't see it
	 and returned a new reference to an i8x_object.  We need to
	 unreference that before continuing with the exception.  */
      ob = i8x_ob_unref (ob);
    }

  if ((got_exception || err != I8X_OK) && ud != NULL)
    {
      /* An error occurred, and we have preallocated userdata.
	 Free it before continuing with the exception.  */
      py8x_userdata_free (ud);
    }

  if (!got_exception && err != I8X_OK)
    {
      /* A libi8x error occurred, and there's no exception set.
	 We need to set one.  */
      py8x_set_exception (ctx, err);

      got_exception = true;
    }

  return !got_exception;
}

/* Wrapper for _py8x_check_call.  */

#define PY8X_CHECK_CALL_DEREF_UD(ctx, err, ob, ud)			\
  do {									\
    if (!_py8x_check_call (ctx, err, (struct i8x_object *) ob,		\
			   (struct py8x_userdata *) ud))		\
      return NULL;							\
  } while (0)

/* Variant of PY8X_CHECK_CALL_DEREF_UD for objects without
   preallocated userdata.  */

#define PY8X_CHECK_CALL_DEREF(ctx, err, ob)				\
  PY8X_CHECK_CALL_DEREF_UD (ctx, err, ob, NULL)

/* Variant of PY8X_CHECK_CALL_DEREF for libi8x calls that
   do not create new references to libi8x objects.  */

#define PY8X_CHECK_CALL(ctx, err)					\
  PY8X_CHECK_CALL_DEREF (ctx, err, NO_OBJECT)

/* Variant of _PY8X_CHECK_UNCAUGHT_DEREF_UD for libi8x calls
   that do not create new references to libi8x objects.  */

#define PY8X_CHECK_UNCAUGHT()						\
  PY8X_CHECK_CALL (NULL, I8X_OK)

/* Set a TypeError and return NULL if obj is not callable.  */

#define PY8X_CHECK_CALLABLE(obj)					\
  do {									\
    if (!PyCallable_Check (obj))					\
      {									\
	PyErr_Format (PyExc_TypeError,					\
		      "'%.200s' object is not callable",		\
                      obj->ob_type->tp_name);				\
	return NULL;							\
      }									\
  } while (0)

/* PyCapsule_Destructor suitable for all libi8x objects.  */

static void
py8x_ob_unref (PyObject *obc)
{
  const char *classname = PyCapsule_GetName (obc);
  struct i8x_object *ob = PyCapsule_GetPointer (obc, classname);
  dbg (i8x_ob_get_ctx (ob), "%s %p capsule released\n", classname, ob);

  struct py8x_userdata *ud = py8x_get_userdata (ob);
  if (ud == NULL)
    py8x_internal_error ("object userdata == NULL");

  /* Release the child before the parent.  */
  PyObject *parent = ud->parent;
  ud->parent = NULL;

  i8x_ob_unref (ob);
  Py_DECREF (parent);
}

/* Encapsulate and return a libi8x object.  */

static PyObject *
py8x_encapsulate_2 (struct i8x_object *ob, struct py8x_userdata *new_ud)
{
  struct py8x_userdata *ud;
  PyObject *result = NULL;

  /* Encapsulate NULLs as Py_None.  */
  if (ob == NULL)
    {
      if (new_ud != NULL)
	{
	  /* The caller supplied userdata for a NULL object.  */
	  PyErr_SetString (PyExc_AssertionError,
			   "ob == NULL && new_ud != NULL");
	  return NULL;
	}

      Py_RETURN_NONE;
    }

  ud = py8x_get_userdata (ob);
  if (ud != NULL && new_ud != NULL)
    {
      /* The caller supplied userdata for an object that already has
	 userdata set.  This is a programmer error.  */
      PyErr_SetString (PyExc_AssertionError,
		       "ud != NULL && new_ud != NULL");
      return NULL;
    }

  if (ud == NULL)
    {
      /* The object has no userdata. Create if necessary.  */
      if (new_ud == NULL)
	new_ud = py8x_userdata_new (&py8x_ob_udops);
      if (new_ud == NULL)
	return PyErr_NoMemory ();

      /* Attach it to the object. */
      i8x_ob_set_userdata (ob, new_ud, py8x_userdata_free);

      ud = new_ud;
    }

  /* Reference the object's parent's wrapper.
     N.B. for contexts this will reference Py_None.  */
  if (ud->parent == NULL)
    {
      ud->parent = py8x_encapsulate_2 (i8x_ob_get_parent (ob), NULL);
      if (ud->parent == NULL)
	return NULL;
    }

  /* Try and use a previously-created wrapped capsule.  */
  if (ud->selfwr != NULL)
    {
      result = PyWeakref_GetObject (ud->selfwr);
      if (result == NULL)
	return NULL;

      if (result == Py_None)
	{
	  result = NULL;

	  Py_DECREF (ud->selfwr);
	  ud->selfwr = NULL;
	}
      else
	Py_INCREF (result);
    }

  /* Create a new wrapped capsule if necessary.  */
  if (result == NULL)
    {
      struct i8x_ctx *ctx = i8x_ob_get_ctx (ob);
      PyObject *obf_fn = py8x_ctx_get_object_factory_fn (ctx);
      const char *classname = i8x_ob_get_classname (ob);
      PyObject *capsule;

      /* Create a capsule to hold the object.  */
      capsule = PyCapsule_New (i8x_ob_ref (ob), classname, py8x_ob_unref);
      if (capsule == NULL)
	return NULL;
      dbg (ctx, "%s %p capsule created\n", classname, ob);

      /* Create a Python object to hold the capsule.  */
      struct i8x_object *ctx_ob = (struct i8x_object *) ctx;
      PyObject *ctxc = py8x_encapsulate_2 (ob == ctx_ob ? NULL : ctx_ob,
					   NULL);
      if (ctxc == NULL)
	{
	  Py_DECREF (capsule);
	  return NULL;
	}
      result = PyObject_CallFunction (obf_fn, "Os", ctxc, classname);
      Py_DECREF (ctxc);
      if (result == NULL)
	{
	  Py_DECREF (capsule);
	  return NULL;
	}

      /* Store the capsule in the wrapper object.  */
      int err = PyObject_SetAttrString (result, PY8X_CNAME_ATTR, capsule);
      Py_DECREF (capsule);
      if (err != 0)
	{
	  Py_DECREF (result);
	  return NULL;
	}

      /* Store a weak reference to our own wrapper object.  */
      ud->selfwr = PyWeakref_NewRef (result, NULL);
      if (ud->selfwr == NULL)
	{
	  Py_DECREF (result);
	  return NULL;
	}
    }

  return result;
}

static PyObject *
py8x_encapsulate_1 (struct i8x_object *ob, struct py8x_userdata *ud)
{
  PyObject *result = py8x_encapsulate_2 (ob, ud);

  i8x_ob_unref (ob);

  return result;
}

#define py8x_encapsulate(x)						\
  (py8x_encapsulate_1 ((struct i8x_object *) x, NULL))

/* Return the libi8x object pointer from a wrapped capsule.  If
   classname is NULL type-checking is disabled; this is used by
   py8x_ob_from_capsule.  Don't call this function directly, use
   the macros below.  */

static struct i8x_object *
py8x_from_capsule (PyObject *wrapped, const char *classname)
{
  PyObject *expect_exception;

  /* Ensure we're not called with an error set.  We'd likely
     overwrite it with a TypeError and make things difficult
     to debug.  */
  if (PyErr_Occurred () != NULL)
    {
      PyErr_SetString (PyExc_AssertionError,
		       "py8x_from_capsule called with an error set");
      return NULL;
    }

  /* Get the libi8x object pointer.  */
  PyObject *capsule = PyObject_GetAttrString (wrapped, PY8X_CNAME_ATTR);
  if (capsule == NULL)
    expect_exception = PyExc_AttributeError;
  else
    {
      if (classname == NULL)
	classname = PyCapsule_GetName (capsule);

      void *result = PyCapsule_GetPointer (capsule, classname);
      Py_DECREF (capsule);
      if (result == NULL)
	expect_exception = PyExc_ValueError;
      else
	return (struct i8x_object *) result;
    }

  /* Something failed.  If an unexpected exception is set
     then let that propagate.  Set a TypeError otherwise.  */
  PyObject *exception = PyErr_Occurred ();
  if (exception != NULL && exception != expect_exception)
    return NULL;

  if (classname == NULL)
    classname = "object";
  else if (strcmp (classname, "inferior") == 0)
    classname = "inf";

  PyErr_Format (PyExc_TypeError, "an i8x_%s is required", classname);
  return NULL;
}

#define PY8X_OBJECT_FUNCTIONS(TYPE, PREFIX, CLASSNAME)			\
  static inline struct i8x_ ## TYPE * __attribute__ ((always_inline))	\
  py8x_ ## PREFIX ## _from_capsule (PyObject *wrapped)			\
  {									\
    return (struct i8x_ ## TYPE *) py8x_from_capsule (wrapped,		\
						      CLASSNAME);	\
  }
PY8X_OBJECT_FUNCTIONS (ctx, ctx, "ctx");
PY8X_OBJECT_FUNCTIONS (func, func, "func");
PY8X_OBJECT_FUNCTIONS (funcref, funcref, "funcref");
PY8X_OBJECT_FUNCTIONS (inf, inf, "inferior");
PY8X_OBJECT_FUNCTIONS (list, list, "list");
PY8X_OBJECT_FUNCTIONS (listitem, listitem, "listitem");
PY8X_OBJECT_FUNCTIONS (note, note, "note");
PY8X_OBJECT_FUNCTIONS (object, ob, NULL);
PY8X_OBJECT_FUNCTIONS (reloc, reloc, "reloc");
PY8X_OBJECT_FUNCTIONS (type, type, "type");
PY8X_OBJECT_FUNCTIONS (xctx, xctx, "xctx");

#define PY8X_FROM_CAPSULE_2(TYPE, NAME)					\
  py8x_ ## TYPE ## _from_capsule (NAME ## c);				\
  if (NAME == NULL)							\
    return NULL

#define PY8X_FROM_CAPSULE(TYPENAME)					\
  PY8X_FROM_CAPSULE_2 (TYPENAME, TYPENAME)

/* Helpers for objects with extended userdata.  */

#define PY8X_USERDATA_FUNCTIONS(TYPE)					\
  static inline struct py8x_ ## TYPE ## _userdata *			\
    __attribute__ ((always_inline))					\
  py8x_ ## TYPE ## _userdata_new (void)					\
  {									\
    return (struct py8x_ ## TYPE ## _userdata *)			\
      py8x_userdata_new (&py8x_ ## TYPE ## _udops);			\
  }									\
									\
  static inline struct py8x_ ## TYPE ## _userdata *			\
    __attribute__ ((always_inline))					\
  py8x_ ## TYPE ## _get_userdata (struct i8x_ ## TYPE *x)		\
  {									\
    return (struct py8x_ ## TYPE ## _userdata *)			\
      i8x_ ## TYPE ## _get_userdata (x);				\
  }									\
									\
  static inline PyObject * __attribute__ ((always_inline))		\
  py8x_ ## TYPE ## _encapsulate (struct i8x_ ## TYPE *x,		\
				 struct py8x_ ## TYPE ## _userdata *ud) \
  {									\
    return py8x_encapsulate_1 ((struct i8x_object *) x,			\
			       (struct py8x_userdata *) ud);		\
  }

/* Context (i8x_ctx) userdata.  */

struct py8x_ctx_userdata
{
  PY8X_USERDATA_FIELDS;

  /* Object factory.  A Python callable invoked to create
     weak-referencable wrapper objects into which we store
     PyCapsule-wrapped libi8x objects.  */
  PyObject *obf_fn;

  /* Logging function.  May be Py_None, in which case
     messages will be output on stderr.  */
  PyObject *log_fn;

  /* True if we've attempted to log our name and version
     on this context's debug log.  */
  bool py8x_announced;
};

static void
py8x_ctx_userdata_cleanup (struct py8x_userdata *ud_p)
{
  struct py8x_ctx_userdata *ud = (struct py8x_ctx_userdata *) ud_p;

  Py_DECREF (ud->obf_fn);
  Py_DECREF (ud->log_fn);
}

static const struct py8x_userdata_ops py8x_ctx_udops =
  {
    "i8x_ctx",
    sizeof (struct py8x_ctx_userdata),
    py8x_ctx_userdata_cleanup,
  };

PY8X_USERDATA_FUNCTIONS (ctx)

/* Userdata for the context currently being created by py8x_ctx_new.
   Various things can log before py8x_ctx_encapsulate sets the
   context's userdata; this static global exists so that py8x_log
   can access the Python log function it needs in this case.  */

static struct py8x_ctx_userdata *py8x_new_context_ud;

/* Log a message to stderr.  Should mirror libi8x's default logger.  */

static void
py8x_log_stderr (int priority, const char *filename, int linenumber,
		 const char *function, const char *msg)
{
  /* PySys_WriteStderr wants 1000 bytes max.  */
  char buf[1000];
  ssize_t size = sizeof (buf);
  static const char dots[] = "...\n";

  if (snprintf (buf, size, "py8x: %s: %s", function, msg) >= size)
    strcpy (buf + size - sizeof (dots), dots);

  PySys_WriteStderr ("%s", buf);
}

/* Log a message, ideally via the user-supplied logging function.  */

static void
py8x_log (struct i8x_ctx *ctx, int priority, const char *filename,
	  int linenumber, const char *function, const char *msg)
{
  struct py8x_ctx_userdata *ud = py8x_ctx_get_userdata (ctx);
  PyObject *result = NULL;

  /* No userdata means we're within py8x_ctx_new, before
     py8x_ctx_encapsulate has had chance to set it.  */
  if (ud == NULL)
    ud = py8x_new_context_ud;
  if (ud == NULL)
    {
      py8x_log_stderr (priority, filename, linenumber, function, msg);
      py8x_internal_error ("context userdata == NULL");
    }

  /* Announce ourselves.  */
  if (!ud->py8x_announced)
    {
      ud->py8x_announced = true;
      dbg (ctx, "using py8x %s\n", PY8X_VERSION);
    }

  /* Call the user-defined logging function if there is one.  */
  if (ud->log_fn != Py_None)
    {
      PyObject *type, *value, *traceback;
      PyErr_Fetch (&type, &value, &traceback);

      result = PyObject_CallFunction (ud->log_fn, "isiss", priority,
				      filename, linenumber, function,
				      msg);

      if (type != NULL)
	PyErr_Restore (type, value, traceback);
    }

  if (result == NULL)
    py8x_log_stderr (priority, filename, linenumber, function, msg);

  Py_XDECREF (result);
}

/* Logging function for all py8x-created contexts.  */

static void __attribute__ ((format(printf, 6, 0)))
py8x_vlogf (struct i8x_ctx *ctx, int priority, const char *filename,
	    int linenumber, const char *function, const char *format,
	    va_list args)
{
  char *msg;

  int count = vasprintf (&msg, format, args);
  if (count < 0)
    msg = "vasprintf failed\n";

  py8x_log (ctx, priority, filename, linenumber, function, msg);

  if (count >= 0)
    free (msg);
}

/* Logging function for py8x_logf_cond macros.  */

static void
py8x_logf (struct i8x_ctx *ctx, int priority, const char *filename,
	   int linenumber, const char *function, const char *format,
	   ...)
{
  va_list args;

  va_start (args, format);
  py8x_vlogf (ctx, priority, filename, linenumber, function, format,
	      args);
  va_end (args);
}

/* Helper for py8x_ctx_new.  */

static PyObject *
py8x_ctx_new_1 (int flags, struct py8x_ctx_userdata *ud)
{
  struct i8x_ctx *ctx = NULL;
  i8x_err_e err;

  err = i8x_ctx_new (flags, py8x_vlogf, &ctx);

  PY8X_CHECK_CALL_DEREF_UD (NULL, err, ctx, ud);

  return py8x_ctx_encapsulate (ctx, ud);
}

/* Python binding for i8x_ctx_new.  */

static PyObject *
py8x_ctx_new (PyObject *self, PyObject *args)
{
  PyObject *obf_fn;
  int flags;
  PyObject *log_fn;
  struct py8x_ctx_userdata *ud;
  PyObject *result = NULL;

  if (!PyArg_ParseTuple (args, "OiO", &obf_fn, &flags, &log_fn))
    return NULL;

  PY8X_CHECK_CALLABLE (obf_fn);
  if (log_fn != Py_None)
    PY8X_CHECK_CALLABLE (log_fn);

  ud = py8x_ctx_userdata_new ();
  if (ud == NULL)
    return PyErr_NoMemory ();

  Py_INCREF (obf_fn);
  ud->obf_fn = obf_fn;

  Py_INCREF (log_fn);
  ud->log_fn = log_fn;

  py8x_new_context_ud = ud;
  result = py8x_ctx_new_1 (flags, ud);
  py8x_new_context_ud = NULL;

  return result;
}

/* Return the object factory for a context.  */

static PyObject *
py8x_ctx_get_object_factory_fn (struct i8x_ctx *ctx)
{
  return py8x_ctx_get_userdata (ctx)->obf_fn;
}

/* Set the object factory for a context.  */

static PyObject *
py8x_ctx_set_object_factory (PyObject *self, PyObject *args)
{
  PyObject *ctxc, *obf_fn;

  if (!PyArg_ParseTuple (args, "OO", &ctxc, &obf_fn))
    return NULL;

  PY8X_CHECK_CALLABLE (obf_fn);

  struct i8x_ctx *ctx = PY8X_FROM_CAPSULE (ctx);
  struct py8x_ctx_userdata *ud = py8x_ctx_get_userdata (ctx);

  Py_DECREF (ud->obf_fn);
  Py_INCREF (obf_fn);
  ud->obf_fn = obf_fn;

  Py_RETURN_NONE;
}

/* Return the log function for a context.  */

static PyObject *
py8x_ctx_get_log_fn (PyObject *self, PyObject *args)
{
  PyObject *ctxc;

  if (!PyArg_ParseTuple (args, "O", &ctxc))
    return NULL;

  struct i8x_ctx *ctx = PY8X_FROM_CAPSULE (ctx);
  struct py8x_ctx_userdata *ud = py8x_ctx_get_userdata (ctx);

  Py_INCREF (ud->log_fn);
  return ud->log_fn;
}

/* Python binding for i8x_ctx_set_log_fn.  */

static PyObject *
py8x_ctx_set_log_fn (PyObject *self, PyObject *args)
{
  PyObject *ctxc, *log_fn;

  if (!PyArg_ParseTuple (args, "OO", &ctxc, &log_fn))
    return NULL;

  if (log_fn != Py_None)
    PY8X_CHECK_CALLABLE (log_fn);

  struct i8x_ctx *ctx = PY8X_FROM_CAPSULE (ctx);
  struct py8x_ctx_userdata *ud = py8x_ctx_get_userdata (ctx);

  Py_DECREF (ud->log_fn);
  Py_INCREF (log_fn);
  ud->log_fn = log_fn;

  Py_RETURN_NONE;
}

/* Convert a Python number to a C void pointer.  Returns NULL and
   sets an exception on failure.  May return NULL on success.  */

static void *
py8x_PyNumber_AsVoidPtr (PyObject *object, bool allow_negative)
{
  if (!PyNumber_Check (object))
    {
      PyErr_SetString (PyExc_TypeError, "an integer is required");
      return NULL;
    }

#if IS_PY3
    object = PyNumber_Long (object);
#else
    object = PyNumber_Int (object);
#endif  /* IS_PY3 */
  if (object == NULL)
    return NULL;

  void *value = PyLong_AsVoidPtr (object);
  if (PyErr_Occurred () != NULL)
    value = NULL;
  else if (!allow_negative)
    {
      /* PyLong_AsVoidPtr accepts negative values: catch this.  */
      PyObject *check = PyLong_FromVoidPtr (value);
      if (check == NULL)
	value = NULL;
      else
	{
	  int cmp = PyObject_RichCompareBool (object, check, Py_EQ);
	  Py_DECREF (check);
	  if (cmp == 0)
	    PyErr_SetNone (PyExc_OverflowError);
	  if (cmp != 1)
	    value = NULL;
	}
    }

  Py_DECREF (object);

  return value;
}

/* Convert a Python object to an i8x_funcref.  If the Python
   object is a wrapped capsule then it will be unwrapped and
   type-checked as a funcref.  If it's not a wrapped capsule
   it's assumed to be a string containing the signature of a
   function registered in the context.  Returns a borrowed
   reference.  */

static struct i8x_funcref *
py8x_unpack_funcref (struct i8x_ctx *ctx, PyObject *ref_or_sig)
{
  struct i8x_funcref *ref;
  const char *signature = NULL;

  /* If this looks like a wrapped capsule then unpack it.  */
  if (PyObject_HasAttrString (ref_or_sig, PY8X_CNAME_ATTR))
    {
      ref = py8x_funcref_from_capsule (ref_or_sig);
      if (ref != NULL)
	return ref;
    }
  else
    {
      /* The other valid alternative is a string signature.  */
      Py_ssize_t size;

      signature = PyStr_AsUTF8AndSize (ref_or_sig, &size);

      /* Embedded NULs in the signature could indicate something
	 sneaky going on.  Disallow it.  */
      if (signature != NULL && strlen (signature) != (size_t) size)
	{
	  char buf[32];
	  const char *msg = i8x_strerror_r (I8X_EINVAL, buf,
					    sizeof (buf));

	  PyErr_SetString (PyExc_ValueError, msg);

	  return NULL;
	}
    }

  /* Handle any exceptions from py8x_funcref_from_capsule or
     PyStr_AsUTF8AndSize.  */
  if (signature == NULL)
    {
      PyObject *exception = PyErr_Occurred ();

      if (exception == NULL || exception == PyExc_TypeError)
	{
	  PyErr_SetString (PyExc_TypeError,
			   "an i8x_funcref or string is required");
	}

      return NULL;
    }

  /* Get an i8x_funcref representing the signature.  */
  i8x_err_e err = i8x_ctx_get_funcref (ctx, signature, &ref);

  PY8X_CHECK_CALL_DEREF (ctx, err, ref);

  /* We want to return a borrowed reference, but what we have
     is a new reference.  If the function is resolved then the
     context owns a reference: we can dereference without it
     being freed.  This is a hack I'm going to regret but YOLO.  */
  if (!i8x_funcref_is_resolved (ref))
    {
      i8x_ctx_clear_last_error (ctx);
      err = I8X_UNRESOLVED_FUNCTION;
    }
  i8x_funcref_unref (ref);

  PY8X_CHECK_CALL (ctx, err);

  return ref;
}

/* Actions for py8x_{pack,unpack}_tuple.  */

typedef enum
{
  PY8X_ARGS,
  PY8X_RETS
}
py8x_argsrets_e;

/* Helper for py8x_{pack,unpack}_tuple.  */

#define py8x_pack_unpack_types(ref, what)				\
  (what == PY8X_ARGS							\
   ? i8x_funcref_get_ptypes (ref)					\
   : i8x_funcref_get_rtypes (ref))

/* Pack a Python tuple from an array of i8x_values.  */

static PyObject *
py8x_pack_tuple (union i8x_value *src, struct i8x_funcref *ref,
		 py8x_argsrets_e what)
{
  struct i8x_list *types =  py8x_pack_unpack_types (ref, what);
  size_t length = i8x_list_size (types);
  size_t offset = what == PY8X_ARGS ? 3 : 0;
  struct i8x_listitem *li;
  size_t i;

  PyObject *result = PyTuple_New (length + offset);
  if (result == NULL)
    return NULL;

  i8x_list_foreach_indexed (types, li, i)
    {
      struct i8x_type *type = i8x_listitem_get_type (li);
      int index = what == PY8X_ARGS ? i + offset : length - i - 1;
      PyObject *item;

      if (i8x_type_is_functype (type))
	item = py8x_encapsulate (i8x_funcref_ref (src[i].f));
      else
	item = PyLong_FromUnsignedLong (src[i].u);

      if (item == NULL || PyTuple_SetItem (result, index, item) != 0)
	{
	  Py_DECREF (result);
	  return NULL;
	}
    }

  return result;
}

/* Unpack a Python tuple into an array of i8x_values.  */

static bool
py8x_unpack_tuple (union i8x_value *dst, PyObject *src,
		   struct i8x_funcref *ref, py8x_argsrets_e what)
{
  struct i8x_ctx *ctx = i8x_funcref_get_ctx (ref);
  struct i8x_list *types =  py8x_pack_unpack_types (ref, what);
  size_t length = i8x_list_size (types);
  size_t check_length;
  bool src_is_sequence = (PySequence_Check (src)
#if !IS_PY3
			  && !PyString_Check (src)
#endif /* !IS_PY3 */
			  && !PyUnicode_Check (src));
  struct i8x_listitem *li;
  size_t i;

  if (src_is_sequence)
    check_length = (size_t) PySequence_Length (src);
  else if (what == PY8X_RETS)
    {
      /* Native functions with no returns may return None.
	 Native functions with one return may return unboxed.  */
      check_length = src == Py_None ? 0 : 1;
    }
  else
    {
      PyErr_Format (PyExc_TypeError,
		    "must be sequence, not '%.200s'",
		    src->ob_type->tp_name);
      return false;
    }

  if (length != check_length)
    {
      PyErr_Format (PyExc_ValueError,
		    "wrong number of %s (expected " ULDEC ", got "
		    LDEC  ")",
		    what == PY8X_ARGS ? "arguments" : "returns",
		    length, check_length);
      return false;
    }

  i8x_list_foreach_indexed (types, li, i)
    {
      struct i8x_type *type = i8x_listitem_get_type (li);
      PyObject *item;

      if (src_is_sequence)
	{
	  int index = what == PY8X_ARGS ? i : length - i - 1;

	  item = PySequence_GetItem (src, index);
	  if (item == NULL)
	    return false;
	}
      else
	{
	  Py_INCREF (src);
	  item = src;
	}

      if (i8x_type_is_functype (type))
	{
	  struct i8x_funcref *value = py8x_unpack_funcref (ctx, item);

	  Py_DECREF (item);
	  if (value == NULL)
	    return false;

	  dst[i].f = value;
	}
      else
	{
	  void *value = py8x_PyNumber_AsVoidPtr (item, true);
	  Py_DECREF (item);
	  if (value == NULL && PyErr_Occurred () != NULL)
	    return false;

	  dst[i].p = value;
	}
    }

  return true;
}

#define py8x_pack_args(src, ref) 					\
  py8x_pack_tuple (src, ref, PY8X_ARGS)

#define py8x_pack_rets(src, ref) 					\
  py8x_pack_tuple (src, ref, PY8X_RETS)

#define py8x_unpack_args(dst, src, ref) 				\
  py8x_unpack_tuple (dst, src, ref, PY8X_ARGS)

#define py8x_unpack_rets(dst, src, ref) 				\
  py8x_unpack_tuple (dst, src, ref, PY8X_RETS)

/* Function (i8x_func) userdata.  */

struct py8x_func_userdata
{
  PY8X_USERDATA_FIELDS;

  /* Implementation (native only).  */
  PyObject *impl;
};

static void
py8x_func_userdata_cleanup (struct py8x_userdata *ud_p)
{
  struct py8x_func_userdata *ud = (struct py8x_func_userdata *) ud_p;

  Py_XDECREF (ud->impl);
}

static const struct py8x_userdata_ops py8x_func_udops =
  {
    "i8x_func",
    sizeof (struct py8x_func_userdata),
    py8x_func_userdata_cleanup,
  };

PY8X_USERDATA_FUNCTIONS (func)

/* Helper for py8x_natfunc_impl.  */

#define PY8X_NFI_SETARG(i, v)						\
  do {									\
    PyObject *arg = v;							\
									\
    if (arg == NULL || PyTuple_SetItem (args, (i), arg) != 0)		\
      {									\
	Py_DECREF (args);						\
	return I8X_NATCALL_FAILED;					\
      }									\
  } while (0)

/* Implementation function for all py8x-created native functions.  */

static i8x_err_e
py8x_natfunc_impl (struct i8x_xctx *xctx,
		   struct i8x_inf *inf,
		   struct i8x_func *func,
		   union i8x_value *argv,
		   union i8x_value *retv)
{
  struct i8x_funcref *ref = i8x_func_get_funcref (func);

  /* Pack the arguments.  */
  PyObject *args = py8x_pack_args (argv, ref);

  if (args == NULL)
    return I8X_NATCALL_FAILED;

  PY8X_NFI_SETARG (0, py8x_encapsulate (i8x_xctx_ref (xctx)));
  PY8X_NFI_SETARG (1, py8x_encapsulate (i8x_inf_ref (inf)));
  PY8X_NFI_SETARG (2, py8x_encapsulate (i8x_func_ref (func)));

  /* Make the call.  */
  struct py8x_func_userdata *ud = py8x_func_get_userdata (func);

  PyObject *rets = PyObject_Call (ud->impl, args, NULL);
  Py_DECREF (args);
  if (rets == NULL)
    return I8X_NATCALL_FAILED;

  /* Unpack the returns.  */
  bool success = py8x_unpack_rets (retv, rets, ref);
  Py_DECREF (rets);
  return success ? I8X_OK : I8X_NATCALL_FAILED;
}

/* Python binding for i8x_ctx_import_bytecode.  */

static PyObject *
py8x_ctx_import_bytecode (PyObject *self, PyObject *args)
{
  PyObject *ctxc;
  Py_buffer buffer;
  const char *srcname;
  long srcoff;

  if (!PyArg_ParseTuple (args, "O"
#if IS_PY3
			 "y"
#else
			 "s"
#endif /* IS_PY3 */
			 "*zl", &ctxc, &buffer, &srcname, &srcoff))
    return NULL;

  struct py8x_func_userdata *ud = py8x_func_userdata_new ();
  if (ud == NULL)
    return PyErr_NoMemory ();

  struct i8x_ctx *ctx = PY8X_FROM_CAPSULE (ctx);
  struct i8x_func *func;
  i8x_err_e err = i8x_ctx_import_bytecode (ctx,
					   buffer.buf, buffer.len,
					   srcname, srcoff,
					   &func);
  PyBuffer_Release (&buffer);

  PY8X_CHECK_CALL_DEREF_UD (ctx, err, func, ud);

  return py8x_func_encapsulate (func, ud);
}

/* Python binding for i8x_ctx_import_native.  */

static PyObject *
py8x_ctx_import_native (PyObject *self, PyObject *args)
{
  PyObject *ctxc;
  const char *signature;
  PyObject *impl;

  if (!PyArg_ParseTuple (args, "OsO", &ctxc, &signature, &impl))
    return NULL;

  PY8X_CHECK_CALLABLE (impl);

  struct py8x_func_userdata *ud = py8x_func_userdata_new ();
  if (ud == NULL)
    return PyErr_NoMemory ();

  Py_INCREF (impl);
  ud->impl = impl;

  struct i8x_ctx *ctx = PY8X_FROM_CAPSULE (ctx);
  struct i8x_func *func;
  i8x_err_e err = i8x_ctx_import_native (ctx, signature,
					 py8x_natfunc_impl, &func);

  PY8X_CHECK_CALL_DEREF_UD (ctx, err, func, ud);

  return py8x_func_encapsulate (func, ud);
}

/* Python binding for i8x_xctx_call.  */

static PyObject *
py8x_xctx_call (PyObject *self, PyObject *args)
{
  PyObject *xctxc, *ref_or_sig, *infc, *tmp;

  if (!PyArg_ParseTuple (args, "OOOO", &xctxc, &ref_or_sig, &infc, &tmp))
    return NULL;
  args = tmp;

  struct i8x_xctx *xctx = PY8X_FROM_CAPSULE (xctx);
  struct i8x_inf *inf = PY8X_FROM_CAPSULE (inf);

  struct i8x_ctx *ctx = i8x_xctx_get_ctx (xctx);
  struct i8x_funcref *ref = py8x_unpack_funcref (ctx, ref_or_sig);
  if (ref == NULL)
    return NULL;

  size_t argc = i8x_funcref_get_num_params (ref);
  size_t retc = i8x_funcref_get_num_returns (ref);
  union i8x_value *argv = alloca (PY8X_MAX (argc, retc));
  union i8x_value *retv = argv;

  if (!py8x_unpack_args (argv, args, ref))
    return NULL;

  i8x_err_e err = i8x_xctx_call (xctx, ref, inf, argv, retv);

  PY8X_CHECK_CALL (ctx, err);

  return py8x_pack_rets (retv, ref);
}

/* Memory reader function for all py8x-created inferiors.  */

static i8x_err_e
py8x_read_mem_fn (struct i8x_inf *inf, uintptr_t addr, size_t len,
		  void *result)
{
  PyObject *infc = py8x_encapsulate (i8x_inf_ref (inf));
  if (infc == NULL)
    return I8X_READ_MEM_FAILED;

  PyObject *func = PyObject_GetAttrString (infc, "read_memory");
  if (func == NULL)
    {
      Py_DECREF (infc);
      return I8X_READ_MEM_FAILED;
    }

  PyObject *ret =
    (PyMethod_Check (func) && PyMethod_Self (func) == infc)
    ? PyObject_CallFunction (func, "kk", addr, len)
    : PyObject_CallFunction (func, "Okk", infc, addr, len);

  Py_DECREF (infc);
  Py_DECREF (func);
  if (ret == NULL)
    return I8X_READ_MEM_FAILED;

  Py_buffer buf;
  if (PyObject_GetBuffer (ret, &buf, PyBUF_SIMPLE) != 0)
    {
      Py_DECREF (ret);
      return I8X_READ_MEM_FAILED;
    }

  if (buf.len != (Py_ssize_t) len)
    {
      Py_DECREF (ret);
      PyErr_Format (PyExc_ValueError,
		    "read_memory returned bad length (expected " ULDEC
		    ", got " LDEC ")", len, buf.len);
      return I8X_READ_MEM_FAILED;
    }

  memcpy (result, buf.buf, len);
  Py_DECREF (ret);
  return I8X_OK;
}

/* Relocation function for all py8x-created inferiors.  */

static i8x_err_e
py8x_relocate_fn (struct i8x_inf *inf, struct i8x_reloc *reloc,
		  uintptr_t *result)
{
  PyObject *infc = py8x_encapsulate (i8x_inf_ref (inf));
  if (infc == NULL)
    return I8X_RELOC_FAILED;

  PyObject *func = PyObject_GetAttrString (infc, "relocate_address");
  if (func == NULL)
    {
      Py_DECREF (infc);
      return I8X_RELOC_FAILED;
    }

  PyObject *relocc = py8x_encapsulate (i8x_reloc_ref (reloc));
  if (relocc == NULL)
    {
      Py_DECREF (infc);
      Py_DECREF (func);
      return I8X_RELOC_FAILED;
    }

  PyObject *ret =
    (PyMethod_Check (func) && PyMethod_Self (func) == infc)
    ? PyObject_CallFunctionObjArgs (func, relocc, NULL)
    : PyObject_CallFunctionObjArgs (func, infc, relocc, NULL);

  Py_DECREF (infc);
  Py_DECREF (func);
  Py_DECREF (relocc);
  if (ret == NULL)
    return I8X_RELOC_FAILED;

  uintptr_t res = PyLong_AsUnsignedLong (ret);
  Py_DECREF (ret);
  if (PyErr_Occurred () != NULL)
    return I8X_RELOC_FAILED;

  *result = res;
  return I8X_OK;
}

/* Python binding for i8x_inf_new.  */

static PyObject *
py8x_inf_new (PyObject *self, PyObject *args)
{
  PyObject *ctxc;

  if (!PyArg_ParseTuple (args, "O", &ctxc))
    return NULL;

  struct i8x_ctx *ctx = PY8X_FROM_CAPSULE (ctx);
  struct i8x_inf *inf;
  i8x_err_e err = i8x_inf_new (ctx, &inf);

  PY8X_CHECK_CALL_DEREF (ctx, err, inf);

  i8x_inf_set_read_mem_fn (inf, py8x_read_mem_fn);
  i8x_inf_set_relocate_fn (inf, py8x_relocate_fn);

  return py8x_encapsulate (inf);
}

/* Helper for methods that return list items (i8x_listitem).  */

#define PY8X_RETURN_LISTITEM(value)					\
  do {									\
    struct i8x_listitem *result = value;				\
									\
    if (result == NULL)							\
      {									\
	PyErr_SetNone(PyExc_StopIteration);				\
	return NULL;							\
      }									\
									\
    return py8x_encapsulate (i8x_listitem_ref (result));		\
  } while (0)

/* Python binding for i8x_list_get_first.  */

static PyObject *
py8x_list_get_first (PyObject *self, PyObject *args)
{
  PyObject *listc;

  if (!PyArg_ParseTuple (args, "O", &listc))
    return NULL;

  struct i8x_list *list = PY8X_FROM_CAPSULE (list);

  PY8X_RETURN_LISTITEM (i8x_list_get_first (list));
}

/* Python binding for i8x_list_get_next.  */

static PyObject *
py8x_list_get_next (PyObject *self, PyObject *args)
{
  PyObject *listc;
  PyObject *currc;

  if (!PyArg_ParseTuple (args, "OO", &listc, &currc))
    return NULL;

  struct i8x_list *list = PY8X_FROM_CAPSULE (list);
  struct i8x_listitem *curr = PY8X_FROM_CAPSULE_2 (listitem, curr);

  PY8X_RETURN_LISTITEM (i8x_list_get_next (list, curr));
}

/* PyArg_ParseTuple converter for uintptr_t with overflow checking.  */

static int
py8x_pylong_AsUintptr_t (PyObject *object, void *result)
{
  void *value = py8x_PyNumber_AsVoidPtr (object, false);
  if (value == NULL && PyErr_Occurred ())
    return 0;

  *(void **) result = value;

  return 1;
}

/* Python binding for i8x_ctx_get_funcref.  */

static PyObject *
py8x_ctx_get_funcref (PyObject *self, PyObject *args)
{
  PyObject *ctxc;
  const char *signature;

  if (!PyArg_ParseTuple (args, "Os", &ctxc, &signature))
    return NULL;

  struct i8x_ctx *ctx = PY8X_FROM_CAPSULE (ctx);
  struct i8x_funcref *ref;
  i8x_err_e err = i8x_ctx_get_funcref (ctx, signature, &ref);

  PY8X_CHECK_CALL_DEREF (ctx, err, ref);

  return py8x_encapsulate (ref);
}

/* Python binding for i8x_ctx_get_functions.  */

static PyObject *
py8x_ctx_get_functions (PyObject *self, PyObject *args)
{
  PyObject *ctxc;

  if (!PyArg_ParseTuple (args, "O", &ctxc))
    return NULL;

  struct i8x_ctx *ctx = PY8X_FROM_CAPSULE (ctx);
  struct i8x_list *result = i8x_ctx_get_functions (ctx);

  PY8X_CHECK_UNCAUGHT ();

  return py8x_encapsulate (i8x_list_ref (result));
}

/* Python binding for i8x_ctx_get_log_priority.  */

static PyObject *
py8x_ctx_get_log_priority (PyObject *self, PyObject *args)
{
  PyObject *ctxc;

  if (!PyArg_ParseTuple (args, "O", &ctxc))
    return NULL;

  struct i8x_ctx *ctx = PY8X_FROM_CAPSULE (ctx);
  int result = i8x_ctx_get_log_priority (ctx);

  PY8X_CHECK_UNCAUGHT ();

  return PyInt_FromLong (result);
}

/* Python binding for i8x_ctx_set_log_priority.  */

static PyObject *
py8x_ctx_set_log_priority (PyObject *self, PyObject *args)
{
  PyObject *ctxc;
  int priority;

  if (!PyArg_ParseTuple (args, "Oi", &ctxc, &priority))
    return NULL;

  struct i8x_ctx *ctx = PY8X_FROM_CAPSULE (ctx);
  i8x_ctx_set_log_priority (ctx, priority);

  PY8X_CHECK_UNCAUGHT ();

  Py_RETURN_NONE;
}

/* Python binding for i8x_func_get_funcref.  */

static PyObject *
py8x_func_get_funcref (PyObject *self, PyObject *args)
{
  PyObject *funcc;

  if (!PyArg_ParseTuple (args, "O", &funcc))
    return NULL;

  struct i8x_func *func = PY8X_FROM_CAPSULE (func);
  struct i8x_funcref *result = i8x_func_get_funcref (func);

  PY8X_CHECK_UNCAUGHT ();

  return py8x_encapsulate (i8x_funcref_ref (result));
}

/* Python binding for i8x_func_get_note.  */

static PyObject *
py8x_func_get_note (PyObject *self, PyObject *args)
{
  PyObject *funcc;

  if (!PyArg_ParseTuple (args, "O", &funcc))
    return NULL;

  struct i8x_func *func = PY8X_FROM_CAPSULE (func);
  struct i8x_note *result = i8x_func_get_note (func);

  PY8X_CHECK_UNCAUGHT ();

  return py8x_encapsulate (i8x_note_ref (result));
}

/* Python binding for i8x_func_get_relocs.  */

static PyObject *
py8x_func_get_relocs (PyObject *self, PyObject *args)
{
  PyObject *funcc;

  if (!PyArg_ParseTuple (args, "O", &funcc))
    return NULL;

  struct i8x_func *func = PY8X_FROM_CAPSULE (func);
  struct i8x_list *result = i8x_func_get_relocs (func);

  PY8X_CHECK_UNCAUGHT ();

  return py8x_encapsulate (i8x_list_ref (result));
}

/* Python binding for i8x_func_unregister.  */

static PyObject *
py8x_func_unregister (PyObject *self, PyObject *args)
{
  PyObject *funcc;

  if (!PyArg_ParseTuple (args, "O", &funcc))
    return NULL;

  struct i8x_func *func = PY8X_FROM_CAPSULE (func);
  i8x_err_e err = i8x_func_unregister (func);

  PY8X_CHECK_CALL (i8x_func_get_ctx (func), err);

  Py_RETURN_NONE;
}

/* Python binding for i8x_funcref_get_num_params.  */

static PyObject *
py8x_funcref_get_num_params (PyObject *self, PyObject *args)
{
  PyObject *refc;

  if (!PyArg_ParseTuple (args, "O", &refc))
    return NULL;

  struct i8x_funcref *ref = PY8X_FROM_CAPSULE_2 (funcref, ref);
  size_t result = i8x_funcref_get_num_params (ref);

  PY8X_CHECK_UNCAUGHT ();

  return PyLong_FromLong (result);
}

/* Python binding for i8x_funcref_get_num_returns.  */

static PyObject *
py8x_funcref_get_num_returns (PyObject *self, PyObject *args)
{
  PyObject *refc;

  if (!PyArg_ParseTuple (args, "O", &refc))
    return NULL;

  struct i8x_funcref *ref = PY8X_FROM_CAPSULE_2 (funcref, ref);
  size_t result = i8x_funcref_get_num_returns (ref);

  PY8X_CHECK_UNCAUGHT ();

  return PyLong_FromLong (result);
}

/* Python binding for i8x_funcref_get_signature.  */

static PyObject *
py8x_funcref_get_signature (PyObject *self, PyObject *args)
{
  PyObject *refc;

  if (!PyArg_ParseTuple (args, "O", &refc))
    return NULL;

  struct i8x_funcref *ref = PY8X_FROM_CAPSULE_2 (funcref, ref);
  const char *result = i8x_funcref_get_signature (ref);

  PY8X_CHECK_UNCAUGHT ();

  if (result == NULL)
    Py_RETURN_NONE;

  return PyStr_FromString (result);
}

/* Python binding for i8x_funcref_get_type.  */

static PyObject *
py8x_funcref_get_type (PyObject *self, PyObject *args)
{
  PyObject *refc;

  if (!PyArg_ParseTuple (args, "O", &refc))
    return NULL;

  struct i8x_funcref *ref = PY8X_FROM_CAPSULE_2 (funcref, ref);
  struct i8x_type *result = i8x_funcref_get_type (ref);

  PY8X_CHECK_UNCAUGHT ();

  return py8x_encapsulate (i8x_type_ref (result));
}

/* Python binding for i8x_funcref_is_global.  */

static PyObject *
py8x_funcref_is_global (PyObject *self, PyObject *args)
{
  PyObject *refc;

  if (!PyArg_ParseTuple (args, "O", &refc))
    return NULL;

  struct i8x_funcref *ref = PY8X_FROM_CAPSULE_2 (funcref, ref);
  int result = i8x_funcref_is_global (ref);

  PY8X_CHECK_UNCAUGHT ();

  if (result)
    Py_RETURN_TRUE;
  else
    Py_RETURN_FALSE;
}

/* Python binding for i8x_funcref_is_resolved.  */

static PyObject *
py8x_funcref_is_resolved (PyObject *self, PyObject *args)
{
  PyObject *refc;

  if (!PyArg_ParseTuple (args, "O", &refc))
    return NULL;

  struct i8x_funcref *ref = PY8X_FROM_CAPSULE_2 (funcref, ref);
  int result = i8x_funcref_is_resolved (ref);

  PY8X_CHECK_UNCAUGHT ();

  if (result)
    Py_RETURN_TRUE;
  else
    Py_RETURN_FALSE;
}

/* Python binding for i8x_list_size.  */

static PyObject *
py8x_list_size (PyObject *self, PyObject *args)
{
  PyObject *listc;

  if (!PyArg_ParseTuple (args, "O", &listc))
    return NULL;

  struct i8x_list *list = PY8X_FROM_CAPSULE (list);
  size_t result = i8x_list_size (list);

  PY8X_CHECK_UNCAUGHT ();

  return PyLong_FromLong (result);
}

/* Python binding for i8x_listitem_get_object.  */

static PyObject *
py8x_listitem_get_object (PyObject *self, PyObject *args)
{
  PyObject *itemc;

  if (!PyArg_ParseTuple (args, "O", &itemc))
    return NULL;

  struct i8x_listitem *item = PY8X_FROM_CAPSULE_2 (listitem, item);
  struct i8x_object *result = i8x_listitem_get_object (item);

  PY8X_CHECK_UNCAUGHT ();

  return py8x_encapsulate (i8x_ob_ref (result));
}

/* Python binding for i8x_note_get_src_name.  */

static PyObject *
py8x_note_get_src_name (PyObject *self, PyObject *args)
{
  PyObject *notec;

  if (!PyArg_ParseTuple (args, "O", &notec))
    return NULL;

  struct i8x_note *note = PY8X_FROM_CAPSULE (note);
  const char *result = i8x_note_get_src_name (note);

  PY8X_CHECK_UNCAUGHT ();

  if (result == NULL)
    Py_RETURN_NONE;

  return PyStr_FromString (result);
}

/* Python binding for i8x_ob_get_ctx.  */

static PyObject *
py8x_ob_get_ctx (PyObject *self, PyObject *args)
{
  PyObject *obc;

  if (!PyArg_ParseTuple (args, "O", &obc))
    return NULL;

  struct i8x_object *ob = PY8X_FROM_CAPSULE (ob);
  struct i8x_ctx *result = i8x_ob_get_ctx (ob);

  PY8X_CHECK_UNCAUGHT ();

  return py8x_encapsulate (i8x_ctx_ref (result));
}

/* Python binding for i8x_reloc_get_func.  */

static PyObject *
py8x_reloc_get_func (PyObject *self, PyObject *args)
{
  PyObject *relocc;

  if (!PyArg_ParseTuple (args, "O", &relocc))
    return NULL;

  struct i8x_reloc *reloc = PY8X_FROM_CAPSULE (reloc);
  struct i8x_func *result = i8x_reloc_get_func (reloc);

  PY8X_CHECK_UNCAUGHT ();

  return py8x_encapsulate (i8x_func_ref (result));
}

/* Python binding for i8x_reloc_get_src_offset.  */

static PyObject *
py8x_reloc_get_src_offset (PyObject *self, PyObject *args)
{
  PyObject *relocc;

  if (!PyArg_ParseTuple (args, "O", &relocc))
    return NULL;

  struct i8x_reloc *reloc = PY8X_FROM_CAPSULE (reloc);
  ssize_t result = i8x_reloc_get_src_offset (reloc);

  PY8X_CHECK_UNCAUGHT ();

  return PyLong_FromLong (result);
}

/* Python binding for i8x_reloc_get_unrelocated.  */

static PyObject *
py8x_reloc_get_unrelocated (PyObject *self, PyObject *args)
{
  PyObject *relocc;

  if (!PyArg_ParseTuple (args, "O", &relocc))
    return NULL;

  struct i8x_reloc *reloc = PY8X_FROM_CAPSULE (reloc);
  uintptr_t result = i8x_reloc_get_unrelocated (reloc);

  PY8X_CHECK_UNCAUGHT ();

  return PyLong_FromLong (result);
}

/* Python binding for i8x_type_get_ptypes.  */

static PyObject *
py8x_type_get_ptypes (PyObject *self, PyObject *args)
{
  PyObject *typec;

  if (!PyArg_ParseTuple (args, "O", &typec))
    return NULL;

  struct i8x_type *type = PY8X_FROM_CAPSULE (type);
  struct i8x_list *result = i8x_type_get_ptypes (type);

  PY8X_CHECK_UNCAUGHT ();

  return py8x_encapsulate (i8x_list_ref (result));
}

/* Python binding for i8x_type_get_rtypes.  */

static PyObject *
py8x_type_get_rtypes (PyObject *self, PyObject *args)
{
  PyObject *typec;

  if (!PyArg_ParseTuple (args, "O", &typec))
    return NULL;

  struct i8x_type *type = PY8X_FROM_CAPSULE (type);
  struct i8x_list *result = i8x_type_get_rtypes (type);

  PY8X_CHECK_UNCAUGHT ();

  return py8x_encapsulate (i8x_list_ref (result));
}

/* Python binding for i8x_type_is_functype.  */

static PyObject *
py8x_type_is_functype (PyObject *self, PyObject *args)
{
  PyObject *typec;

  if (!PyArg_ParseTuple (args, "O", &typec))
    return NULL;

  struct i8x_type *type = PY8X_FROM_CAPSULE (type);
  int result = i8x_type_is_functype (type);

  PY8X_CHECK_UNCAUGHT ();

  if (result)
    Py_RETURN_TRUE;
  else
    Py_RETURN_FALSE;
}

/* Python binding for i8x_xctx_new.  */

static PyObject *
py8x_xctx_new (PyObject *self, PyObject *args)
{
  PyObject *ctxc;
  size_t stack_slots;

  if (!PyArg_ParseTuple (args, "OO&", &ctxc, py8x_pylong_AsUintptr_t, &stack_slots))
    return NULL;

  struct i8x_ctx *ctx = PY8X_FROM_CAPSULE (ctx);
  struct i8x_xctx *xctx;
  i8x_err_e err = i8x_xctx_new (ctx, stack_slots, &xctx);

  PY8X_CHECK_CALL_DEREF (ctx, err, xctx);

  return py8x_encapsulate (xctx);
}


/* Convert an unsigned value to signed w.r.t. libi8x's wordsize.  */

static PyObject *
py8x_to_signed (PyObject *self, PyObject *args)
{
  union i8x_value v;

  if (!PyArg_ParseTuple (args, "O&", py8x_pylong_AsUintptr_t, &v.u))
    return NULL;

  return PyLong_FromLong (v.i);
}

/* Convert an signed value to unsigned w.r.t. libi8x's wordsize.  */

static PyObject *
py8x_to_unsigned (PyObject *self, PyObject *args)
{
  union i8x_value v;

  if (!PyArg_ParseTuple (args, "l", &v.i))
    return NULL;

  return PyLong_FromUnsignedLong (v.u);
}

/* Module-level functions table.  */

#define PY8X_FUNCTION(name) {#name, py8x_ ## name, METH_VARARGS, NULL}

static PyMethodDef libi8x_methods[] = {
  PY8X_FUNCTION (ctx_new),
  PY8X_FUNCTION (ctx_set_object_factory),
  PY8X_FUNCTION (ctx_get_log_fn),
  PY8X_FUNCTION (ctx_set_log_fn),
  PY8X_FUNCTION (ctx_import_bytecode),
  PY8X_FUNCTION (ctx_import_native),
  PY8X_FUNCTION (xctx_call),
  PY8X_FUNCTION (inf_new),
  PY8X_FUNCTION (list_get_first),
  PY8X_FUNCTION (list_get_next),
  PY8X_FUNCTION (to_signed),
  PY8X_FUNCTION (to_unsigned),
  PY8X_FUNCTION (ctx_get_funcref),
  PY8X_FUNCTION (ctx_get_functions),
  PY8X_FUNCTION (ctx_get_log_priority),
  PY8X_FUNCTION (ctx_set_log_priority),
  PY8X_FUNCTION (func_get_funcref),
  PY8X_FUNCTION (func_get_note),
  PY8X_FUNCTION (func_get_relocs),
  PY8X_FUNCTION (func_unregister),
  PY8X_FUNCTION (funcref_get_num_params),
  PY8X_FUNCTION (funcref_get_num_returns),
  PY8X_FUNCTION (funcref_get_signature),
  PY8X_FUNCTION (funcref_get_type),
  PY8X_FUNCTION (funcref_is_global),
  PY8X_FUNCTION (funcref_is_resolved),
  PY8X_FUNCTION (list_size),
  PY8X_FUNCTION (listitem_get_object),
  PY8X_FUNCTION (note_get_src_name),
  PY8X_FUNCTION (ob_get_ctx),
  PY8X_FUNCTION (reloc_get_func),
  PY8X_FUNCTION (reloc_get_src_offset),
  PY8X_FUNCTION (reloc_get_unrelocated),
  PY8X_FUNCTION (type_get_ptypes),
  PY8X_FUNCTION (type_get_rtypes),
  PY8X_FUNCTION (type_is_functype),
  PY8X_FUNCTION (xctx_new),
  {NULL, NULL, 0, NULL}
};

/* Module definition.  */

static struct PyModuleDef libi8x_moduledef =
  {
    PyModuleDef_HEAD_INIT,
    .m_name = "_libi8x",
    .m_doc = PyDoc_STR ("Python bindings for libi8x."),
    .m_size = -1,
    .m_methods = libi8x_methods,
  };

/* Module initialization function.  */

#define PY8X_EXCEPTION(name, parent)					\
  do {									\
    py8x_ ## name = PyErr_NewException ("_libi8x." #name, parent, NULL);\
									\
    if (py8x_ ## name == NULL						\
	|| PyModule_AddObject (m, #name, py8x_ ## name) != 0)		\
      return NULL;							\
  } while (0)

MODULE_INIT_FUNC (_libi8x)
{
  PyObject *m = PyModule_Create (&libi8x_moduledef);
  if (m == NULL)
    return NULL;

  PyModule_AddStringConstant (m, "__version__", PY8X_VERSION);

  PY8X_EXCEPTION (I8XError, PyExc_Exception);

  PY8X_EXCEPTION (NoteError, py8x_I8XError);
  PY8X_EXCEPTION (ExecutionError, py8x_I8XError);

  PY8X_EXCEPTION (CorruptNoteError, py8x_NoteError);
  PY8X_EXCEPTION (InvalidNoteError, py8x_NoteError);
  PY8X_EXCEPTION (UnhandledNoteError, py8x_NoteError);

  PY8X_EXCEPTION (DivideByZeroError, py8x_ExecutionError);
  PY8X_EXCEPTION (StackOverflowError, py8x_ExecutionError);
  PY8X_EXCEPTION (UnresolvedFunctionError, py8x_ExecutionError);
  PY8X_EXCEPTION (ReturnTypeError, py8x_ExecutionError);

  PyModule_AddIntConstant (m, "DBG_MEM", I8X_DBG_MEM);
  PyModule_AddIntConstant (m, "LOG_TRACE", I8X_LOG_TRACE);

  return m;
}
